{********************************************************}
{                                                        }
{                 Zeos Database Objects                  }
{              Common resource constants                 }
{                                                        }
{       Copyright (c) 1999-2001 Sergey Seroukhov         }
{    Copyright (c) 1999-2001 Zeos Development Group      }
{                                                        }
{********************************************************}

unit ZCommonConst;

interface

{$INCLUDE ../Zeos.inc}

resourcestring

{$IFNDEF RUSSIAN} {$IFNDEF GERMAN} {$IFNDEF PORTUGUESE}
{$IFNDEF FRENCH} {$IFNDEF POLISH} {$IFNDEF CZECH}
{$IFNDEF ITALIAN} {$IFNDEF DUTCH} {$IFNDEF SPANISH}
{$IFNDEF CROATIAN} {$IFNDEF HUNGARY}

  SPrevMonth       = 'Prior month|';
  SPrevYear        = 'Prior year|';
  SNextMonth       = 'Next month|';
  SNextYear        = 'Next year|';
  SDateDlgTitle    = 'Choose date';

  SDefaultFilter   = 'All files (*.*)|*.*';
  SBrowse          = 'List';

  SSyntaxError     = 'Syntax error';
  SIncorVarIdx     = 'Incorrect variable index';
  SIncorFuncIdx    = 'Incorrect function index';
  STypesMismatch   = 'Types mismatch';
  SFuncNotFound    = 'Function = "%s" not found';
  SVarNotFound     = 'Variable = "%s" not found';
  SIncorOperate    = 'Incorrect operation';
  SEvalError       = 'Evalution error';
  SStackFull       = 'Stack is full';
  SStackEmpty      = 'Stack is empty';
  SIncorFuncParam  = 'Incorrect params in function = "%s"';

{$ENDIF} {$ENDIF}
{$ENDIF} {$ENDIF} {$ENDIF}
{$ENDIF} {$ENDIF} {$ENDIF}
{$ENDIF} {$ENDIF} {$ENDIF}

{$IFDEF RUSSIAN}

  SPrevMonth       = ' |';
  SPrevYear        = ' |';
  SNextMonth       = ' |';
  SNextYear        = ' |';
  SDateDlgTitle    = ' ';

  SDefaultFilter   = '  (*.*)|*.*';
  SBrowse          = '';

  SSyntaxError     = ' ';
  SIncorVarIdx     = '  ';
  SIncorFuncIdx    = '  ';
  STypesMismatch   = ' ';
  SFuncNotFound    = ' = "%s"  ';
  SVarNotFound     = ' = "%s"  ';
  SIncorOperate    = ' ';
  SEvalError       = ' ';
  SStackFull       = ' ';
  SStackEmpty      = ' ';
  SIncorFuncParam  = '    = "%s"';

{$ENDIF}

{$IFDEF GERMAN}

  SPrevMonth       = 'Voriger Monat|';
  SPrevYear        = 'Voriges Jahr|';
  SNextMonth       = 'Nchster Monat|';
  SNextYear        = 'Nchstes Jahr|';
  SDateDlgTitle    = 'Datum whlen';

  SDefaultFilter   = 'Alle Dateien (*.*)|*.*';
  SBrowse          = 'Liste';

  SSyntaxError     = 'Syntax-Fehler';
  SIncorVarIdx     = 'Falscher Variablen-Index';
  SIncorFuncIdx    = 'Falscher Funktions-Index';
  STypesMismatch   = 'Typ-Fehler';
  SFuncNotFound    = 'Funktion = "%s" nicht gefunden';
  SVarNotFound     = 'Variable = "%s" nicht gefunden';
  SIncorOperate    = 'Falsche Operation';
  SEvalError       = 'Auswertungsfehler';
  SStackFull       = 'Stack ist voll';
  SStackEmpty      = 'Stack ist leer';
  SIncorFuncParam  = 'Falsche Parameter in Funktion = "%s"';

{$ENDIF}

{$IFDEF PORTUGUESE}

  SPrevMonth       = 'Ms anterior|';
  SPrevYear        = 'Ano anterior|';
  SNextMonth       = 'Prximo ms|';
  SNextYear        = 'Prximo ano|';
  SDateDlgTitle    = 'Escolha a data';

  SDefaultFilter   = 'Todos os arquivos (*.*)|*.*';
  SBrowse          = 'Lista';

  SSyntaxError     = 'Erro de sintaxe';
  SIncorVarIdx     = '-ndice variavel incorreto';
  SIncorFuncIdx    = 'Incorrect function index';
  STypesMismatch   = 'Erro de tipos';
  SFuncNotFound    = 'Funo = "%s" no encontrada';
  SVarNotFound     = 'Varivel = "%s" no encontrada';
  SIncorOperate    = 'Operao incorreta';
  SEvalError       = 'Erro de avaliao';
  SStackFull       = 'A pilha est cheia';
  SStackEmpty      = 'A Pilha est vazia';
  SIncorFuncParam  = 'Parmetros incorretos na funo = "%s"';

{$ENDIF}

{$IFDEF FRENCH}

  SPrevMonth = 'Mois prcdent|';
  SPrevYear = 'Anne prcdente|';
  SNextMonth = 'Mois suivant|';
  SNextYear = 'Anne suivante|';
  SDateDlgTitle = 'Choisir la date';

  SDefaultFilter = 'Tous les fichiers (*.*)|*.*';
  SBrowse = 'Liste';

  SSyntaxError = 'Erreur de syntaxe';
  SIncorVarIdx = 'Indice de variable incorrect';
  SIncorFuncIdx = 'Indice de fonction incorrect';
  STypesMismatch = 'Type incorrect';
  SFuncNotFound = 'Fonction = "%s" non trouve';
  SVarNotFound = 'Variable = "%s" non trouve';
  SIncorOperate = 'Opration incorrecte';
  SEvalError = 'Erreur d''valuation';
  SStackFull = 'Pile pleine';
  SStackEmpty = 'Pile vide';
  SIncorFuncParam = 'Paramtre incorrect de la fonction = "%s"';

{$ENDIF}

{$IFDEF POLISH}

  SPrevMonth       = 'Poprzedni miesic|';
  SPrevYear        = 'Poprzedni rok|';
  SNextMonth       = 'Nastpny miesic|';
  SNextYear        = 'Nastpny rok|';
  SDateDlgTitle    = 'Wybierz dat';

  SDefaultFilter   = 'Wszystkie pliki (*.*)|*.*';
  SBrowse          = 'Lista';

  SSyntaxError     = 'Bd skadni';
  SIncorVarIdx     = 'Bdny indeks zmiennej';
  SIncorFuncIdx    = 'Bdny indeks funkcji';
  STypesMismatch   = 'Przestawienie typw';
  SFuncNotFound    = 'Nie znaleziono funkcji "%s"';
  SVarNotFound     = 'Nie znaleziono zmiennej "%s"';
  SIncorOperate    = 'Bdna operacja';
  SEvalError       = 'Bdne oszacowanie';
  SStackFull       = 'Przepeniony stos';
  SStackEmpty      = 'Pusty stos';
  SIncorFuncParam  = 'Bdne argumenty funkcji "%s"';

{$ENDIF}

{$IFDEF CZECH}

  SPrevMonth       = 'Prior month|';
  SPrevYear        = 'Prior year|';
  SNextMonth       = 'Next month|';
  SNextYear        = 'Next year|';
  SDateDlgTitle    = 'Choose date';

  SDefaultFilter   = 'All files (*.*)|*.*';
  SBrowse          = 'List';

  SSyntaxError     = 'Syntax error';
  SIncorVarIdx     = 'Incorrect variable index';
  SIncorFuncIdx    = 'Incorrect function index';
  STypesMismatch   = 'Types mismatch';
  SFuncNotFound    = 'Function = "%s" not found';
  SVarNotFound     = 'Variable = "%s" not found';
  SIncorOperate    = 'Incorrect operation';
  SEvalError       = 'Evalution error';
  SStackFull       = 'Stack is full';
  SStackEmpty      = 'Stack is empty';
  SIncorFuncParam  = 'Incorrect params in function = "%s"';

{$ENDIF}

{$IFDEF ITALIAN}

  SPrevMonth       = 'mese precedente|';
  SPrevYear        = 'anno precedente|';
  SNextMonth       = 'mese successivo|';
  SNextYear        = 'anno successivo|';
  SDateDlgTitle    = 'Scegli una data';

  SDefaultFilter   = 'Tutti i file (*.*)|*.*';
  SBrowse          = 'Lista';

  SSyntaxError     = 'Errore di sintassi';
  SIncorVarIdx     = 'Errato variable index';
  SIncorFuncIdx    = 'Errato function index';
  STypesMismatch   = 'Tipo errato';
  SFuncNotFound    = 'Funzione = "%s" non trovata';
  SVarNotFound     = 'Variabile = "%s" non trovata';
  SIncorOperate    = 'Operazione non corretta';
  SEvalError       = 'Errore di valutazione';
  SStackFull       = 'Stack pieno';
  SStackEmpty      = 'Stack vuoto';
  SIncorFuncParam  = 'Parametri incorretti nella funzione = "%s"';

{$ENDIF}

{$IFDEF DUTCH}

  SPrevMonth       = 'Vorige maand|';
  SPrevYear        = 'Vorig jaar|';
  SNextMonth       = 'Volgende maand|';
  SNextYear        = 'Volgend jaar|';
  SDateDlgTitle    = 'Kies datum';

  SDefaultFilter   = 'Alle bestanden (*.*)|*.*';
  SBrowse          = 'Lijst';

  SSyntaxError     = 'Syntax fout';
  SIncorVarIdx     = 'Incorrecte variable index';
  SIncorFuncIdx    = 'Incorrecte functie index';
  STypesMismatch   = 'Types passen niet';
  SFuncNotFound    = 'Functie = "%s" niet gevonden';
  SVarNotFound     = 'Variable = "%s" niet gevonden';
  SIncorOperate    = 'Incorrecte operatie';
  SEvalError       = 'Evalutiefout';
  SStackFull       = 'Stack is vol';
  SStackEmpty      = 'Stack is leeg';
  SIncorFuncParam  = 'Incorrecte parameters in functie = "%s"';

{$ENDIF}

{$IFDEF SPANISH}

  SPrevMonth       = 'Mes Anterior|';
  SPrevYear        = 'Ao Anterior|';
  SNextMonth       = 'Mes Siguiente|';
  SNextYear        = 'Ao Siguiente|';
  SDateDlgTitle    = 'Elegir Fechas';

  SDefaultFilter   = 'Todos los archivos (*.*)|*.*';
  SBrowse          = 'Listar';

  SSyntaxError     = 'Error de Syntaxis';
  SIncorVarIdx     = 'Indice de variable arroneo';
  SIncorFuncIdx    = 'Indice de Funcion Erroneo';
  STypesMismatch   = 'Tipos iguales';
  SFuncNotFound    = 'Funcion = "%s" no existe';
  SVarNotFound     = 'Variable = "%s" no existe';
  SIncorOperate    = 'Operacion Incorrecta';
  SEvalError       = 'Error de Evaluacion';
  SStackFull       = 'Pila Llena';
  SStackEmpty      = 'Pila Vacia';
  SIncorFuncParam  = 'Parametros incorrectos en la funcion = "%s"';

{$ENDIF}

{$IFDEF CROATIAN}

  SPrevMonth       = 'Predhodni mjesec|';
  SPrevYear        = 'Predhodna godina|';
  SNextMonth       = 'Slijedei mjesec|';
  SNextYear        = 'Slijedea godina|';
  SDateDlgTitle    = 'Izaberi nadnevak';

  SDefaultFilter   = 'Sve datoteke (*.*)|*.*';
  SBrowse          = 'Listaj';

  SSyntaxError     = 'Sintaksna greka';
  SIncorVarIdx     = 'Krivi indeks varijable';
  SIncorFuncIdx    = 'Krivi indeks funkcije';
  STypesMismatch   = 'Nekompatibilni tipovi';
  SFuncNotFound    = 'Funkcija = "%s" nije pronaena';
  SVarNotFound     = 'Varijabla = "%s" nije pronaena';
  SIncorOperate    = 'Kriva operacija';
  SEvalError       = 'Greka u izraunu';
  SStackFull       = 'Stog je pun';
  SStackEmpty      = 'Stog je prazan';
  SIncorFuncParam  = 'Krivi parametri u funkciji = "%s"';

{$ENDIF}

{$IFDEF HUNGARY}

  SPrevMonth       = 'Elz hnap|';
  SPrevYear        = 'Elz v|';
  SNextMonth       = 'Kv. hnap|';
  SNextYear        = 'Kv. v|';
  SDateDlgTitle    = 'Dtumvlaszts';

  SDefaultFilter   = 'Minden file (*.*)|*.*';
  SBrowse          = 'Lista';

  SSyntaxError     = 'Nyelvtani hiba';
  SIncorVarIdx     = 'Hibs vltoz index';
  SIncorFuncIdx    = 'Hibs fggvny index';
  STypesMismatch   = 'Tpuskevereds';
  SFuncNotFound    = ' = "%s" fggvny nem tallhat';
  SVarNotFound     = ' = "%s" vltoz nem tallhat';
  SIncorOperate    = 'Hibs mvelet';
  SEvalError       = 'Kirtkels hiba';
  SStackFull       = 'Stack tele';
  SStackEmpty      = 'Stack res';
  SIncorFuncParam  = 'Hibs paramter a = "%s" fggvnyben';

{$ENDIF}

implementation

end.