unit POP3Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, Menus, ExtCtrls, StdCtrls, Buttons, inifiles, OleCtrls, isp3,
  ShellAPI;

const
  wm_IconMessage = wm_User;

type
  TfrmPOP3 = class(TForm)
    PageControl: TPageControl;
    tabHeaders: TTabSheet;
    tabNotify: TTabSheet;
    tabApplications: TTabSheet;
    tabServerInfo: TTabSheet;
    tabAbout: TTabSheet;
    POP3StatusBar: TStatusBar;
    POP3PopupMenu: TPopupMenu;
    popChkMail: TMenuItem;
    popLaunch: TMenuItem;
    popPreferences: TMenuItem;
    popEnable: TMenuItem;
    N2: TMenuItem;
    popClose: TMenuItem;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Bevel3: TBevel;
    Bevel4: TBevel;
    Bevel5: TBevel;
    Label1: TLabel;
    udFrequency: TUpDown;
    edtFrequency: TEdit;
    Label2: TLabel;
    Bevel6: TBevel;
    Label3: TLabel;
    chkPlaySound: TCheckBox;
    chkDisplayAnimation: TCheckBox;
    radBeep: TRadioButton;
    radWaveFile: TRadioButton;
    edtWaveFileName: TEdit;
    btnBrowse: TButton;
    OpenWaveFileDialog: TOpenDialog;
    Label4: TLabel;
    edtOther: TEdit;
    btnBrowseOther: TButton;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    edtServerName: TEdit;
    edtUser: TEdit;
    edtPassword: TEdit;
    lblMessages: TLabel;
    lblLastChecked: TLabel;
    Bevel7: TBevel;
    lstHeaders: TListBox;
    Label11: TLabel;
    btnDelete: TBitBtn;
    POP1: TPOP;
    btnCheck: TButton;
    btnUpdate: TButton;
    Timer1: TTimer;
    Bevel8: TBevel;
    chkConfirmDelete: TCheckBox;
    chkFrom: TCheckBox;
    chkDate: TCheckBox;
    chkPriority: TCheckBox;
    imgIcon1: TImage;
    Label10: TLabel;
    imgIcon2: TImage;
    imgIcon3: TImage;
    imgAnimate: TImage;
    tmrImage: TTimer;
    PopupMenuTask: TPopupMenu;
    popTaskOptions: TMenuItem;
    popTaskClose: TMenuItem;
    N3: TMenuItem;
    popTaskAbout: TMenuItem;
    popTaskCheckeMail: TMenuItem;
    popTaskLaunchMail: TMenuItem;
    popTaskDisable: TMenuItem;
    N4: TMenuItem;
    N1: TMenuItem;
    popAbout1: TMenuItem;
    PaintBox1: TPaintBox;
    yLabel: TLabel;
    xLabel: TLabel;
    chkSavePassword: TCheckBox;
    Label9: TLabel;
    procedure chkPlaySoundClick(Sender: TObject);
    procedure radWaveFileClick(Sender: TObject);
    procedure radBeepClick(Sender: TObject);
    procedure btnBrowseClick(Sender: TObject);
    procedure popCloseClick(Sender: TObject);
    procedure popPreferencesClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure UpdateUserInfo(Sender: TObject) ;
    procedure ReadUserInfo(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure POP1Error(Sender: TObject; Number: Smallint;
      var Description: WideString; Scode: Integer; const Source,
      HelpFile: WideString; HelpContext: Integer;
      var CancelDisplay: WordBool);
    procedure POP1ProtocolStateChanged(Sender: TObject;
      ProtocolState: Smallint);
    procedure POP1StateChanged(Sender: TObject; State: Smallint);
    procedure POP1RefreshMessageCount(Sender: TObject; Number: Integer);
    procedure btnCheckClick(Sender: TObject);
    procedure btnUpdateClick(Sender: TObject);
    procedure popChkMailClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure POP1DocOutput(Sender: TObject; const DocOutput: DocOutput);
    procedure lstHeadersClick(Sender: TObject);
    procedure btnDeleteClick(Sender: TObject);
    procedure popEnableClick(Sender: TObject);
    procedure tmrImageTimer(Sender: TObject);
    procedure btnBrowseOtherClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure popTaskOptionsClick(Sender: TObject);
    procedure popTaskCloseClick(Sender: TObject);
    procedure popTaskCheckeMailClick(Sender: TObject);
    procedure popTaskAboutClick(Sender: TObject);
    procedure popTaskDisableClick(Sender: TObject);
    procedure popAbout1Click(Sender: TObject);
    procedure imgIcon1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure popTaskLaunchMailClick(Sender: TObject);
    procedure popLaunchClick(Sender: TObject);
  private
    { Private declarations }
    IniFile: TIniFile;
    HelperApplicationPath : String ;
    bAskForPassword, POPError : Boolean ;
    FMessageCount, DelMsg: Integer ;
    iNumMessages, iMsgDnloaded : Integer ;
    nid: TNotifyIconData ;
  public
    { Public declarations }
    procedure IconTray(var Msg: TMessage);
      message wm_IconMessage ;
  end;

var
  frmPOP3: TfrmPOP3;

implementation

uses MMSystem, POP3Passwd;

{$R *.DFM}
{$R YPOP3.RES}

function NoParam: Variant ;
begin
 TVarData(Result).VType := varError ;
 TVarData(Result).VError := DISP_E_PARAMNOTFOUND ;
end ;


procedure TfrmPOP3.chkPlaySoundClick(Sender: TObject);
begin
  radBeep.Enabled := chkPlaySound.Checked ;
  radWaveFile.Enabled := chkPlaySound.Checked ;
  if chkPlaySound.Checked = False then
  begin
    edtWaveFileName.Enabled := False ;
    btnBrowse.Enabled := False ;
  end ;
  if chkPlaySound.Checked then
   begin
    if radBeep.Checked then
     begin
      edtWaveFileName.Enabled := False ;
      btnBrowse.Enabled := False ;
     end
    else if radWaveFile.Checked then
     begin
      edtWaveFileName.Enabled := True ;
      btnBrowse.Enabled := True ;
     end ;
   end ;
end;

procedure TfrmPOP3.radWaveFileClick(Sender: TObject);
begin
 edtWaveFileName.Enabled := radWaveFile.Checked ;
 btnBrowse.Enabled := radWaveFile.Checked ;
end;

procedure TfrmPOP3.radBeepClick(Sender: TObject);
begin
 edtWaveFileName.Enabled := radWaveFile.Checked ;
 btnBrowse.Enabled := radWaveFile.Checked ;
end;

procedure TfrmPOP3.btnBrowseClick(Sender: TObject);
begin
 with OpenWaveFileDialog do
 begin
  Filter := 'Wave File (*.wav)|*.wav' ;
  DefaultExt := 'txt' ;
  Filename := '' ;
  Options := [ofHideReadOnly, ofFileMustExist, ofPathmustExist] ;
 end ;
 if OpenWaveFileDialog.Execute then
  begin
   if OpenWaveFileDialog.FileName <> '' then
    edtWaveFileName.Text := OpenWaveFileDialog.FileName
   else
     edtWaveFileName.Text := '' ;
  end ;
end;

procedure TfrmPOP3.popCloseClick(Sender: TObject);
begin
 if POP1.State = prcConnected then POP1.Quit ;
 Application.Terminate ;
end;

procedure TfrmPOP3.popPreferencesClick(Sender: TObject);
begin
 PageControl.ActivePage := tabNotify ; 
end;

procedure TfrmPOP3.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 UpdateUserInfo(Sender) ;
 if POP1.State = prcConnected then POP1.Quit ;
 Action := caNone ;
 ShowWindow (Handle, sw_Hide) ;
end;

procedure TfrmPOP3.UpdateUserInfo(Sender: TObject);
var
 FileName, SoundString: String ;
begin
 FileName := ExtractFilePath(ParamStr(0)) + 'pop3c.ini' ;
 IniFile := TIniFile.Create(FileName) ;
 IniFile.WriteString('POP3Client', 'Frequency', edtFrequency.Text) ;

 HelperApplicationPath := edtOther.Text ;

 IniFile.WriteString('POP3Client', 'Application', HelperApplicationPath) ;
 IniFile.WriteString('POP3Client', 'Server', edtServerName.Text) ;
 IniFile.WriteString('POP3Client', 'User', edtUser.Text) ;
 if chkSavePassword.Checked then
  IniFile.WriteString('POP3Client', 'Password', edtPassword.Text) 
 else
  IniFile.WriteString('POP3Client', 'Password', '.not_saved') ;
 if chkPlaySound.Checked then
  begin
   if radBeep.Checked then
    SoundString := 'Beep'
   else
    SoundString := edtWaveFileName.Text
  end
 else
  SoundString := 'None' ;
 IniFile.WriteString('POP3Client', 'Sound', SoundString) ;
 //animation
 if chkDisplayAnimation.Checked then
  IniFile.WriteString('POP3Client', 'Animation', 'True')
 else
  IniFile.WriteString('POP3Client', 'Animation', 'False') ;
 //deletion
 if chkConfirmDelete.Checked then
  IniFile.WriteString('POP3Client', 'Deletion', 'True')
 else
  IniFile.WriteString('POP3Client', 'Deletion', 'False') ;
 //show from info
 if chkFrom.Checked then
  IniFile.WriteString('POP3Client', 'From', 'True')
 else
  IniFile.WriteString('POP3Client', 'From', 'False') ;
 //show time info
 if chkDate.Checked then
  IniFile.WriteString('POP3Client', 'Date', 'True')
 else
  IniFile.WriteString('POP3Client', 'Date', 'False') ;
 //show priority info
 if chkPriority.Checked then
  IniFile.WriteString('POP3Client', 'Priority', 'True')
 else
  IniFile.WriteString('POP3Client', 'Priority', 'False') ;


 IniFile.Destroy ;
end;


procedure TfrmPOP3.FormCreate(Sender: TObject);
begin
 POPError := False ;
 FMessageCount := 0 ;
 DelMsg := 0 ;
 bAskForPassword := False ;
 HelperApplicationPath := 'e:whatever.exe' ;
 SendMessage(lstHeaders.Handle, LB_SetHorizontalExtent, lstHeaders.Width*2, 0) ;
 ReadUserInfo(Sender) ;
 imgAnimate.Picture := imgIcon1.Picture ;
 //load the initial icon
 Icon.Handle := LoadIcon (HInstance, 'ICON1') ;
 //fill the NotifyIcon data
 nid.cbSize := sizeof(nid) ;
 nid.Wnd := Handle ;
 nid.uID := 1; //icon Id
 nid.uCallbackMessage := wm_IconMessage ;
 nid.hIcon := Icon.Handle ;
 nid.szTip:= 'No messages' ;
 nid.uFlags := nif_Message or nif_Icon or nif_Tip ;
 Shell_NotifyIcon (NIM_ADD, @nid) ;
 tmrImageTimer(self) ;
 btnCheckClick(Sender) ;
end;


procedure TfrmPOP3.ReadUserInfo(Sender: TObject);
var
 FileName, ItemData: String ;
begin
 FileName := ExtractFilePath(ParamStr(0)) + 'pop3c.ini' ;
 IniFile := TIniFile.Create(FileName) ;
 ItemData := IniFile.ReadString('POP3Client', 'Frequency', ItemData) ;
 //MessageDlg ( 'ItemData = '+ItemData, mtError, [mbOK], 0) ;
 if ItemData = '' then
  begin
    popTaskDisable.Checked := False ;
    popTaskDisableClick(Sender) ;
    exit ;
  end ;
 if (StrToInt(ItemData) < 1) or (StrToInt(ItemData) > 60) then
  udFrequency.Position := 10
 else
  udFrequency.Position := StrToInt(ItemData) ;

 Timer1.Interval := udFrequency.Position * 60 * 1000 ;

 ItemData := IniFile.ReadString('POP3Client', 'Application', ItemData) ;

 edtOther.Text := ItemData ;
 HelperApplicationPath := ItemData ;

 ItemData := IniFile.ReadString('POP3Client', 'Server', ItemData) ;
 edtServerName.Text := ItemData ;
 ItemData := IniFile.ReadString('POP3Client', 'User', ItemData) ;
 edtUser.Text := ItemData ;
 ItemData := IniFile.ReadString('POP3Client', 'Password', ItemData) ;
 if ItemData = '.not_saved' then
  begin
   chkSavePassword.Checked := False ;
   if not bAskForPassword then
    bAskForPassword := True ;
   // ask for password
   ItemData := '' ;
   InputQuery ('POP3 password', 'Please enter your POP3 password (not blanked):', ItemData ) ;
   if ItemData = '' then
   begin
    popTaskDisable.Checked := False ;
    popTaskDisableClick(Sender) ;
   end ;
   edtPassword.Text := ItemData ;
  end
 else
  begin
   edtPassword.Text := ItemData ;
   chkSavePassword.Checked := True ;
 end ;

 ItemData := IniFile.ReadString('POP3Client', 'Sound', ItemData) ;
 if ItemData = 'Beep' then
  begin
   chkPlaySound.Checked := True ;
   radBeep.Enabled := True ;
   radBeep.Checked := True ;
   radWaveFile.Enabled := True ;
   radWaveFile.Checked := False ;
   edtWaveFileName.Text := '' ;
   edtWaveFileName.Enabled := False ;
   btnBrowse.Enabled := False ;
  end
 else if ItemData = 'None' then
  begin
   chkPlaySound.Checked := False ;
   radBeep.Enabled := False ;
   radBeep.Checked := False ;
   radWaveFile.Enabled := False ;
   radWaveFile.Checked := False ;
   edtWaveFileName.Text := '' ;
   edtWaveFileName.Enabled := False ;
   btnBrowse.Enabled := False ;
  end
 else
  begin
   chkPlaySound.Checked := True ;
   radBeep.Enabled := True ;
   radBeep.Checked := False ;
   radWaveFile.Enabled := True ;
   radWaveFile.Checked := True ;
   edtWaveFileName.Text := ItemData ;
   edtWaveFileName.Enabled := True ;
   btnBrowse.Enabled := True ;
  end ;
 //animation
 ItemData := IniFile.ReadString('POP3Client', 'Animation', ItemData) ;
 if ItemData = 'True' then
  chkDisplayAnimation.Checked := True
 else
  chkDisplayAnimation.Checked := False ;
 //deletion
 ItemData := IniFile.ReadString('POP3Client', 'Deletion', ItemData) ;
 if ItemData = 'True' then
  chkConfirmDelete.Checked := True
 else
  chkConfirmDelete.Checked := False ;

 ItemData := IniFile.ReadString('POP3Client', 'From', ItemData) ;
 if ItemData = 'True' then
  chkFrom.Checked := True
 else
  chkFrom.Checked := False ;

 ItemData := IniFile.ReadString('POP3Client', 'Date', ItemData) ;
 if ItemData = 'True' then
  chkDate.Checked := True
 else
  chkDate.Checked := False ;

 ItemData := IniFile.ReadString('POP3Client', 'Priority', ItemData) ;
 if ItemData = 'True' then
  chkPriority.Checked := True
 else
  chkPriority.Checked := False ;

 IniFile.Destroy ;
end;

procedure TfrmPOP3.POP1Error(Sender: TObject; Number: Smallint;
  var Description: WideString; Scode: Integer; const Source,
  HelpFile: WideString; HelpContext: Integer; var CancelDisplay: WordBool);
var
 I : Integer ;
 ErrorStr : String ;
begin
 POPError := True ;
 CancelDisplay := True ;
 if POP1.ProtocolState = popAuthorization then
  MessageDlg ( 'Authorization Error', mtError, [mbOK], 0) ;
 for I := 1 to POP1.Errors.Count do
  ErrorStr := Format(#13'(%s)', [POP1.Errors.Item(I).Description]) ;
 MessageDlg(Format('%d - %s%s', [Number, Description, Trim(ErrorStr)]),
             mtError, [mbOK], 0) ;
end;

procedure TfrmPOP3.POP1ProtocolStateChanged(Sender: TObject;
  ProtocolState: Smallint);
begin
 case ProtocolState of
  popAuthorization:
   POP1.Authenticate(POP1.UserID, POP1.Password) ;
  popTransaction:
   POP3StatusBar.SimpleText := 'Authorization successfull' ;
   //StatusBar.Update ;
 end ;
end;

procedure TfrmPOP3.POP1StateChanged(Sender: TObject; State: Smallint);
begin
 case State of
  prcConnecting:
   POP3StatusBar.SimpleText := 'Connecting to POP3 Server' + POP1.RemoteHost + '...' ;
  prcResolvingHost:
   POP3StatusBar.SimpleText := 'Resolving Host' ;
  prcHostResolved:
   POP3StatusBar.SimpleText := 'Host Resolved' ;
  prcConnected:
   begin
    POP3StatusBar.SimpleText := 'Connected' ;
    if DelMsg > 0 then
     begin
      POP1.Delete(DelMsg) ;
      DelMsg := 0 ;
     end ;
   end ;
  prcDisconnected:
   POP3StatusBar.SimpleText := 'Disconnected' ;
 end ;
end;

procedure TfrmPOP3.POP1RefreshMessageCount(Sender: TObject;
  Number: Integer);
begin
 FMessageCount := Number ;
 iNumMessages := Number ;
 iMsgDnloaded := 1 ;
 lblMessages.Caption := 'Messages waiting: ' + IntToStr(Number) + ' message(s)';

 if Number > 0 then
  begin
   Application.Title := 'You have ' + IntToStr(Number) + ' message(s) waiting' ;
   frmPOP3.Caption := Application.Title ;
   Application.Icon.Handle := LoadIcon (HInstance, 'ICON2') ;
   if chkPlaySound.Checked then
   begin
    if radBeep.Checked then beep ;
    if radWaveFile.Checked then
     PlaySound (PChar(edtWaveFileName.Text), 0, snd_Async);
   end ;
   POP1.RetrieveMessage(iMsgDnloaded) ;
   Dec(iNumMessages) ;
   Inc(iMsgDnloaded) ;
   if not lstHeaders.Enabled then lstHeaders.Enabled := True ;
   if chkDisplayAnimation.Checked then
    tmrImage.Enabled := True
   else
    tmrImage.Enabled := False ;
   end
 else      // no mails
  begin
   imgAnimate.Picture := imgIcon1.Picture ;
   Application.Title := 'No messages.' ;
   frmPOP3.Caption := Application.Title ;
   Icon.Handle := LoadIcon (HInstance, 'ICON1') ;
   nid.hIcon := Icon.Handle ;
   strcopy (nid.szTip, PChar(Caption)) ;
   nid.uFlags := nif_Icon or nif_Tip ;
   Shell_NotifyIcon(NIM_MODIFY, @nid) ;
   POP1.Quit ;
  end ;
end;

procedure TfrmPOP3.btnCheckClick(Sender: TObject);
begin
 if edtPassword.Text = '' then
 begin
  MessageDlg ( 'POP3 Server Login Error', mtError, [mbOK], 0) ;
  popTaskDisable.Checked := False ;
  popTaskDisableClick(Sender) ;
  exit ;
 end ;
 if (POP1.State = prcConnected) and (POP1.ProtocolState = popTransaction)
   and not POP1.Busy then
    POP1.Quit
 else
  if (POP1.State = prcDisconnected) then
  begin
   lstHeaders.Clear ;
   Icon.Handle := LoadIcon (HInstance, 'ICON4') ;
   nid.hIcon := Icon.Handle ;
   Caption := 'Checking eMail...' ;
   strcopy (nid.szTip, PChar(Caption)) ;
   nid.uFlags := nif_Icon or nif_Tip ;
   Shell_NotifyIcon(NIM_MODIFY, @nid) ;

   POP1.RemoteHost := edtServerName.Text ;
   POP1.UserID := edtUser.Text ;
   POP1.Password := edtPassword.Text ;
   POP1.Connect(NoParam, NoParam) ;
   lblLastChecked.Caption := 'Last checked at: '+ TimeToStr(Now) ;
  end ;
end;

procedure TfrmPOP3.btnUpdateClick(Sender: TObject);
begin
 UpdateUserInfo(Sender) ;
 ReadUserInfo(Sender) ;
end;

procedure TfrmPOP3.popChkMailClick(Sender: TObject);
begin
 btnCheckClick(Sender) ;
end;

procedure TfrmPOP3.Timer1Timer(Sender: TObject);
begin
 //if (POP1.State = prcConnected) and (POP1.ProtocolState = popTransaction) then
 btnCheckClick(Sender) ;
end;

procedure TfrmPOP3.POP1DocOutput(Sender: TObject;
  const DocOutput: DocOutput);
var
 Buffer: WideString ;
 I: Integer ;
 FinalString, SubjectString, FromString, DateString, PriorityString: String ;
begin
 case DocOutput.State of
  icDocBegin:
   POP3StatusBar.SimpleText := 'Initiating header transfer' ;
  icDocHeaders:
   begin
    POP3StatusBar.SimpleText := 'Retrieving headers' ;
    for I:= 1 to DocOutput.Headers.Count do
     begin
     if DocOutput.Headers.Item(I).Name = 'Date' then
      DateString := DocOutput.Headers.Item(I).Value ;
     if DocOutput.Headers.Item(I).Name = 'From' then
      FromString := DocOutput.Headers.Item(I).Value ;
     if DocOutput.Headers.Item(I).Name = 'Subject' then
      SubjectString := DocOutput.Headers.Item(I).Value ;
     if DocOutput.Headers.Item(I).Name = 'X-Priority' then
      PriorityString := DocOutput.Headers.Item(I).Value ;
     end ;

     if SubjectString = '' then SubjectString := 'No Subject' ;
     if DateString = '' then DateString := 'No Date' ;
     if FromString = '' then FromString := 'Sender Unknown' ;
     if PriorityString = '' then SubjectString := '3 (Normal)' ;
     FinalString := SubjectString ;
     if chkFrom.Checked then
      FinalString := FinalString + ' - ' + FromString ;
     if chkDate.Checked then
      FinalString := FinalString + ' - ' + DateString ;
     if chkPriority.Checked then
      FinalString := FinalString + ' - ' + PriorityString ;
     lstHeaders.Items.Add (FinalString) ;
    end ;
  icDocData:
   begin
    POP3StatusBar.SimpleText := Format ('Retrieving data - %d bytes', [Trunc(DocOutput.BytesTransferred)]);
    Buffer := DocOutput.DataString ;
    //lstHeaders.Items.Add (Buffer) ;
   end ;
  icDocEnd:
   if POPError then
    POP3StatusBar.SimpleText := 'Transfer Aborted'
   else
    begin
     POP3StatusBar.SimpleText := 'Retrieval complete' ;
     if (iNumMessages > 0) then
      begin
       POP1.RetrieveMessage(iMsgDnloaded) ;
       Dec(iNumMessages) ;
       Inc(iMsgDnloaded) ;
      end
     else
      if POP1.State = prcConnected then POP1.Quit ;
    end ;
 end ;
 //POP3Status.Update ;
end;

procedure TfrmPOP3.lstHeadersClick(Sender: TObject);
begin
 btnDelete.Enabled := True ;
end;

procedure TfrmPOP3.btnDeleteClick(Sender: TObject);
var
 iMsgNum : Integer ;
 sMessage : String ;
 bDelMessage : Bool ;
begin
  bDelMessage := True ;
 iMsgNum := lstHeaders.ItemIndex + 1 ; //indexes to 0
 if chkConfirmDelete.Checked then
  begin
   bDelMessage := False ;
   sMessage := 'Delete message #' + IntToStr(iMsgNum) + '?';
   if MessageDlg(sMessage, mtConfirmation, [mbYes, mbNo], 0) = mrYes then
    bDelMessage := True ;
  end ;
 if bDelMessage then
  begin
   POP3StatusBar.SimpleText := 'Deleting message from server...' ;
   if POP1.State <> prcConnected then
   begin
    DelMsg := iMsgNum ;
    btnCheckClick(Sender) ;
   end ;
   //POP1.Delete(iMsgNum) ;
   POP3StatusBar.SimpleText := 'Message Deleted' ;
   lstHeaders.Items.Delete (iMsgNum-1) ;
 end ;
 if lstHeaders.Items.Count <= 0 then
  begin
   lstHeaders.Enabled := False ;
   btnDelete.Enabled := False ;
   tmrImage.Enabled := False ;
   imgAnimate.Picture := imgIcon1.Picture ;
 end ;
end;

procedure TfrmPOP3.popEnableClick(Sender: TObject);
begin
 //change menu to enabled
 popTaskDisableClick(Sender) ;
end;

procedure TfrmPOP3.tmrImageTimer(Sender: TObject);
begin
 if imgAnimate.Tag = imgIcon2.Tag then
  begin
   imgAnimate.Picture := imgIcon1.Picture ;
   imgAnimate.Tag := imgIcon1.Tag ;
   Icon.Handle := LoadIcon (HInstance, 'ICON2') ;
  end
 else
  begin
   imgAnimate.Picture := imgIcon2.Picture ;
   imgAnimate.Tag := imgIcon2.Tag ;
   Icon.Handle := LoadIcon (HInstance, 'ICON1') ;
  end ;
  nid.hIcon := Icon.Handle ;
  strcopy (nid.szTip, PChar(Caption)) ;
  nid.uFlags := nif_Icon or nif_Tip ;
  Shell_NotifyIcon(NIM_MODIFY, @nid) ;
end;

procedure TfrmPOP3.btnBrowseOtherClick(Sender: TObject);
begin
with OpenWaveFileDialog do
 begin
  Filter := 'Executable File (*.exe)|*.exe|Batch File (*.bat)|*.bat|Command File (*.cmd)|*.cmd' ;
  DefaultExt := 'exe' ;
  Filename := '' ;
  Options := [ofHideReadOnly, ofFileMustExist, ofPathmustExist] ;
 end ;
 if OpenWaveFileDialog.Execute then
  begin
   if OpenWaveFileDialog.FileName <> '' then
    edtOther.Text := OpenWaveFileDialog.FileName
   else
     edtOther.Text := '' ;
   HelperApplicationPath := edtOther.Text ;
  end ;
end;

procedure TfrmPOP3.FormDestroy(Sender: TObject);
begin
 nid.uFlags := 0 ;
 Shell_NotifyIcon (NIM_DELETE, @nid) ;
end;


procedure TfrmPOP3.IconTray(var Msg: TMessage);
var
 Pt: TPoint ;
begin
 if Msg.LParam = wm_rbuttondown then
 begin
  GetCursorPos(Pt) ;
  SetForegroundWindow(Handle) ;
  PopupMenuTask.Popup (Pt.x, Pt.y) ;
 end ;
 if Msg.LParam = wm_lbuttondblclk then
    btnCheckClick(self)
end ;


procedure TfrmPOP3.popTaskOptionsClick(Sender: TObject);
begin
 ShowWindow(Handle, sw_ShowNormal) ;
 SetForegroundWindow (Handle) ;
 Show ;
 PageControl.ActivePage := tabHeaders ;
end;

procedure TfrmPOP3.popTaskCloseClick(Sender: TObject);
begin
 Application.Terminate ;
end;

procedure TfrmPOP3.popTaskCheckeMailClick(Sender: TObject);
begin
 btnCheckClick(Sender) ;
end;

procedure TfrmPOP3.popTaskAboutClick(Sender: TObject);
begin
 ShowWindow(Handle, sw_ShowNormal) ;
 SetForegroundWindow (Handle) ;
 Show ;
 PageControl.ActivePage := tabAbout ;
end;

procedure TfrmPOP3.popTaskDisableClick(Sender: TObject);
begin
 popTaskDisable.Checked := not popTaskDisable.Checked ;
 if popTaskDisable.Checked then
  begin
   Timer1.Enabled := False ;
   Icon.Handle := LoadIcon (HInstance, 'ICON3') ;
   nid.hIcon := Icon.Handle ;
   //nid.szTip:= 'YAP Disabled ;
   Caption := 'YAP Disabled' ;
   strcopy (nid.szTip, PChar(Caption)) ;
   nid.uFlags := nif_Icon or nif_Tip ;
   Shell_NotifyIcon(NIM_MODIFY, @nid) ;
  end
 else
  begin
   Timer1.Enabled := true ;
   Icon.Handle := LoadIcon (HInstance, 'ICON1') ;
   nid.hIcon := Icon.Handle ;
   Caption := 'No message(s)' ;
   strcopy (nid.szTip, PChar(Caption)) ;
   nid.uFlags := nif_Icon or nif_Tip ;
   Shell_NotifyIcon(NIM_MODIFY, @nid) ;
  end ;
end;

procedure TfrmPOP3.popAbout1Click(Sender: TObject);
begin
 PageControl.ActivePage := tabAbout ;
end;

procedure Delay(Seconds, MilliSec: Word) ;
var
 TimeOut: TDateTime ;
begin
 TimeOut := Now + EncodeTime(0, Seconds div 60, Seconds mod 60, MilliSec) ;
 while Now < TimeOut do
  Application.ProcessMessages ;
end ;


procedure TfrmPOP3.imgIcon1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
 I, LineH : Integer ;
begin
 if (Button = mbLeft) and (ssShift in Shift) then
 begin
  xLabel.Visible := False ;
  yLabel.Visible := False ;
  Paintbox1.Visible := True ;
  Paintbox1.Canvas.Font.Name := 'Arial' ;
  Paintbox1.Canvas.Font.Size := 20 ;
  LineH := Paintbox1.Canvas.TextHeight('0') ;
  for I:= 0 to 100 + LineH*10 do
   with PaintBox1.Canvas do
    begin
     TextOut (20, 100-I,         '           YAP 0.5         ') ;
     TextOut (20, 100+LineH-I,         '  Yet Another Pop3 Client  ') ;
     TextOut (20, 100+LineH*2-I,   '   written in Delphi 3.0   ') ;
     TextOut (20, 100+LineH*3-I, 'uses NetManage POP3 Control') ;
     TextOut (20, 100+LineH*4-I, '                           ') ;
     TextOut (20, 100+LineH*5-I, '            from           ') ;
     TextOut (20, 100+LineH*6-I, '           Fergus          ') ;
     TextOut (20, 100+LineH*7-I, '          (c)1998          ') ;
     TextOut (20, 100+LineH*8-I, '                           ') ;
     TextOut (20, 100+LineH*9-I, '                           ') ;
     Delay(0,5) ;
    end ;
  Paintbox1.Visible := False ;
  xLabel.Visible := True ;
  yLabel.Visible := True ;
 end ;
end;

procedure TfrmPOP3.popTaskLaunchMailClick(Sender: TObject);
var
 RunString : String ;
begin
 //WinExec('C:\Program.exe', SW_SHOWNORMAL);
 RunString := HelperApplicationPath + ' -mail' ;
 WinExec (PChar(RunString), SW_SHOWNORMAL) ;
 btnCheckClick(Sender) ;
end;

procedure TfrmPOP3.popLaunchClick(Sender: TObject);
begin
 popTaskLaunchMailClick(Sender) ;
end;

end.
