unit xtcStatusBar;
{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
+ xtcStatusBar : Standard status bar with hints and hottrack property added
+ Author: Alan Rose  alan.jr@xtra.co.nz
+ Date:   9/4/2000
+ Freeware. Comments welcomed
+
+ I have purposely kept it simple by descending from TStatusbar else Hints could have been added to TStatusPanel descendant
+ To use set form showhint to true. Setup hints in hints property
+ Hottracking requires panel property style be set to psOwnerdraw. this is done automatically on setting hottrack to True
+ XTC stands for either a popular band from the eighties or eXtra Tough Components. Doesnt matter really.
+
+ New Properties \ Events
+    HotTrack:      Turn this on to activate hottracking over panels
+    HotTrackColor: Colour of font on Hottrack
+    HotTrackBrush: Colour of brush on HotTrack
+    Hints:         StringList of Hints to use with panels
+    MouseEnter:    Event Added for programer to utilize
+    MouseLeave:    Event Added for programer to utilize
+    CurrentPanel:  Runtime access to current panel. i.e could be used in onclick event
+
+  Verion 1.0 10/4/2000
+  - Released
+
+
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
}
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls,StdCtrls;

type
  TxtcStatusBar = class(TStatusBar)
  private
    { Private declarations }
    FHints      : TStrings;
    FOverColour : TColor;
    FPanelColour: TColor;
    FHotTrack   : Boolean;
    FX,FPrev    : Integer;
    FOnMouseEnter, FOnMouseLeave : TNotifyEvent;
  protected
    { Protected declarations }
    Procedure SetupCustomDraw;
  public
    { Public declarations }
    Constructor Create(AOwner : TComponent) ; Override;
    Destructor  Destroy; Override;
    Procedure   SetHints(Value : TStrings);
    procedure SetHotTrack(Value : Boolean);
    procedure CMMouseEnter(var Message: TMessage); message CM_MOUSEENTER;
    procedure CMMouseLeave(var Message: TMessage); message CM_MOUSELEAVE;
    property CurrentPanel: Integer read FPrev; // could be used in onclick event by programmer to do action on click of selected panel
  published
    { Published declarations }
    procedure MouseMove(Shift:TShiftState; X, Y: Integer); override;
    property Hints : TStrings read FHints write SetHints;
    property HotTrack : Boolean read FHotTrack write SetHotTrack;
    property HotTrackColor: TColor read FOverColour write FOverColour;
    property HotTrackBrush: TColor read FPanelColour write FPanelColour;
    property OnMouseEnter: TNotifyEvent read FOnMouseEnter write FOnMouseEnter;
    property OnMouseLeave: TNotifyEvent read FOnMouseLeave write FOnMouseLeave;
    procedure DrawPanel(Panel: TStatusPanel; const Rect: TRect); override;
   end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('XTC', [TxtcStatusBar]);
end;

{ TxtcStatusBar }

procedure TxtcStatusBar.CMMouseEnter(var Message: TMessage);
begin
  if assigned(OnMouseEnter) then OnMouseEnter(self);
end;

procedure TxtcStatusBar.CMMouseLeave(var Message: TMessage);
begin
 if assigned(OnMouseLeave) then OnMouseLeave(self);
 FPrev := -1;
 Repaint;
end;

constructor TxtcStatusBar.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FHints       := TStringList.Create;
  FOverColour  := clBlue;
  FPanelColour := clBtnFace;
  FPrev        := -1;
  FHotTrack    := True; // default on
  SetupCustomDraw
end;

destructor TxtcStatusBar.Destroy;
begin
  FHints.Free;
  inherited Destroy;
end;

procedure TxtcStatusBar.DrawPanel(Panel: TStatusPanel; const Rect: TRect);
// custom draw panel
begin
  inherited;
  if Assigned(OnDrawPanel) then
    OnDrawPanel(Self, Panel, Rect)
  else
    begin
      if (Panel.Index = FPrev) and FHotTrack then // on current panel and hottracking
        begin
          Canvas.Brush.Color := FPanelColour;
          Canvas.FillRect(Rect);
          Canvas.Font.Color := FOverColour;
          Canvas.TextRect(Rect,Rect.Left,Rect.Top+((Rect.Bottom-Rect.Top-Canvas.TextHeight(Panel.Text)) div 2),Panel.Text);
        end
      else
        begin   // default rest
          Canvas.Brush.Color := clBtnFace;
          Canvas.FillRect(Rect);
          Canvas.Font.Color := clBlack;
          Canvas.TextRect(Rect,Rect.Left,Rect.Top+((Rect.Bottom-Rect.Top-Canvas.TextHeight(Panel.Text)) div 2),Panel.Text);
       end;
    end;
end;

procedure TxtcStatusBar.MouseMove(Shift: TShiftState; X, Y: Integer);
// find position of cursor in panels and setup for draw event
var i,j : Integer;
begin
  FX := X;
  j  := 0;
  if Panels.Count > 0 then // there are panels
    for i := 0 to Panels.Count -1 do  // loop through panels and find current panel
      begin
        if ((FX > j) and (FX <= j+Panels.Items[i].width)) or (Panels.Count-1 = i) then
          begin
            if (Hints.Count-1 < i) or (Hints.Count = 0) then
              Hint := ''  // no hint to show
            else
              Hint := Hints[i];  // use this hint
            if FPrev <> i then // mouse in different panel
              begin
                Application.CancelHint; // hide previous hint so new hint can show
                FPrev := i;
                Repaint; // repaint panels
              end;
            FPrev := i;  // hold current panel
            Break; // make a break for it
          end;
        j := j+Panels.Items[i].width; // inc width position
      end;

  Inherited;
end;

procedure TxtcStatusBar.SetHints(Value: TStrings);
begin
  if Hints.Text <> Value.Text then
    Hints.Assign(Value);
  SetupCustomDraw;
end;


procedure TxtcStatusBar.SetHotTrack(Value: Boolean);
begin
  FHotTrack := Value;
  SetupCustomDraw
end;


procedure TxtcStatusBar.SetupCustomDraw;
// set draw method accordingly
var i : Integer;
begin
  if Panels.count > 0 then
    For i := 0 to Panels.count -1 do
      if FHotTrack then
        Panels.Items[i].Style := psOwnerDraw
      else
         Panels.Items[i].Style := psText;
end;

end.
