// xTextEditor Demo  1998, Deks
// xAction Package  1998, Deks
//
// Deks Site: http://deks.webjump.com/
// E-mail: Deks@online.nsk.su
// ============================================================================
unit uxTextEditor;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, ExtCtrls, Menus, uxAction, RXSplit, StdCtrls;

type
  TxTextEditorForm = class(TForm)
    MainMenu: TMainMenu;
    File1: TMenuItem;
    miFileNew: TMenuItem;
    miFileOpen: TMenuItem;
    miFileSave: TMenuItem;
    miFileSep1: TMenuItem;
    miFileExit: TMenuItem;
    ToolbarPanel: TPanel;
    tbNew: TSpeedButton;
    tbSave: TSpeedButton;
    tbOpen: TSpeedButton;
    xNewAction: TxAction;
    xOpenAction: TxAction;
    xSaveAction: TxAction;
    xExitAction: TxAction;
    xControlLink_New: TxControlLink;
    tbExit: TSpeedButton;
    OpenFileDialog: TOpenDialog;
    xControlLink1: TxControlLink;
    xControlLink2: TxControlLink;
    xControlLink3: TxControlLink;
    Panel1: TPanel;
    RxSplitter1: TRxSplitter;
    Memo1: TMemo;
    procedure xNewActionExecute(Sender: TObject);
    procedure xOpenActionExecute(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure CallNewAction(Sender: TObject);
    procedure CallOpenAction(Sender: TObject);
    procedure CallSaveAction(Sender: TObject);
    procedure CallExitAction(Sender: TObject);
    procedure xExitActionExecute(Sender: TObject);
    procedure xSaveActionExecute(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  xTextEditorForm: TxTextEditorForm;

implementation

{$R *.DFM}

uses uxEditorForm, VCLUtils;

// ----------------------------------------------------------------------------
procedure TxTextEditorForm.xNewActionExecute(Sender: TObject);
begin
  // Implementation of new action: create new editor window.
  TxEditorForm.Create(Self);
  xSaveAction.Enabled := True;
end;

// ----------------------------------------------------------------------------
procedure TxTextEditorForm.xOpenActionExecute(Sender: TObject);
begin
  // Implementation of Open action: open file in Editor form.
  if OpenFileDialog.Execute then

  with TxEditorForm.Create(Self) do
    Editor.Lines.LoadFromFile(OpenFileDialog.FileName);
  xSaveAction.Enabled := True;
end;

// ----------------------------------------------------------------------------
procedure TxTextEditorForm.xSaveActionExecute(Sender: TObject);
begin
  // Implementation of save action.
  NotImplemented;
end;

// ----------------------------------------------------------------------------
procedure TxTextEditorForm.xExitActionExecute(Sender: TObject);
begin
  // Implementation of exit action.
  Close;
end;

// ----------------------------------------------------------------------------
procedure TxTextEditorForm.FormShow(Sender: TObject);
begin
  xSaveAction.Enabled := False;
end;

// ----------------------------------------------------------------------------
procedure TxTextEditorForm.CallNewAction(Sender: TObject);
begin
  xNewAction.Execute;
end;

// ----------------------------------------------------------------------------
procedure TxTextEditorForm.CallOpenAction(Sender: TObject);
begin
  xOpenAction.Execute;
end;

// ----------------------------------------------------------------------------
procedure TxTextEditorForm.CallSaveAction(Sender: TObject);
begin
  xSaveAction.Execute;
end;

// ----------------------------------------------------------------------------
procedure TxTextEditorForm.CallExitAction(Sender: TObject);
begin
  xExitAction.Execute;
end;

end.
