{******************************************************************
*  (c)copyrights Corona Ltd. Donetsk 1999
*  Project: Zeos Library
*  Module: TTransact class for direct MySQL access (version 1.0)
*  Author: Sergey Seroukhov   E-Mail: voland@cm.dongu.donetsk.ua
*  Date: 23/03/99
*
*  List of changes:
******************************************************************}

unit ZMySQLTr;

interface

{$R *.DCR}

uses
  SysUtils, Windows, DB, Classes, Forms, ZDirSql, ZDirMySql, LibMySQL, ZToken,
  ZMySQLCon, ZDirTrSql;

{$I ..\Zeos.inc}

type
{***************** TMySQLTransact definition ********************}

TMySQLTransact = class(TComponent)
private
  FConnected: Boolean;            // Is connected?
  FUseTransServer: Boolean;       // Is user transact-server?
  FHost, FPort: String;           // Server host name and port
  FDatabase: TMySQLDatabase;      // Connect to
  FAutoCommit: Boolean;           // Is autocommit?

  FTrDb: TDirTrSQLConnect;        // Transact-server connect handle
  FTrQuery: TDirTrSQLQuery;       // Transact-server query handle

  procedure SetConnected(Value: Boolean);
  procedure SetHost(Value: String);
  procedure SetDatabase(Value: TMySQLDatabase);
public
// Class constructor
  constructor Create(AOwner: TComponent); override;
// Class destructor
  destructor Destroy; override;

// Connect to SQL-database
  procedure Connect;
// Disconnect from database
  procedure Disconnect;
// Execute a query
  procedure ExecSQL(SQL: String);
// Commit transaction
  procedure Commit;
// Rollback transaction
  procedure Rollback;

// Transaction connect status
  property Connected: Boolean read FConnected write SetConnected;
// Transact-server connect handle
  property Handle: TDirTrSQLQuery read FTrQuery;
published
// Connect to database component
  property Database: TMySQLDatabase read FDatabase write SetDatabase;
// SQL-server host name
  property Host: String read FHost write SetHost;
// Transact-server port
  property Port: String read FPort write FPort;
// Is use transact-server
  property UseTransServer: Boolean read FUseTransServer write FUseTransServer;
// Is autocommit
  property AutoCommit: Boolean read FAutoCommit write FAutoCommit;
end;

procedure Register;

implementation

{***************** TMySQLTransact implementation *****************}

// Class constructor
constructor TMySQLTransact.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FTrDb := TDirTrSQLConnect.Create;
  FTrQuery := TDirTrSQLQuery.CreateDb(FTrDb);
  FPort := '19700';
  FHost := '';
  FUseTransServer := false;
  FAutoCommit := false;
end;

// Class destructor
destructor TMySQLTransact.Destroy;
begin
  Disconnect;
  FTrQuery.Free;
  FTrDb.Free;
  inherited;
end;

// Set connected prop
procedure TMySQLTransact.SetConnected(Value: Boolean);
begin
  if Value=FConnected then exit;
  if Value then Connect
  else Disconnect;
end;

// Set new host name
procedure TMySQLTransact.SetHost(Value: String);
begin
  Disconnect;
  FHost := Value;
end;

// Set database connection prop
procedure TMySQLTransact.SetDatabase(Value: TMySQLDatabase);
begin
  Disconnect;
  FDatabase := Value;
  FHost := Value.Host;
end;

// Connect to SQL-database
procedure TMySQLTransact.Connect;
begin
  if FConnected then exit;

  // Connect to database
  if not Assigned(FDatabase) then
{$IFDEF RUSSIAN}
    DatabaseError('    ');
{$ELSE}
    DatabaseError('Connect to database not defined');
{$ENDIF}
  FDatabase.Connect;
  if FDatabase.Connected=false then
{$IFDEF RUSSIAN}
    DatabaseError('   ');
{$ELSE}
    DatabaseError('Connect tro database error');
{$ENDIF}

  // Create connect to transact-server
  if UseTransServer then begin
    FTrDb.ConnectFull(FHost, FPort, FDatabase.Database,
       FDatabase.Login, FDatabase.Password);
    if FTrDb.Status<>DB_CONNECTION_OK then
{$IFDEF RUSSIAN}
      DatabaseError('   -');
{$ELSE}
      DatabaseError('Can not connect to transact-server');
{$ENDIF}

{$IFDEF RUSSIAN}
    FTrQuery.SQL := 'SET OPTION CHARACTER SET CP1251_KOI8';
    FTrQuery.Exec;
    if FTrQuery.Status<>DB_COMMAND_OK then
      DatabaseError('   -.');
{$ENDIF}
  end;
  FConnected := true;
end;

// Disconnect from database
procedure TMySQLTransact.Disconnect;
begin
  if not FConnected then exit;
  FTrDb.Disconnect;
  FConnected := false;
end;

// Execute a query
procedure TMySQLTransact.ExecSQL(SQL: String);
begin
  if not FConnected then
{$IFDEF RUSSIAN}
    DatabaseError('   ');
{$ELSE}
    DatabaseError('Not connected yet');
{$ENDIF}

  if UseTransServer then begin
    if not Assigned(FTrDb.Handle) then
{$IFDEF RUSSIAN}
      DatabaseError(' c -  ');
{$ELSE}
      DatabaseError('Not connected with transact-server');
{$ENDIF}

    FTrQuery.SQL := SQL;
    FTrQuery.Exec;
    if FTrQuery.Status<>DB_COMMAND_OK then
      DatabaseError(FTrDb.Error);

    if FAutoCommit then begin
      FTrQuery.SQL := 'COMMIT';
      FTrQuery.Exec;
      if FTrQuery.Status<>DB_COMMAND_OK then
        DatabaseError(FTrDb.Error);
    end;
  end else begin
    if not Assigned(FDatabase) then
{$IFDEF RUSSIAN}
      DatabaseError('    ');
{$ELSE}
      DatabaseError('Is not defined connect to database');
{$ENDIF}

    FDatabase.ExecSQL(SQL);
  end;
end;

// Commit transaction
procedure TMySQLTransact.Commit;
begin
  if UseTransServer then ExecSQL('COMMIT');
end;

// Rollback transaction
procedure TMySQLTransact.Rollback;
begin
  if UseTransServer then ExecSQL('ROLLBACK');
end;


{****************************************************}

// Register component in component palette
procedure Register;
begin
  RegisterComponents(ZEOS_PALETTE, [TMySQLTransact]);
end;

end.
