{******************************************************************
*  (c)copyrights Corona Ltd. Donetsk 1999
*  Project: Zeos Library
*  Module: TMySQLQuery class for direct MySQL access (version 2.0)
*  Author: Sergey Seroukhov   E-Mail: voland@cm.dongu.donetsk.ua
*  Date: 27/01/99
*
*  List of changes:
******************************************************************}

//****************** Include file *********************
//**************** BLOB-fields support *****************

type

{************ TMyBlobStream definition ***************}

// Class for blobs support
TMyBlobStream = class(TStream)
private
  FField: TBlobField;
  FBlobIdx: Integer;
  FDataSet: TMySQLQuery;
  FBuffer: PRecordData;
  FMode: TBlobStreamMode;
  FOpened: Boolean;
  FModified: Boolean;
  FPosition: LongInt;
  function GetBlobSize: LongInt;
  function GetBlobOffset(FieldNum: Integer): Integer;
public
  constructor Create(Field: TBlobField; Mode: TBlobStreamMode);
  destructor Destroy; override;
  function Read(var Buffer; Count: LongInt): LongInt; override;
  function Write(const Buffer; Count: LongInt): LongInt; override;
  function Seek(Offset: LongInt; Origin: Word): LongInt; override;
  procedure Truncate;
end;

{*************** TMyBlobStream implementation ****************}

constructor TMyBlobStream.Create(Field: TBlobField; Mode: TBlobStreamMode);
begin
  FMode := Mode;
  FField := Field;
  FDataset := FField.Dataset as TMySQLQuery;
  if not FDataset.GetActiveRecBuf(FBuffer) then
    Exit;
  FBlobIdx := GetBlobOffset(FField.FieldNo);
  if not FField.Modified then begin
    if Mode<>bmRead then
      if not (FDataset.State in [dsEdit, dsInsert]) then
{$IFDEF RUSSIAN}
        DatabaseError('   Insert  Edit');
{$ELSE}
        DatabaseError('Not in Insert or Edit mode');
{$ENDIF}
  end;
  FOpened := True;
  if Mode=bmWrite then begin
    Truncate;
  end;
end;

destructor TMyBlobStream.Destroy;
begin
  if FOpened then begin
    if FModified then FField.Modified := True;
  end;
  if FModified then begin
    try
      FDataSet.DataEvent(deFieldChange, LongInt(FField));
    except
      Application.HandleException(Self);
    end;
  end;
end;

function TMyBlobStream.Read(var Buffer; Count: LongInt): LongInt;
begin
  Result := 0;
  if FOpened then begin
    if Count>Size - FPosition then begin
      Result := Size - FPosition;
    end else begin
      Result := Count;
    end;
    if Result>0 then begin
      Move(FBuffer^.Blobs[FBlobIdx].BlobData^[FPosition], Buffer, Result);
      Inc(FPosition, Result);
    end;
  end;
end;

function TMyBlobStream.Write(const Buffer; Count: LongInt): LongInt;
var
  Temp: Pointer;
  NewSize: Integer;
begin
  Result := 0;
  if FOpened then begin
    NewSize := FPosition + Count;
    if NewSize<FBuffer^.Blobs[FBlobIdx].BlobSize then begin
      NewSize := FBuffer^.Blobs[FBlobIdx].BlobSize;
    end;

    if (NewSize>FBuffer^.Blobs[FBlobIdx].BlobSize) or
      not (FModified or FField.Modified) then begin
      GetMem(Temp, NewSize);
      if (FBuffer^.Blobs[FBlobIdx].BlobData<>NIL) and
        (FBuffer^.Blobs[FBlobIdx].BlobSize>0) then begin
        Move(FBuffer^.Blobs[FBlobIdx].BlobData^, Temp^, FBuffer^.Blobs[FBlobIdx].BlobSize);
//        if (FModified or FField.Modified) then begin
//          FreeBlob(FBuffer);
//        end;
      end;
      FBuffer^.Blobs[FBlobIdx].BlobData := Temp;
    end;
    Move(Buffer, FBuffer^.Blobs[FBlobIdx].BlobData^[FPosition], Count);
    Inc(FPosition, Count);
    if FPosition>FBuffer^.Blobs[FBlobIdx].BlobSize then begin
      FBuffer^.Blobs[FBlobIdx].BlobSize := FPosition;
    end;
    Result := Count;
    FModified := true;
  end;
end;

function TMyBlobStream.Seek(Offset: LongInt; Origin: Word): LongInt;
begin
  case Origin of
    0: FPosition := Offset;
    1: Inc(FPosition, Offset);
    2: FPosition := GetBlobSize + Offset;
  end;
  Result := FPosition;
end;

procedure TMyBlobStream.Truncate;
begin
  if FOpened then begin
    FPosition := 0;
//    if FField.Modified then FreeBlob(FBuffer);
//    if FBuffer^.Blobs[FBlobIdx].BlobData<>NIL then
//      FreeMem(FBuffer^.Blobs[FBlobIdx].BlobData, FBuffer^.Blobs[FBlobIdx].BlobSize);
    FBuffer^.Blobs[FBlobIdx].BlobData := NIL;
    FBuffer^.Blobs[FBlobIdx].BlobSize := 0;
//    FBuffer^.Blobs[FBlobIdx].FieldNum := 0;
    FModified := true;
  end;
end;

function TMyBlobStream.GetBlobSize: LongInt;
begin
  Result := 0;
  if FOpened then begin
    Result := FBuffer^.Blobs[FBlobIdx].BlobSize;
  end;
end;

function TMyBlobStream.GetBlobOffset(FieldNum: Integer): Integer;
var Idx: Integer;
begin
  Result := 0;
  for Idx:=0 to 15 do begin
    if FBuffer^.Blobs[Idx].FieldNum=FieldNum then begin
      Result := Idx;
      Exit;
    end;
  end;
  for Idx:=0 to 15 do begin
    if FBuffer^.Blobs[Idx].FieldNum=0 then begin
      FBuffer^.Blobs[Idx].FieldNum := FieldNum;
      Result := Idx;
      Exit;
    end;
  end;
end;

// Close blobs
procedure TMySQLQuery.CloseBlob(Field: TField);
begin
//  FreeBlob(PRecordData(ActiveBuffer));
end;

// Create a blob stream
function TMySQLQuery.CreateBlobStream(Field: TField; Mode: TBlobStreamMode): TStream;
begin
  Result := TMyBlobStream.Create(Field as TBlobField, Mode);
end;

