{******************************************************************
*  (c)copyrights Corona Ltd. Donetsk 1999
*  Project: Zeos Library
*  Module: TMySQLQuery class for direct MySQL access (version 2.0)
*  Author: Sergey Seroukhov   E-Mail: voland@cm.dongu.donetsk.ua
*  Date: 27/01/99
*
*  List of changes:
******************************************************************}

//****************** Include file *********************
//******** Cached updates support ***********

// Post updates from buffer
procedure TMySQLQuery.FlushBuffer;
var
  I, N1, N2: Integer;
  Error: String;
  New, Old: TFieldValues;
begin
  if not FRequestLive then exit;

  New := TFieldValues.Create;
  Old := TFieldValues.Create;

  Error := '';
  for I := 0 to SaveRecords.Count-1 do begin
    N1 := TDBRecord(SaveRecords.Items[I]).Index;
    if TDBRecord(SaveRecords.Items[I]).FieldStatus=fsNormal then continue;
    
    N2 := Records.FindRecord(N1);
    if N2<0 then begin
      TDBRecord(SaveRecords.Items[I]).Free;
      continue;
    end;
    FillFieldValues(TDBRecord(SaveRecords.Items[I]).Data, Old);
    FillFieldValues(TDBRecord(Records.Items[N2]).Data, New);
    if Assigned(FApplyUpdates) then
      FApplyUpdates(Self, Old, New, TDBRecord(SaveRecords.Items[I]).FieldStatus)
    else
      FormSQLQuery(Old, New, TDBRecord(SaveRecords.Items[I]).FieldStatus);

// Apply auto_increment fields
    if not FTransact.UseTransServer and not FUseGen and
      (TDBRecord(SaveRecords.Items[I]).FieldStatus in [fsInserted, fsAppend])
      and (GetAutoIncField(FTables[0])<>'') then begin
      SetRealFieldValue(GetRealFieldNo(GetAutoIncField(FTables[0])),
        IntToStr(FDb.Handle.Extra_Info),TDBRecord(Records.Items[N2]).Data);
    end;

// Cancel update record
    TDBRecord(SaveRecords.Items[I]).FieldStatus := fsNormal;
    if TDBRecord(Records.Items[N2]).FieldStatus<>fsDeleted then
      TDBRecord(Records.Items[N2]).FieldStatus := fsNormal
    else TDBRecord(Records.Items[N2]).Free;
  end;

  New.Free;
  Old.Free;
  if Error<>'' then DatabaseError(Error);
end;

// Clear updates from cache
procedure TMySQLQuery.ClearBuffer;
var I: Integer;
begin
// Clear old records and erase marks
  SaveRecords.Clear;
  for I := Records.Count-1 downto 0 do
    if TDBRecord(Records.Items[I]).FieldStatus<>fsDeleted then
      TDBRecord(Records.Items[I]).FieldStatus := fsNormal
    else TDBRecord(Records.Items[I]).Free;

  if FCurRec>=Records.Count then FCurRec := Records.Count-1;
end;

// Commit updates
procedure TMySQLQuery.Flush;
begin
  FlushBuffer;
  ClearBuffer;
end;

// Post cached updates
procedure TMySQLQuery.ApplyUpdates;
begin
  if State in [dsEdit, dsInsert] then Post;
  FlushBuffer;
  if not (State in [dsInactive]) then Resync([]);
end;

// Clear updates buffer
procedure TMySQLQuery.CommitUpdates;
begin
  ClearBuffer;
end;

// Rollback all cached updates
procedure TMySQLQuery.CancelUpdates;
var
  I, N: Integer;
  TempRecord: TDBRecord;
begin
  if State in [dsEdit, dsInsert] then Cancel;

// Rollback updates
  for I := Records.Count-1 downto 0  do begin
    TempRecord := TDBRecord(Records.Items[I]);
    if TempRecord.FieldStatus=fsNormal then continue;
    if TempRecord.FieldStatus in [fsInserted, fsAppend] then TempRecord.Free
    else begin
      N := SaveRecords.FindRecord(TempRecord.Index);
      if N<0 then
{$IFDEF RUSSIAN}
        DatabaseError('   ');
{$ELSE}
        DatabaseError('Internal structure buffer error');
{$ENDIF}
      TempRecord.Copy(TDBRecord(SaveRecords.Items[N]));
      TempRecord.FieldStatus := fsNormal;
    end;
  end;

  SaveRecords.Clear;
// Reread visible records
  if not (State in [dsInactive]) then Resync([]);

  if not FRequestLive then
{$IFDEF RUSSIAN}
    DatabaseError('    "  "');
{$ELSE}
    DatabaseError('Incorrect command in "Read Only" mode');
{$ENDIF}
end;

// Record update type
function TMySQLQuery.UpdateStatus: TUpdateStatus;
begin
  case TDBRecord(Records.Items[FCurRec]).FieldStatus of
    fsInserted,fsAppend: Result := usInserted;
    fsDeleted: Result := usDeleted;
    fsUpdated: Result := usModified;
    else Result := usUnmodified;
  end;
end;

// Erase updates for a field
procedure TMySQLQuery.RevertRecord;
var
  I: Integer;
  TempRecord: TDBRecord;
begin
  if not FRequestLive then exit;
  if State in [dsInsert] then begin
    Cancel;
    exit;
  end;
  if State in [dsEdit] then Cancel;
// Rollback changed
  TempRecord := TDBRecord(Records.Items[FCurRec]);
  if TempRecord.FieldStatus=fsNormal then exit;

  for I := 0 to SaveRecords.Count-1 do begin
    if TempRecord.Index<>TDBRecord(SaveRecords.Items[I]).Index then continue;

    if TDBRecord(SaveRecords.Items[I]).FieldStatus in [fsInserted, fsAppend] then
      TempRecord.Free
    else begin
      TempRecord.Copy(TDBRecord(SaveRecords.Items[I]));
      TempRecord.FieldStatus := fsNormal;
    end;
    TDBRecord(SaveRecords.Items[I]).Free;

    if not (State in [dsInactive]) then Resync([]);
    exit;
  end;
end;

// Check if any updates in a cache buffer
function TMySQLQuery.GetUpdatesPending: Boolean;
begin
  if State=dsInactive then Result := false
  else Result := SaveRecords.Count>0;
end;

// Set visible updated records types
procedure TMySQLQuery.SetUpdateRecord(Value: TShowRecordTypes);
begin
  FUpdateRecord := Value;
  if not (State in [dsInactive]) then Resync([]);
end;

