{******************************************************************
*  (c)copyrights Corona Ltd. Donetsk 1999
*  Project: Zeos Library
*  Module: TMySQLQuery class for direct MySQL access (version 2.0)
*  Author: Sergey Seroukhov   E-Mail: voland@cm.dongu.donetsk.ua
*  Date: 27/01/99
*
*  List of changes:
******************************************************************}

//****************** Include file *********************
//********** Master-detail links support ************

// Get link field names
function TMySQLQuery.GetLinkFields: String;
begin
  Result := FLinkFields;
end;

// Set link field values
procedure TMySQLQuery.SetLinkFields(const Value: String);
var
  Buffer, Token, FieldList: String;
  TokenType: TTokenType;
begin
  FLinkCount := 0;
  Buffer := Value;
  FieldList := '';
  while Buffer<>'' do begin
    TokenType := ExtractTokenEx(Buffer, Token);
    case TokenType of
      ttAlpha: begin
          FDetailFields[FLinkCount] := Token;
        end;
      ttString: begin
          DeleteQuotes(Token);
          FDetailFields[FLinkCount] := Token;
        end;
      else
{$IFDEF RUSSIAN}
        DatabaseError('   ');
{$ELSE}
        DatabaseError('Incorrect links define');
{$ENDIF}
    end;

    ExtractTokenEx(Buffer, Token);
    if Token<>'=' then
{$IFDEF RUSSIAN}
      DatabaseError('   ');
{$ELSE}
      DatabaseError('Incorrect links define');
{$ENDIF}

    TokenType := ExtractTokenEx(Buffer, Token);
    case TokenType of
      ttAlpha: begin
          FMasterFields[FLinkCount] := Token;
          if FieldList<>'' then FieldList := FieldList + ', ';
          FieldList := FieldList + Token;
        end;
      ttString: begin
          if FieldList<>'' then FieldList := FieldList + ', ';
          FieldList := FieldList + Token;
          DeleteQuotes(Token);
          FMasterFields[FLinkCount] := Token;
        end;
      else
{$IFDEF RUSSIAN}
        DatabaseError('   ');
{$ELSE}
        DatabaseError('Incorrect links define');
{$ENDIF}
    end;
    Inc(FLinkCount);
    ExtractToken(Buffer, Token);
    if Token='' then break;
    if Token<>',' then PutbackToken(Buffer, Token);
  end;
  FLinkFields := Value;
  FMasterLink.FieldNames := FieldList;
end;

// Get master datasource
function TMySQLQuery.GetMasterDataSource: TDataSource;
begin
  Result := FMasterLink.DataSource;
end;

// Set master source
procedure TMySQLQuery.SetMasterDataSource(Value: TDataSource);
begin
  if IsLinkedTo(Value) then
{$IFDEF RUSSIAN}
    DatabaseError('   Dataset');
{$ELSE}
    DatabaseError('Cyclic link in Dataset');
{$ENDIF}
  FMasterLink.DataSource := Value;
end;

// Master dataset change event
procedure TMySQLQuery.MasterChanged(Sender: TObject);
var Temp: String;
begin
  if not FMasterLink.Active then exit;

  CheckBrowseMode;

  if FLinkRequery then begin
    Temp := FQuery.SQL;
    MasterRequery;
    if Temp=FQuery.SQL then exit;

// Quick query refresh
    ApplyUpdates;

    FQuery.Close;
    Records.Clear;
    FQuery.Open;
    if not FQuery.Active then
{$IFDEF RUSSIAN}
      DatabaseError('   ');
{$ELSE}
      DatabaseError('Error in form detail query');
{$ENDIF}

    FLastBookmark := 0;
    FFetchCount := 0;
    FCurRec := -1;

    FirstFetch := True;
  end;

  if not (State in [dsInactive]) then begin
    First;
    Resync([]);
  end;
end;

// Master dataset deactivate event
procedure TMySQLQuery.MasterDisabled(Sender: TObject);
begin
  First;
  if not (State in [dsInactive]) then Resync([]);
end;

// Detail query restructure
procedure TMySQLQuery.MasterRequery;
var
  Sql, Select, From, Where, Group, OrderBy, Other, Add: String;
  MasterField: TField;
  I, N: Integer;
begin
  if (not FMasterLink.Active) or (not FLinkRequery) then begin
    FQuery.Sql := FSql.Text;
    exit;
  end;

  Sql := FSql.Text;

  if not SplitQuery(Sql,Select,From,Where,Group,OrderBy,Other) then
    FLinkRequery := false
  else begin

    Add := '';
    if FMasterLink.Active and (FMasterLink.Fields.Count > 0) then begin
      for I := 0 to FLinkCount-1 do begin
        N := 0; MasterField := NIL;
        while N<FMasterLink.Fields.Count do begin
          MasterField := TField(FMasterLink.Fields[N]);
          if MasterField.FieldName = FMasterFields[I] then break;
          MasterField := NIL;
          Inc(N);
        end;

        if not Assigned(MasterField) then
{$IFDEF RUSSIAN}
          DatabaseError('   "'+FMasterFields[I]+'"');
{$ELSE}
          DatabaseError('Incorrect field name "'+FMasterFields[I]+'"');
{$ENDIF}

        if Add<>'' then Add := Add + ' AND ';
        Add := Add + FDetailFields[I] + '="' + MasterField.AsString + '"';
      end;
    end;
  end;

  if Add<>'' then begin
    if Where<>'' then Where := '(' + Where + ') AND ';
    Where := Where + Add;
  end;

  FQuery.Sql := FormQuery(Select,From,Where,Group,OrderBy,Other);
end;

