{******************************************************************
*  (c)copyrights Corona Ltd. Donetsk 1999
*  Project: Zeos Library
*  Module: TMySQLQuery class for direct MySQL access (version 2.0)
*  Author: Sergey Seroukhov   E-Mail: voland@cm.dongu.donetsk.ua
*  Date: 27/01/99
*
*  List of changes:
******************************************************************}

{****************** Include file *********************}
{*********** Sorting records in a query **************}

// Inverse records order
procedure TMySQLQuery.SortInverse;
var
  I, N: LongInt;
  TempRecords: TDBRecords;
  TempField: TDBRecord;
begin
  while not FQuery.EOF do QueryRecord;
  if Records.Count=0 then exit;

  TempRecords := TDBRecords.Create;
  N := TDBRecord(Records.Items[RecNo-1]).Index;
  for I := Records.Count-1 downto 0 do begin
    TempField := TDBRecord(TempRecords.Add);
    TempField.Assign(Records.Items[I]);
    TempField.ArrangeIndex := I+1;
// Null buffer pointer to undelete
    TDBRecord(Records.Items[I]).Data := NIL;
  end;
  Records.Free;
  Records := TempRecords;

// Reread visible records
  if not (State in [dsInactive]) then Resync([]);
// Position cursor to last record
  N := TempRecords.FindRecord(N);
  if N>=0 then RecNo := N+1;
end;

// Inc records sort by a field
procedure TMySQLQuery.SortByField(FieldName: String);
var
  I, J, N, M, FieldNo: LongInt;
  TempRecords: TDBRecords;
  TempField: TDBRecord;
  Value, MinValue: Variant;
begin
  while not FQuery.EOF do QueryRecord;
  if Records.Count=0 then exit;

  FieldNo := GetRealFieldNo(FieldName);
  if FieldNo<0 then
{$IFDEF RUSSIAN}
    DatabaseError('  ');
{$ELSE}
    DatabaseError('Incorrect field name');
{$ENDIF}

  TempRecords := TDBRecords.Create;
  N := TDBRecord(Records.Items[RecNo-1]).Index;

  J := 0;
  while Records.Count>0 do begin
    M := 0;
    MinValue := GetRealFieldValue(FieldNo, TDBRecord(Records.Items[0]).Data);
    for I := 0 to Records.Count-1  do begin
      Value := GetRealFieldValue(FieldNo, TDBRecord(Records.Items[I]).Data);
      if Value<MinValue then begin
        MinValue := Value;
        M := I;
      end;
    end;
    TempField := TDBRecord(TempRecords.Add);
    TempField.Assign(Records.Items[M]);
    TempField.ArrangeIndex := J+1;
// Null buffer pointer to undelete
    TDBRecord(Records.Items[M]).Data := NIL;
    TDBRecord(Records.Items[M]).Free;
  end;
  Records.Free;
  Records := TempRecords;

// Reread visible records
  if not (State in [dsInactive]) then Resync([]);
// Position to last record
  N := TempRecords.FindRecord(N);
  if N>=0 then RecNo := N+1;
end;

// Desc records sort by a field
procedure TMySQLQuery.SortDescByField(FieldName: String);
var
  I, J, N, M, FieldNo: LongInt;
  TempRecords: TDBRecords;
  TempField: TDBRecord;
  Value, MaxValue: Variant;
begin
  while not FQuery.EOF do QueryRecord;
  if Records.Count=0 then exit;

  FieldNo := GetRealFieldNo(FieldName);
  if FieldNo<0 then
{$IFDEF RUSSIAN}
    DatabaseError('  ');
{$ELSE}
    DatabaseError('Incorrect field name');
{$ENDIF}

  TempRecords := TDBRecords.Create;
  N := TDBRecord(Records.Items[RecNo-1]).Index;

  J := 0;
  while Records.Count>0 do begin
    M := 0;
    MaxValue := GetRealFieldValue(FieldNo, TDBRecord(Records.Items[0]).Data);
    for I := 0 to Records.Count-1  do begin
      Value := GetRealFieldValue(FieldNo, TDBRecord(Records.Items[I]).Data);
      if Value>MaxValue then begin
        MaxValue := Value;
        M := I;
      end;
    end;
    TempField := TDBRecord(TempRecords.Add);
    TempField.Assign(Records.Items[M]);
    TempField.ArrangeIndex := J+1;
// Null buffer pointer to undelete
    TDBRecord(Records.Items[M]).Data := NIL;
    TDBRecord(Records.Items[M]).Free;
  end;
  Records.Free;
  Records := TempRecords;

// Reread visible records
  if not (State in [dsInactive]) then Resync([]);
// Position cursor to last record
  N := TempRecords.FindRecord(N);
  if N>=0 then RecNo := N+1;
end;

const MAX_VALUE = 999999999;

// Clear records sort order
procedure TMySQLQuery.SortClear;
var
  I, J, N1, M, N2: LongInt;
  TempRecords: TDBRecords;
  TempField: TDBRecord;
begin
//  while not FQuery.EOF do QueryRecord;
  if Records.Count=0 then exit;

  TempRecords := TDBRecords.Create;
  N1 := TDBRecord(Records.Items[MinIntValue([Records.Count,RecNo])-1]).Index;
  for I := 0 to Records.Count-1 do begin
    M := MAX_VALUE;
    N2 := -1;
    for J := 0 to Records.Count-1 do
      if TDBRecord(Records.Items[J]).Index<M then begin
        N2 := J;
        M := TDBRecord(Records.Items[J]).Index;
      end;
    if N2<0 then begin
{$IFDEF RUSSIAN}
      DatabaseError('    NormalArrange');
{$ELSE}
      DatabaseError('Internal error in NormalArrange');
{$ENDIF}
      exit;
    end;
    TempField := TDBRecord(TempRecords.Add);
    TempField.Assign(Records.Items[N2]);
    if TempField.ArrangeIndex>0 then TempField.ArrangeIndex := I+1;
// Null buffer pointer to undelete
    TDBRecord(Records.Items[N2]).Data := NIL;
    TDBRecord(Records.Items[N2]).Index := MAX_VALUE;
  end;
  Records.Free;
  Records := TempRecords;

// Reread visible records
  if not (State in [dsInactive]) then Resync([]);
// Position cursor to last record
  N1 := TempRecords.FindRecord(N1);
  if N1>=0 then RecNo := N1+1;
end;

// Check is record hided by filter?
function TMySQLQuery.CheckRecordByFilter(RecNo: LongInt): Boolean;
var
  I, N: Integer;
  Buffer: PRecordData;
  Temp: String;
  MasterField: TField;
begin
  if (RecNo<0) or (RecNo>=Records.Count) then begin
    Result := false;
    exit;
  end;

  Buffer := TDBRecord(Records.Items[RecNo]).Data;
  Result := true;

  if FCachedUpdates then begin
    case TDBRecord(Records.Items[RecNo]).FieldStatus of
      fsInserted, fsAppend:
        if not (rtInserted in FUpdateRecord) then Result := false;
      fsDeleted:
        if not (rtDeleted in FUpdateRecord) then Result := false;
      fsUpdated:
        if not (rtModified in FUpdateRecord) then Result := false;
      else
        if not (rtUnmodified in FUpdateRecord) then Result := false;
    end;
    if Result=false then exit;
  end;

  if (not FLinkRequery) and FMasterLink.Active
    and (FMasterLink.Fields.Count > 0) then begin
    for I := 0 to FLinkCount-1 do begin
      N := 0; MasterField := NIL;
      while N<FMasterLink.Fields.Count do begin
        MasterField := TField(FMasterLink.Fields[N]);
        if MasterField.FieldName = FMasterFields[I] then break;
        MasterField := NIL;
        Inc(N);
      end;

      if not Assigned(MasterField) then
{$IFDEF RUSSIAN}
        DatabaseError('   "'+FMasterFields[I]+'"');
{$ELSE}
        DatabaseError('Incorrect field name "'+FMasterFields[I]+'"');
{$ENDIF}

      N := GetRealFieldNo(FDetailFields[I]);
      if N<0 then
{$IFDEF RUSSIAN}
        DatabaseError('   "'+FDetailFields[I]+'"');
{$ELSE}
        DatabaseError('Incorrect field name "'+FDetailFields[I]+'"');
{$ENDIF}
      if VarAsType(GetRealFieldValue(N, Buffer),varString)<>
        MasterField.AsString then begin
        Result := false;
        break;
      end;
    end;
    if Result = false then exit;
  end;

  if not Assigned(FParser) or (FParser.Equation='') then exit;

  for I := 0 to FParser.VarCount-1 do begin
    N := GetRealFieldNo(FParser.VarNames[I]);
    if N<0 then
{$IFDEF RUSSIAN}
      DatabaseError('   "'+FParser.VarNames[I]+'"');
{$ELSE}
      DatabaseError('Incorrect field name "'+FParser.VarNames[I]+'"');
{$ENDIF}
    FParser.Variables[FParser.VarNames[I]] := GetRealFieldValue(N, Buffer);
  end;
  Temp := VarAsType(FParser.Evalute, varString);
  if StrToFloatDefEx(Temp,-1)<>0 then Result := true
  else Result := false;
end;

