{******************************************************************
*  (c)copyrights Corona Ltd. Donetsk 1999
*  Project: Zeos Library
*  Module: TMySQLQuery class for direct MySQL access (version 2.0)
*  Author: Sergey Seroukhov   E-Mail: voland@cm.dongu.donetsk.ua
*  Date: 27/01/99
*
*  List of changes:
******************************************************************}

//****************** Include file *********************
//************* SQL-queries processing ******************

// Define all fields in a query
// TableName - table name
procedure TMySQLQuery.FillAllFields(TableName: String);
var
  I: Integer;
  Temp: String;
begin
  FExecQuery := TDirMySQLQuery.CreateDb(FDb);

  Temp := TableName; TableName := '';
  for I:=0 to FTables.Count-1 do
    if FTables[I]=Temp then
      TableName := FTables[I];
  if TableName='' then begin
    for I:=0 to FAliases.Count-1 do
      if FAliases[I]=Temp then
        TableName := FTables[I];
  end;
  if TableName='' then TableName := Temp;

  FExecQuery.SQL := 'SHOW COLUMNS FROM ' + TableName;
  FExecQuery.Open;
  with FExecQuery do
    while not FExecQuery.EOF do begin
      PutFieldDesc(TableName, FExecQuery.Fields[0], TableName+'.'+FExecQuery.Fields[0],
        FExecQuery.Fields[1], FExecQuery.Fields[2], FExecQuery.Fields[3],
        FExecQuery.Fields[4], FExecQuery.Fields[5]);
        FExecQuery.Next;
    end;
  FExecQuery.Free;
end;

// Define all indexed fields in a query
// TableName - table name
(*
procedure TMySQLQuery.FillAllIndexFields(TableName: String);
begin
  FExecQuery := TDirMySQLQuery.CreateDb(FDb);
  FExecQuery.SQL := 'SHOW COLUMNS FROM ' + TableName + ' LIKE "%No"';
  FExecQuery.Open;
  with FExecQuery do
    while not FExecQuery.EOF do begin
      PutFieldDesc(TableName, FExecQuery.Fields[0], TableName+'.'+FExecQuery.Fields[0],
        FExecQuery.Fields[1], FExecQuery.Fields[2], FExecQuery.Fields[3],
        FExecQuery.Fields[4], FExecQuery.Fields[5]);
        FExecQuery.Next;
    end;
  FExecQuery.Free;
end;
*)

// Define a field
// TableName - table name
// FieldName - field name
// AliasName - alias name
procedure TMySQLQuery.FillField(TableName, FieldName, AliasName: String);
var I: Integer;
begin
  FExecQuery := TDirMySQLQuery.CreateDb(FDb);

  for I := 0 to FAliases.Count-1 do
    if TableName=FAliases[I] then begin
      TableName := FTables[I];
      break;
    end;

  if TableName<>'' then begin
    FExecQuery.SQL := 'SHOW COLUMNS FROM ' + TableName + ' LIKE "' + FieldName + '"';
    FExecQuery.Open;
    with FExecQuery do
      if not FExecQuery.EOF then begin
        PutFieldDesc(TableName, FExecQuery.Fields[0], AliasName, FExecQuery.Fields[1],
          FExecQuery.Fields[2], FExecQuery.Fields[3], FExecQuery.Fields[4],
          FExecQuery.Fields[5]);
      end;
  end else begin
    for I:=0 to FTables.Count-1 do begin
      TableName := FTables[I];
      FExecQuery.SQL := 'SHOW COLUMNS FROM ' + TableName + ' LIKE "' + FieldName + '"';
      FExecQuery.Open;
      with FExecQuery do
        if not FExecQuery.EOF then begin
          PutFieldDesc(TableName, FExecQuery.Fields[0], AliasName, FExecQuery.Fields[1],
            FExecQuery.Fields[2], FExecQuery.Fields[3], FExecQuery.Fields[4],
            FExecQuery.Fields[5]);
          break;
        end;
    end;
  end;
  FExecQuery.Free;
end;

// Store field description
// Table - table name
// Field - field name
// Alias - table alias
// TypeName - field type
// Null - is nulls
// Key - key type
// Def - default value
// Extra - autoupdate type
procedure TMySQLQuery.PutFieldDesc(Table, Field, Alias, TypeName, Null, Key,
  Def, Extra: String);
var
  I: Integer;
  Fld: TMySQLField;
begin
  for I := 0 to FFieldDescs.Count-1 do
    if (TMySQLField(FFieldDescs.Items[I]).Alias=Alias) then exit;

  Fld := TMySQLField.Create(FFieldDescs);
  Fld.Table := Table;
  Fld.Field := Field;
  Fld.Alias := Alias;
  Fld.Length := 0;

  if Pos('int',TypeName)>0 then begin
    Fld.FieldType := ftInteger;
  end else if Copy(TypeName,1,6)='year' then begin
    Fld.FieldType := ftInteger;
  end else if Copy(TypeName,1,6)='double' then begin
    Fld.FieldType := ftFloat;
  end else if Copy(TypeName,1,5)='float' then begin
    Fld.FieldType := ftFloat;
  end else if Copy(TypeName,1,4)='real' then begin
    Fld.FieldType := ftFloat;
  end else if Copy(TypeName,1,7)='decimal' then begin
    Fld.FieldType := ftFloat;
  end else if Copy(TypeName,1,7)='numeric' then begin
    Fld.FieldType := ftFloat;
  end else if Copy(TypeName,1,4)='char' then begin
    Fld.FieldType := ftString;
    Fld.Length := StrToIntDef(Copy(TypeName,6,Length(TypeName)-6),50);
  end else if Copy(TypeName,1,7)='varchar' then begin
    Fld.FieldType := ftString;
    Fld.Length := StrToIntDef(Copy(TypeName,9,Length(TypeName)-9),50);
  end else if TypeName='date' then begin
    Fld.FieldType := ftDate;
  end else if TypeName='datetime' then begin
    Fld.FieldType := ftDateTime;
  end else if Copy(TypeName,1,9)='timestamp' then begin
    Fld.FieldType := ftString;
    Fld.Length := StrToIntDef(Copy(TypeName,11,Length(TypeName)-11),50);
  end else if TypeName='time' then begin
    Fld.FieldType := ftTime;
  end else if Pos('blob',TypeName)>0 then begin
    Fld.FieldType := ftBlob;
  end else if Pos('text',TypeName)>0 then begin
    Fld.FieldType := ftMemo;
  end else if (LowerCase(TypeName)='enum('+#39+'y'+#39+','+#39+'n'+#39+')') or
    (LowerCase(TypeName)='enum('+#39+'n'+#39+','+#39+'y'+#39+')') then begin
    Fld.FieldType := ftBoolean;
  end else if Copy(TypeName,1,4)='enum' then begin
    Fld.FieldType := ftString;
    Fld.Length := EnumMaxLength(TypeName);
  end else
{$IFDEF RUSSIAN}
    DatabaseError('   ');
{$ELSE}
    DatabaseError('Unknown database type');
{$ENDIF}

  if Key='PRI' then Fld.KeyMode := kmPrimary
  else if Key='MUL' then Fld.KeyMode := kmIndex
  else if Key='UNI' then Fld.KeyMode := kmUnique
  else Fld.KeyMode := kmNone;

  if Extra<>'' then Fld.AutoMode := amAutoInc
  else if TypeName='timestamp' then Fld.AutoMode := amTimeStamp
  else Fld.AutoMode := amNone;

  if (Null<>'') and (Key='') then Fld.IsNull := true
  else Fld.IsNull := false;
  Fld.Def := Def;
end;

// Find field definition in collection
function TMySQLQuery.FindFieldDesc(Field, Alias: String): TMySQLField;
var
  I: Integer;
  Table, Temp: String;
  TokenType: TTokenType;
begin
  Result := NIL;

  if Pos('.', Field)>0 then begin
    Temp := Field;
    ExtractToken(Temp, Table);
    if Temp[1]<>'.' then exit;
    ExtractToken(Temp, Field);
    TokenType := ExtractToken(Temp, Field);
    if (TokenType<>ttAlpha) or (Temp<>'') then exit;
    for I := 0 to FFieldDescs.Count-1 do begin
      if (TMySQLField(FFieldDescs.Items[I]).Table=Table) and
         (TMySQLField(FFieldDescs.Items[I]).Field=Field) then begin
        Result := TMySQLField(FFieldDescs.Items[I]);
        exit;
      end;
    end;
  end else begin
    for I := 0 to FFieldDescs.Count-1 do begin
      if TMySQLField(FFieldDescs.Items[I]).Alias=Alias then begin
        Result := TMySQLField(FFieldDescs.Items[I]);
        exit;
      end;
    end;
    for I := 0 to FFieldDescs.Count-1 do begin
      if TMySQLField(FFieldDescs.Items[I]).Field=Field then begin
        Result := TMySQLField(FFieldDescs.Items[I]);
        exit;
      end;
    end;
  end;
end;

// Normalize field names
procedure TMySQLQuery.NormalizeFieldDescs;
var
  I, J, P: Integer;
  FieldName, Temp1, Temp2: String;
begin
  for I := FFieldDescs.Count-1 downto 0 do begin
    FieldName := ExtractField(TMySQLField(FFieldDescs.Items[I]).Alias);
    Temp1 := UpperCase(FieldName);
    P := 0;
    for J := 0 to FFieldDescs.Count-1 do begin
      if J=I then continue;
      Temp2 := UpperCase(ExtractField(TMySQLField(FFieldDescs.Items[J]).Alias));
      if Temp1=Temp2 then Inc(P);
    end;
    if P<=0 then TMySQLField(FFieldDescs.Items[I]).Alias := FieldName
    else TMySQLField(FFieldDescs.Items[I]).Alias := FieldName+'_'+IntToStr(P);
  end;
end;

// Define field names in a query
procedure TMySQLQuery.DefineFieldDefs;
label NextLabel;
var
  Query, Token, Table, Field, Alias: String;
  TokenType: TTokenType;
  I: Integer;
begin
  FFieldDescs.Clear;
  Query := FSQL.Text;

// Extract a table names from a query
  ExtractSelectTables(Query, FTables, FAliases);

// If no tables then exit
  if FTables.Count=0 then begin
    FRequestLive := false;
    FReadOnly := true;
    exit;
  end;

// Fill all index fields in a query
// Store for fiture
//  for I := 0 to FTables.Count-1 do
//    FillAllIndexFields(FTables[I]);

  ExtractToken(Query, Token);
  if UpperCase(Token)<>'SELECT' then begin
    FRequestLive := false;
    exit;
  end;

  while (Query<>'') and (UpperCase(Token)<>'FROM') do begin
    TokenType := ExtractToken(Query,Token);
    if TokenType=ttAlpha then begin
      if Query[1]='.' then begin
        Table := Token;
        ExtractToken(Query, Token);
        TokenType := ExtractToken(Query, Token);
        if (TokenType<>ttAlpha) and (Token<>'*') then goto NextLabel;
        if Token='*' then begin
          FillAllFields(Table);
          goto NextLabel;
        end;
      end else Table := '';
      Field := Token;

      ExtractToken(Query, Token);
      if (UpperCase(Token)='AS')or(Token='=') then begin
        ExtractToken(Query, Token);
        Alias := Token;
      end else begin
        PutbackToken(Query, Token);
        if Table<>'' then Alias := Table + '.' + Field
        else Alias := Field;
      end;
      FillField(Table, Field, Alias);
    end else if Token='*' then begin
      for I:=0 to FTables.Count-1 do
        FillAllFields(FTables[I]);
      break;
    end;

NextLabel:
    repeat
      ExtractToken(Query, Token);
    until (Query='') or (UpperCase(Token)='FROM') or (Token=',');
  end;

  NormalizeFieldDescs;
end;

// Get string field value from record buffer
// FieldNo - field number
// Buffer - record buffer
function TMySQLQuery.GetFieldValue(FieldNo: Integer; Buffer: PRecordData): String;
begin
  Result := GetRealFieldValue(FieldNo, Buffer);
end;

// Get string field value from record buffer
// FieldNo - field number
// Buffer - record buffer
function TMySQLQuery.GetRealFieldValue(FieldNo: Integer; Buffer: PRecordData): String;
var
  B: array[0..8*1024] of Byte;
  P: Pointer;
  Field: TField;
  TempStamp: TTimeStamp;
  TempFloat: Double;
  I, J: Integer;
begin
  Result := '';
  Field := FRealFields[FieldNo];

  if Buffer^.Bytes[FieldOffset(Field)] = 0 then begin
    Move(Buffer^.Bytes[FieldOffset(Field) + 1], B, Field.DataSize);
    B[FieldOffset(Field) + 1 + Field.DataSize ] := 0;
    P := @B;
    case Field.DataType of
      ftString: begin
        Result := StrPas(PChar(P));
      end;
      ftInteger: begin
        Result := IntToStr(LongInt(P^));
      end;
      ftFloat: begin
        Result := FloatToStrEx(Double(P^));
      end;
      ftBoolean: begin
        if Boolean(P^) then Result := 'Y'
        else Result := 'N';
      end;
      ftTime: begin
        Result := DateTimeToSqlDate(Frac(TimeStampToDateTime(TTimeStamp(P^))));
      end;
      ftDateTime: begin
        TempFloat := TimeStampToDateTime(MSecsToTimeStamp(TDateTime(P^)));
        Result := DateTimeToSqlDate(TempFloat);
      end;
      ftDate: begin
        TempStamp.Time := 0;
        TempStamp.Date := LongInt(P^);
        Result := DateTimeToSqlDate(TimeStampToDateTime(TempStamp));
      end;
      ftBlob, ftMemo: begin
        Result := '';
        for I:=0 to 15 do begin
          if Buffer^.Blobs[I].FieldNum=Field.FieldNo then begin
            P := Buffer^.Blobs[I].BlobData;
            for J:=0 to Buffer^.Blobs[I].BlobSize-1 do begin
              Result := Result + PChar(P)^;
              P := Pointer(LongInt(P)+1);
            end;
            break;
          end;
        end;
      end;

    end;
  end;
end;

// Set string field value to record buffer
// FieldNo - field number
// Buffer - record buffer
// Value -  string field value
function TMySQLQuery.SetRealFieldValue(FieldNo: Integer; Value: String;
  Buffer: PRecordData): String;
var
  I, J: Integer;
  Field: TField;
  ps: array[0..4*1024] of char;
  TempTime: TDateTime;
  TimeStamp: TTimeStamp;
  TempInt: LongInt;
  TempDouble: Double;
  TempBool: Boolean;
  P: Pointer;
begin
  Result :='';
  Field := FRealFields[FieldNo];
  FillChar(ps,2000,0);

  case Field.DataType of
    ftString: begin
      StrPCopy(ps, Value);
    end;
    ftInteger: begin
      TempInt := LongInt(StrToIntDef(Value,0));
      Move(TempInt, ps, SizeOf(LongInt));
    end;
    ftFloat: begin
      TempDouble := StrToFloatEx(Value);
      Move(TempDouble, ps, SizeOf(Double));
    end;
    ftBoolean: begin
      if Value='' then TempBool := false
      else TempBool := UpperCase(Value)[1]='Y';
      Move(TempBool, ps, SizeOf(Boolean));
    end;
    ftTime: begin
      TimeStamp := DateTimeToTimeStamp(SqlDateToDateTime(Value));
      Move(TimeStamp, ps, SizeOf(TTimeStamp));
    end;
    ftDateTime: begin
      TimeStamp := DateTimeToTimeStamp(SqlDateToDateTime(Value));
      TempTime := TimeStampToMSecs(TimeStamp);
      Move(TempTime, ps, SizeOf(TDateTime));
    end;
    ftDate: begin
      TempInt := DateTimeToTimeStamp(SqlDateToDateTime(Value)).Date;
      Move(TempInt, ps, SizeOf(Single));
    end;
    ftBlob, ftMemo: begin
      for I:=0 to 15 do begin
        if Buffer^.Blobs[I].FieldNum=Field.FieldNo then begin
          P := Buffer^.Blobs[I].BlobData;
          if P<>NIL then FreeMem(P, Buffer^.Blobs[I].BlobSize);
          GetMem(P, Length(Value));
          if P=NIL then
{$IFDEF RUSSIAN}
            DatabaseError('  ');
{$ELSE}
            DatabaseError('Memory allocatiopn error');
{$ENDIF}
          Buffer^.Blobs[I].BlobSize := Length(Value);
          Buffer^.Blobs[I].BlobData := P;
          for J:=1 to Buffer^.Blobs[I].BlobSize do begin
            PChar(P)^ := Value[J];
            P := Pointer(LongInt(P)+1);
          end;
          break;
        end;
      end;
    end;

  end;

  Buffer^.Bytes[FieldOffset(Field)] := 0;
  Move(ps, Buffer^.Bytes[FieldOffset(Field) + 1], Field.DataSize);
end;

// Fill field structure
// Buffer - record buffer
// FieldValues - field values structure
procedure TMySQLQuery.FillFieldValues(Buffer: PRecordData;
  FieldValues: TFieldValues);
var
  I: Integer;
  FieldDesc: TMySQLField;
begin
  FieldValues.Clear;
  for I := 0 to FieldCount-1 do begin
    if not Assigned(FRealFields[I]) or (FRealFields[I].FieldKind<>fkData) then
      continue;
    FieldDesc := FindFieldDesc('', FRealFields[I].FieldName);
    if Assigned(FieldDesc) then begin
      FieldValues.AddField(FieldDesc.Table+'.'+FieldDesc.Field, FieldDesc.Alias,
        GetFieldValue(I, Buffer));
    end;
  end;
end;

// Get primary key name of table
// TableName - table name
function TMySQLQuery.GetPrimaryKey(TableName: String): String;
var I: Integer;
begin
  Result := '';
  for I := 0 to FFieldDescs.Count-1 do
    if (TMySQLField(FFieldDescs.Items[I]).Table=TableName) and
      (TMySQLField(FFieldDescs.Items[I]).KeyMode=kmPrimary) then begin
      Result := TMySQLField(FFieldDescs.Items[I]).Field;
      exit;
    end;
end;

// Get auto_increment field of table
// TableName - table name
function TMySQLQuery.GetAutoIncField(TableName: String): String;
var I: Integer;
begin
  Result := '';
  for I := 0 to FFieldDescs.Count-1 do
    if (TMySQLField(FFieldDescs.Items[I]).Table=TableName) and
      (TMySQLField(FFieldDescs.Items[I]).KeyMode=kmPrimary) and
      (TMySQLField(FFieldDescs.Items[I]).AutoMode=amAutoInc) then begin
      Result := TMySQLField(FFieldDescs.Items[I]).Field;
      exit;
    end;
end;

// Get primary key alias of table
// TableName - table name
function TMySQLQuery.GetPrimaryKeyAlias(TableName: String): String;
var I: Integer;
begin
  Result := '';
  for I := 0 to FFieldDescs.Count-1 do
    if (TMySQLField(FFieldDescs.Items[I]).Table=TableName) and
      (TMySQLField(FFieldDescs.Items[I]).KeyMode=kmPrimary) then begin
      Result := TMySQLField(FFieldDescs.Items[I]).Alias;
      exit;
    end;
end;

// Define a real field number in a query
// FieldName - field name
function TMySQLQuery.GetRealFieldNo(FieldName: String): Integer;
var Field: TField;
begin
  Field := FindField(FieldName);
  if Assigned(Field) then Result := GetFieldDefNo(Field)
  else Result := -1;
end;

// Auto set zeos generators to primary keys
procedure TMySQLQuery.ApplyGens(Buffer: PRecordData);
var
  I: Integer;
//  J, N: Integer;
  KeyField, KeyAlias: String;
  KeyNo, GenValue: LongInt;
//  FieldDesc: TMySqlField;
begin
// Store for fiture...  for I := 0 to FTables.Count-1 do begin
  for I := 0 to MinIntValue([0,FTables.Count-1]) do begin
    KeyField := GetPrimaryKey(FTables[I]);
    KeyAlias := GetPrimaryKeyAlias(FTables[I]);

    KeyNo := GetRealFieldNo(KeyAlias);
    if KeyNo<0 then continue;
    GenValue := FConnection.GetGen(FTables[I]);
    SetRealFieldValue(KeyNo, IntToStr(GenValue), Buffer);
{
    N := 0;
    for J := 0 to FieldCount - 1 do begin
      FieldDesc := FindFieldDesc(Fields[J].FieldName,Fields[J].FieldName);
      if Assigned(FieldDesc) and (Fields[J].FieldKind in [fkData]) and
        StrCmpEnd(FieldDesc.Field,KeyField) and (N<>KeyNo) then begin
        SetRealFieldValue(N, IntToStr(GenValue), Buffer);
      end;
      if (Fields[J].FieldKind in [fkData]) then Inc(N);
    end;
}  end;
end;

// Auto form update sql query
// Old - old field values
// New - new field values
// Status - changed type
procedure TMySQLQuery.FormSQLQuery(Old,New: TFieldValues; Status: TFieldStatus);
var
  I, J: Integer;
  KeyField, SQL, Where, Fields, Values: String;
  FieldDesc: TMySQLField;
  IsAutoInc: Boolean;
begin
  if not Assigned(FTransact) then
{$IFDEF RUSSIAN}
    DatabaseError('   Transaction');
{$ELSE}
    DatabaseError('Component Transaction nod defined');
{$ENDIF}

// Form command for tables
//  Store for fiture...  for I := 0 to FTables.Count-1 do begin
  for I := 0 to MinIntValue([0,FTables.Count-1]) do begin

// Get a primary key name
    KeyField := GetPrimaryKey(FTables[I]);
    IsAutoInc := false;

// Form WHERE
    if KeyField<>'' then try
      KeyField := FTables[I] + '.' + KeyField;
      Where := ' WHERE ' + ExtractField(KeyField) + '="' +
        StringToSQL(Old.FieldsByName[KeyField]) + '"';
      FieldDesc := FindFieldDesc(KeyField, KeyField);
      if Assigned(FieldDesc) and (FieldDesc.AutoMode=amAutoInc) then
        IsAutoInc := true;
    except
      KeyField := '';
    end;
    if KeyField='' then begin
      Where := '';
      for J := 0 to Old.Count-1 do begin
        if not StrCmpBegin(Old.FieldNames[J],FTables[I]+'.') then continue;
        if Where<>'' then Where := Where + ' AND ';
        Where := Where + ExtractField(Old.FieldNames[J]) + '="' +
          StringToSQL(Old.Fields[J]) + '"';
      end;
      Where := ' WHERE ' + Where;
    end;

// Form SQL command
    SQL := '';
    case Status of
      fsUpdated: begin
        for J := 0 to New.Count-1 do begin
          if not StrCmpBegin(New.FieldNames[J],FTables[I]+'.') then continue;
          if New.Fields[J]=Old.Fields[J] then continue;
          if SQL<>'' then SQL := SQL + ', ';
          SQL := SQL + ExtractField(New.FieldNames[J]) + '="' +
            StringToSQL(New.Fields[J]) + '"';
        end;
        if SQL<>'' then
          SQL := 'UPDATE ' + FTables[I] + ' SET ' + SQL + Where;
      end;
      fsInserted,fsAppend: begin
        Fields := ''; Values := '';
        for J := 0 to New.Count-1 do begin
          if not StrCmpBegin(New.FieldNames[J],FTables[I]+'.') then continue;
          if (New.FieldNames[J]=KeyField) and IsAutoInc then continue;
          if Fields<>'' then Fields := Fields + ', ';
          Fields := Fields + ExtractField(New.FieldNames[J]);
          if Values<>'' then Values := Values + ', ';
          Values := Values + '"' + StringToSQL(New.Fields[J]) + '"';
        end;
        if (Fields<>'') and (Values<>'') then
          SQL := 'INSERT INTO ' + FTables[I] + ' (' + Fields + ') VALUES (' +
                Values + ')';
      end;
      fsDeleted: begin
        if Where<>'' then SQL := 'DELETE FROM ' + FTables[I] + Where;
      end;
    end;
    if SQL<>'' then FTransact.ExecSQL(SQL);
  end;
end;

// Create demanded connections
procedure TMySQLQuery.CreateConnections;
begin
// Connect to database
  if not Assigned(FConnection) then
{$IFDEF RUSSIAN}
    DatabaseError('   Connection');
{$ELSE}
    DatabaseError('Component Connection not defined');
{$ENDIF}
  FConnection.Connect;
  if not FConnection.Connected then
{$IFDEF RUSSIAN}
    DatabaseError('   ');
{$ELSE}
    DatabaseError('Database connect error');
{$ENDIF}

// Connect to transact-server
  if FRequestLive then begin
    if not Assigned(FTransact) then
{$IFDEF RUSSIAN}
      DatabaseError('   Transaction');
{$ELSE}
      DatabaseError('Component Transaction not defined');
{$ENDIF}
    FTransact.Connect;
    if not FTransact.Connected then
{$IFDEF RUSSIAN}
      DatabaseError('   -');
{$ELSE}
      DatabaseError('Transact-server connect error');
{$ENDIF}
  end;

  FQuery.SQL := FSQL.Text;
  FDb := FConnection.Handle;

// Define database connect by open mode
  if FStoreResult then begin
    FQuery.Dataset := FDb;
    FQuery.SetOpenMode(omStore);
  end else begin
    FDbUse := TDirMySQLConnect.Create;
    FDbUse.ConnectFull(FDb.HostName, FDb.Port, FDb.Db, FDb.Login, FDb.Passwd);
    if FDbUse.Status<>DB_CONNECTION_OK then begin
      FDbUse.Free;
{$IFDEF RUSSIAN}
      DatabaseError('   ');
{$ELSE}
      DatabaseError('Database connect error');
{$ENDIF}
    end;
    FQuery.Dataset := FDbUse;
    FQuery.SetOpenMode(omUse);

{$IFDEF RUSSIAN}
    if mysql_query(FDbUse.Handle,'SET OPTION CHARACTER SET CP1251_KOI8')<>0 then
      DatabaseError(FDb.Error);
{$ENDIF}
  end;
end;

// Auto keys form
// KeyFields - list of key fields
// KeyValues - key values array
procedure TMySQLQuery.FormKeyValues(var KeyFields: String; var KeyValues: Variant);
var
  I, J, Count, FieldNo: Integer;
  KeyField: String;
  FieldDesc: TMySQLField;
  TempValues: array[0..50] of Variant;
  Buffer: PRecordData;
begin
  if not GetActiveRecBuf(Buffer) then Exit;

  Count := 0;
  KeyFields := '';
// Form command for tables
  for I := 0 to FTables.Count-1 do begin

// Define a primary key
    KeyField := GetPrimaryKey(FTables[I]);

// Form keys
    if KeyField<>'' then try
      KeyField := FTables[I] + '.' + KeyField;
      FieldDesc := FindFieldDesc(KeyField, KeyField);
      if Assigned(FieldDesc) then begin
        FieldNo := GetRealFieldNo(FieldDesc.Alias);
        if FieldNo>=0 then begin
          if KeyFields<>'' then KeyFields := KeyFields + ', ';
          KeyFields := KeyFields + '"' + FieldDesc.Alias + '"';
          TempValues[Count] := GetRealFieldValue(FieldNo, Buffer);
          Inc(Count);
          if I=0 then break;
        end else KeyField := '';
      end;
    except
      KeyField := '';
    end;
    if KeyField='' then begin
      for J := 0 to FieldCount-1 do begin
        FieldDesc := FindFieldDesc('', Fields[J].FieldName);
        if not Assigned(FieldDesc) or (FieldDesc.Table<>FTables[I]) then continue;
        FieldNo := GetRealFieldNo(FieldDesc.Alias);
        if FieldNo<0 then continue;
        if KeyFields<>'' then KeyFields := KeyFields + ', ';
        KeyFields := KeyFields + '"' + FieldDesc.Alias + '"';
        TempValues[Count] := GetRealFieldValue(FieldNo, Buffer);
        Inc(Count);
      end;
    end;
  end;
  if Count>0 then begin
    if Count=1 then KeyValues := TempValues[0]
    else begin
      KeyValues := VarArrayCreate([0,Count-1],varVariant);
      for I := 0 to Count-1 do
        KeyValues[I] := TempValues[I];
    end;
  end else begin
    KeyValues := false;
  end;
end;

// Set field default values
procedure TMySQLQuery.InitDefaults;
var
  I: Integer;
  Def: String;
  TempField: TMySQLField;
  InitField: TField;
begin
  for I := 0 to FFieldDescs.Count-1 do begin
    TempField := TMySQLField(FFieldDescs.Items[I]);
    InitField := FindField(TempField.Alias);
    if not Assigned(InitField) then continue;

    Def := '';
    if TempField.Def<>'' then Def := TempField.Def
    else if TempField.KeyMode<>kmNone then
      case TempField.FieldType of
        ftSmallint, ftInteger, ftWord, {$IFNDEF VER100}ftLargeint,{$ENDIF}
        ftFloat, ftCurrency, ftBCD: Def := '0';
        ftBoolean: Def := 'N';
        ftDate: Def := '0000-00-00';
        ftTime: Def := '00:00:00';
        ftDateTime: Def := '0000-00-00 00:00:00';
      end;

    if InitField.DefaultExpression='' then
      InitField.DefaultExpression := Def;
  end;
end;

// Create optimize array for find fields
procedure TMySQLQuery.OptimizeFindFields;
var
  I, N: Integer;
  FieldDesc: TMySQLField;
begin
  for I := 0 to MAX_FIELDS do begin
    FFieldDescNums[I] := -1;
    FQueryFieldNums[I] := -1;
  end;

  for I := 0 to FieldCount-1 do begin
    if Fields[I].FieldNo<=0 then continue;
    FQueryFieldNums[Fields[I].FieldNo] := FQuery.FieldIndex(Fields[I].FieldName);
    FieldDesc := FindFieldDesc('',Fields[I].FieldName);
    if not Assigned(FieldDesc) then continue;
    N := 0;
    while N<FFieldDescs.Count do begin
      if FieldDesc=FFieldDescs.Items[N] then begin
        FFieldDescNums[Fields[I].FieldNo] := N;
        break;
      end;
      Inc(N);
    end;
  end;
end;
