{******************************************************************
*  (c)copyrights Corona Ltd. Donetsk 1999
*  Project: Zeos Library
*  Module: TDatabase class for direct MySQL access (version 1.0)
*  Author: Sergey Seroukhov   E-Mail: voland@cm.dongu.donetsk.ua
*  Date: 23/03/99
*
*  List of changes:
******************************************************************}

unit ZMySQLCon;

interface

{$R *.DCR}

uses
  SysUtils, Windows, DB, Classes, Forms, ZDirSql, ZDirMySql, LibMySQL, ZToken;

{$I ..\Zeos.inc}
  
type
{***************** TMySQLDatabase definition ********************}

TMySQLDatabase = class(TComponent)
private
  FDatabase, FLogin, FPasswd, FHost: String;
  FDb: TDirMySqlConnect;
  FOnLogin: TNotifyEvent;
  FConnected: Boolean;
  FPort: String;

  procedure SetConnected(Value: Boolean);
  procedure SetHost(Value: String);
  procedure SetDatabase(Value: String);
public
// Class constructor
  constructor Create(AOwner: TComponent); override;
// Class destructor
  destructor Destroy; override;

// Connect to MySQL database
  procedure Connect;
// Disconnect from MySQL database
  procedure Disconnect;
// Execute a query
// SQL - SQL query
  procedure ExecSQL(SQL: String);
// Execute a MySQL function
// Func - function with params
  function ExecFunc(Func: String): String;
// Get generator value
// TableName - table name (equal to generator name)
  function GetGen(TableName: String): LongInt;

// Direct database connect handle
  property Handle: TDirMySQLConnect read FDb;
published
// SQL server host name
  property Host: String read FHost write SetHost;
// Database name
  property Database: String read FDatabase write SetDatabase;
// User's login
  property Login: String read FLogin write FLogin;
// User's password
  property Password: String read FPasswd write FPasswd;
// MySQL server port
  property Port: String read FPort write FPort;
// Connect open/close status
  property Connected: Boolean read FConnected write SetConnected;

// On Connect Event
  property OnLogin:TNotifyEvent read FOnLogin write FOnLogin;
end;

procedure Register;

implementation

{***************** TMySQLDatabase implementation *****************}

// Class constructor
constructor TMySQLDatabase.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FDb := TDirMySqlConnect.Create;
  FPort := '33600';
end;

// Class destructor
destructor TMySQLDatabase.Destroy;
begin
  Disconnect;
  FDb.Free;
  inherited;
end;

// Set connected prop
procedure TMySQLDatabase.SetConnected(Value: Boolean);
begin
  if Value=FConnected then exit;
  if Value then Connect
  else Disconnect;
end;

// Set new host name
procedure TMySQLDatabase.SetHost(Value: String);
begin
  Disconnect;
  FHost := Value;
end;

// Set new database name
procedure TMySQLDatabase.SetDatabase(Value: String);
begin
  Disconnect;
  FDatabase := Value;
end;

// Connect to MySQL database
procedure TMySQLDatabase.Connect;
begin
  if FConnected then exit;
  if Assigned(FOnLogin) then FOnLogin(Self);

  FDb.HostName := FHost;
  FDb.Db := FDatabase;
  FDb.Login := FLogin;
  FDb.Passwd := FPasswd;

  if FDb.Connect=DB_CONNECTION_OK then begin
    FConnected := true;
{$IFDEF RUSSIAN}
    ExecSQL('SET OPTION CHARACTER SET CP1251_KOI8');
{$ENDIF}
  end else
    DatabaseError(FDb.Error);
end;

// Disconnect from MySQL database
procedure TMySQLDatabase.Disconnect;
begin
  if not FConnected then exit;
  FDb.Disconnect;
  FConnected := false;
end;

// Execute a MySQL function with params
function TMySQLDatabase.ExecFunc(Func: String): String;
var Query: TDirMySQLQuery;
begin
  if not FConnected then
{$IFDEF RUSSIAN}
    DatabaseError('  ');
{$ELSE}
    DatabaseError('Not connected yet');
{$ENDIF}

  Query := TDirMySQLQuery.CreateDB(FDb);
  Query.SQL := 'SELECT '+Func;

  Query.Open;
  if Query.Status<>DB_TUPLES_OK then
    DatabaseError(FDb.Error);
  Result := Query.Fields[0];
  Query.Free;
end;

// Execute a query
procedure TMySQLDatabase.ExecSQL(SQL: String);
var
  Token: String;
  FResult: pmysql_res;
begin
  if not FConnected then
{$IFDEF RUSSIAN}
    DatabaseError('  ');
{$ELSE}
    DatabaseError('Not connected yet');
{$ENDIF}

  if (mysql_query(FDb.Handle, PChar(SQL)) <> 0) then
    DatabaseError(FDb.Error);
  ExtractToken(SQL, Token);
  if (UpperCase(Token)='SELECT') or (UpperCase(Token)='SHOW') then begin
    FResult := mysql_store_result(FDb.Handle);
    if FResult<>NIL then mysql_free_result(FResult);
  end;
end;

// Get a generator value
// TableName - table name (equal to generator name)
function TMySQLDatabase.GetGen(TableName: String): LongInt;
begin
  if not FConnected then
{$IFDEF RUSSIAN}
    DatabaseError('  ');
{$ELSE}
    DatabaseError('Not connected yet');
{$ENDIF}

  Result := StrToIntDef(ExecFunc('GETGEN("'+TableName+'")'),0);
end;

{**********************************************************}

// Register component in a component pallette
procedure Register;
begin
  RegisterComponents(ZEOS_PALETTE, [TMySQLDatabase]);
end;

end.
