{******************************************************************
*  (c)copyrights TCX
*  Project: MySQL
*  Module: MySQL Windows API
*
*  List of changes:
*  04/03/99 - resize MYSQL structure, fix memory allocation error
*  12/03/99 - erase nonused classes
******************************************************************}

unit LibMySQL;

interface

uses Windows, Classes, Winsock;

const
  DEFAULT_DLL_LOCATION   = 'libmySQL.DLL';

// Last Modification Information
  TMYSQLCOMMON_LAST_MODIFIED = '01.06.1999b';
  TMYSQLCOMMON_LAST_AUTHOR   = 'jy';

// General Declarations
  MYSQL_ERRMSG_SIZE      = 200;
  MYSQL_PORT             = 3306;
  LOCAL_HOST             = 'localhost';
  NAME_LEN               = 64;
  PROTOCOL_VERSION       = 10;
  FRM_VER                = 6;

// Enum Field Types
  FIELD_TYPE_DECIMAL     = 0;
  FIELD_TYPE_TINY        = 1;
  FIELD_TYPE_SHORT       = 2;
  FIELD_TYPE_LONG        = 3;
  FIELD_TYPE_FLOAT       = 4;
  FIELD_TYPE_DOUBLE      = 5;
  FIELD_TYPE_NULL        = 6;
  FIELD_TYPE_TIMESTAMP   = 7;
  FIELD_TYPE_LONGLONG    = 8;
  FIELD_TYPE_INT24       = 9;
  FIELD_TYPE_DATE        = 10;
  FIELD_TYPE_TIME        = 11;
  FIELD_TYPE_DATETIME    = 12;
  FIELD_TYPE_YEAR        = 13;
  FIELD_TYPE_NEWDATE     = 14;
  FIELD_TYPE_ENUM        = 247;
  FIELD_TYPE_SET         = 248;
  FIELD_TYPE_TINY_BLOB   = 249;
  FIELD_TYPE_MEDIUM_BLOB = 250;
  FIELD_TYPE_LONG_BLOB   = 251;
  FIELD_TYPE_BLOB        = 252;
  FIELD_TYPE_VAR_STRING  = 253;
  FIELD_TYPE_STRING      = 254;

// For Compatibility
  FIELD_TYPE_CHAR         = FIELD_TYPE_TINY;
  FIELD_TYPE_INTERVAL     = FIELD_TYPE_ENUM;

// Client Connection Options
  _CLIENT_LONG_PASSWORD	 = 1;	// new more secure passwords
  _CLIENT_FOUND_ROWS	 = 2;	// Found instead of affected rows
  _CLIENT_LONG_FLAG	 = 4;	// Get all column flags
  _CLIENT_CONNECT_WITH_DB = 8;	// One can specify db on connect
  _CLIENT_NO_SCHEMA	 = 16;	// Don't allow database.table.column
  _CLIENT_COMPRESS	 = 32;	// Can use compression protcol
  _CLIENT_ODBC		 = 64;	// Odbc client
  _CLIENT_LOCAL_FILES	 = 128;	// Can use LOAD DATA LOCAL
  _CLIENT_IGNORE_SPACE	 = 256;	// Ignore spaces before '('

// Server Administration Refresh Options
  _REFRESH_GRANT	 = 1;     //Refresh grant tables
  _REFRESH_LOG		 = 2;     // Start on new log file
  _REFRESH_TABLES	 = 4;     // close all tables
  _REFRESH_HOSTS	 = 8;     // Flush host cache
  _REFRESH_FAST		 = 32768; // Intern flag

// TmySQLClientModify constants
  MODIFY_SQL_LENGTH = 65535;

type

_mysql_status = (MYSQL_STATUS_READY, MYSQL_STATUS_GET_RESULT,
  MYSQL_STATUS_USE_RESULT);

_mysql_option = (MYSQL_OPT_CONNECT_TIMEOUT, MYSQL_OPT_COMPRESS);

ENUM_FIELD_TYPES = byte;
MY_BOOL          = char;
GPTR             = pchar;
SOCKET           = word;
PCardinal        = ^Cardinal;

PUSED_MEM = ^USED_MEM;
USED_MEM = record
  next: pused_mem;
  left,size: Cardinal;
end;

PERR_PROC = ^ERR_PROC;
ERR_PROC = procedure;

PMEM_ROOT = ^MEM_ROOT;
MEM_ROOT = record
  free,
  used          : pused_mem;

  min_malloc,
  block_size    : Cardinal;

  error_handler : PERR_PROC;
end;

NET = record
  nettype                 : ENUM_FIELD_TYPES;
  hPipe                   : Integer; // if Windows
  fd                      : Integer;
  fcntl                   : Integer;

  padding1                : LongInt; // to be fixed

  buff,
  buff_end,
  write_pos               : PChar;

  last_error              : array [1..MYSQL_ERRMSG_SIZE] of Char;
  last_errno,
  max_packet,
  timeout,
  pkt_nr                  : Integer; //Cardinal;

  error,
  return_errno,
  compress                : MY_BOOL;

  remain_in_buf_length,
  buf_length,
  where_b                 : longint;

  save_char               : char;

  padding2                : integer; // to be fixed
end;

  //-----

  PMYSQL_FIELD = ^MYSQL_FIELD;
  MYSQL_FIELD = record
    name,
    table,
    def        : pchar;

    _type      : ENUM_FIELD_TYPES;

    length,
    max_length,
    flags,
    decimals    : Cardinal;
  end;

  MYSQL_FIELD_OFFSET = Cardinal;

  //-----

  PMYSQL_ROW = ^MYSQL_ROW;
  MYSQL_ROW = pointer; // array of pchar

  PMYSQL_ROWS = ^MYSQL_ROWS;
  MYSQL_ROWS = record
    next : PMYSQL_ROWS;
    data : PMYSQL_ROW;
  end;

  MYSQL_ROW_OFFSET = PMYSQL_ROWS;

  //-----

  PMYSQL_DATA = ^MYSQL_DATA;
  MYSQL_DATA = record
    rows,
    fields : Cardinal;

    data   : PMYSQL_ROWS;
    alloc  : MEM_ROOT;
 end;

  //-----

  PMYSQL_OPTIONS = ^_MYSQL_OPTIONS;
  _MYSQL_OPTIONS = record
    connect_timeout : longint;

    compress,
    named_pipe      : MY_BOOL;

    padding3        : array[0..3] of char;
  end;

  //-----

  PMYSQL = ^MYSQL;
  MYSQL = record
    _net                  : NET;
    host,
    user,
    passwd,
    unix_socket,
    server_version,
    host_info,
    info,
    db                   : pchar;

    port,client_flag,
    server_capabilities,
    protocol_version,
    field_count          : Cardinal;

    thread_id,
    affected_rows,
    insert_id,
    extra_info           : longint;

    packet_length        : longint;
    status               : _mysql_status;
    fields               : PMYSQL_FIELD;
    field_alloc          : MEM_ROOT;
    padding4             : array[0..11] of char; // to be fixed

    free_me,
    reconnect            : MY_BOOL;

    options              : _mysql_options;

    reserved             : array[0..40] of Byte;
  end;

  //-----

  PMYSQL_RES = ^MYSQL_RES;
  MYSQL_RES = record
    row_count,
    padding5,
    field_count,
    current_field              : longint;
    fields                     : PMYSQL_FIELD;
    data                       : PMYSQL_DATA;
    data_cursor                : PMYSQL_ROWS;
    field_alloc                : MEM_ROOT;
    row,
    current_row                : PMYSQL_ROW;
    lengths                    : ^Cardinal;
    handle                     : ^MYSQL;
    eof                        : MY_BOOL;
    overflow2                  : array[0..127] of char; // overflow catch
  end;

{Exports from LIBMYSQL.dll [As of 3.22.9-beta]
  35 exported name(s), 35 export addresse(s).  Ordinal base is 1.
    Ordinal RVA       Name
    ------- --------  ----
    0000    0000467b  mysql_close
    0001    000035e9  mysql_connect
    0002    0000621e  mysql_create_db
    0003    00005bd4  mysql_data_seek
    0004    00002f37  mysql_debug
    0005    000062b7  mysql_drop_db
    0006    00006480  mysql_dump_debug_info
    0007    00006695  mysql_escape_string
    0008    0000592a  mysql_fetch_field
    0009    00005b27  mysql_fetch_lengths
    0010    00005963  mysql_fetch_row
    0011    00005c84  mysql_field_seek
    0012    00002fc9  mysql_free_result
    0013    00006638  mysql_get_client_info
    0014    00006618  mysql_get_host_info
    0015    00006628  mysql_get_proto_info
    0016    00006608  mysql_get_server_info
    0017    000034b4  mysql_init
    0018    00006418  mysql_kill
    0019    00005ca3  mysql_list_dbs
    0020    00005ea2  mysql_list_fields
    0021    000060ba  mysql_list_processes
    0022    00005dfd  mysql_list_tables
    0023    00006642  mysql_options
    0024    000065a8  mysql_ping
    0025    0000476b  mysql_query
    0026    00003684  mysql_real_connect
    0027    0000478c  mysql_real_query
    0028    000063b0  mysql_refresh
    0029    00005c5b  mysql_row_seek
    0030    000041e1  mysql_select_db
    0031    00006350  mysql_shutdown
    0032    000064e0  mysql_stat
    0033    000054eb  mysql_store_result
    0034    0000573f  mysql_use_result
}

{ These types and vars are dynamic functions/procedures that will  }
{ become "alive" when the libmysql.dll gets loaded at run-time.  jy}
type
  Tmysql_debug =           procedure (debug: pchar);
  Tmysql_dump_debug_info = function  (_mysql: pmysql) : integer;

  Tmysql_init =            function  (_mysql: pmysql) : pmysql; stdcall; //Added July 23
  Tmysql_connect =         function  (_mysql: pmysql; const host, user, passwd: pchar) : pmysql; stdcall;
  Tmysql_real_connect =    function  (_mysql: pmysql; const host, user, passwd, db: pchar;     port: Cardinal; unix_socket: PChar; clientflag: Cardinal) : pmysql; stdcall;
  Tmysql_close =           procedure (_mysql: pmysql); stdcall; //Added July 23

  Tmysql_query =           function  (_mysql: pmysql; const query: pchar) : integer; stdcall;
  Tmysql_real_query =      function  (_mysql: pmysql; const query: pchar; len: integer) : integer;

  Tmysql_select_db =       function  (_mysql: pmysql; const DB: pchar) : integer; stdcall;
  Tmysql_create_db =       function  (_mysql: pmysql; const DB: PChar) : integer; stdcall;
  Tmysql_drop_db =         function  (_mysql: pmysql; const DB: PChar) : integer; stdcall;

  Tmysql_shutdown =        function  (_mysql: pmysql): Integer; stdcall;
  Tmysql_refresh =         function  (_mysql: pmysql; refresh_options: Cardinal) : integer; stdcall;
  Tmysql_kill =            function  (_mysql: pmysql; pid: longint) : integer; stdcall;
  Tmysql_ping =            function  (_mysql: pmysql) : integer; stdcall;
  Tmysql_stat =            function  (_mysql: pmysql) : pchar; stdcall;
  Tmysql_options =         function  (_mysql: pmysql; _option: _mysql_option; const arg: PChar) : Integer;stdcall;
  Tmysql_escape_string =   function  (pto, pfrom: pchar; len: longint) : integer;

  Tmysql_get_server_info = function  (_mysql: pmysql) : PChar; stdcall;
  Tmysql_get_client_info = function : PChar; stdcall;
  Tmysql_get_host_info =   function  (_mysql: pmysql) : PChar; stdcall;
  Tmysql_get_proto_info =  function  (_mysql: pmysql) : Cardinal; stdcall;

  Tmysql_list_dbs =        function  (_mysql: pmysql; wild: pchar) : pmysql_res; stdcall;
  Tmysql_list_tables =     function  (_mysql: pmysql; const wild: pchar) : pmysql_res; stdcall;
  Tmysql_list_fields =     function  (_mysql: pmysql; const table, wild: pchar) : pmysql_res; stdcall;
  Tmysql_list_processes =  function  (_mysql: pmysql) : pmysql_res; stdcall;

  Tmysql_store_result =    function  (_mysql: pmysql) : pmysql_res; stdcall;
  Tmysql_use_result =      function  (_mysql: pmysql) : pmysql_res; stdcall;
  Tmysql_free_result =     procedure (result: pmysql_res); stdcall;

  Tmysql_fetch_row =       function  (result: pmysql_res) : pmysql_row; stdcall;
  Tmysql_fetch_lengths =   function  (result: pmysql_res) : integer; stdcall;
  Tmysql_fetch_field =     function  (result: pmysql_res) : pmysql_field; stdcall;

  Tmysql_data_seek =       procedure (result: pmysql_res; offset: Cardinal); stdcall;
  Tmysql_row_seek =        function  (result: pmysql_res; row: mysql_row_offset) : mysql_row_offset; stdcall;
  Tmysql_field_seek =      function  (result: pmysql_res; offset: mysql_field_offset) : mysql_field_offset; stdcall;

var
  libmysql_location : string;

  mysql_debug           : Tmysql_debug;
  mysql_dump_debug_info : Tmysql_dump_debug_info;

  mysql_init            : Tmysql_init;
  mysql_connect         : Tmysql_connect;
  mysql_real_connect    : Tmysql_real_connect;
  mysql_close           : Tmysql_close;

  mysql_select_db       : Tmysql_select_db;
  mysql_create_db       : Tmysql_create_db;
  mysql_drop_db         : Tmysql_drop_db;

  mysql_query           : Tmysql_query;
  mysql_real_query      : Tmysql_query;

  mysql_shutdown        : Tmysql_shutdown;
  mysql_refresh         : Tmysql_refresh;
  mysql_kill            : Tmysql_kill;
  mysql_ping            : Tmysql_ping;
  mysql_stat            : Tmysql_stat;
  mysql_options         : Tmysql_options;
  mysql_escape_string   : Tmysql_escape_string;

  mysql_get_server_info : Tmysql_get_server_info;
  mysql_get_client_info : Tmysql_get_client_info;
  mysql_get_host_info   : Tmysql_get_host_info;
  mysql_get_proto_info  : Tmysql_get_proto_info;

  mysql_list_dbs        : Tmysql_list_dbs;
  mysql_list_tables     : Tmysql_list_tables;
  mysql_list_fields     : Tmysql_list_fields;
  mysql_list_processes  : Tmysql_list_processes;

  mysql_data_seek       : Tmysql_data_seek;
  mysql_row_seek        : Tmysql_row_seek;
  mysql_field_seek      : Tmysql_field_seek;

  mysql_fetch_row       : Tmysql_fetch_row;
  mysql_fetch_lengths   : Tmysql_fetch_lengths;
  mysql_fetch_field     : Tmysql_fetch_field;

  mysql_store_result    : Tmysql_store_result;
  mysql_use_result      : Tmysql_use_result;
  mysql_free_result     : Tmysql_free_result;

  hDLL : HWND;

implementation

uses
  SysUtils;

function LoadLibMySQL: Boolean;
begin
  Result:=FALSE;

  if hDLL<>0 then exit;

  hDLL:=LoadLibrary(PChar(libmysql_location));

  if hDLL<>0 then begin
    @mysql_debug           := GetProcAddress(hDLL,'mysql_debug');           // broken?
    @mysql_dump_debug_info := GetProcAddress(hDLL,'mysql_dump_debug_info'); // broken?

    @mysql_init            := GetProcAddress(hDLL,'mysql_init');            //
    @mysql_connect         := GetProcAddress(hDLL,'mysql_connect');         // na
    @mysql_real_connect    := GetProcAddress(hDLL,'mysql_real_connect');    //
    @mysql_close           := GetProcAddress(hDLL,'mysql_close');           //

    @mysql_select_db       := GetProcAddress(hDLL,'mysql_select_db');       //
    @mysql_create_db       := GetProcAddress(hDLL,'mysql_create_db');       //
    @mysql_drop_db         := GetProcAddress(hDLL,'mysql_drop_db');         //

    @mysql_query           := GetProcAddress(hDLL,'mysql_query');           //
    @mysql_real_query      := GetProcAddress(hDLL,'mysql_real_query');      // na
    @mysql_shutdown        := GetProcAddress(hDLL,'mysql_shutdown');        //
    @mysql_refresh         := GetProcAddress(hDLL,'mysql_refresh');         //
    @mysql_kill            := GetProcAddress(hDLL,'mysql_kill');            //
    @mysql_ping            := GetProcAddress(hDLL,'mysql_ping');            //
    @mysql_stat            := GetProcAddress(hDLL,'mysql_stat');            //
    @mysql_options         := GetProcAddress(hDLL,'mysql_options');         //
    @mysql_escape_string   := GetProcAddress(hDLL,'mysql_escape_string');   //

    @mysql_get_server_info := GetProcAddress(hDLL,'mysql_get_server_info'); //
    @mysql_get_client_info := GetProcAddress(hDLL,'mysql_get_client_info'); //
    @mysql_get_host_info   := GetProcAddress(hDLL,'mysql_get_host_info');   //
    @mysql_get_proto_info  := GetProcAddress(hDLL,'mysql_get_proto_info');  //

    @mysql_list_fields     := GetProcAddress(hDLL,'mysql_list_fields');     //
    @mysql_list_processes  := GetProcAddress(hDLL,'mysql_list_processes');  //
    @mysql_list_dbs        := GetProcAddress(hDLL,'mysql_list_dbs');        //
    @mysql_list_tables     := GetProcAddress(hDLL,'mysql_list_tables');     //

    @mysql_data_seek       := GetProcAddress(hDLL,'mysql_data_seek');       // na
    @mysql_row_seek        := GetProcAddress(hDLL,'mysql_row_seek');        // na
    @mysql_field_seek      := GetProcAddress(hDLL,'mysql_field_seek');      // na

    @mysql_fetch_row       := GetProcAddress(hDLL,'mysql_fetch_row');       //
    @mysql_fetch_lengths   := GetProcAddress(hDLL,'mysql_fetch_lengths');   // na
    @mysql_fetch_field     := GetProcAddress(hDLL,'mysql_fetch_field');     //

    @mysql_use_result      := GetProcAddress(hDLL,'mysql_use_result');      // na
    @mysql_store_result    := GetProcAddress(hDLL,'mysql_store_result');    //
    @mysql_free_result     := GetProcAddress(hDLL,'mysql_free_result');     //

    Result:=TRUE;
  end;
end;

var
  wVersionRequested: Word;
  wsaData: TWSADATA;
  Res: Boolean;

initialization
  wVersionRequested := $0101;
  Res := WSAStartup(wVersionRequested, wsaData) = 0;
  if not Res then raise Exception.Create('Initialized Winsock error');

  libmysql_location:=DEFAULT_DLL_LOCATION;
  hDLL:=0;
  LoadLibMySQL;
finalization
  if hDLL<>0 then FreeLibrary(hDLL);

  WSACleanup;
end.

