{******************************************************************
*  (c)copyrights Corona Ltd. Donetsk 1999
*  Project: Zeos Library
*  Module: Hash-table classes
*  Author: Sergey Seroukhov   E-Mail: voland@cm.dongu.donetsk.ua
*  Date: 01/04/98
*
*  List of changes:
*    28/04/99 - Add Assign method
******************************************************************}

unit ZHash;

interface

uses SysUtils, Classes;

{$I ..\Zeos.inc}

const
// Maximum values in hash-table item
  MAX_HASH_ITEMS = 10;

type
// Item of hash-table
THashItem = record
  HashKey: String;
  Items: array[0..MAX_HASH_ITEMS-1] of Variant;
end;
PHashItem = ^THashItem;

{****************** THash definition ************************}

// Hash-table class
THash = class (TList)
private
// Get hash-item
  function GetHashItem(Index: String): PHashItem;
public
// Class destructor
  destructor Destroy; override;

// Add new item to hash-table
  procedure Add(KeyValue: String; ItemValues:array of Variant);
// Delete item
  procedure Delete(Index: Integer);
// Delete item by key
  procedure DeleteByKey(Index: String);
// Clear all hash items
  procedure Clear; {$IFNDEF VER100}  override; {$ENDIF}
// Assign another hash-table
  procedure Assign(Source: TObject); virtual;

// Hash items
  property HashItems[Index: String]: PHashItem read GetHashItem; default;
end;

implementation

{******************* THash implementation ***********************}

// Get hash item
function THash.GetHashItem(Index: String): PHashItem;
var
  I: Integer;
  Item: PHashItem;
begin
  Result := NIL;
  for I := 0 to Count-1 do begin
    Item := PHashItem(inherited Items[I]);
    if Item.HashKey=Index then begin
      Result := Item;
      break;
    end;
  end;
  if Result=NIL then
{$IFDEF RUSSIAN}
    raise Exception.CreateFmt(' -   "%s"  ',[Index]);
{$ELSE}
    raise Exception.CreateFmt('Hash-item with key "%s" not found',[Index]);
{$ENDIF}
end;

// Class destructor
destructor THash.Destroy;
begin
  Clear;
  inherited;
end;

// Add new item
procedure THash.Add(KeyValue: String; ItemValues: array of Variant);
var
  NewItem: PHashItem;
  I: Integer;
begin
  New(NewItem);
  if not Assigned(NewItem) then
{$IFDEF RUSSIAN}
    raise Exception.Create('   ');
{$ELSE}
    raise Exception.Create('Memory allocation error');
{$ENDIF}
  NewItem.HashKey := KeyValue;

  for I := 0 to MAX_HASH_ITEMS-1 do
    NewItem.Items[I] := NULL;

  for I := 0 to High(ItemValues) do
    if I<MAX_HASH_ITEMS then NewItem.Items[I] := ItemValues[I]
{$IFDEF RUSSIAN}
    else raise Exception.Create('   -');
{$ELSE}
    else raise Exception.Create('Too many items in hash-table');
{$ENDIF}

  inherited Add(NewItem);
end;

// Delete item by key
procedure THash.DeleteByKey(Index: String);
var
  I, N: Integer;
  Item: PHashItem;
begin
  N := -1;
  for I := 0 to Count-1 do begin
    Item := PHashItem(inherited Items[I]);
    if Item.HashKey=Index then begin
      N := I;
      break;
    end;
  end;

  if N>=0 then Delete(N)
  else
{$IFDEF RUSSIAN}
    raise Exception.CreateFmt(' -   %s  ',[Index]);
{$ELSE}
    raise Exception.CreateFmt('Hash-item with key "%s" not found',[Index]);
{$ENDIF}
end;

// Delete item
procedure THash.Delete(Index: Integer);
var Item: PHashItem;
begin
  Item := PHashItem(inherited Items[Index]);
  if Item<>NIL then Dispose(Item);
  inherited Delete(Index);
end;

// Clear hash-table
procedure THash.Clear;
var
  I: Integer;
  Item: PHashItem;
begin
  for I:=0 to Count-1 do begin
    Item := PHashItem(inherited Items[I]);
    if Item<>NIL then Dispose(Item);
  end;

  inherited;
end;

// Assign another hash-table
procedure THash.Assign(Source: TObject);
var
  I, J: Integer;
  Item1, Item2: PHashItem;
begin
  Clear;
  if not (Source is THash) then exit;

  for I:=0 to THash(Source).Count-1 do begin
    Item1 := PHashItem(THash(Source).Items[I]);
    Add(Item1.HashKey,['']);
    Item2 := PHashItem(Items[Count-1]);
    for J := 0 to MAX_HASH_ITEMS-1 do
      Item2.Items[J] := Item1.Items[J];
  end;
end;

end.
