{******************************************************************
*  (c)copyrights Corona Ltd. Donetsk 1999
*  Project: Zeos Library
*  Module: Extra functions
*  Author: Sergey Seroukhov   E-Mail: voland@cm.dongu.donetsk.ua
*  Date: 24/04/99
*
*  List of changes:
*   08/05/99 - Add function currency to string
******************************************************************}

unit ZExtra;

interface

uses SysUtils, Classes, Db, ZToken;

{$I ..\Zeos.inc}

{**************** Extra functions definition ****************}

// Convert SQL Date to TDateTime
// Value - String as 'YYYY-MM-DD'|'YYYY-MM-DD HH:MM:SS'|'HH:MM:SS'
function SqlDateToDateTime(Value: String): TDateTime;

// Convert TDateTime to SQL Ansi-92 Date
// Value - date and(or) time
function DateTimeToSqlDate(Value: TDateTime):String;

// String compare from the end
// Str1, Str2 - string values
function StrCmpEnd(Str1, Str2: String): Boolean;

// String compare from the begin
// Str1, Str2 - string values
function StrCmpBegin(Str1, Str2: String): Boolean;

// Convert string value to float with '.' delimiter
// Value - string value
function StrToFloatEx(Value: String): Double;

// Convert string value to float with '.' delimiter with default value
// Value - string value
function StrToFloatDefEx(Value: String; Default: Double): Double;

// Convert float value to string with '.' delimiter
// Value - float value
function FloatToStrEx(Value: Double): String;

// Convert currency value to string
// Total - currency sum
// Currency - Short currency name
// Coin - Short coins name
function MoneyToString(Total: Double; Currency, Coin: String): String;

implementation

{************** Extra functions implementation ***************}

// Convert SQL Date to TDateTime
// Value - String as 'YYYY-MM-DD'|'YYYY-MM-DD HH:MM:SS'|'HH:MM:SS'
function SqlDateToDateTime(Value: String): TDateTime;
var
  Year, Month, Day, Hour, Min, Sec: Integer;
  Temp: String;
begin
  Temp := Value;
  Result := 0;
  if Length(Temp)<>8 then begin
    Year := StrToIntDef(Copy(Temp,1,4),0);
    Month := StrToIntDef(Copy(Temp,6,2),0);
    Day := StrToIntDef(Copy(Temp,9,2),0);
    if (Year*Month*Day)<>0 then Result := EncodeDate(Year, Month, Day)
    else Result := 0;
  end;
  if Length(Temp)>10 then Temp := Copy(Temp,Length(Temp)-7,8);
  if Length(Temp)=8 then begin
    Hour := StrToIntDef(Copy(Temp,1,2),0);
    Min := StrToIntDef(Copy(Temp,4,2),0);
    Sec := StrToIntDef(Copy(Temp,7,2),0);
    Result := Result + EncodeTime(Hour, Min, Sec, 0);
  end;
end;

// Convert TDateTime to SQL Ansi-92 Date
// Value - date and(or) time
function DateTimeToSqlDate(Value: TDateTime):String;
begin
  Result := '';
  if Trunc(Value)<>0 then
    Result := FormatDateTime('yyyy-mm-dd', Value);
  if Frac(Value)<>0 then begin
    if Result<>'' then Result := Result + ' ';
    Result := Result + FormatDateTime('hh:nn:ss', Value);
  end;
end;

// String compare from the end
// Str1, Str2 - string values
function StrCmpEnd(Str1, Str2: String): Boolean;
var P1, P2: Integer;
begin
  Result := true;
  P1 := Length(Str1);
  P2 := Length(Str2);
  while (P1>0) and (P2>0) do begin
    if Str1[P1]<>Str2[P2] then begin
      Result := false;
      break;
    end;
    Dec(P1);
    Dec(P2);
  end;
end;

// String compare from the begin
// Str1, Str2 - string values
function StrCmpBegin(Str1, Str2: String): Boolean;
var P1, L1, P2, L2: Integer;
begin
  Result := true;
  L1 := Length(Str1);
  L2 := Length(Str2);
  P1 := 0; P2 := 0;
  while (P1<=L1) and (P2<=L2) do begin
    if Str1[P1]<>Str2[P2] then begin
      Result := false;
      break;
    end;
    Inc(P1);
    Inc(P2);
  end;
end;

// Convert string value to float with '.' delimiter
// Value - string value
function StrToFloatEx(Value: String): Double;
var Temp: Char;
begin
  Result := 0;
  if Value<>'' then begin
    Temp := DecimalSeparator;
    DecimalSeparator := '.';
    try Result := StrToFloat(Value);
    except Result := 0; end;
    DecimalSeparator := Temp;
  end;
end;

// Convert string value to float with '.' delimiter with default value
// Value - string value
function StrToFloatDefEx(Value: String; Default: Double): Double;
var Temp: Char;
begin
  Result := Default;
  if Value='' then exit;
  Temp := DecimalSeparator;
  if Pos('.',Value)>0 then DecimalSeparator := '.';
  try Result := StrToFloat(Value);
  except end;
  DecimalSeparator := Temp;
end;

// Convert float value to string with '.' delimiter
// Value - float value
function FloatToStrEx(Value: Double): String;
var Temp: Char;
begin
  Temp := DecimalSeparator;
  DecimalSeparator := '.';
  Result := FloatToStr(Value);
  DecimalSeparator := Temp;
end;

// Convert currency value to string
// Total - currency sum
// Currency - Short currency name
// Coin - Short coins name
function MoneyToString(Total: Double; Currency, Coin: String): String;
const
{$IFDEF RUSSIAN}
  StrTop: array[0..5] of String =
    ('','','','','','');
  Padeg: array[0..1,0..9] of String = (
    (''  ,'','','','',  '',  '',  '',  '',  ''),
    ('', '','','','','','','','','')
  );
  NumLevel: array[0..3,0..9] of String = (
    ('','','','','','','','','',''),
    ('','','','','','','',
     '','',''),
    ('','','','','','','','',
     '',''),
    ('','','','','',
     '','','','','')
  );
  NoRole: array[0..1] of String = ('','');
{$ELSE}
  StrTop: array[0..5] of String =
    ('hundred','thousend','million','milliard','trillion','trilliard');
  Padeg: array[0..1,0..9] of String = (
    ('','','','','','','','','',''),
    ('','','','','','','','','','')
  );
  NumLevel: array[0..3,0..9] of String = (
    ('','one','two','three','four','five','six','seven','eight','nine'),
    ('','ten','twenty','theerty','fourty','fifty','sixty',
     'seventy','eighty','ninety'),
    ('','one','tow','three','four','five','six','seven',
     'eight','nine'),
    ('ten','eleven','twelve','thirteen','fourteen',
     'fifteen','sixteen','seventeen','eighting','nineteen')
  );
  NoRole: array[0..1] of String = ('one','two');
{$ENDIF}
  MAX_DIGIT_NUM = 18;
var
  MaxLevel: LongInt;
  Levels: array[0..MAX_DIGIT_NUM] of Byte;
  TotalLow: LongInt;
  IsEmpty: Boolean;
  Temp: String;
begin
  Result := '';
  IsEmpty := true;
  if Trunc(Total*100)=0 then exit;

  TotalLow := Trunc(Frac(Total)*100);
  MaxLevel := 0;
  while (Total>0)and(MaxLevel<MAX_DIGIT_NUM) do begin
    Levels[MaxLevel] := Trunc(Total) mod 10;
    Total := Total / 10;
    Inc(MaxLevel);
  end;
  Dec(MaxLevel);

  while MaxLevel>=0 do begin
    if IsEmpty and (Levels[MaxLevel]<>0) then IsEmpty := false;
    Temp := '';
    if ((MaxLevel mod 3)=1) and (Levels[MaxLevel]=1) then begin
      Dec(MaxLevel);
      Temp := NumLevel[3][Levels[MaxLevel]];
    end else
      if (MaxLevel=3) and ((Levels[MaxLevel]=2)or(Levels[MaxLevel]=1)) then
        Temp := NoRole[Levels[MaxLevel]-1]
      else
        Temp := NumLevel[MaxLevel mod 3][Levels[MaxLevel]];

    if Temp<>'' then Result := Result + Temp + ' ';

    if ((MaxLevel mod 3)=0)and not IsEmpty then begin
     if Result<>'' then begin
       Temp := StrTop[MaxLevel div 3];
       if MaxLevel div 3=1 then
         Temp := Temp + Padeg[0][Levels[MaxLevel]]
       else if MaxLevel div 3>1 then
         Temp := Temp + Padeg[1][Levels[MaxLevel]];
       if Temp<>'' then Result := Result + Temp + ' ';
     end;
     IsEmpty := true;
    end;

    Dec(MaxLevel);
  end;
  if Trim(Result)<>'' then Result := Result + ' ' + Currency;
  if TotalLow<10 then Result := Result + ' 0' + IntToStr(TotalLow) + ' ' + Coin
  else Result := Result + ' ' + IntToStr(TotalLow) + ' ' + Coin;
end;

end.

