{******************************************************************
*  (c)copyrights Corona Ltd. Donetsk 1999
*  Project: Zeos Library
*  Module: Functions for convert text between different rus encodings
*  Author: Sergey Seroukhov   E-Mail: voland@cm.dongu.donetsk.ua
*  Date: 24/04/99
*
*  List of changes:
******************************************************************}

unit ZConvert;

interface

uses Windows;

type
  TEncodingType=(dos2koi,koi2dos,dos2win,win2dos,win2koi,koi2win);

// Convert from KOI8-R to CP1251
function ConvKoi2Win(Value: String): String;
// Convert from CP1251 to KOI8-R
function ConvWin2Koi(Value: String): String;
// Convert from CP1251 to 866
function ConvWin2Dos(Value: String): String;
// Convert from 866 to CP1251
function ConvDos2Win(Value: String): String;
// Convert 866 to KOI8-R
function ConvDos2Koi(Value: String): String;
// Convert KOI8-R to 866
function ConvKoi2Dos(Value: String): String;

implementation

type TTransTable = array[128..255] of Char;
const
  Dos2KoiTable: TTransTable =
    ( #225, #226, #247, #231, #228, #229, #246, #250, #233, #234, #235, #236,
      #237, #238, #239, #240, #242, #243, #244, #245, #230, #232, #227, #254,
      #251{}, #253, #255, #249, #248, #252, #224, #241, #193, #194, #215, #199,
      #196, #197, #214, #218, #201, #202, #203, #204, #205, #206, #207, #208,
      #144, #145, #146, #129, #135, #178, #180, #167, #166, #181, #161, #168,
      #174, #173, #172, #131, #132, #137, #136, #134, #128, #138, #175, #176,
      #171, #165, #187, #184, #177, #160, #190, #185, #186, #182, #183, #170,
      #169, #162, #163, #189, #188, #133, #130, #141, #140, #142, #143, #139,
      #210, #211, #212, #213, #198, #200, #195, #222, #219, #221, #223, #217,
      #216, #220, #192, #209, #179, #163, #153, #152, #147, #155, #159, #151,
      #156, #149, #158, #150, #191, #157, #148, #154);
  Koi2DosTable: TTransTable =
    ( #196, #179, #218, #191, #192, #217, #195, #180, #194, #193, #197, #223,
      #220, #219, #221, #222, #176, #177, #178, #244, #254, #249, #251, #247,
      #243, #242, #255, #245, #248, #253, #250, #246, #205, #186, #213, #241,
      #164, #201, #184, #183, #187, #212, #211, #200, #190, #189, #188, #198,
      #199, #204, #181, #240, #182, #185, #209, #210, #203, #207, #208, #202,
      #216, #215, #206, #252, #238, #160, #161, #230, #164, #165, #228, #163,
      #229, #168, #169, #170, #171, #172, #173, #174, #175, #239, #224, #225,
      #226, #227, #166, #162, #236, #235, #167, #232, #237, #233, #231, #234,
      #158, #128, #129, #150, #132, #133, #148, #131, #149, #136, #137, #138,
      #139, #140, #141, #142, #143, #159, #144, #145, #146, #147, #134, #130,
      #156, #155, #135, #152{251}, #157, #153, #151, #154);

// Convert 866 to KOI8-R
function ConvDos2Koi(Value: String): String;
var I: Integer;
begin
  Result := '';
  for I := 1 to Length(Value) do begin
    if Value[I]>#127 then
      Result := Result + Dos2KoiTable[Integer(Value[I])]
    else Result := Result + Value[I];
  end;
end;

// Convert KOI8-R to 866
function ConvKoi2Dos(Value: String): String;
var I: Integer;
begin
  Result := '';
  for I := 1 to Length(Value) do begin
    if Value[I]>#127 then
      Result := Result + Koi2DosTable[Integer(Value[I])]
    else Result := Result + Value[I];
  end;
end;

// Convert 866 to CP1251
function ConvDos2Win(Value: String): String;
var
  I: Integer;
  Src,Dest:array[0..3] of Char;
begin
  Src[1]:=#0;
  Result := '';
  for I := 1 to Length(Value) do begin
    Src[0] := Value[I];
    OemToCharBuff(Src,Dest,3);
    Result := Result + Dest[0];
  end
end;

// Convert CP1251 to 866
function ConvWin2Dos(Value: String): String;
var
  I: Integer;
  Src,Dest:array[0..3] of Char;
begin
  Src[1]:=#0;
  Result := '';
  for I := 1 to Length(Value) do begin
    Src[0] := Value[I];
    CharToOemBuff(Src,Dest,3);
    Result := Result + Dest[0];
  end
end;

// Convert CP1251 to KOI8-R
function ConvWin2Koi(Value: String): String;
begin
  Value := ConvWin2Dos(Value);
  Result := ConvDos2Koi(Value);
end;

// Convert KOI8-R to CP1251
function ConvKoi2Win(Value: String): String;
begin
  Value := ConvKoi2Dos(Value);
  Result := ConvDos2Win(Value);
end;

end.
