{******************************************************************
*  (c)copyrights Corona Ltd. Donetsk 1999
*  Project: Zeos Library
*  Module: Macro-Capella language Windows API
*  Author: Sergey Seroukhov   E-Mail: voland@cm.dongu.donetsk.ua
*  Date: 26/07/99
*
*  List of changes:
******************************************************************}

unit MacroLib;

interface
uses Classes;

{******************* Constants and types definition ****************}
const
  vrInteger	= 0;
  vrDouble	= 1;
  vrChar	= 2;
  vrString	= 3;
  vrBoolean	= 4;
  vrPointer	= 5;
  vrNull	= 6;
  MacroLibFile      = 'macro.dll';


type PPChar = ^PChar;

{***************** Capella variant values processing ***************}
// Create new variant value
function macro_create_value(value: PPChar): PChar; stdcall;

// Drop variant value
procedure macro_free_value(varb: PChar); stdcall;

// Get type of variant value
function macro_value_type(varb: PChar): Integer; stdcall;

// Get string result
function macro_get_string(varb: PChar): PChar; stdcall;

// Get integer result
function macro_get_int(varb: PChar): LongInt; stdcall;

// Get float result
function macro_get_real(varb: PChar): Double; stdcall;

// Get pointer result
function macro_get_pointer(varb: PChar): Pointer; stdcall;

// Get logical result
function macro_get_bool(varb: PChar): Integer; stdcall;

// Set new string value
procedure macro_set_string(varb: PChar; value: PChar); stdcall;

// Set new integer value
procedure macro_set_int(varb: PChar; value: LongInt); stdcall;

// Set new float value
procedure macro_set_real(varb: PChar; value: Double); stdcall;

// Set new pointer value
procedure macro_set_pointer(varb: PChar; value: Pointer); stdcall;

// Set new logical value
procedure macro_set_bool(varb: PChar; value: Integer); stdcall;

{************** Count Stack processing ***************}

// Create new Count Stack
function macro_create_stack(stack: PPChar): PChar; stdcall;

// Drop Count Stack
procedure macro_free_stack(stack: PChar); stdcall;

// Get error message
function macro_error(stack: PChar): PChar; stdcall;

// Get stack items quantity
function macro_stack_count(stack: PChar): LongInt; stdcall;

// Get process index
function macro_process_id(stack: PChar): LongInt; stdcall;

// Push value to stack
function macro_stack_push(stack, varb: PChar): Integer; stdcall;

// Pop value from stack
function macro_stack_pop(stack, varb: PChar): Integer; stdcall;

{***************** Functions server processing *****************}

// Create new function
function macro_create_func(stack, func, code: PChar; proc_id: LongInt): Integer;
  stdcall;

// Find a function
function macro_find_func(stack, func: PChar; proc_id: LongInt): Integer;
  stdcall;

// Drop function
procedure macro_drop_func(stack, func: PChar; proc_id: LongInt); stdcall;

// Drop all process functions
procedure macro_drop_all_funcs(stack: PChar; proc_id: LongInt); stdcall;

// Execute a code
function macro_exec_code(stack, code: PChar): Integer; stdcall;

// Execute a function
function macro_exec_func(stack, func: PChar): Integer; stdcall;

{***************** Variable Server processing *****************}

// Create new variable
function macro_create_var(stack, varb: PChar; var_type, opt_num, cmd: Integer;
  proc_id: LongInt): Integer; stdcall;

// Find a variable
function macro_find_var(stack, varb: PChar; proc_id: LongInt): Integer; stdcall;

// Drop a variable
procedure macro_drop_var(stack, varb: PChar; proc_id: LongInt); stdcall;

// Drop all process varibles
procedure macro_drop_all_vars(stack: PChar; proc_id: LongInt); stdcall;

// Get a variable value
function macro_get_var(stack, varb: PChar; opt_num: Integer; proc_id: LongInt):
  Integer; stdcall;

// Set new variable value
function macro_set_var(stack, varb: PChar; opt_num: Integer; proc_id: LongInt):
  Integer; stdcall;

// Execute an object method
function macro_exec_method(stack, varb: PChar; proc_id: LongInt): Integer;
  stdcall;

implementation

{***************** Variant values processing ***************}
function macro_create_value(value: PPChar): PChar;
  stdcall; external MacroLibFile;
procedure macro_free_value(varb: PChar);
  stdcall; external MacroLibFile;
function macro_value_type(varb: PChar): Integer;
  stdcall; external MacroLibFile;
function macro_get_string(varb: PChar): PChar;
  stdcall; external MacroLibFile;
function macro_get_int(varb: PChar): LongInt;
  stdcall; external MacroLibFile;
function macro_get_real(varb: PChar): Double;
  stdcall; external MacroLibFile;
function macro_get_pointer(varb: PChar): Pointer;
  stdcall; external MacroLibFile;
function macro_get_bool(varb: PChar): Integer;
  stdcall; external MacroLibFile;
procedure macro_set_string(varb: PChar; value: PChar);
  stdcall; external MacroLibFile;
procedure macro_set_int(varb: PChar; value: LongInt);
  stdcall; external MacroLibFile;
procedure macro_set_real(varb: PChar; value: Double);
  stdcall; external MacroLibFile;
procedure macro_set_pointer(varb: PChar; value: Pointer);
  stdcall; external MacroLibFile;
procedure macro_set_bool(varb: PChar; value: Integer);
  stdcall; external MacroLibFile;

{************** Count Stack processing ***************}
function macro_create_stack(stack: PPChar): PChar;
  stdcall; external MacroLibFile;
procedure macro_free_stack(stack: PChar);
  stdcall; external MacroLibFile;
function macro_error(stack: PChar): PChar;
  stdcall; external MacroLibFile;
function macro_stack_count(stack: PChar): LongInt;
  stdcall; external MacroLibFile;
function macro_process_id(stack: PChar): LongInt;
  stdcall; external MacroLibFile;
function macro_stack_push(stack, varb: PChar): Integer;
  stdcall; external MacroLibFile;
function macro_stack_pop(stack, varb: PChar): Integer;
  stdcall; external MacroLibFile;

{***************** Function server processing *****************}
function macro_create_func(stack, func, code: PChar; proc_id: LongInt): Integer;
  stdcall; external MacroLibFile;
function macro_find_func(stack, func: PChar; proc_id: LongInt): Integer;
  stdcall; external MacroLibFile;
procedure macro_drop_func(stack, func: PChar; proc_id: LongInt);
  stdcall; external MacroLibFile;
procedure macro_drop_all_funcs(stack: PChar; proc_id: LongInt);
  stdcall; external MacroLibFile;
function macro_exec_code(stack, code: PChar): Integer;
  stdcall; external MacroLibFile;
function macro_exec_func(stack, func: PChar): Integer;
  stdcall; external MacroLibFile;

{***************** Variable server processing *****************}
function macro_create_var(stack, varb: PChar; var_type, opt_num, cmd: Integer;
  proc_id: LongInt): Integer;
  stdcall; external MacroLibFile;
function macro_find_var(stack, varb: PChar; proc_id: LongInt): Integer;
  stdcall;  external MacroLibFile;
procedure macro_drop_var(stack, varb: PChar; proc_id: LongInt);
  stdcall; external MacroLibFile;
procedure macro_drop_all_vars(stack: PChar; proc_id: LongInt);
  stdcall;  external MacroLibFile;
function macro_get_var(stack, varb: PChar; opt_num: Integer; proc_id: LongInt):
  Integer; stdcall;  external MacroLibFile;
function macro_set_var(stack, varb: PChar; opt_num: Integer; proc_id: LongInt):
  Integer; stdcall;  external MacroLibFile;
function macro_exec_method(stack, varb: PChar; proc_id: LongInt): Integer;
  stdcall; external MacroLibFile;

end.
