unit Main;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	StdCtrls, ComCtrls;

type
	TForm1 = class(TForm)
    edtCode: TEdit;
    edtMessage: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    StatusBar1: TStatusBar;
    procedure edtCodeKeyPress(Sender: TObject; var Key: Char);
    procedure edtCodeChange(Sender: TObject);
	private
		{ Private declarations }
		Function FindError(ErrorCode :Integer):String;
	public
		{ Public declarations }
	end;

var
	Form1: TForm1;

implementation

{$R *.DFM}

Function TForm1.FindError(ErrorCode:Integer):String;
begin
	Case ErrorCode of
		-8:		Result := 'LZERROR_UNKNOWNALG';
		-7:   Result := 'LZERROR_BADVALUE';
		-6:   Result := 'LZERROR_GLOBLOCK';
		-5:   Result := 'LZERROR_GLOBALLOC';
		-4:   Result := 'LZERROR_WRITE';
		-3:   Result := 'LZERROR_READ';
		-2:   Result := 'LZERROR_BADOUTHANDLE';
		-1:   Result := 'LZERROR_BADINHANDLE';
		0:    Result := 'NO_ERROR, ERROR_SUCCESS';
		1:  	Result := 'ERROR_INVALID_FUNCTION';
		2:   	Result := 'ERROR_FILE_NOT_FOUND';
		3:   	Result := 'ERROR_PATH_NOT_FOUND';
		4:   	Result := 'ERROR_TOO_MANY_OPEN_FILES';
		5:   	Result := 'ERROR_ACCESS_DENIED';
		6:   	Result := 'ERROR_INVALID_HANDLE';
		7:   	Result := 'ERROR_ARENA_TRASHED';
		8:   	Result := 'ERROR_NOT_ENOUGH_MEMORY';
		9:   	Result := 'ERROR_INVALID_BLOCK';
		10:  	Result := 'ROR_BAD_ENVIRONMENT';
		11:  	Result := 'ROR_BAD_FORMAT';
		12:  	Result := 'ROR_INVALID_ACCESS';
		13:  	Result := 'ROR_INVALID_DATA';
		14:  	Result := 'ROR_OUTOFMEMORY';
		15:  	Result := 'ROR_INVALID_DRIVE';
		16:  	Result := 'ROR_CURRENT_DIRECTORY';
		17:  	Result := 'ROR_NOT_SAME_DEVICE';
		18:  	Result := 'ROR_NO_MORE_FILES';
		19:  	Result := 'ROR_WRITE_PROTECT';
		20:  	Result := 'ROR_BAD_UNIT';
		21:  	Result := 'ROR_NOT_READY';
		22:  	Result := 'ROR_BAD_COMMAND';
		23:  	Result := 'ROR_CRC';
		24:  	Result := 'ROR_BAD_LENGTH';
		25:  	Result := 'ROR_SEEK';
		26:  	Result := 'ROR_NOT_DOS_DISK';
		27:  	Result := 'ROR_SECTOR_NOT_FOUND';
		28:  	Result := 'ROR_OUT_OF_PAPER';
		29:  	Result := 'ROR_WRITE_FAULT';
		30:  	Result := 'ROR_READ_FAULT';
		31:  	Result := 'ROR_GEN_FAILURE';
		32:  	Result := 'ROR_SHARING_VIOLATION';
		33:  	Result := 'ROR_LOCK_VIOLATION';
		34:  	Result := 'ROR_WRONG_DISK';
		36:  	Result := 'ROR_SHARING_BUFFER_EXCEEDED';
		38:  	Result := 'ROR_HANDLE_EOF';
		39:  	Result := 'ROR_HANDLE_DISK_FULL';
		50:  	Result := 'ROR_NOT_SUPPORTED';
		51:  	Result := 'ROR_REM_NOT_LIST';
		52:  	Result := 'ROR_DUP_NAME';
		53:  	Result := 'ROR_BAD_NETPATH';
		54:  	Result := 'ROR_NETWORK_BUSY';
		55:  	Result := 'ROR_DEV_NOT_EXIST';
		56:  	Result := 'ROR_TOO_MANY_CMDS';
		57:  	Result := 'ROR_ADAP_HDW_ERR';
		58:  	Result := 'ROR_BAD_NET_RESP';
		59:  	Result := 'ROR_UNEXP_NET_ERR';
		60:  	Result := 'ROR_BAD_REM_ADAP';
		61:  	Result := 'ROR_PRINTQ_FULL';
		62:  	Result := 'ROR_NO_SPOOL_SPACE';
		63:  	Result := 'ROR_PRINT_CANCELLED';
		64:  	Result := 'ROR_NETNAME_DELETED';
		65:  	Result := 'ROR_NETWORK_ACCESS_DENIED';
		66:  	Result := 'ROR_BAD_DEV_TYPE';
		67:  	Result := 'ROR_BAD_NET_NAME';
		68:  	Result := 'ROR_TOO_MANY_NAMES';
		69:  	Result := 'ROR_TOO_MANY_SESS';
		70:  	Result := 'ROR_SHARING_PAUSED';
		71:  	Result := 'ROR_REQ_NOT_ACCEP';
		72:  	Result := 'ROR_REDIR_PAUSED';
		80:  	Result := 'ROR_FILE_EXISTS';
		82:  	Result := 'ROR_CANNOT_MAKE';
		83:  	Result := 'ROR_FAIL_I24';
		84:  	Result := 'ROR_OUT_OF_STRUCTURES';
		85:  	Result := 'ROR_ALREADY_ASSIGNED';
		86:  	Result := 'ROR_INVALID_PASSWORD';
		87:  	Result := 'ROR_INVALID_PARAMETER';
		88:  	Result := 'ROR_NET_WRITE_FAULT';
		89:  	Result := 'ROR_NO_PROC_SLOTS';
		100: 	Result := 'RROR_TOO_MANY_SEMAPHORES';
		101: 	Result := 'RROR_EXCL_SEM_ALREADY_OWNED';
		102: 	Result := 'RROR_SEM_IS_SET';
		103: 	Result := 'RROR_TOO_MANY_SEM_REQUESTS';
		104: 	Result := 'RROR_INVALID_AT_INTERRUPT_TIME';
		105: 	Result := 'RROR_SEM_OWNER_DIED';
		106: 	Result := 'RROR_SEM_USER_LIMIT';
		107: 	Result := 'RROR_DISK_CHANGE';
		108: 	Result := 'RROR_DRIVE_LOCKED';
		109: 	Result := 'RROR_BROKEN_PIPE';
		110: 	Result := 'RROR_OPEN_FAILED';
		111: 	Result := 'RROR_BUFFER_OVERFLOW';
		112: 	Result := 'RROR_DISK_FULL';
		113: 	Result := 'RROR_NO_MORE_SEARCH_HANDLES';
		114: 	Result := 'RROR_INVALID_TARGET_HANDLE';
		117: 	Result := 'RROR_INVALID_CATEGORY';
		118: 	Result := 'RROR_INVALID_VERIFY_SWITCH';
		119: 	Result := 'RROR_BAD_DRIVER_LEVEL';
		120: 	Result := 'RROR_CALL_NOT_IMPLEMENTED';
		121: 	Result := 'RROR_SEM_TIMEOUT';
		122: 	Result := 'RROR_INSUFFICIENT_BUFFER';
		123: 	Result := 'RROR_INVALID_NAME';
		124: 	Result := 'RROR_INVALID_LEVEL';
		125: 	Result := 'RROR_NO_VOLUME_LABEL';
		126: 	Result := 'RROR_MOD_NOT_FOUND';
		127: 	Result := 'RROR_PROC_NOT_FOUND';
		128: 	Result := 'RROR_WAIT_NO_CHILDREN';
		129: 	Result := 'RROR_CHILD_NOT_COMPLETE';
		130: 	Result := 'RROR_DIRECT_ACCESS_HANDLE';
		131: 	Result := 'RROR_NEGATIVE_SEEK';
		132: 	Result := 'RROR_SEEK_ON_DEVICE';
		133: 	Result := 'RROR_IS_JOIN_TARGET';
		134: 	Result := 'RROR_IS_JOINED';
		135: 	Result := 'RROR_IS_SUBSTED';
		136: 	Result := 'RROR_NOT_JOINED';
		137: 	Result := 'RROR_NOT_SUBSTED';
		138: 	Result := 'RROR_JOIN_TO_JOIN';
		139: 	Result := 'RROR_SUBST_TO_SUBST';
		140: 	Result := 'RROR_JOIN_TO_SUBST';
		141: 	Result := 'RROR_SUBST_TO_JOIN';
		142: 	Result := 'RROR_BUSY_DRIVE';
		143: 	Result := 'RROR_SAME_DRIVE';
		144: 	Result := 'RROR_DIR_NOT_ROOT';
		145: 	Result := 'RROR_DIR_NOT_EMPTY';
		146: 	Result := 'RROR_IS_SUBST_PATH';
		147: 	Result := 'RROR_IS_JOIN_PATH';
		148: 	Result := 'RROR_PATH_BUSY';
		149: 	Result := 'RROR_IS_SUBST_TARGET';
		150: 	Result := 'RROR_SYSTEM_TRACE';
		151: 	Result := 'RROR_INVALID_EVENT_COUNT';
		152: 	Result := 'RROR_TOO_MANY_MUXWAITERS';
		153: 	Result := 'RROR_INVALID_LIST_FORMAT';
		154: 	Result := 'RROR_LABEL_TOO_LONG';
		155: 	Result := 'RROR_TOO_MANY_TCBS';
		156: 	Result := 'RROR_SIGNAL_REFUSED';
		157: 	Result := 'RROR_DISCARDED';
		158: 	Result := 'RROR_NOT_LOCKED';
		159: 	Result := 'RROR_BAD_THREADID_ADDR';
		160: 	Result := 'RROR_BAD_ARGUMENTS';
		161: 	Result := 'RROR_BAD_PATHNAME';
		162: 	Result := 'RROR_SIGNAL_PENDING';
		164: 	Result := 'RROR_MAX_THRDS_REACHED';
		167: 	Result := 'RROR_LOCK_FAILED';
		170: 	Result := 'RROR_BUSY';
		173: 	Result := 'RROR_CANCEL_VIOLATION';
		174: 	Result := 'RROR_ATOMIC_LOCKS_NOT_SUPPORTED';
		180: 	Result := 'RROR_INVALID_SEGMENT_NUMBER';
		182: 	Result := 'RROR_INVALID_ORDINAL';
		183: 	Result := 'RROR_ALREADY_EXISTS';
		186: 	Result := 'RROR_INVALID_FLAG_NUMBER';
		187: 	Result := 'RROR_SEM_NOT_FOUND';
		188: 	Result := 'RROR_INVALID_STARTING_CODESEG';
		189: 	Result := 'RROR_INVALID_STACKSEG';
		190: 	Result := 'RROR_INVALID_MODULETYPE';
		191: 	Result := 'RROR_INVALID_EXE_SIGNATURE';
		192: 	Result := 'RROR_EXE_MARKED_INVALID';
		193: 	Result := 'RROR_BAD_EXE_FORMAT';
		194: 	Result := 'RROR_ITERATED_DATA_EXCEEDS_64k';
		195: 	Result := 'RROR_INVALID_MINALLOCSIZE';
		196: 	Result := 'RROR_DYNLINK_FROM_INVALID_RING';
		197: 	Result := 'RROR_IOPL_NOT_ENABLED';
		198: 	Result := 'RROR_INVALID_SEGDPL';
		199: 	Result := 'RROR_AUTODATASEG_EXCEEDS_64k';
		200: 	Result := 'RROR_RING2SEG_MUST_BE_MOVABLE';
		201: 	Result := 'RROR_RELOC_CHAIN_XEEDS_SEGLIM';
		202: 	Result := 'RROR_INFLOOP_IN_RELOC_CHAIN';
		203: 	Result := 'RROR_ENVVAR_NOT_FOUND';
		205: 	Result := 'RROR_NO_SIGNAL_SENT';
		206: 	Result := 'RROR_FILENAME_EXCED_RANGE';
		207: 	Result := 'RROR_RING2_STACK_IN_USE';
		208: 	Result := 'RROR_META_EXPANSION_TOO_LONG';
		209: 	Result := 'RROR_INVALID_SIGNAL_NUMBER';
		210: 	Result := 'RROR_THREAD_1_INACTIVE';
		212: 	Result := 'RROR_LOCKED';
		214: 	Result := 'RROR_TOO_MANY_MODULES';
		215: 	Result := 'RROR_NESTING_NOT_ALLOWED';
		230: 	Result := 'RROR_BAD_PIPE';
		231:	Result := 'RROR_PIPE_BUSY';
		232:	Result := 'RROR_NO_DATA';
		233: 	Result := 'RROR_PIPE_NOT_CONNECTED';
		234: 	Result := 'RROR_MORE_DATA';
		240: 	Result := 'RROR_VC_DISCONNECTED';
		254: 	Result := 'RROR_INVALID_EA_NAME';
		255: 	Result := 'RROR_EA_LIST_INCONSISTENT';
		259: 	Result := 'RROR_NO_MORE_ITEMS';
		266: 	Result := 'RROR_CANNOT_COPY';
		267: 	Result := 'RROR_DIRECTORY';
		275: 	Result := 'RROR_EAS_DIDNT_FIT';
		276: 	Result := 'RROR_EA_FILE_CORRUPT';
		277: 	Result := 'RROR_EA_TABLE_FULL';
		278: 	Result := 'RROR_INVALID_EA_HANDLE';
		282: 	Result := 'RROR_EAS_NOT_SUPPORTED';
		288: 	Result := 'RROR_NOT_OWNER';
		298: 	Result := 'RROR_TOO_MANY_POSTS';
		317: 	Result := 'RROR_MR_MID_NOT_FOUND';
		487: 	Result := 'RROR_INVALID_ADDRESS';
		534: 	Result := 'RROR_ARITHMETIC_OVERFLOW';
		535: 	Result := 'RROR_PIPE_CONNECTED';
		536: 	Result := 'RROR_PIPE_LISTENING';
		994: 	Result := 'RROR_EA_ACCESS_DENIED';
		995: 	Result := 'RROR_OPERATION_ABORTED';
		996: 	Result := 'RROR_IO_INCOMPLETE';
		997: 	Result := 'RROR_IO_PENDING';
		998: 	Result := 'RROR_NOACCESS';
		999: 	Result := 'RROR_SWAPERROR';
		1001:	Result := 'ERROR_STACK_OVERFLOW';
		1002:	Result := 'ERROR_INVALID_MESSAGE';
		1003:	Result := 'ERROR_CAN_NOT_COMPLETE';
		1004:	Result := 'ERROR_INVALID_FLAGS';
		1005:	Result := 'ERROR_UNRECOGNIZED_VOLUME';
		1006:	Result := 'ERROR_FILE_INVALID';
		1007:	Result := 'ERROR_FULLSCREEN_MODE';
		1008:	Result := 'ERROR_NO_TOKEN';
		1009:	Result := 'ERROR_BADDB';
		1010:	Result := 'ERROR_BADKEY';
		1011:	Result := 'ERROR_CANTOPEN';
		1012:	Result := 'ERROR_CANTREAD';
		1013:	Result := 'ERROR_CANTWRITE';
		1014:	Result := 'ERROR_REGISTRY_RECOVERED';
		1015:	Result := 'ERROR_REGISTRY_CORRUPT';
		1016:	Result := 'ERROR_REGISTRY_IO_FAILED';
		1017:	Result := 'ERROR_NOT_REGISTRY_FILE';
		1018:	Result := 'ERROR_KEY_DELETED';
		1019:	Result := 'ERROR_NO_LOG_SPACE';
		1020:	Result := 'ERROR_KEY_HAS_CHILDREN';
		1021:	Result := 'ERROR_CHILD_MUST_BE_VOLATILE';
		1022:	Result := 'ERROR_NOTIFY_ENUM_DIR';
		1051:	Result := 'ERROR_DEPENDENT_SERVICES_RUNNING';
		1052:	Result := 'ERROR_INVALID_SERVICE_CONTROL';
		1053:	Result := 'ERROR_SERVICE_REQUEST_TIMEOUT';
		1054:	Result := 'ERROR_SERVICE_NO_THREAD';
		1055:	Result := 'ERROR_SERVICE_DATABASE_LOCKED';
		1056:	Result := 'ERROR_SERVICE_ALREADY_RUNNING';
		1057:	Result := 'ERROR_INVALID_SERVICE_ACCOUNT';
		1058:	Result := 'ERROR_SERVICE_DISABLED';
		1059:	Result := 'ERROR_CIRCULAR_DEPENDENCY';
		1060:	Result := 'ERROR_SERVICE_DOES_NOT_EXIST';
		1061:	Result := 'ERROR_SERVICE_CANNOT_ACCEPT_CTRL';
		1062:	Result := 'ERROR_SERVICE_NOT_ACTIVE';
		1063:	Result := 'ERROR_FAILED_SERVICE_CONTROLLER_CONNECT';
		1064:	Result := 'ERROR_EXCEPTION_IN_SERVICE';
		1065:	Result := 'ERROR_DATABASE_DOES_NOT_EXIST';
		1066:	Result := 'ERROR_SERVICE_SPECIFIC_ERROR';
		1067:	Result := 'ERROR_PROCESS_ABORTED';
		1068:	Result := 'ERROR_SERVICE_DEPENDENCY_FAIL';
		1069:	Result := 'ERROR_SERVICE_LOGON_FAILED';
		1070:	Result := 'ERROR_SERVICE_START_HANG';
		1071:	Result := 'ERROR_INVALID_SERVICE_LOCK';
		1072:	Result := 'ERROR_SERVICE_MARKED_FOR_DELETE';
		1073:	Result := 'ERROR_SERVICE_EXISTS';
		1074:	Result := 'ERROR_ALREADY_RUNNING_LKG';
		1075:	Result := 'ERROR_SERVICE_DEPENDENCY_DELETED';
		1076:	Result := 'ERROR_BOOT_ALREADY_ACCEPTED';
		1077:	Result := 'ERROR_SERVICE_NEVER_STARTED';
		1078:	Result := 'ERROR_DUPLICATE_SERVICE_NAME';
		1100:	Result := 'ERROR_END_OF_MEDIA';
		1101:	Result := 'ERROR_FILEMARK_DETECTED';
		1102:	Result := 'ERROR_BEGINNING_OF_MEDIA';
		1103:	Result := 'ERROR_SETMARK_DETECTED';
		1104:	Result := 'ERROR_NO_DATA_DETECTED';
		1105:	Result := 'ERROR_PARTITION_FAILURE';
		1106:	Result := 'ERROR_INVALID_BLOCK_LENGTH';
		1107:	Result := 'ERROR_DEVICE_NOT_PARTITIONED';
		1108:	Result := 'ERROR_UNABLE_TO_LOCK_MEDIA';
		1109:	Result := 'ERROR_UNABLE_TO_UNLOAD_MEDIA';
		1110:	Result := 'ERROR_MEDIA_CHANGED';
		1111:	Result := 'ERROR_BUS_RESET';
		1112:	Result := 'ERROR_NO_MEDIA_IN_DRIVE';
		1113:	Result := 'ERROR_NO_UNICODE_TRANSLATION';
		1114:	Result := 'ERROR_DLL_INIT_FAILED';
		1115:	Result := 'ERROR_SHUTDOWN_IN_PROGRESS';
		1116:	Result := 'ERROR_NO_SHUTDOWN_IN_PROGRESS';
		1117:	Result := 'ERROR_IO_DEVICE';
		1118:	Result := 'ERROR_SERIAL_NO_DEVICE';
		1119:	Result := 'ERROR_IRQ_BUSY';
		1120:	Result := 'ERROR_MORE_WRITES';
		1121:	Result := 'ERROR_COUNTER_TIMEOUT';
		1122:	Result := 'ERROR_FLOPPY_ID_MARK_NOT_FOUND';
		1123:	Result := 'ERROR_FLOPPY_WRONG_CYLINDER';
		1124:	Result := 'ERROR_FLOPPY_UNKNOWN_ERROR';
		1125:	Result := 'ERROR_FLOPPY_BAD_REGISTERS';
		1126:	Result := 'ERROR_DISK_RECALIBRATE_FAILED';
		1127:	Result := 'ERROR_DISK_OPERATION_FAILED';
		1128:	Result := 'ERROR_DISK_RESET_FAILED';
		1129:	Result := 'ERROR_EOM_OVERFLOW';
		1130:	Result := 'ERROR_NOT_ENOUGH_SERVER_MEMORY';
		1131:	Result := 'ERROR_POSSIBLE_DEADLOCK';
		1200:	Result := 'ERROR_BAD_DEVICE';
		1201:	Result := 'ERROR_CONNECTION_UNAVAIL';
		1202:	Result := 'ERROR_DEVICE_ALREADY_REMEMBERED';
		1203:	Result := 'ERROR_NO_NET_OR_BAD_PATH';
		1204:	Result := 'ERROR_BAD_PROVIDER';
		1205:	Result := 'ERROR_CANNOT_OPEN_PROFILE';
		1206:	Result := 'ERROR_BAD_PROFILE';
		1207:	Result := 'ERROR_NOT_CONTAINER';
		1208:	Result := 'ERROR_EXTENDED_ERROR';
		1209:	Result := 'ERROR_INVALID_GROUPNAME';
		1210:	Result := 'ERROR_INVALID_COMPUTERNAME';
		1211:	Result := 'ERROR_INVALID_EVENTNAME';
		1212:	Result := 'ERROR_INVALID_DOMAINNAME';
		1213:	Result := 'ERROR_INVALID_SERVICENAME';
		1214:	Result := 'ERROR_INVALID_NETNAME';
		1215:	Result := 'ERROR_INVALID_SHARENAME';
		1216:	Result := 'ERROR_INVALID_PASSWORDNAME';
		1217:	Result := 'ERROR_INVALID_MESSAGENAME';
		1218:	Result := 'ERROR_INVALID_MESSAGEDEST';
		1219:	Result := 'ERROR_SESSION_CREDENTIAL_CONFLICT';
		1220:	Result := 'ERROR_REMOTE_SESSION_LIMIT_EXCEEDED';
		1221:	Result := 'ERROR_DUP_DOMAINNAME';
		1300:	Result := 'ERROR_NOT_ALL_ASSIGNED';
		1301:	Result := 'ERROR_SOME_NOT_MAPPED';
		1302:	Result := 'ERROR_NO_QUOTAS_FOR_ACCOUNT';
		1303:	Result := 'ERROR_LOCAL_USER_SESSION_KEY';
		1304:	Result := 'ERROR_NULL_LM_PASSWORD';
		1305:	Result := 'ERROR_UNKNOWN_REVISION';
		1306:	Result := 'ERROR_REVISION_MISMATCH';
		1307:	Result := 'ERROR_INVALID_OWNER';
		1308:	Result := 'ERROR_INVALID_PRIMARY_GROUP';
		1309:	Result := 'ERROR_NO_IMPERSONATION_TOKEN';
		1310:	Result := 'ERROR_CANT_DISABLE_MANDATORY';
		1311:	Result := 'ERROR_NO_LOGON_SERVERS';
		1312:	Result := 'ERROR_NO_SUCH_LOGON_SESSION';
		1313:	Result := 'ERROR_NO_SUCH_PRIVILEGE';
		1314:	Result := 'ERROR_PRIVILEGE_NOT_HELD';
		1315:	Result := 'ERROR_INVALID_ACCOUNT_NAME';
		1316:	Result := 'ERROR_USER_EXISTS';
		1317:	Result := 'ERROR_NO_SUCH_USER';
		1318:	Result := 'ERROR_GROUP_EXISTS';
		1319:	Result := 'ERROR_NO_SUCH_GROUP';
		1320:	Result := 'ERROR_MEMBER_IN_GROUP';
		1321:	Result := 'ERROR_MEMBER_NOT_IN_GROUP';
		1322:	Result := 'ERROR_LAST_ADMIN';
		1323:	Result := 'ERROR_WRONG_PASSWORD';
		1324:	Result := 'ERROR_ILL_FORMED_PASSWORD';
		1325:	Result := 'ERROR_PASSWORD_RESTRICTION';
		1326:	Result := 'ERROR_LOGON_FAILURE';
		1327:	Result := 'ERROR_ACCOUNT_RESTRICTION';
		1328:	Result := 'ERROR_INVALID_LOGON_HOURS';
		1329:	Result := 'ERROR_INVALID_WORKSTATION';
		1330:	Result := 'ERROR_PASSWORD_EXPIRED';
		1331:	Result := 'ERROR_ACCOUNT_DISABLED';
		1332:	Result := 'ERROR_NONE_MAPPED';
		1333:	Result := 'ERROR_TOO_MANY_LUIDS_REQUESTED';
		1334:	Result := 'ERROR_LUIDS_EXHAUSTED';
		1335:	Result := 'ERROR_INVALID_SUB_AUTHORITY';
		1336:	Result := 'ERROR_INVALID_ACL';
		1337:	Result := 'ERROR_INVALID_SID';
		1338:	Result := 'ERROR_INVALID_SECURITY_DESCR';
		1340:	Result := 'ERROR_BAD_INHERITANCE_ACL';
		1341:	Result := 'ERROR_SERVER_DISABLED';
		1342:	Result := 'ERROR_SERVER_NOT_DISABLED';
		1343:	Result := 'ERROR_INVALID_ID_AUTHORITY';
		1344:	Result := 'ERROR_ALLOTTED_SPACE_EXCEEDED';
		1345:	Result := 'ERROR_INVALID_GROUP_ATTRIBUTES';
		1346:	Result := 'ERROR_BAD_IMPERSONATION_LEVEL';
		1347:	Result := 'ERROR_CANT_OPEN_ANONYMOUS';
		1348:	Result := 'ERROR_BAD_VALIDATION_CLASS';
		1349:	Result := 'ERROR_BAD_TOKEN_TYPE';
		1350:	Result := 'ERROR_NO_SECURITY_ON_OBJECT';
		1351:	Result := 'ERROR_CANT_ACCESS_DOMAIN_INFO';
		1352:	Result := 'ERROR_INVALID_SERVER_STATE';
		1353:	Result := 'ERROR_INVALID_DOMAIN_STATE';
		1354:	Result := 'ERROR_INVALID_DOMAIN_ROLE';
		1355:	Result := 'ERROR_NO_SUCH_DOMAIN';
		1356:	Result := 'ERROR_DOMAIN_EXISTS';
		1357:	Result := 'ERROR_DOMAIN_LIMIT_EXCEEDED';
		1358:	Result := 'ERROR_INTERNAL_DB_CORRUPTION';
		1359:	Result := 'ERROR_INTERNAL_ERROR';
		1360:	Result := 'ERROR_GENERIC_NOT_MAPPED';
		1361:	Result := 'ERROR_BAD_DESCRIPTOR_FORMAT';
		1362:	Result := 'ERROR_NOT_LOGON_PROCESS';
		1363:	Result := 'ERROR_LOGON_SESSION_EXISTS';
		1364:	Result := 'ERROR_NO_SUCH_PACKAGE';
		1365:	Result := 'ERROR_BAD_LOGON_SESSION_STATE';
		1366:	Result := 'ERROR_LOGON_SESSION_COLLISION';
		1367:	Result := 'ERROR_INVALID_LOGON_TYPE';
		1368:	Result := 'ERROR_CANNOT_IMPERSONATE';
		1369:	Result := 'ERROR_RXACT_INVALID_STATE';
		1370:	Result := 'ERROR_RXACT_COMMIT_FAILURE';
		1371:	Result := 'ERROR_SPECIAL_ACCOUNT';
		1372:	Result := 'ERROR_SPECIAL_GROUP';
		1373:	Result := 'ERROR_SPECIAL_USER';
		1374:	Result := 'ERROR_MEMBERS_PRIMARY_GROUP';
		1375:	Result := 'ERROR_TOKEN_ALREADY_IN_USE';
		1376:	Result := 'ERROR_NO_SUCH_ALIAS';
		1377:	Result := 'ERROR_MEMBER_NOT_IN_ALIAS';
		1378:	Result := 'ERROR_MEMBER_IN_ALIAS';
		1379:	Result := 'ERROR_ALIAS_EXISTS';
		1380:	Result := 'ERROR_LOGON_NOT_GRANTED';
		1381:	Result := 'ERROR_TOO_MANY_SECRETS';
		1382:	Result := 'ERROR_SECRET_TOO_LONG';
		1383:	Result := 'ERROR_INTERNAL_DB_ERROR';
		1384:	Result := 'ERROR_TOO_MANY_CONTEXT_IDS';
		1385:	Result := 'ERROR_LOGON_TYPE_NOT_GRANTED';
		1386:	Result := 'ERROR_NT_CROSS_ENCRYPTION_REQUIRED';
		1387:	Result := 'ERROR_NO_SUCH_MEMBER';
		1388:	Result := 'ERROR_INVALID_MEMBER';
		1389:	Result := 'ERROR_TOO_MANY_SIDS';
		1390:	Result := 'ERROR_LM_CROSS_ENCRYPTION_REQUIRED';
		1391:	Result := 'ERROR_NO_INHERITANCE';
		1392:	Result := 'ERROR_FILE_CORRUPT';
		1393:	Result := 'ERROR_DISK_CORRUPT';
		1394:	Result := 'ERROR_NO_USER_SESSION_KEY';
		1400:	Result := 'ERROR_INVALID_WINDOW_HANDLE';
		1401:	Result := 'ERROR_INVALID_MENU_HANDLE';
		1402:	Result := 'ERROR_INVALID_CURSOR_HANDLE';
		1403:	Result := 'ERROR_INVALID_ACCEL_HANDLE';
		1404:	Result := 'ERROR_INVALID_HOOK_HANDLE';
		1405:	Result := 'ERROR_INVALID_DWP_HANDLE';
		1406:	Result := 'ERROR_TLW_WITH_WSCHILD';
		1407:	Result := 'ERROR_CANNOT_FIND_WND_CLASS';
		1408:	Result := 'ERROR_WINDOW_OF_OTHER_THREAD';
		1409:	Result := 'ERROR_HOTKEY_ALREADY_REGISTERED';
		1410:	Result := 'ERROR_CLASS_ALREADY_EXISTS';
		1411:	Result := 'ERROR_CLASS_DOES_NOT_EXIST';
		1412:	Result := 'ERROR_CLASS_HAS_WINDOWS';
		1413:	Result := 'ERROR_INVALID_INDEX';
		1414:	Result := 'ERROR_INVALID_ICON_HANDLE';
		1415:	Result := 'ERROR_PRIVATE_DIALOG_INDEX';
		1416:	Result := 'ERROR_LISTBOX_ID_NOT_FOUND';
		1417:	Result := 'ERROR_NO_WILDCARD_CHARACTERS';
		1418:	Result := 'ERROR_CLIPBOARD_NOT_OPEN';
		1419:	Result := 'ERROR_HOTKEY_NOT_REGISTERED';
		1420:	Result := 'ERROR_WINDOW_NOT_DIALOG';
		1421:	Result := 'ERROR_CONTROL_ID_NOT_FOUND';
		1422:	Result := 'ERROR_INVALID_COMBOBOX_MESSAGE';
		1423:	Result := 'ERROR_WINDOW_NOT_COMBOBOX';
		1424:	Result := 'ERROR_INVALID_EDIT_HEIGHT';
		1425:	Result := 'ERROR_DC_NOT_FOUND';
		1426:	Result := 'ERROR_INVALID_HOOK_FILTER';
		1427:	Result := 'ERROR_INVALID_FILTER_PROC';
		1428:	Result := 'ERROR_HOOK_NEEDS_HMOD';
		1429:	Result := 'ERROR_GLOBAL_ONLY_HOOK';
		1430:	Result := 'ERROR_JOURNAL_HOOK_SET';
		1431:	Result := 'ERROR_HOOK_NOT_INSTALLED';
		1432:	Result := 'ERROR_INVALID_LB_MESSAGE';
		1433:	Result := 'ERROR_SETCOUNT_ON_BAD_LB';
		1434:	Result := 'ERROR_LB_WITHOUT_TABSTOPS';
		1435:	Result := 'ERROR_DESTROY_OBJECT_OF_OTHER_THREAD';
		1436:	Result := 'ERROR_CHILD_WINDOW_MENU';
		1437:	Result := 'ERROR_NO_SYSTEM_MENU';
		1438:	Result := 'ERROR_INVALID_MSGBOX_STYLE';
		1439:	Result := 'ERROR_INVALID_SPI_VALUE';
		1440:	Result := 'ERROR_SCREEN_ALREADY_LOCKED';
		1441:	Result := 'ERROR_HWNDS_HAVE_DIFFERENT_PARENT';
		1442:	Result := 'ERROR_NOT_CHILD_WINDOW';
		1443:	Result := 'ERROR_INVALID_GW_COMMAND';
		1444:	Result := 'ERROR_INVALID_THREAD_ID';
		1445:	Result := 'ERROR_NON_MDICHILD_WINDOW';
		1446:	Result := 'ERROR_POPUP_ALREADY_ACTIVE';
		1447:	Result := 'ERROR_NO_SCROLLBARS';
		1448:	Result := 'ERROR_INVALID_SCROLLBAR_RANGE';
		1449:	Result := 'ERROR_INVALID_SHOWWIN_COMMAND';
		1500:	Result := 'ERROR_EVENTLOG_FILE_CORRUPT';
		1501:	Result := 'ERROR_EVENTLOG_CANT_START';
		1502:	Result := 'ERROR_LOG_FILE_FULL';
		1503:	Result := 'ERROR_EVENTLOG_FILE_CHANGED';
		1700: Result := 'RPC_S_INVALID_STRING_BINDING';
		1701: Result := 'RPC_S_WRONG_KIND_OF_BINDING';
		1702: Result := 'RPC_S_INVALID_BINDING';
		1703: Result := 'RPC_S_PROTSEQ_NOT_SUPPORTED';
		1704: Result := 'RPC_S_INVALID_RPC_PROTSEQ';
		1705: Result := 'RPC_S_INVALID_STRING_UUID';
		1706: Result := 'RPC_S_INVALID_ENDPOINT_FORMAT';
		1707: Result := 'RPC_S_INVALID_NET_ADDR';
		1708: Result := 'RPC_S_NO_ENDPOINT_FOUND';
		1709: Result := 'RPC_S_INVALID_TIMEOUT';
		1710: Result := 'RPC_S_OBJECT_NOT_FOUND';
		1711: Result := 'RPC_S_ALREADY_REGISTERED';
		1712: Result := 'RPC_S_TYPE_ALREADY_REGISTERED';
		1713: Result := 'RPC_S_ALREADY_LISTENING';
		1714: Result := 'RPC_S_NO_PROTSEQS_REGISTERED';
		1715: Result := 'RPC_S_NOT_LISTENING';
		1716: Result := 'RPC_S_UNKNOWN_MGR_TYPE';
		1717: Result := 'RPC_S_UNKNOWN_IF';
		1718: Result := 'RPC_S_NO_BINDINGS';
		1719: Result := 'RPC_S_NO_PROTSEQS';
		1720: Result := 'RPC_S_CANT_CREATE_ENDPOINT';
		1721: Result := 'RPC_S_OUT_OF_RESOURCES';
		1722: Result := 'RPC_S_SERVER_UNAVAILABLE';
		1723: Result := 'RPC_S_SERVER_TOO_BUSY';
		1724: Result := 'RPC_S_INVALID_NETWORK_OPTIONS';
		1725: Result := 'RPC_S_NO_CALL_ACTIVE';
		1726: Result := 'RPC_S_CALL_FAILED';
		1727: Result := 'RPC_S_CALL_FAILED_DNE';
		1728: Result := 'RPC_S_PROTOCOL_ERROR';
		1730: Result := 'RPC_S_UNSUPPORTED_TRANS_SYN';
		1731: Result := 'RPC_S_SERVER_OUT_OF_MEMORY';
		1732: Result := 'RPC_S_UNSUPPORTED_TYPE';
		1733: Result := 'RPC_S_INVALID_TAG';
		1734: Result := 'RPC_S_INVALID_BOUND';
		1735: Result := 'RPC_S_NO_ENTRY_NAME';
		1736: Result := 'RPC_S_INVALID_NAME_SYNTAX';
		1737: Result := 'RPC_S_UNSUPPORTED_NAME_SYNTAX';
		1739: Result := 'RPC_S_UUID_NO_ADDRESS';
		1740: Result := 'RPC_S_DUPLICATE_ENDPOINT';
		1741: Result := 'RPC_S_UNKNOWN_AUTHN_TYPE';
		1742: Result := 'RPC_S_MAX_CALLS_TOO_SMALL';
		1743: Result := 'RPC_S_STRING_TOO_LONG';
		1744: Result := 'RPC_S_PROTSEQ_NOT_FOUND';
		1745: Result := 'RPC_S_PROCNUM_OUT_OF_RANGE';
		1746: Result := 'RPC_S_BINDING_HAS_NO_AUTH';
		1747: Result := 'RPC_S_UNKNOWN_AUTHN_SERVICE';
		1748: Result := 'RPC_S_UNKNOWN_AUTHN_LEVEL';
		1749: Result := 'RPC_S_INVALID_AUTH_IDENTITY';
		1750: Result := 'RPC_S_UNKNOWN_AUTHZ_SERVICE';
		1751: Result := 'EPT_S_INVALID_ENTRY';
		1752: Result := 'EPT_S_CANT_PERFORM_OP';
		1753: Result := 'EPT_S_NOT_REGISTERED';
		1755: Result := 'RPC_S_INCOMPLETE_NAME';
		1756: Result := 'RPC_S_INVALID_VERS_OPTION';
		1757: Result := 'RPC_S_NO_MORE_MEMBERS';
		1759: Result := 'RPC_S_INTERFACE_NOT_FOUND';
		1760: Result := 'RPC_S_ENTRY_ALREADY_EXISTS';
		1761: Result := 'RPC_S_ENTRY_NOT_FOUND';
		1762: Result := 'RPC_S_NAME_SERVICE_UNAVAILABLE';
		1764: Result := 'RPC_S_CANNOT_SUPPORT';
		1765: Result := 'RPC_S_NO_CONTEXT_AVAILABLE';
		1766: Result := 'RPC_S_INTERNAL_ERROR';
		1767: Result := 'RPC_S_ZERO_DIVIDE';
		1768: Result := 'RPC_S_ADDRESS_ERROR';
		1769: Result := 'RPC_S_FP_DIV_ZERO';
		1770: Result := 'RPC_S_FP_UNDERFLOW';
		1771: Result := 'RPC_S_FP_OVERFLOW';
		1772: Result := 'RPC_X_NO_MORE_ENTRIES';
		1773: Result := 'RPC_X_SS_CHAR_TRANS_OPEN_FAIL';
		1774: Result := 'RPC_X_SS_CHAR_TRANS_SHORT_FILE';
		1775: Result := 'RPC_X_SS_IN_NULL_CONTEXT';
		1776: Result := 'RPC_X_SS_CONTEXT_MISMATCH';
		1777: Result := 'RPC_X_SS_CONTEXT_DAMAGED';
		1778: Result := 'RPC_X_SS_HANDLES_MISMATCH';
		1779: Result := 'RPC_X_SS_CANNOT_GET_CALL_HANDLE';
		1780: Result := 'RPC_X_NULL_REF_POINTER';
		1781: Result := 'RPC_X_ENUM_VALUE_OUT_OF_RANGE';
		1782: Result := 'RPC_X_BYTE_COUNT_TOO_SMALL';
		1783: Result := 'RPC_X_BAD_STUB_DATA';
		1784:	Result := 'ERROR_INVALID_USER_BUFFER';
		1785:	Result := 'ERROR_UNRECOGNIZED_MEDIA';
		1786:	Result := 'ERROR_NO_TRUST_LSA_SECRET';
		1787:	Result := 'ERROR_NO_TRUST_SAM_ACCOUNT';
		1788:	Result := 'ERROR_TRUSTED_DOMAIN_FAILURE';
		1789:	Result := 'ERROR_TRUSTED_RELATIONSHIP_FAILURE';
		1790:	Result := 'ERROR_TRUST_FAILURE';
		1791: Result := 'RPC_S_CALL_IN_PROGRESS';
		1792:	Result := 'ERROR_NETLOGON_NOT_STARTED';
		1793:	Result := 'ERROR_ACCOUNT_EXPIRED';
		1794:	Result := 'ERROR_REDIRECTOR_HAS_OPEN_HANDLES';
		1795:	Result := 'ERROR_PRINTER_DRIVER_ALREADY_INSTALLED';
		1796:	Result := 'ERROR_UNKNOWN_PORT';
		1797:	Result := 'ERROR_UNKNOWN_PRINTER_DRIVER';
		1798:	Result := 'ERROR_UNKNOWN_PRINTPROCESSOR';
		1799:	Result := 'ERROR_INVALID_SEPARATOR_FILE';
		1800:	Result := 'ERROR_INVALID_PRIORITY';
		1801:	Result := 'ERROR_INVALID_PRINTER_NAME';
		1802:	Result := 'ERROR_PRINTER_ALREADY_EXISTS';
		1803:	Result := 'ERROR_INVALID_PRINTER_COMMAND';
		1804:	Result := 'ERROR_INVALID_DATATYPE';
		1805:	Result := 'ERROR_INVALID_ENVIRONMENT';
		1806: Result := 'RPC_S_NO_MORE_BINDINGS';
		1807:	Result := 'ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT';
		1808:	Result := 'ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT';
		1809:	Result := 'ERROR_NOLOGON_SERVER_TRUST_ACCOUNT';
		1810:	Result := 'ERROR_DOMAIN_TRUST_INCONSISTENT';
		1811:	Result := 'ERROR_SERVER_HAS_OPEN_HANDLES';
		1812:	Result := 'ERROR_RESOURCE_DATA_NOT_FOUND';
		1813:	Result := 'ERROR_RESOURCE_TYPE_NOT_FOUND';
		1814:	Result := 'ERROR_RESOURCE_NAME_NOT_FOUND';
		1815:	Result := 'ERROR_RESOURCE_LANG_NOT_FOUND';
		1816:	Result := 'ERROR_NOT_ENOUGH_QUOTA';
		1898: Result := 'RPC_S_GROUP_MEMBER_NOT_FOUND';
		1899: Result := 'EPT_S_CANT_CREATE';
		1900: Result := 'RPC_S_INVALID_OBJECT';
		2138:	Result := 'ERROR_NO_NETWORK';
		2202:	Result := 'ERROR_BAD_USERNAME';
		2250:	Result := 'ERROR_NOT_CONNECTED';
		2401:	Result := 'ERROR_OPEN_FILES';
		2404:	Result := 'ERROR_DEVICE_IN_USE';
		6118:	Result := 'ERROR_NO_BROWSER_SERVERS_FOUND';
		else Result := '?';
	end{case};
end;

procedure TForm1.edtCodeKeyPress(Sender: TObject; var Key: Char);
begin
		if key in ['-','1','2','3','4','5','6','7','8','9','0', #8{bkspc}] then
			Exit
		else begin
			MessageBeep(mb_IconExclamation);
			Key := #0;
		end;
end;

procedure TForm1.edtCodeChange(Sender: TObject);
begin
	Try
		if FindError(StrToInt(edtCode.Text)) = '?' then begin
			edtMessage.Color := clRed;
			edtMessage.Font.Color := clWhite;
			edtMessage.Text := 'Unknown Error Code';
		end else begin
			edtMessage.Color := clWindow;
			edtMessage.Font.Color := clWindowText;
			edtMessage.Text := FindError(StrToInt(edtCode.Text));
		end{if}
	Except
		edtMessage.Color := clRed;
		edtMessage.Font.Color := clWhite;
		edtMessage.Text := 'Unknown Error Code';
	end{try};
end;

end.
