unit ListUnit;
{WienieMC, program to stuff keys into the keyboard-buffer.
 Made by Anton Bil, abil@mail.HZeeland.nl

 For this program to run you need one component to be installed:
 - TrayIcon by Rauf Gereyhanov
 You can find this file at the Delphi Super Page, or at my download-page:
 http://www.HZeeland.nl/~abil/download/download.html
 This page also contains the latest version of this program, and
 lots of other sourcecode and programs that I have made.

 This program is based on an example of the use of keybd_event that I found
 at the delphi.misc newsgroup after two days of searching. Thank you for the
 suggestion! After that it was quite easy to write the rest.

 This program can be improved, if you want to, please do, only give credits
 to me if you use this code.
 Some improvements I have thought of are:
- Increase macro-possibilities: define more macro-commands etc.
- Introduce an object for the Mylist, instead of three different arrays. That
  would be more elegant...

Version 2.0:
- added keyboard-shortcuts, remember to compile SNOOPDLL first, because
  it contains a DLL that must be present when the program runs!
- deleted unused unit-names from the uses-clause
- removed the WindowsL-component from the uses-clause, the program has its own
  lines of code to activate a window.
- added a few times Application.Processmessages, to avoid the keyboard-buffer
  from getting too full
- added a wait before the writing of characters.

  If you have suggestions, let me know, have fun!

}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, TaskIcon, Menus, inifiles, ComCtrls, ToolWin,
  MacrHelp, ExtCtrls, WindowsL;

const WM_MyKeyboard=WM_USER+1001;{identifies the message sent by the library}
      ControlKey:boolean=false;{true when user presses CTRL-key}

type
  TWienieMacro = class(TForm)
    WindowsList1: TWindowsList;
    TaskIcon1: TTaskIcon;
    Memo1: TMemo;
    PopupMenu1: TPopupMenu;
    Close1: TMenuItem;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Edit1: TMenuItem;
    Window1: TMenuItem;
    Help1: TMenuItem;
    Reload1: TMenuItem;
    Apply1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    Hide1: TMenuItem;
    Show1: TMenuItem;
    MenuEdit: TEdit;
    Label1: TLabel;
    CountLabel: TLabel;
    Add1: TMenuItem;
    Delete1: TMenuItem;
    Help2: TMenuItem;
    About1: TMenuItem;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    SaveAs1: TMenuItem;
    Open1: TMenuItem;
    ToolBar1: TToolBar;
    FastLeft: TToolButton;
    ImageList1: TImageList;
    Left: TToolButton;
    Right: TToolButton;
    FastRight: TToolButton;
    ToolButton1: TToolButton;
    Add: TToolButton;
    Del: TToolButton;
    SaveButton: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    Hide: TToolButton;
    space: TMenuItem;
    Timer1: TTimer;
    HotKeyEdit: TEdit;
    Label2: TLabel;
    WaitTimer: TTimer;
    procedure FastLeftClick(Sender: TObject);
    procedure Close1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure DoAction(Sender: TObject);
    procedure TaskIcon1RightClick(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Exit1Click(Sender: TObject);
    procedure Hide1Click(Sender: TObject);
    procedure Show1Click(Sender: TObject);
    procedure LeftClick(Sender: TObject);
    procedure RightClick(Sender: TObject);
    procedure FastRightClick(Sender: TObject);
    procedure AddClick(Sender: TObject);
    procedure DelClick(Sender: TObject);
    procedure Help2Click(Sender: TObject);
    procedure Reload1Click(Sender: TObject);
    procedure Apply1Click(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure SaveAs1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure TaskIcon1LeftClick(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Timer1Timer(Sender: TObject);
    procedure WaitTimerTimer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    ProcessActive:boolean;
    MyList:TList;
    CurrNr:Integer;
    MenuItems,HotKeyItems:TStringList;
    StartMenuCount:word;
    procedure ReadIni(s:string);
    procedure UpDateDisplay;
    procedure SaveDisplay;
    procedure SaveToFile(s:string);
    procedure SendKeys(s : string);
    procedure wmHandleMessages(var Msg:TMsg;var Handled:Boolean);
    procedure MyAction(nr:integer);
    procedure MyAction2(nr:integer);
  end;

var
  WienieMacro: TWienieMacro;        
  Hook:HHOOK;
  DllInstance:DWORD;
  HookProc:FARPROC;

implementation

uses Macrabot;

{$R *.DFM}
function xstr(i:integer;j:integer):string;
{simple procedure used to concatenate strings with numbers}
var h:string;
begin
  str(i:j,h);
  xstr:=h;
end;

{the following procedures are an exact copy of an example found
 in the Delphi-newsgroup}
procedure SimulateKeyDown(Key : byte);
begin
  keybd_event(Key, 0, 0, 0);
end;

procedure SimulateKeyUp(Key : byte);
begin
  keybd_event(Key, 0, KEYEVENTF_KEYUP, 0);
end;

procedure SimulateKeystroke(Key : byte;
                            extra : DWORD);
begin
  keybd_event(Key,
              extra,
              0,
              0);
  keybd_event(Key,
              extra,
              KEYEVENTF_KEYUP,
              0);
end;

procedure TWienieMacro.SendKeys(s : string);
var
  i,j,k : integer;
  SHIFT,alt,ctrl:boolean;
  flag : bool;
  w : word;
  hs:string;
  Handle:THandle;
procedure SetOff;
begin
      if alt then                   
      begin
        SimulateKeyUp(VK_MENU);
        alt:=false;
      end;
      if ctrl then
      begin
        SimulateKeyUp(VK_CONTROL);
        ctrl:=false;
      end;
      if shift then
      begin
        SimulateKeyUp(VK_SHIFT);
        shift:=false;
      end;
end;

procedure SendSingleKey;
var shift:boolean;
begin
   {If the key requires the shift key down - hold it down}
   shift:=HiByte(w) and 1 = 1;
    if shift then
      SimulateKeyDown(VK_SHIFT);
   {Send the VK_KEY}
   SimulateKeystroke(LoByte(w), 0);
   SetOff;
   {If the key required the shift key down - release it}

   if shift then
     SimulateKeyUp(VK_SHIFT);
end;

function weekday(i:integer):string;
begin
  case i of
    1:weekday:='Sunday';
    2:weekday:='Monday';
    3:weekday:='Tuesday';
    4:weekday:='Wednesday';
    5:weekday:='Thursday';
    6:weekday:='Friday';
    7:weekday:='Saturday';
  end;
end;

{the following part has been thoroughly modified}
procedure InsertString(var s:string;mess:string;p:integer);
         begin
           s:=copy(s,1,p)+
           InputBox('Enter value', mess,'')+
           copy(s,p+1,length(s));
         end;
begin
 alt:=false;
 ctrl:=false;
 shift:=false;
 {Get the state of the caps lock key}
  flag := not GetKeyState(VK_CAPITAL) and 1 = 0;
 {If the caps lock key is on then turn it off}
  if flag then
    SimulateKeystroke(VK_CAPITAL, 0);
  i:=1;
  while i <= Length(s) do begin
    if (i mod 10)=0 then Application.ProcessMessages;
    w := VkKeyScan(s[i]);
   {If there is not an error in the key translation}
    if ((HiByte(w) <> $FF) and
        (LoByte(w) <> $FF)) then begin
     if (s[i]='@') then
     begin
       if (s[i+1]<>'@')  then
       begin
         SimulateKeystroke(VK_MENU, 0);
         alt:=true;
       end else
       begin
         inc(i);
         SendSingleKey;
       end;
     end
     else
     if s[i]='^' then
     begin
       if (s[i+1]<>'^') then
       begin
         SimulateKeystroke(VK_CONTROL, 0);
         ctrl:=true;
       end else
       begin
         inc(i);
         SendSingleKey;
       end;
     end
     else
     if s[i]='{' then
     begin
       k:=pos('}',copy(s,i+1,length(s)));
       if k>0 then
       begin
         hs:=uppercase(copy(s,i+1,k-1));
         if hs='INS' then SimulateKeystroke(VK_INSERT, 0) else
         if hs='DEL' then SimulateKeystroke(VK_DELETE, 0) else
         if hs='RT' then SimulateKeystroke(VK_RETURN, 0) else
         if hs='TAB' then SimulateKeystroke(VK_TAB, 0) else
         if hs='ESC' then SimulateKeystroke(VK_ESCAPE, 0) else
         if hs='BACK' then SimulateKeystroke(VK_BACK, 0) else
         if hs='UP' then SimulateKeystroke(VK_up, 0) else
         if hs='DOWN' then SimulateKeystroke(VK_DOWN, 0) else
         if hs='LEFT' then SimulateKeystroke(VK_LEFT, 0) else
         if hs='RIGHT' then SimulateKeystroke(VK_RIGHT, 0) else
         if hs='PGDN' then SimulateKeystroke(VK_NEXT, 0) else
         if hs='PGUP' then SimulateKeystroke(VK_PRIOR, 0) else
         if hs='END' then SimulateKeystroke(VK_END, 0) else
         if hs='HOME' then SimulateKeystroke(VK_HOME, 0) else
         if hs='PRTSC' then SimulateKeystroke(VK_SNAPSHOT, 0) else
         if hs='F1' then SimulateKeystroke(VK_F1, 0) else
         if hs='F2' then SimulateKeystroke(VK_F2, 0) else
         if hs='F3' then SimulateKeystroke(VK_F3, 0) else
         if hs='F4' then SimulateKeystroke(VK_F4, 0) else
         if hs='F5' then SimulateKeystroke(VK_F5, 0) else
         if hs='F6' then SimulateKeystroke(VK_F6, 0) else
         if hs='F7' then SimulateKeystroke(VK_F7, 0) else
         if hs='F8' then SimulateKeystroke(VK_F8, 0) else
         if hs='F9' then SimulateKeystroke(VK_F9, 0) else
         if hs='F10' then SimulateKeystroke(VK_F10, 0) else
         if hs='F11' then SimulateKeystroke(VK_F11, 0) else
         if hs='F12' then SimulateKeystroke(VK_F12, 0) else
         if hs='SHIFT' then
         begin
           SimulateKeystroke(VK_SHIFT, 0);
           shift:=true;
         end else
         if copy(hs,1,6)='SELECT' then
         begin
           hs:=copy(hs,8,length(hs));
           while (length(hs)>0) and (hs[1]=' ') do hs:=copy(hs,2,length(hs));
           for j:=0 to WindowsList1.TheWindowsList.count-1 do
           if pos(hs,uppercase(WienieMacro.windowslist1.TheWindowsList[j]))>0 then
           begin
             Handle:=WindowsList1.GetHandle(j);
             SetForegroundWindow(Handle);
           end;
         end else
         if copy(hs,1,3)='GET' then
         InsertString(s,copy(hs,4,length(hs)),i+k) else
         if hs='?' then
         InsertString(s,'',i+k) else
         if hs='DATE' then
         begin
           insert(DateToStr(Date),s,i+k+1);
         end else
         if hs='TIME' then
         begin
           insert(TimeToStr(Time),s,i+k+1);
         end else
         if hs='DAY' then
         begin
           insert(weekday(DayOfWeek(Date)),s,i+k+1);
         end;
         i:=i+k;
       end else
       begin
         SendSingleKey;
       end;
     end else
     begin
      SendSingleKey;
     end;
      inc(i);
    end;
  end;
 {if the caps lock key was on at start, turn it back on}
  if flag then
    SimulateKeystroke(VK_CAPITAL, 0);
  SetOff;
end;

procedure TWienieMacro.FastLeftClick(Sender: TObject);
begin
  SaveDisplay;
  if Mylist.Count>0 then Currnr:=0 else CurrNr:=-1;
  UpdateDisPlay;
end;

procedure TWienieMacro.Close1Click(Sender: TObject);
begin
  close;
end;

procedure TWienieMacro.FormCreate(Sender: TObject);
begin
  ProcessActive:=false;
  StartMenuCount:=PopupMenu1.Items.Count;
  TaskIcon1.active:=true;
  MyList:=TList.create;
  MenuItems:=TStringList.create;
  HotKeyItems:=TStringList.create;
  ReadIni(ChangeFileExt(paramstr(0),'.ini'));
  Application.OnMessage:=wmHandleMessages;
end;

procedure TWienieMacro.UpDateDisplay;
{updates the display with the current macro-keys to edit}
var i:integer;
    hs:TStringList;
begin
  Memo1.Lines.Clear;
  menuEdit.Text:='';
  HotKeyEdit.Text:='';
  if CurrNr>=0 then
  begin
    MenuEdit.enabled:=true;
    Memo1.enabled:=true;
    MenuEdit.Text:=MenuItems[CurrNr];
    HotKeyEdit.Text:=HotKeyItems[CurrNr];
    hs:=TStringList(MyList[CurrNr]);
    for i:=0 to hs.Count-1 do
    Memo1.Lines.Add(hs[i]);
    CountLabel.Caption:=xstr(CurrNr,1);
  end else
  begin
    CountLabel.Caption:='--';
    MenuEdit.enabled:=false;
    Memo1.enabled:=false;
  end;
end;

procedure TWienieMacro.MyAction2(nr:integer);
var s:tstringlist;
    i:integer;
begin
  if ProcessActive then exit;
  ProcessActive:=true;

  {wait a while}
  WaitTimer.enabled:=true;
  while WaitTimer.enabled do Application.ProcessMessages;

  {process macro}
    if nr>=MyList.count then
    begin
      ShowMessage('Wrong index for macro!');
      exit;
    end;
    s:=TStringList(MyList[nr]);
    for i:=0 to s.count-1 do
    begin
      Application.ProcessMessages;
      SendKeys(s[i]);
    end;
    ProcessActive:=false;
end;

procedure TWienieMacro.MyAction(nr:integer);
var Handle:THandle;
    WindowHandle2 : HWND;
    FoundIt:boolean;
Procedure GetVisibleWindowsProc(WinHandle : HWND);
Var
  P : Array[0..256] Of Char;
Begin
  P[0] := #0;
  GetWindowText(WinHandle, P, 255);
  If (P[0] > #0) Then
    If IsWindowVisible(WinHandle)
      Then FoundIt:=true;
End;  // Procedure

begin
  {select first visible window}
  FoundIt:=false;
  WindowHandle2 := FindWindow( Nil, Nil);
  GetVisibleWindowsProc(WindowHandle2);
  While not FoundIt and (WindowHandle2 <> 0) Do  // While there are still windows
    Begin
    WindowHandle2 := GetWindow(WindowHandle2, GW_HWNDNEXT);
    GetVisibleWindowsProc(WindowHandle2);
    End;
    if foundit then
    Handle:=WindowHandle2 else
    begin
      showmessage('No visible windows to send messages to!');
      exit;
    end;
    SetForegroundWindow(Handle);
  {process macro}  
  MyAction2(nr);
end;


procedure TWienieMacro.DoAction(Sender: TObject);
{activate macro-processing out of a menu-item}
begin
  with Sender as TMenuItem do
  MyAction(tag);
end;

procedure TWienieMacro.ReadIni(s:string);
{read saved defaults}
var IniFile : tIniFile;
    i,j:integer;
    gevonden,gevonden2:boolean;
    MenuI,ItemI,HotItemI:string;
    hm:tmenuItem;
    StrItem:TStringList;
begin
  IniFile := tIniFile.Create(s);
  While PopupMenu1.Items.Count>StartMenuCount do
  PopupMenu1.Items.delete(0);
  MyList.Clear;
  MenuItems.Clear;
  HotkeyItems.Clear;
  gevonden:=true;
  i:=0;
  while gevonden do
  begin
     MenuI:=IniFile.ReadString('Default', 'Caption'+xstr(i,1) , 'Not Found');
     gevonden:=Menui<>'Not Found';
     if gevonden then
     begin
       HotItemI:=IniFile.ReadString('Default', 'HotKey'+xstr(i,1) , 'Not Found');
       if HotItemI='Not Found' then HotItemI:=' ';
       popupmenu1.Items.insert(i,TMenuItem.create(PopupMenu1));
       hm:=PopupMenu1.Items[i];
       with hm do
       begin
         StrItem:=TStringList.Create;
         gevonden2:=true;
         j:=0;
         while gevonden2 do
         begin
           ItemI:=IniFile.ReadString('Default', 'L'+xstr(i,1)+'-'+xstr(j,1) , 'Not Found');
           gevonden2:=Itemi<>'Not Found';
           if gevonden2 then
           begin
             StrItem.add(ItemI);
           end;
           inc(j);
         end;
         MyList.add(StrItem);
         MenuItems.add(MenuI);
         HotKeyItems.add(HotItemI);
         Caption:=MenuI;
         Tag:=i;
         OnClick:=DoAction;
       end;
       inc(i);
     end;
  end;
  If MyList.Count>0 then
  CurrNr:=0 else CurrNr:=-1;
  UpdateDisplay;
end;

procedure TWienieMacro.TaskIcon1RightClick(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  PopupMenu1.popup(x,y);
end;

procedure TWienieMacro.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  SaveToFile(ChangeFileExt(paramstr(0),'.ini'));
  MyList.free;
  MenuItems.Free;
  HotKeyItems.Free;
  {get rid of hook and library}
  UnhookWindowsHookEx(Hook);
  FreeLibrary(DllInstance);
end;

procedure TWienieMacro.Exit1Click(Sender: TObject);
begin
  Close
end;

procedure TWienieMacro.Hide1Click(Sender: TObject);
begin
  Visible:=false;
end;

procedure TWienieMacro.Show1Click(Sender: TObject);
begin
  Visible:=true;
end;

procedure TWienieMacro.LeftClick(Sender: TObject);
begin
  SaveDisplay;
  if CurrNr>0 then dec(CurrNr);
  UpdateDisPlay;
end;

procedure TWienieMacro.RightClick(Sender: TObject);
begin
  SaveDisplay;
  if Currnr<MyList.Count-1 then inc(CurrNr);
  UpdateDisPlay;
end;

procedure TWienieMacro.FastRightClick(Sender: TObject);
begin
  SaveDisplay;
  if MyList.Count>0 then CurrNr:=MyList.Count-1;
  UpdateDisPlay;
end;

procedure TWienieMacro.AddClick(Sender: TObject);
begin
  SaveDisplay;
  MyList.Add(TStringlist.create);
  MenuItems.Add('&New');
  HotKeyItems.Add(' ');
  CurrNr:=MyList.Count-1;
  UpdateDisplay;
end;

procedure TWienieMacro.SaveDisplay;
{Save Items, and add them to the PopupMenu}
var i:integer;
    hs:TStringList;
begin
  if CurrNr>=0 then
  begin
    hs:=TStringList(MyList[currnr]);
    with hs do
    begin
      clear;
      for i:=0 to Memo1.Lines.Count-1 do
      add(Memo1.Lines[i]);
      MenuItems[CurrNr]:=MenuEdit.text;
      HotKeyItems[CurrNr]:=HotKeyEdit.text;
    end;
  end;
end;

procedure TWienieMacro.DelClick(Sender: TObject);
begin
  if currnr>=0 then
  begin
    MyList.Delete(CurrNr);
    MenuItems.Delete(CurrNr);
    HotKeyItems.Delete(CurrNr);
    if Currnr=Mylist.Count then dec(CurrNr);
    UpdateDisplay;
  end;
end;

procedure TWienieMacro.Help2Click(Sender: TObject);
begin
  HelpBox.Filename:=changefileext(paramstr(0),'.TXT');
  HelpBox.ShowModal;
end;

procedure TWienieMacro.Reload1Click(Sender: TObject);
begin
  ReadIni(ChangeFileExt(paramstr(0),'.ini'));
end;

procedure TWienieMacro.Apply1Click(Sender: TObject);
begin
  SaveToFile(ChangeFileExt(paramstr(0),'.ini'));
  ReadIni(ChangeFileExt(paramstr(0),'.ini'));
end;

procedure TWienieMacro.Open1Click(Sender: TObject);
begin
  with OpenDialog1 do
  if Execute then
  ReadIni(ChangeFileExt(filename,'.ini'));
end;

procedure TWienieMacro.SaveToFile(s:string);
var IniFile : tIniFile;
    i,j:integer;
    hs:TStringList;
begin
  SaveDisplay;
  IniFile := tIniFile.Create(s);
  IniFile.EraseSection('Default');
  for i:=0 to MyList.Count-1 do
  begin
    IniFile.WriteString('Default', 'Caption'+xstr(i,1) , MenuItems[i]);
    IniFile.WriteString('Default', 'HotKey'+xstr(i,1) , HotKeyItems[i]);
    hs:=TStringList(MyList[i]);
    for j:=0 to hs.count-1 do
    begin
      IniFile.WriteString('Default', 'L'+xstr(i,1)+'-'+xstr(j,1) , hs[j]);
    end;
  end;
  IniFile.free;
end;

procedure TWienieMacro.SaveAs1Click(Sender: TObject);
begin
  with SaveDialog1 do
  if Execute then
  SaveToFile(ChangeFileExt(filename,'.ini'));
end;

procedure TWienieMacro.About1Click(Sender: TObject);
begin
  AboutBox.ShowModal;
end;

procedure TWienieMacro.TaskIcon1LeftClick(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  PopupMenu1.popup(x,y);
end;

procedure TWienieMacro.Timer1Timer(Sender: TObject);
begin
    Timer1.enabled:=false;
    DllInstance:=LoadLibrary('SNOOPDLL');
    HookProc:=GetProcAddress(DllInstance,'HookProcedure');
    Hook:=SetWindowsHookEx(WH_KEYBOARD,HookProc,DllInstance,0);
end;

procedure TWienieMacro.wmHandleMessages(var Msg:TMsg;var Handled:Boolean);
var i:integer;
    ch:char;
    w:word;
begin
{  if Msg.Message=WM_MyKeyboard then}
  if (Msg.Message=WM_COMMAND) and (msg.wparam>WM_MyKeyboard) then
  begin
    with Msg do
    begin
      wparam:=wparam-WM_MyKeyboard;
      if ProcessActive then exit;
      w:=HiWord(lParam);
      {does anyone know a more elegant way to get the down-state of
       the CTRL-key? I used getkeystate, but it did not work!}
      if ((msg.wparam=17)) and ((w and KF_UP) = 0) then
      ControlKey:=true;
      ch:=upcase(chr(msg.wparam));
      if controlkey and (msg.wparam<>17) and ((w and KF_UP) <> 0)
         and ((w and KF_ALTDOWN) <> 0)then
      begin
        ControlKey:=false;
        for i:=0 to HotKeyItems.count-1 do
        if length(HotKeyItems[i])>0 then
        if uppercase(HotKeyItems[i][1])=ch then
              begin
                Myaction2(i);
            end;
        end;
      end;
  end
end;

procedure TWienieMacro.WaitTimerTimer(Sender: TObject);
begin
  WaitTimer.enabled:=false;
end;

end.
