//*********************************************************************************
//*                                                                               *
//*  Unit Description : The Vqf Api                                               *
//*                                                                               *
//*  Author/Developer : Richard de Jong                                           *
//*                                                                               *
//*  Copyright (c) Richard de Jong                                                *
//*  All Rights reserved.                                                         *
//*                                                                               *
//*  24-7-99 0:59:08                                                              *
//*                                                                               *
//*  This units implements the vqf decoder                                        *
//*  functions.                                                                   *
//*                                                                               *
//*  it uses the vqf.dll suplied with the                                         *
//*  package, you don`t need any other                                            *
//*  files than vqf.dll, twinvq2.cdb and                                          *
//*  this unit.                                                                   *
//*  (decode32.dll is not used and not                                            *
//*  required)                                                                    *
//*                                                                               *
//*  if the vqf.dll doesn`t exist then the                                        *
//*  application can still continue, the                                          *
//*  unit will display a message and                                              *
//*  continue, the methods will do nothing                                        *
//*  if this is the case.                                                         *
//*                                                                               *
//*********************************************************************************
unit Vqf;

interface

uses forms, dialogs, windows;

var
VqfLoaded:Bool;
VqfHandle:Integer;
BB:Pchar;
Ww:String;

const
q = '\vqf.dll';
qq = '\twinvq2.cdb';

// The get info record
type VqfInfo = record
HWND:integer;
filename:LPSTR;
pReserved1:PBYTE;
dwSamplerate:DWORD;
nChannels:byte;
nBitrate:integer;
strSongname:LPSTR;
strComment:LPSTR;
dwReserved2:DWORD;
dwTotalSeconds:DWORD;
dwTotalFrames:DWORD;
strFilename2:LPSTR;
pReserved3:PBYTE;
pReserved4:PBYTE;
bPermissionToSave:BOOL;
strOriginalFile:LPSTR;
pReserved5:PBYTE;
strCopyright:LPSTR;
strAuthor:LPSTR;
dwReserved3:DWORD;
pReserved6:PBYTE;
pReserved7:PBYTE;
pReserved8:PBYTE;
pReserved9:PBYTE;
end;

// Main Play record

type vqfstruc = record
HWND:integer;
filename:LPSTR;
d1:integer;
c:array[0..7] of integer;
filename2:LPSTR;
end;

type PVqfStruc = ^vqfstruc;
type PVqfInfo = ^Vqfinfo;

// Simple procedures

procedure PlayVqfFileApi(Filename:String;Handle:integer);
procedure DllDecoderPause;
procedure DllDecoderRestart;

{
   DllDecoderGetIframe will return the current frame
   this integer will be zero if stopped and nonzero
   if playing

}

function DllDecoderGetIframe:integer;cdecl;

//Normalized call`s
function VqfPlaying:Bool;
function PlayVqf(Filename:string;WindowHandle:integer):string;
function TitleVqf(FileN:string):string;
function GetFileInfoVqf(filename:string):vqfinfo;

// These time functions uses the DlldecoderGetIframe
{

 Sample Result of CurrentTime: 00:11 or 01:59
 you don`t need to do anything!! Just call the
 function with the current playing FileName
 andthen you have the time.

}


function CurrentSecond(filename:string):Integer;
function CurrentTime(Filename:string):String;
function MaxTime(FileName:string):string;

procedure StopVqf;



implementation

uses sysutils;

// Checks if vqf.dll is playing

function VqfPlaying:Bool;
begin
if DllDecoderGetIFrame = 0 then Result := False else Result := True;
end;

procedure DllDecoderRestart;
var
A:procedure;
begin
if vqfloaded = false then exit;
@A := GetProcAddress(VqfHandle, 'DllDecoderRestart');
if @A <> nil then
 begin
  A;
 end;
end;

procedure DllDecoderPause;
var
A:procedure;
begin
if vqfloaded = false then exit;
@A := GetProcAddress(VqfHandle, 'DllDecoderPause');
if @A <> nil then
 begin
  A;
 end;
end;

procedure DllDecoderStart(vqfstruc:pvqfstruc);cdecl;
var
A:procedure(v:pvqfstruc);cdecl;
begin
if vqfloaded = false then exit;
@A := GetProcAddress(VqfHandle, 'DllDecoderStart');
if @A <> nil then
 begin
  A(Vqfstruc);
 end;
end;

procedure DllDecoderGetInfo(var vqfinfo:Pvqfinfo);cdecl;
var
A:procedure(v:Pvqfinfo);cdecl;
begin
if vqfloaded = false then exit;
@A := GetProcAddress(VqfHandle, 'DllDecoderGetInfo');
if @A <> nil then
 begin
  A(Vqfinfo);
 end;
end;


function DllDecoderGetIframe:integer;cdecl;
var
A:Function:integer;cdecl;
begin
result := 0;
if vqfloaded = false then exit;
@A := GetProcAddress(VqfHandle, 'DllDecoderGetIframe');
if @A <> nil then
 begin
  result := A;
 end;
end;

procedure StopVqf;
var
A:procedure;
begin
if vqfloaded = false then exit;
@A := GetProcAddress(VqfHandle, 'DllDecoderStop');
if @A <> nil then
 begin
  A;
 end;
end;


function GetFileInfoVqf(filename:string):vqfinfo;
var
A:VqfInfo;
B:PVqfInfo;
begin
A.filename := pchar(filename);
A.HWND := 0;
B := @A;
DllDecoderGetInfo(B);
Result := B^;
end;

function CurrentSecond(filename:string):Integer;
var
A,B:extended;
C:String;
SS:vqfinfo;
totalframes,currentframe,totalseconds:integer;
begin
currentframe := DlldecodergetIframe;
SS := GetFileInfoVqf(filename);
totalframes := SS.dwTotalFrames;
totalseconds := SS.dwTotalSeconds;
A := currentframe/totalframes;
B := A * totalseconds;
C := format('%0.0f',[B]);
result := strtoint(C);
end;

function CurrentTime(Filename:string):String;
var
A,B,C:Integer;
SS,SSS:String;
begin
A := CurrentSecond(Filename);
B := A div 60;
C := A - (B * 60);
if b > 9 then SS := inttostr(b) else SS := '0' + inttostr(b);
if c > 9 then SSS := inttostr(c) else SSS := '0' + inttostr(c);
result := SS + ':' + SSS;
end;

function MaxTime(FileName:string):string;
var
A,B,C:Integer;
SS,SSS:String;
T:VqfInfo;
begin
T := GetFileInfoVqf(FileName);
A := T.dwTotalSeconds;
B := A div 60;
C := A - (B * 60);
if b > 9 then SS := inttostr(b) else SS := '0' + inttostr(b);
if c > 9 then SSS := inttostr(c) else SSS := '0' + inttostr(c);
result := SS + ':' + SSS;
end;

function TitleVqf(FileN:string):string;
var
N,A:String;
SS:vqfinfo;
begin;
SS := GetFileInfoVqf(FileN);
A := pchar(SS.strAuthor);
N := SS.strSongname;
result := A + ' - ' + N;
end;

procedure PlayVqfFileApi(Filename:String;Handle:integer);
var
A:vqfstruc;
B:Pvqfstruc;
begin
A.filename := Pchar(Filename);
A.filename2 := Pchar(Filename);
A.HWND := Handle;
// don`t know what these values are for
A.d1 := 1;
A.c[0] := 0;

B := @A;
DllDecoderStart(B);
end;

function PlayVqf(Filename:string;WindowHandle:integer):string;
begin
result := TitleVqf(FileName);
PlayVqfFileApi(Filename,WindowHandle);
end;

// This takes care of initialization of the vqf.dll

initialization
StrNew(BB);
BB := StrAlloc(255);
GetSystemDirectory(BB,255);
WW := BB;
if (fileexists(ww + q)) and (fileexists(ww + qq)) then
begin
VqfHandle := LoadLibrary(pchar(ww + q));
if VqfHandle <> 0 then VqfLoaded := true else VqfLoaded := false;
end
else if MessageDlg('Warning! This Program requires the vqf decoder drivers.'+#13+#10+''+#13+#10+'vqf.dll and twinvq2.cdb need to be in the windows system dir.'+#13+#10+''+#13+#10+'You Can continue but the music will be disabled.', mtWarning, [mbIgnore, mbAbort], 0) = idAbort then Application.terminate;

finalization
if vqfloaded then FreeLibrary(VqfHandle);
vqfloaded := false;

end.
