unit VisioList;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ColorBtns;

type

  TVisioButton = class(TColor95Button)
  public
    Index : Integer;
    ImageTag : Integer;
    constructor Create(AnOwner: TComponent); override;
    destructor Destroy; override;
  end;

  TVisioList = class;

  TTabList = class(TCustomControl)
  private
    { Private declarations }
    FScrollBox : TScrollBox;
    FButtonList : TStringList;
    FButtonCapList : TStringList;
    FButtons : TStrings;
    FTitleButton : TColor95Button;
    FButtonImages : TImageList;
    FButtonWidth, FButtonHeight : integer;
    FSpace : integer;
    FTabHeight : integer;
    FCaption : string;
//    procedure AddNewButton
    procedure SetButtonList( Value : TStrings );
    procedure AddButton( btntitle : string );
    procedure SetTabHeight ( value : integer );
    procedure SetCaption( value : string );
    procedure SetButtonImages ( value : TImageList );
  protected
    { Protected declarations }
    procedure WMSize(var M: TWMSize); message wm_Size;
    procedure TitleClick( Sender : TObject );
    procedure ButtonClick( Sender : TObject );
  public
    { Public declarations }
    Index : integer;
    TabManager : TVisioList;
    PosDown : boolean;
    constructor Create(AnOwner: TComponent); override;
    destructor Destroy; override;
  published
    { Published declarations }
    property ButtonList : TStrings read FButtons write SetButtonList;
    property ButtonWidth : integer read FButtonWidth write FButtonWidth;
    property ButtonHeight : integer read FButtonHeight write FButtonHeight;
    property ButtonImages : TImageList read FButtonImages write SetButtonImages;
    property Space : integer read FSpace write FSpace;
    property TabHeight : integer read FTabHeight write SetTabHeight;
    property Caption : string read FCaption write SetCaption;
  end;

  TVisioButtonEvent = procedure (Sender: TObject; tabid, btnid: Integer) of object;
  TVisioList = class(TCustomControl)
  private
    { Private declarations }
    FOnVisioButton : TVisioButtonEvent;
    FTabHeight : Integer;
    FTabs : TStrings;
    procedure SetTabList( value : TStrings );
    procedure SetTabHeight( value : integer);
  protected
    { Protected declarations }
    procedure WMSize(var M: TWMSize); message wm_Size;
    procedure Paint; override;
  public
    { Public declarations }
    FTabList : TStringList;
    constructor Create(AnOwner: TComponent); override;
    destructor Destroy; override;
    procedure AddTabList(tabtitle: string);
    procedure AddVisioBtn(tabindex : integer; btntitle : string);
    procedure SetTabImages( tabindex : integer; images : TImageList);
    procedure ButtonClick(Sender :TObject; tabindex, btnindex : integer);
  published
    { Published declarations }
    property Align;
    property Color;
    property Font;
    property Tabs : TStrings read FTabs write SetTabList;
    property TabHeight : Integer read FTabHeight write SetTabHeight;
    property OnVisioButton : TVisioButtonEvent read FOnVisioButton write FOnVisioButton;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('VPP', [TVisioList]);
end;

{========== TVisioButton ==============}

constructor TVisioButton.Create(AnOwner: TComponent);
begin
  inherited;
end;

destructor TVisioButton.Destroy;
begin
  inherited;
end;

{========== TabList ==============}
constructor TTabList.Create(AnOwner: TComponent);
begin
  inherited;
  Width := 60;
  Height := 120;
  FScrollBox := TScrollBox.Create(self);
  FScrollBox.Parent := self;
  FScrollBox.BorderStyle := bsNone;
//  FScrollBox.AutoScroll := false;
  FScrollBox.VertScrollBar.Tracking := true;
  FButtonWidth := 52; FButtonHeight := 52;
  FSpace := 3;
  FTabHeight := 18;
  FScrollBox.Top := FTabHeight;FScrollBox.Left := 1;
  FScrollBox.Width := Width-1;
  FScrollBox.Height := Height-FTabHeight-1;
  PosDown := false;
  FButtonImages := TImageList.Create(self);
  FButtonList := TStringList.Create;
  FButtonCapList := TStringList.Create;
  FTitleButton := TColor95Button.Create(self);
  FTitleButton.Parent := self;
  FTitleButton.Color := clSilver;
  FTitleButton.Left := 1; FTitleButton.Top := 1;
  FTitleButton.Height := FTabHeight; FTitleButton.Width := Width-3;
  FTitleButton.OnClick := TitleClick;
end;

destructor TTabList.Destroy;
begin
  FButtonList.Free;
  FTitleButton.Free;
  FButtonCapList.Free;
  FScrollBox.Free;
//  FButtonImages.Free;
  inherited;
end;

procedure TTabList.SetTabHeight ( value : integer );
begin
  FTabHeight := value;
  FTitleButton.Height := FTabHeight;
end;

procedure TTabList.SetCaption( value : string );
begin
  FCaption := value;
  FTitleButton.Caption := FCaption;
end;

procedure TTabList.SetButtonList(Value : TStrings);
var
  i : integer;
  vbtn : TVisioButton;
begin
  FButtonList.Clear;
  for i := 0 to Value.Count-1 do begin
    vbtn := TVisioButton.Create(self);
    FButtonList.AddObject(Value[i], vbtn);
  end;
end;

procedure TTabList.SetButtonImages ( value : TImageList );
var
  i : integer;
  vbtn : TVisioButton;
begin
  FButtonImages.Assign(value);
  for i := 0 to FButtonList.Count-1 do begin
    vbtn := TVisioButton(FButtonList.Objects[i]);
    value.GetBitmap(i, vbtn.Glyph);
  end;
end;

procedure TTabList.AddButton( btntitle : string );
var
  vbtn : TVisioButton;
  vcap : TLabel;
  i, j : integer;
begin
  vbtn := TVisioButton.Create(self);
  vbtn.Parent := FScrollBox;
//  vbtn.Caption := btntitle;
  vbtn.Width := FButtonWidth - 16; vbtn.Height := FButtonHeight-20;
  vbtn.Index := FButtonList.Count;
  i := (Width-20) div FButtonWidth;
  j := vbtn.Index div i;
  vbtn.Top := j * (FButtonHeight + FSpace) + FSpace;
  vbtn.Left := (vbtn.Index mod i) * (FButtonWidth + FSpace) + FSpace+8;
  vbtn.Color := clBtnFace;
  vbtn.Layout := blGlyphTop;
  vbtn.Style := bsFlat;
  vbtn.Hint := btntitle;
  vbtn.ShowHint := true;
  vbtn.OnClick := ButtonClick;
  FButtonImages.GetBitmap(FButtonList.Count, vbtn.Glyph);
  FButtonList.AddObject(btntitle, vbtn);
  { For Button Caption }
  vcap := TLabel.Create(self);
  vcap.Parent := FScrollBox;
  vcap.Font.Color := clWhite;
  vcap.Width := FButtonWidth; vcap.Height := 20;
  i := (Width-20) div FButtonWidth;
  j := vbtn.Index div i;
  vcap.Top := j * (FButtonHeight + FSpace) + FSpace +FButtonHeight-20;
  vcap.Left := (vbtn.Index mod i) * (FButtonWidth + FSpace) + FSpace;
  vcap.AutoSize := false;
  vcap.Alignment := taCenter; 
  vcap.Caption := btntitle;
  FButtonCapList.AddObject(btntitle, vcap);
end;

procedure TTabList.WMSize(var M: TWMSize);
var
  i, j, k : integer;
  vbtn : TVisioButton;
  vcap : TLabel;
begin
  inherited;
  FTitleButton.Left := 1; FTitleButton.Top := 1;
  FTitleButton.Height := FTabHeight; FTitleButton.Width := Width-2;
  FScrollBox.Top := FTabHeight; FScrollBox.Left := 1;
  FScrollBox.Width := Width-2;
  FScrollBox.Height := Height-FTabHeight-2;
  i := (Width-10) div FButtonWidth;
  FScrollBox.VertScrollBar.Position := 0;
  for k := 0 to FButtonList.Count-1 do begin
    vbtn := TVisioButton(FButtonList.Objects[k]);
    vcap := TLabel(FButtonCapList.Objects[k]);
    j := vbtn.Index div i;
    vbtn.Top := j * (FButtonHeight + FSpace) + FSpace;
    vbtn.Left := (vbtn.Index mod i) * (FButtonWidth + FSpace) + FSpace+8;
    vcap.Top := j * (FButtonHeight + FSpace) + FSpace +FButtonHeight-20;
    vcap.Left := (vbtn.Index mod i) * (FButtonWidth + FSpace) + FSpace;
  end;
end;

procedure TTabList.TitleClick( Sender : TObject );
var
  vtab : TTabList;
  i, j : integer;
begin
  if PosDown then begin
    with TabManager do begin
      j := 0;
      for i := 0 to Index do begin
        vtab := TTabList(FTabList.Objects[i]);
        vtab.FScrollBox.Visible := false;
        if vtab.PosDown then begin
          vtab.Top := j*(TabHeight)+1;
          vtab.PosDown := false;
        end;
        j := j + 1;
      end;
    end;
    FScrollBox.Visible := true;
  end
  else begin
    with TabManager do begin
      j := 1;
      for i := TabManager.FTabList.Count-1 downto Index+1 do begin
        vtab := TTabList(FTabList.Objects[i]);
        vtab.Top := TabManager.Height-j*TabHeight-1;
        vtab.FScrollBox.Visible := false;
        vtab.PosDown := true;
        j := j + 1;
      end;
    end;
    FScrollBox.Visible := true;
  end;
end;

procedure TTabList.ButtonClick( Sender : TObject );
var
  vbtn : TVisioButton;
begin
  vbtn := TVisioButton(Sender);
  TabManager.ButtonClick( self, Index, vbtn.Index );
end;

{========== TVisioList ==============}
constructor TVisioList.Create(AnOwner: TComponent);
begin
  inherited;
  Width := 140+20;
  Height := 260;
  FTabHeight := 14;
  Color := clGray;
//  FTabs := TStrings.Create;
  FTabList := TStringList.Create;
end;

destructor TVisioList.Destroy;
begin
  //Tabs.Free;
  FTabList.Free;
  inherited;
end;

procedure TVisioList.WMSize(var M: TWMSize);
var
  vtab : TTabList;
  i : integer;
begin
  inherited;
  for i := 0 to FTabList.Count-1 do begin
    vtab := TTabList(FTabList.Objects[i]);
    vtab.Width := Width-2;
    vtab.Height := Height-(FTabList.Count-1)*TabHeight+1;
    if vtab.PosDown then begin
      vtab.Top := Height-(FTablist.Count-i)*TabHeight-1;
    end;
  end;
end;

procedure TVisioList.Paint;
begin
  inherited;
  with Canvas do begin
    Pen.Style := psSolid;
    Pen.Color := clGray;
    Pen.Width := 1;
    MoveTo(0, 0); LineTo(Width-1, 0);
    MoveTo(0, 0); LineTo(0, Height-1);
    Pen.Color :=  clWhite;
    MoveTo(Width-1, 0); LineTo(Width-1, Height-1);
    LineTo(0, Height-1);
  end;
end;

procedure TVisioList.SetTabList( value : TStrings );
var
  i : integer;
  vtab : TTabList;
begin
//  FTabs.Assign(value);
  FTabList.Clear;
  for i := 0 to FTabs.Count-1 do begin
    vtab := TTabList.Create(self);
    FTabList.AddObject(Value[i], vtab);
  end;
end;

procedure TVisioList.SetTabHeight( value : integer);
var
  i : integer;
  vtab : TTabList;
begin
  FTabHeight := value;
  for i := 0 to FTabList.Count-1 do begin
    vtab := TTabList(FTabList.Objects[i]);
    vtab.Top := i * FTabHeight + 1;
    vtab.TabHeight := FTabHeight;
  end;
end;

procedure TVisioList.SetTabImages( tabindex : integer; images : TImageList);
var
  vtab : TTabList;
begin
  vtab := TTabList(FTabList.Objects[tabindex]);
  vtab.ButtonImages := Images;
end;

procedure TVisioList.AddTabList(tabtitle: string);
var
  i,j : integer;
  vtab : TTabList;
begin
//  FTabs.Add(tabtitle);
  vtab := TTabList.Create(self);
  vtab.Parent := self;
  vtab.Caption := tabtitle;
  i := FTabList.Count;
  vtab.Left := 1; vtab.Top := i * FTabHeight+1;
  vtab.Width := Width-2; vtab.Height := Height-2-i*(TabHeight+1);
  vtab.TabHeight := FTabHeight;
  vtab.Color := clGray;
  vtab.Index := FTabList.Count;
  vtab.TabManager := self;
  FTabList.AddObject(tabtitle, vtab);
  for j := 0 to FTabList.Count-1 do begin
    vtab := TTabList(FTabList.Objects[j]);
    vtab.Height := Height-2-i*(TabHeight+1);
  end;
end;

procedure TVisioList.AddVisioBtn(tabindex : integer; btntitle : string);
var
  tab : TTabList;
begin
  tab := TTabList(FTabList.Objects[tabindex]);
  tab.AddButton(btntitle);
end;

procedure TVisioList.ButtonClick(Sender: TObject; tabindex, btnindex : integer);
begin
  if Assigned(FOnVisioButton) then begin
    OnVisioButton(Sender, tabindex, btnindex);
  end;
end;

end.
