{-----------------------------------------------}
{----Purpose : Demo of how to use the microsoft }
{              scripting host activex control   }
{                                               }
{              It will enable you to            }
{              incorporate both VBscript and    }
{              Jscript interpreters into Delphi }
{              applications. And make Delphi    }
{              properties/procedures available  }
{              inside scripts through an        }
{              embedded automation object.      }
{                                               }
{              Other 3rd party scripting        }
{              engines may also work (like      }
{              perl and python).                }
{                                               }
{    Version : 0.95                             }
{    By      : Ir. G.W. van der Vegt            }
{    E-mail  : wvd_vegt@knoware.nl              }
{-----------------------------------------------}
{ ddmmyy   comment                              }
{ -------- ------------------------------------ }
{ 03041998-Initial version.                     }
{ 04041998-Figured out how to pass the          }
{          parameters with the run command.     }
{ 14071998-Added some more sample code.         }
{         -Added some inline documentation.     }
{         -Added error handling.                }
{ 15071998-Finally figured out how to interface }
{          Delphi properties etc into the       }
{          script control with help of an       }
{          automation server in the same exe.   }
{         -Added code to quickly check the      }
{          installation of script control and   }
{          internal automation control.         }
{-----------------------------------------------}
{ todo                                          }
{ 1. Some JScript demo.                         }
{-----------------------------------------------}
{ howto                                         }
{                                               }
{ If not already installed, download the        }
{ script control 1.0 from microsoft             }
{ (http://www.microsoft.com/scripting           }
{ and install (component, import activeX        }
{ it into delphi. Then run this demo.           }
{                                               }
{ The supplied MSScriptControl_TLB.pas file     }
{ is different from most others i've seen,      }
{ although reneratedwith a couple of delphi     }
{ versions i've got (all from the 3.x CS        }
{ series).                                      }
{                                               }
{ The difference is that my TLB file contains   }
{ more interface code and didn't replace some   }
{ psafearrays by olevariants (especially in     }
{ the run commands).                            }
{                                               }
{ To get this sample working, either use the    }
{ supplied TLB file or rewrite the run          }
{ releated samples.                             }
{                                               }
{ I created the Internal Ole Automation Server  }
{ by simply selecting it from the File|New      }
{ wizard and designing it's interface in the    }
{ typelib editor.                               }
{                                               }
{ I didn't import the activeX component into    }
{ the project, it's simply there. You can change}
{ the interface with View|Type Library. Don't   }
{ forget to press CTRL-S to save changes.       }
{                                               }
{ Then I filled in the procedures with some     }
{ sample code that shows how Delphi and the     }
{ script control can interact.                  }
{                                               }
{ The intercafes generated by the TLB editor    }
{ seem to vary wildly. I can't yet get a grip   }
{ on it, but they sure seem to work. Beware     }
{ that the interface section of unit1 is        }
{ managed by the TLB editor, so don't make any  }
{ manual changes. I found that if the editor    }
{ is out of sync, deleting the protected class  }
{ members and saving the tlb file from the      }
{ editor resync them correctly.                 }
{                                               }
{ To enabled the OleServer code, you must       }
{ Run the application once with a /regserver    }
{ commandline                                   }
{ This will generate the following keys in      }
{ registry :                                    }
{   HKEY_CLASSES_ROOT\Scripting.JbiApplication  }
{ and a corresponding key with the CLSID under  }
{   HKEY_CLASSES_ROOT\CLSID                     }
{-----------------------------------------------}

unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, OleCtrls, ActiveX, MSScriptControl_TLB, ComObj, ComCtrls;

type
  TVBA = class(TForm)
    ScriptControl1: TScriptControl;
    Button1: TButton;
    Memo1: TMemo;
    UpDown1: TUpDown;
    procedure Button1Click(Sender: TObject);
    procedure ScriptControl1Error(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  VBA: TVBA;

implementation

{$R *.DFM}

uses
  Registry,Unit1;

const
  crlf =^M^J;
  quote=#039;

{----Make an parameter array needed for scriptcontrol.run}

function MakeParmsArray(Parms : array of OLEvariant): PSafeArray;
var
   rgsabound : array[0..0] of TSafeArrayBound;
   i         : integer;
begin
  rgsabound[0].lLbound   := Low(Parms);
  rgsabound[0].cElements := High(Parms) - Low(Parms) + 1;
  result := SafeArrayCreate(VT_VARIANT, 1, rgsabound);
  for i := 0 to High(Parms) do
    if SafeArrayPutElement(result, i, Parms[i]) <> S_OK then
       raise Exception.Create('Error creating OLE parameter array');
end;

{----Make an empty parameter array needed for scriptcontrol.run sometimes}

function MakeEmptyParmsArray: PSafeArray;
var
   rgsabound : array[0..0] of TSafeArrayBound;
begin
  rgsabound[0].lLbound   := 0;
  rgsabound[0].cElements := 0;
  result := SafeArrayCreate(VT_VARIANT, 1, rgsabound);
end;

{----The samples}

procedure TVBA.Button1Click(Sender: TObject);
var
  psarray    : PSafeArray;
  retval     : OleVariant;
  i          : Integer;
begin

{------------------------------------------------------------}
{----Show interaction between this application and the       }
{    script control on script level.                         }
{------------------------------------------------------------}

{----Add a subroutine with 2 parameters and call it}
  ScriptControl1.AddCode(
      'Sub Hello(x,y)'+crlf+
        'MsgBox x & " - " & y & ", Hello from the VBA scripting world"'+crlf+
      'End Sub'+crlf
  );

{----Use ExecuteStatement to run it as a statement}
  ScriptControl1.ExecuteStatement('Call Hello(5,10)');

{----Build a paramenter list for the run command (it must exactly match the declaration)}
  psArray:=MakeParmsArray(['10',20]);

{----Then run the procedure}
  ScriptControl1.Run('Hello',psArray);

{----Execute a statement directly (and define & set a variable)}
  ScriptControl1.ExecuteStatement('x = 100');

{----And use this variable to Test the Evaluate function}
  retval:=ScriptControl1.Eval('x = 100');       //will return true ;-)
  retval:=ScriptControl1.Eval('x');             //will return 100
  retval:=ScriptControl1.Eval('x = 100/2');     //will return false

{----Combine some of the above...}
  ScriptControl1.ExecuteStatement('call Hello(x,x/2)');

{----Add some more complex code (a vbs sample from ms),
     works under windows NT4}
(*
  ScriptControl1.AddCode(
      'Sub DumpIt'+crlf+
        'Dim adsNS'+crlf+
        'Dim sLF'+crlf+
        'Dim sMsg'+crlf+
        ''+crlf+
        'sLF = Chr(13)'+crlf+
        'sMsg = ""'+crlf+
        ''+crlf+
        'Set adsNS = GetObject("ADS:")'+crlf+
        ''+crlf+
        'For Each obj in adsNS'+crlf+
          'sMsg = sMsg & obj.Name & sLF'+crlf+
        'Next'+crlf+
        ''+crlf+
        'MsgBox sMsg'+crlf+
      'End Sub'+crlf
);
  ScriptControl1.ExecuteStatement('Call DumpIt');
*)

{----Use run to execute a subroutine without parameters}
  ScriptControl1.AddCode(
      'Sub Main'+crlf+
        'MsgBox "Hello from the VBA scripting world"'+crlf+
      'End Sub'+crlf
  );
  psArray:=MakeEmptyParmsArray();
  ScriptControl1.Run('Main',psArray);

{----List Procedures in scriptcontrol}
  for i:=1 to ScriptControl1.Procedures.Count do
    With ScriptControl1.Procedures.Item[i] do
      Application.MessageBox(Pchar(Format('Name=%s'+crlf+
                                          'NumArgs=%d'+crlf+
                                          'HasReturnValue=%d',
                                          [AnsiString(Name),NumArgs,Ord(HasReturnValue)])),
                             'Procedures',MB_OK);

{----Execute code entered in a memo field.
     Make a typo in the memo to test the error handling code}
  ScriptControl1.AddCode(Memo1.Text+crlf);
  psArray:=MakeEmptyParmsArray();
  ScriptControl1.Run('MemoSub',psArray);

{----Show the Script controls AboutBox}
  ScriptControl1._Aboutbox;

{------------------------------------------------------------}
{----Interaction between the script and a automation server  }
{    in this exe file.                                       }
{------------------------------------------------------------}

{----This will Put a text into the memofield}
  ScriptControl1.ExecuteStatement('Jbi.aProcedure("Hello through a Delphi based aProcedure")');

{----Retrieve Value of UpDown Control}
  Application.MessageBox(Pchar(Format('UpDownControl Value=%d',[Integer(ScriptControl1.Eval('Jbi.UpDown'))])),'Script',MB_OK);     //will return UpDown1

{----Set the y position of the mainform}
  ScriptControl1.ExecuteStatement('Jbi.theTop=25');
{----And retrieve & Show it}
  Application.MessageBox(Pchar(Format('Form.Top Value=%d',[Integer(ScriptControl1.Eval('Jbi.theTop'))])),'Script',MB_OK);     //will return Vba.Top

{----Call a procedure that sets the mainforms left position}
  ScriptControl1.ExecuteStatement('Jbi.OnKeyPress(50)');
end;

{----The error handler that shows type, linenumber and characternumber of the error}

procedure TVBA.ScriptControl1Error(Sender: TObject);
begin
   With ScriptControl1.IScriptControl_Error Do
     Application.MessageBox(Pchar(Format('%s:'+crlf+crlf+quote+'%s'+quote+crlf+crlf+'at line:%d, char:%d'+crlf+crlf+'%s',[Get_Source,Get_Description,Get_Line,Get_Column,Get_HelpFile])),'Error',MB_OK);
end;

procedure TVBA.FormCreate(Sender: TObject);
Var
  reg : TRegistry;
begin
{-----Initialize scriptcontrol}
  ScriptControl1.Reset;
  ScriptControl1.Language:='VBScript';
  ScriptControl1.SitehWnd:=Handle;

{----Quick check if we ran with /regserver cmdline before} 
  reg:=TRegistry.Create;
  reg.Rootkey:=HKEY_CLASSES_ROOT;

  if not reg.KeyExists('ScriptControl\CLSID')
    then
      begin
        Application.MessageBox('Script control not found in registry, please check its installation.','Error',MB_OK or MB_ICONSTOP);
        Button1.Enabled:=False;
      end;

  if reg.KeyExists('Scripting.JbiApplication\CLSID')
    then ScriptControl1.AddObject('Jbi',CreateOleObject('Scripting.JbiApplication'),TRUE)
    else
      begin
        Application.MessageBox('Please run this exe with a cmdline of /regserver first','Error',MB_OK or MB_ICONSTOP);
        Button1.Enabled:=False;
      end;
end;

procedure TVBA.FormDestroy(Sender: TObject);
begin
{-----Reset scriptcontrol to be sure (and clear all objects put into it too)}
  ScriptControl1.Reset;
end;

end.


