unit Scripting_TLB;

{ This file contains pascal declarations imported from a type library.
  This file will be written during each import or refresh of the type
  library editor.  Changes to this file will be discarded during the
  refresh process. }

{ Scripting Library }
{ Version 1.0 }

interface

uses Windows, ActiveX, Classes, Graphics, OleCtrls, StdVCL;

const
  LIBID_Scripting: TGUID = '{DD1B4DA8-1BCF-11D2-9B87-444553540000}';

const

{ Component class GUIDs }
  Class_JbiApplication: TGUID = '{DD1B4DAA-1BCF-11D2-9B87-444553540000}';

type

{ Forward declarations: Interfaces }
  IJbiApplication = interface;
  IJbiApplicationDisp = dispinterface;

{ Forward declarations: CoClasses }
  JbiApplication = IJbiApplication;

{ Dispatch interface for JbiApplication Object }

  IJbiApplication = interface(IDispatch)
    ['{DD1B4DA9-1BCF-11D2-9B87-444553540000}']
    function Get_UpDown: Integer; safecall;
    procedure Set_UpDown(Value: Integer); safecall;
    procedure aProcedure(const s: WideString); safecall;
    procedure OnKeyPress(var Key: Byte); safecall;
    function Get_theTop: Integer; safecall;
    procedure Set_theTop(Value: Integer); safecall;
    property UpDown: Integer read Get_UpDown write Set_UpDown;
    property theTop: Integer read Get_theTop write Set_theTop;
  end;

{ DispInterface declaration for Dual Interface IJbiApplication }

  IJbiApplicationDisp = dispinterface
    ['{DD1B4DA9-1BCF-11D2-9B87-444553540000}']
    property UpDown: Integer dispid 1;
    procedure aProcedure(const s: WideString); dispid 2;
    procedure OnKeyPress(var Key: Byte); dispid 3;
    property theTop: Integer dispid 4;
  end;

{ JbiApplicationObject }

  CoJbiApplication = class
    class function Create: IJbiApplication;
    class function CreateRemote(const MachineName: string): IJbiApplication;
  end;



implementation

uses ComObj;

class function CoJbiApplication.Create: IJbiApplication;
begin
  Result := CreateComObject(Class_JbiApplication) as IJbiApplication;
end;

class function CoJbiApplication.CreateRemote(const MachineName: string): IJbiApplication;
begin
  Result := CreateRemoteComObject(MachineName, Class_JbiApplication) as IJbiApplication;
end;


end.
