{-----------------------------------------------}
{----Purpose : Demo of how to use the microsoft }
{              scripting host activex control   }
{              It will enable you to incorporate}
{              both VBscript and Jscript        }
{              interpreters into Delphi         }
{              applications.                    }
{    By      : Ir. G.W. van der Vegt            }
{    E-mail  : wvd_vegt@knoware.nl              }
{-----------------------------------------------}
{ ddmmyy comment                                }
{ ------ -------------------------------------- }
{ 030498-Initial version                        }
{ 040498-Figured out how to pass the parameters }
{        with the run command.                  }
{-----------------------------------------------}
{ todo                                          }
{ 1. Some JScript demo.                         }
{-----------------------------------------------}
{ howto                                         }
{                                               } 
{ If not already installed, download the        }
{ script control 1.0 from microsoft             }
{ (http://www.microsoft.com/scripting           }
{ and install (component, import activeX        }
{ it into delphi. Then run this demo.           }
{-----------------------------------------------}

unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, OleCtrls, ActiveX, MSScriptControl_TLB;

type
  TVBA = class(TForm)
    ScriptControl1: TScriptControl;
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  VBA: TVBA;

implementation

{$R *.DFM}

procedure TVBA.Button1Click(Sender: TObject);
const
  crlf = ^M^J;

var
  psarray    : PSafeArray;
  retval     : OleVariant;
  cDims,
  ndx        : Integer;
  rgsabound  : array[0..0] of TSafeArrayBound;
  tmp        : variant;
  
begin
//Add a subroutine....
  ScriptControl1.AddCode(

'Sub Hello(x,y)'+crlf+
  'MsgBox x & " - " & y & ", Hello from the VBA scripting world"'+crlf+
'End Sub'+crlf

  );
//Execute it as a statement
  ScriptControl1.ExecuteStatement('Call Hello(5,10)');

//Build a paramenter list for the run command (it must exactly match the declaration)
  rgsabound[0].lLbound   := 0; //low bound is 0
  rgsabound[0].cElements := 2; //2 elements in this dimension
  cDims:=1;                    //only 1 dimension (a vector)
  psarray:=SafeArrayCreate(VT_VARIANT, cDims, rgsabound); //vector[0..1] 
  for ndx:=0 to 1 do
    begin
      tmp  :=100+ndx;
      if SafeArrayPutElement(psarray, ndx, tmp)<>S_OK
       then MessageBeep(1);
    end;
//Then run the procedure...
  ScriptControl1.Run('Hello',psarray);

//Execute a statement directly (and define & set a variable)
  ScriptControl1.ExecuteStatement('x = 100');

//And use this variable to Test the Evaluate function
  retval:=ScriptControl1.Eval('x = 100');       //will return true ;-)
  retval:=ScriptControl1.Eval('x');             //will return 100
  retval:=ScriptControl1.Eval('x = 100/2');     //will return false

//Combine some of the above...
  ScriptControl1.ExecuteStatement('call Hello(x,x/2)');

//Add some more complex code
  ScriptControl1.AddCode(

'Sub DumpIt'+crlf+
  'Dim WshShell'+crlf+
  'Dim adsNS'+crlf+
  'Dim sLF'+crlf+
  'Dim sMsg'+crlf+
  ''+crlf+
  'sLF = Chr(13)'+crlf+
  'sMsg = ""'+crlf+
  ''+crlf+
  'Set adsNS = GetObject("ADS:")'+crlf+
  ''+crlf+
  'For Each obj in adsNS'+crlf+
  '        sMsg = sMsg & obj.Name & sLF'+crlf+
  'Next'+crlf+
  ''+crlf+
  ''+crlf+
  'WScript.Echo sMsg'+crlf+
'End Sub'+crlf
);
//Above script won't run anyway. Try Different Namespace Object instead of ADS!!
//ScriptControl1.ExecuteStatement('Call DumpIt');
end;

end.
