{
ZWECK       : Konvertierung geografischer Koordinaten :
              Lngengrad / Breitengrad nach UTM und umgekehrt
              Demo der Unit UTMLaLo

DATEIEN     : TestUTMLaLo.pas
              TestUTMLaLo_MainForm.pas
              TestUTMLaLo_MainForm.dfm

NDERUNGEN  : V1.0 Nov.98

AUTOR       : Kurt Spitzley, email Kurt.Spitzley@rz-online.de oder
                                   101.10490@germanynet.de

================================================================================

SCOPE       : Conversion of geographical positions:
              Longitude / Latitude to Universal Transverse Mercator (UTM)
              and vice versa
              Demo of unit UTMLaLo

FILES       : TestUTMLaLo.pas
              TestUTMLaLo_MainForm.pas
              TestUTMLaLo_MainForm.dfm

LAST CHANGES: V1.0 Nov.98

AUTHOR      : Kurt Spitzley, email Kurt.Spitzley@rz-online.de or
                                   101.10490@germanynet.de
}

unit TestUtmLaLo_MainForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Console,
  UtmLaLo, Mask, Buttons;

type
  TForm1 = class(TForm)
    Memo: TMemo;
    procedure FormShow(Sender: TObject);
  private
  public
    { Public-Deklarationen}
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormShow(Sender: TObject);
var
//  w:TMapDatum;
  UTMLaLo: TUTMLaLo;
  RealLat,
  RealLong,
  UTMNorthing,
  UTMEasting: Extended;
  UTMZone: byte;
  UTMZoneLetter: char;
  RefEllipsoid: TMapDatum;
  Lat,
  Long: TDegMinSec;
  UTMPoint: TUTMPoint;
  LaLoPoint: TLaLoPoint;
  RealLaLoPoint: TRealLaLoPoint;
begin
  RefEllipsoid := WGS84;
  Memo.Lines.Add('Reference Ellipsoid: '+Ellipsoid[WGS84].Name);
  Memo.Lines.Add('');

  // example geo-position to convert

  Lat.Degrees := 50;
  Lat.Minutes := 22;
  Lat.Seconds := 19.12345;
  Long.Degrees := 7;
  Long.Minutes := 16;
  Long.Seconds := 15.12345;

  //----------------------------------------------------------------------------

  Memo.Lines.Add('Test of DegMinSec2Extended and Extended2DegMinSec');
  Memo.Lines.Add(format('In: %d %d'' %2.3f"',
                 [Lat.Degrees,Lat.Minutes,Lat.Seconds]));
  RealLat:= DegMinSec2Extended(Lat);
  Lat:=Extended2DegMinSec(RealLat);
  Memo.Lines.Add(format('Out: %8.8f',[RealLat]));
  Memo.Lines.Add(format('Reconverted to Deg/Min/Sec: %d %d'' %2.3f"',
                 [Lat.Degrees,Lat.Minutes,Lat.Seconds]));
  Memo.Lines.Add(format('In: %d %d'' %2.3f"',
                 [Long.Degrees,Long.Minutes,Long.Seconds]));

  RealLong:= DegMinSec2Extended(Long);
  Long:=Extended2DegMinSec(RealLong);
  Memo.Lines.Add(format('Out: %8.8f',[RealLong]));
  Memo.Lines.Add(format('Reconverted to Deg/Min/Sec: %d %d'' %2.3f"',
                 [Long.Degrees,Long.Minutes,Long.Seconds]));
  Memo.Lines.Add('');

  //----------------------------------------------------------------------------

  Memo.Lines.Add('Test of RealLaLoToUTM and UTMtoRealLaLo');
  Memo.Lines.Add(format('In: Real Lat/Long: %8.3f %8.3f',[RealLat,RealLong]));
  RealLaLoToUTM(RefEllipsoid, RealLat, RealLong, UTMNorthing, UTMEasting, UTMZone, UTMZoneLetter);
  UTMtoRealLaLo(RefEllipsoid, UTMNorthing, UTMEasting, UTMZone, UTMZoneLetter,
              RealLat, RealLong);
  Memo.Lines.Add(format('Out: UTM Zone: %d %s N%8.3f E%8.3f',[UTMZone,UTMZoneLetter,UTMNorthing,UTMEasting]));
  Memo.Lines.Add(format('Reconverted to Real Lat/Long: %8.3f %8.3f',[RealLat,RealLong]));
  Memo.Lines.Add('');

  //----------------------------------------------------------------------------

  Memo.Lines.Add('Test of LaLoToUTM and UTMtoLaLo');
  Memo.Lines.Add(format('In: Lat/Long, Lat: %d %d'' %2.3f" Long: %d %d'' %2.3f"',
                 [Lat.Degrees,Lat.Minutes,Lat.Seconds,
                  Long.Degrees,Long.Minutes,Long.Seconds]));
  LaLoToUTM(RefEllipsoid, Lat, Long, UTMNorthing, UTMEasting, UTMZone, UTMZoneLetter);
  UTMtoLaLo(RefEllipsoid, UTMNorthing, UTMEasting, UTMZone, UTMZoneLetter, Lat, Long);
  Memo.Lines.Add(format('Out: UTM %d %s N%8.3f E%8.3f',
                 [UTMZone,UTMZoneLetter,UTMNorthing,UTMEasting]));
  Memo.Lines.Add(format('Reconverted to Lat/Long: %d %d'' %2.3f"  %d %d'' %2.3f"',
                 [Lat.Degrees,Lat.Minutes,Lat.Seconds,
                  Long.Degrees,Long.Minutes,Long.Seconds]));
  Memo.Lines.Add('');

  //----------------------------------------------------------------------------

  RealLaLoPoint.Latitude:=RealLat;
  RealLaLoPoint.Longitude:=RealLong;
  Memo.Lines.Add('Test of RealLaLo2UTM and UTM2RealLaLo');
  Memo.Lines.Add(format('In: Real Lat/Long: %8.3f %8.3f',
                [RealLaLoPoint.Latitude,RealLaLoPoint.Longitude]));
  UTMPoint:= RealLaLo2UTM(RefEllipsoid,RealLaLoPoint);
  RealLaLoPoint:=UTM2RealLaLo(RefEllipsoid,UTMPoint);
  with UTMPoint do
    Memo.Lines.Add(format('Out: UTM %d %s N%8.3f E%8.3f',
                   [Zone,ZoneLetter,Northing,Easting]));
  with RealLaLoPoint do
    Memo.Lines.Add(format('Reconverted to Real Lat/Long: %8.3f %8.3f',
                   [Latitude,Longitude]));
    Memo.Lines.Add('');

  //----------------------------------------------------------------------------

  LaLoPoint.Latitude:=Lat;
  LaLoPoint.Longitude:=Long;
  Memo.Lines.Add('Test of LaLo2UTM and UTM2LaLo');
  with LaLoPoint do
  Memo.Lines.Add(format('In: Lat/Long, Lat: %d %d'' %2.3f" Long: %d %d'' %2.3f"',
                 [Latitude.Degrees,Latitude.Minutes,Latitude.Seconds,
                  Longitude.Degrees,Longitude.Minutes,Longitude.Seconds]));
  UTMPoint:= LaLo2UTM(RefEllipsoid,LaLoPoint);
  LaLoPoint:=UTM2LaLo(RefEllipsoid,UTMPoint);
  with UTMPoint do
    Memo.Lines.Add(format('Out: UTM %d %s N%8.3f E%8.3f',
                   [Zone,ZoneLetter,Northing,Easting]));
  with LaLoPoint do
    Memo.Lines.Add(format('Reconverted to Lat/Long: %d %d'' %2.3f"  %d %d'' %2.3f"',
                   [Latitude.Degrees,Latitude.Minutes,Latitude.Seconds,
                    Longitude.Degrees,Longitude.Minutes,Longitude.Seconds]));
    Memo.Lines.Add('');

  //----------------------------------------------------------------------------

  UTMLaLo:=TUTMlaLo.Create;
  UTMLaLo.RefEllipsoid:=WGS84;

  Memo.Lines.Add('Test of class TUTMLaLo: RealLaLoToUTM and UTMtoRealLaLo');
  Memo.Lines.Add(format('In: Real Lat/Long: %8.3f %8.3f',[RealLat,RealLong]));
  UTMLaLo.RealLaLoToUTM(RealLat, RealLong, UTMNorthing, UTMEasting, UTMZone, UTMZoneLetter);
  UTMLaLo.UTMtoRealLaLo(UTMNorthing, UTMEasting, UTMZone, UTMZoneLetter,
              RealLat, RealLong);
  Memo.Lines.Add(format('Out: UTM Zone: %d %s N%8.3f E%8.3f',[UTMZone,UTMZoneLetter,UTMNorthing,UTMEasting]));
  Memo.Lines.Add(format('Reconverted to Real Lat/Long: %8.3f %8.3f',[RealLat,RealLong]));
  Memo.Lines.Add('');

  Memo.Lines.Add('Test of class TUTMLaLo: LaLoToUTM and UTMtoLaLo');
  Memo.Lines.Add(format('In: Lat/Long, Lat: %d %d'' %2.3f" Long: %d %d'' %2.3f"',
                 [Lat.Degrees,Lat.Minutes,Lat.Seconds,
                  Long.Degrees,Long.Minutes,Long.Seconds]));
  UTMLaLo.LaLoToUTM(Lat, Long, UTMNorthing, UTMEasting, UTMZone, UTMZoneLetter);
  UTMLaLo.UTMtoLaLo(UTMNorthing, UTMEasting, UTMZone, UTMZoneLetter, Lat, Long);
  Memo.Lines.Add(format('Out: UTM %d %s N%8.3f E%8.3f',
                 [UTMZone,UTMZoneLetter,UTMNorthing,UTMEasting]));
  Memo.Lines.Add(format('Reconverted to Lat/Long: %d %d'' %2.3f"  %d %d'' %2.3f"',
                 [Lat.Degrees,Lat.Minutes,Lat.Seconds,
                  Long.Degrees,Long.Minutes,Long.Seconds]));
  Memo.Lines.Add('');

  RealLaLoPoint.Latitude:=RealLat;
  RealLaLoPoint.Longitude:=RealLong;
  Memo.Lines.Add('Test of class TUTMLaLo: RealLaLo2UTM and UTM2RealLaLo');
  Memo.Lines.Add(format('In: Real Lat/Long: %8.3f %8.3f',
                [RealLaLoPoint.Latitude,RealLaLoPoint.Longitude]));
  UTMPoint:= UTMLaLo.RealLaLo2UTM(RealLaLoPoint);
  RealLaLoPoint:=UTMLaLo.UTM2RealLaLo(UTMPoint);
  with UTMPoint do
    Memo.Lines.Add(format('Out: UTM %d %s N%8.3f E%8.3f',
                   [Zone,ZoneLetter,Northing,Easting]));
  with RealLaLoPoint do
    Memo.Lines.Add(format('Reconverted to Real Lat/Long: %8.3f %8.3f',
                   [Latitude,Longitude]));
    Memo.Lines.Add('');

  LaLoPoint.Latitude:=Lat;
  LaLoPoint.Longitude:=Long;
  Memo.Lines.Add('Test of class TUTMLaLo: LaLo2UTM and UTM2LaLo');
  with LaLoPoint do
  Memo.Lines.Add(format('In: Lat/Long, Lat: %d %d'' %2.3f" Long: %d %d'' %2.3f"',
                 [Latitude.Degrees,Latitude.Minutes,Latitude.Seconds,
                  Longitude.Degrees,Longitude.Minutes,Longitude.Seconds]));
  UTMPoint:= UTMLaLo.LaLo2UTM(LaLoPoint);
  LaLoPoint:=UTMLaLo.UTM2LaLo(UTMPoint);
  with UTMPoint do
    Memo.Lines.Add(format('Out: UTM %d %s N%8.3f E%8.3f',
                   [Zone,ZoneLetter,Northing,Easting]));
  with LaLoPoint do
    Memo.Lines.Add(format('Reconverted to Lat/Long: %d %d'' %2.3f"  %d %d'' %2.3f"',
                   [Latitude.Degrees,Latitude.Minutes,Latitude.Seconds,
                    Longitude.Degrees,Longitude.Minutes,Longitude.Seconds]));
    Memo.Lines.Add('');

  UTMLaLo.Free;

  //----------------------------------------------------------------------------

end;

end.

