unit UserDlg;

{ -------------------------------------------------------------------------- }
{ Die Features der Komponente sind in der UserDlg.htm Datei enthalten        }                                   
{                                                                            }
{ (c) by Tom Peiffer 04.09.98                                                }
{    V.2.1                                                                   }
{                                                                            }
{  (c) e puer kleng Verbesserungen  v.2.2 by Guy Besch 6.9.1998              }
{                                                                            }
{     - Mindestbreite der Buttons einstellbar                                }
{     - Alle Buttons gleiche Gre, whlbar                                  }
{     - kein Array mehr fr die Buttons sondern unbegrenzt viele Buttons     }
{       mittels                                                              }
{       Findcomponent()                                                      }
{     - Jetzt sind as Buttons, und keine Speedbuttons mehr, Defaultbutton    }
{       wird jetzt auch angezeigt. (Default an Abort geet awer net.          }
{     - Jeder Button kriegt auf Wunsch jetzt Automatisch seinen passenden    }
{       Glyph                                                                }
{                                                                            }
{  (c) by Tom Peiffer 08.09.98 (01:16)                                       }
{      V.3.0                                                                 }
{      - Default Button klappt jetzt                                         }
{      - Einbinden von WAV Files mglich                                     }
{      - Ahnlich wie bei TQuery ist es nun mglich whrend der Laufzeit      }
{        die Message nach Parametern abzundern.                             }
{                                                                            }
{  (c) by Guy Besch  9.9.1998  v3.01                                         }
{      - About Box hinzugefgt                                               }
{      - Wunsch: ein Preview des fertigen Dialogs                            }
{                                                                            }
{  (c) by Tom Peiffer 09.09.98 v3.02                                         }
{      - Wunsch wurde erfllt                                                }
{      - System Beeps sind whlbar, oder natrlich CustomWAVs                }
{                                                                            }
{  (c) by Tom Peiffer 10.09.98 v3.03                                         }
{      - X zum Schliessen des Dialogs wird angezeigt wenn Cancel Property    }
{        auf einen Button gesetzt ist. Rckgabewert ist dann dieser Button   }
{      - Wenn Default > Anzahl der Buttons-1 war gab es eine                 }
{        Zugriffsverletzung                                                  }
{                                                                            }
{      by Pedro Paulo da Gama e Silva 11.09.98 v3.04                         }
{      - added capability to play waves contained into resource files.       }
{      - Just set the ResourceWAV property to true and the CustomWAV prop.   }
{        to the resource name. Sorry, but this waves can't be played using   }
{        preview mode (only in runtime...). Don't forget to include your     }
{        resource file into the application source code:                     }
{        $R YourWaveResource.res.                                            }
{      - Last, but not least: Great component! Thank you guys!               }
{                                                                            }
{  (c) by Tom Peiffer 14.09.98 v3.04                                         }
{       - Changed Pedro's idea of resource WAV files. No need of ResourceWAV }
{         propertyy, instead added to WAV property tbe wavResource item      }
{       - therefore no more wavCustom property, but wavFile instead          }
{       - CutsomWAV contains then either recource wav name or wav file name  }
{                                                                            }
{  (c) by Tom Peiffer 17.09.98 v3.05                                         }
{      - Changed the look of the buttons like the one in Corel applications  }
{           ->  thank you Peter Theill for the your help of the              }
{               CorelButton component                                        }
{      - Add a Cursor property that indicates the curosr behaviour when      }
{        moving mouse over a button                                          }
{                                                                            }
{ -------------------------------------------------------------------------- }

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  CorGlBtn ;

    function max (a,b: integer): integer;
    function DelAllOccurances( text, del: String ): String;



type
  TDefaultIcons = (icCustom,icWarning,icError,
                   icInformation,icConfirmation,icNone) ;
  TWAV = (wavNone,wavFile,wavAsterisk,wavExclamation,wavQuestion,wavDefault,
          wavResource) ;
  TLooks = (btnNormal,btnCorel) ;

  TUserDlg = class(TComponent)
  private
    { Private-Deklarationen }
    FPreview : string ;
    FAbout: String; // About v3.1
    FButtons : TStringList ;
    FMessage : TStringList ;
    FParams : TStringList ;
    FTitle : string ;
    BtnNo : integer ;
    FFont : TFont ;
    frm : TForm ;
    FIcon : TDefaultIcons ;
    FBackColor : TColor ;
    FCustomIcon : TPicture ;
    FWAV : TWAV ;
    FCustomWAV : string ;
    FResourceWAV : boolean;
    //FFlat : boolean ;
    fButtonsMinWidth : integer ;
    fButtonsSameWidth : boolean ;
    fButtonsShowGlyph : boolean ;
    FDefault, FCancel : integer ;
    FButtonsLook : TLooks ;
    FButtonsCursor : TCursor ;
    procedure SetButtons (M : TStringList) ;
    procedure SetMessage (M : TStringList) ;
    procedure SetParams (P : TStringList) ;
    procedure SetFont (F : TFont) ;
    procedure SetCustomIcon (p : TPicture) ;
    procedure SetButtonsMinWidth ( ButtonsMinWidth : integer );
    procedure FormClose  (Sender : TObject) ;
    procedure DialogShow (Sender : TObject) ;
    procedure CheckAndPlayWav ;
    procedure ShowAbout; // About 3.1
    procedure DesignPreview ;  // Preview
  protected
    { Protected-Deklarationen }
  public
    { Public-Deklarationen }
    constructor Create (AOwner : TComponent) ; override ;
    function Show : integer ;
    procedure SetParam (Name  : string ;
                        Value : variant) ;
  published
    { Published-Deklarationen }
    property About: string read FAbout write FAbout stored False;
    property Preview : string read FPreview write FPreview stored false ;
    property Buttons : TStringList read FButtons write SetButtons ;
    property Message : TStringList read FMessage write SetMessage ;
    property Params : TStringList read FParams write SetParams ;
    property Title : string read FTitle write FTitle ;
    property WAV : TWAV read FWAV write FWAV ;
    property CustomWAV : string read FCustomWAV write FCustomWAV ;
    property Font : TFont read FFont write SetFont ;
    property Icon : TDefaultIcons read FIcon write FIcon ;
    property CustomIcon : TPicture read FCustomIcon write SetCustomIcon ;
    property BackColor : TColor read FBackColor write FBackColor ;
    property Default : integer read FDefault write FDefault ; { wenn < 0 dann kein Default }
    property Cancel : integer read FCancel write FCancel ; { wenn < 0 dann kein Cancel }
    property ButtonsMinWidth : integer read fButtonsMinWidth write SetButtonsMinWidth ;     // Mindestbreite alle Buttons
    property ButtonsSameWidth : boolean read fButtonsSameWidth write fButtonsSameWidth ; // Alle Buttons haben dieselbe Gre
    property ButtonsShowGlyph : boolean read fButtonsShowGlyph write fButtonsShowGlyph ; // Buttons mit Glyphs anzeigen
    //property ButtonsLook : TLooks read FButtonsLook write FButtonsLook ;
    property ButtonsCursor : TCursor read FButtonsCursor write FButtonsCursor ;
  end;

procedure Register;

implementation
uses stdctrls, extctrls, buttons, mmsystem, dsgnintf ;

{$R UserDlg.res}

type  // About 3.1
  TAboutProperty = class(TPropertyEditor)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue:string; override;
  end;

  TPreviewProperty = class (TPropertyEditor)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue:string; override;
  end ;

procedure TAboutProperty.Edit;
{call the 'About' dialog window when clicking on ... in the Object Inspector}
begin
  TUSerDlg(GetComponent(0)).ShowAbout;
end;

function TAboutProperty.GetAttributes: TPropertyAttributes;
{set up to display a string in the Object Inspector}
begin
  GetAttributes := [paDialog, paReadOnly];
end;

function TAboutProperty.GetValue: String;
{set string to appear in the Object Inspector}
begin
  GetValue := 'Click here ->';
end;

procedure TUSerDlg.ShowAbout;
const
  msg = 'UserDlg v3.04' + #13 +
        'A Cardware component' + #13 +
        '(32 bit version)' + #13#13 +
        'Copyright  1998 by ' + #13 +
        'Guy Besch <besch@student.uni-kl.de>' + #13 +
        'Tom Peiffer <peiffer@student.uni-kl.de>'+#13+#13+
        'A really ''enhanced'' MessageBox with'+#13+
        'custom Buttons, custom Wave, custom Icons,'+#13+
        'custom font, custom background &&'+#13+
        'Parameters like in SQL-Query''s.'+#13+#13+
        'Now can also play waves from resource files'+#13+
        '(included by Pedro Paulo da Gama e Silva,'+#13+
        ' pedro.paulo@originet.com.br)';
begin
     MessageDlg(msg, mtInformation, [mbOK], 0);
end;
// end About 3.1

procedure TPreviewProperty.Edit;
begin
  TUSerDlg(GetComponent(0)).DesignPreview ;
end;

function TPreviewProperty.GetAttributes: TPropertyAttributes;
{set up to display a string in the Object Inspector}
begin
  GetAttributes := [paDialog, paReadOnly];
end;

function TPreviewProperty.GetValue: String;
{set string to appear in the Object Inspector}
begin
  GetValue := 'Click here ->';
end;

procedure TUSerDlg.DesignPreview;
begin
     show ;
end;

procedure TUserDlg.SetFont (F : TFont) ;
begin
     FFont.Assign (F) ;
end ;

procedure TUserDlg.SetCustomIcon (p : TPicture) ;
begin
     FCustomIcon.Assign (p) ;
     FIcon := icCustom ;
end ;

procedure TUserDlg.SetButtons (M : TStringList) ;
var
 T : string ;
 i : integer ;
begin
     FButtons.Assign (M) ;
     for i := 0 to FButtons.count-1
     do begin
             T := DelAllOccurances(FButtons[i],'&') ;
             T := uppercase (T) ;
             if (T = 'OK') and (FDefault < 0) then FDefault := i ;
             if ((T = 'CANCEL') or (T = 'ABORT')) and (FCancel < 0) then FCancel := i ;
        end ;
end ;

procedure TUserDlg.SetMessage (M : TStringList) ;
begin
     FMessage.Assign (M) ;
end ;

procedure TUSerDlg.SetButtonsMinWidth ( ButtonsMinWidth : integer );
begin
     fButtonsMinWidth := max ( ButtonsMinWidth, 20 );
end;

procedure TUserDlg.SetParams (P : TStringList) ;
begin
     FParams.Assign (P) ;
end ;

procedure TUserDlg.SetParam (Name  : string ;
                             Value : variant) ;
var
 i : integer ;
 Entry : string ;
begin
     Entry := Name + '=' + VarToStr(Value) ;
     i := FParams.IndexOfName (Name) ;
     if i = -1
     then FParams.Add (Entry)
     else FParams[i] := Entry ;
end ;

function max (a,b: integer): integer;
begin
     if a>b then begin
        Result:=a;
     end else begin
         Result:=b;
     end;
end;

// Alle Zeichen del in text lschen
function DelAllOccurances( text, del: String ): String;
var      i: LongInt;
begin
     i:=0;
     while (i<Length(text)) do begin
           if text[i]=del then begin
              Delete(text,i,1);
           end else begin
               Inc(i);
           end;
     end;
     Result:=text;
end;

constructor TUserDlg.Create (AOwner : TComponent) ;
begin
     inherited create (AOwner) ;
     FButtons := TStringList.Create ;
     FFont := TFont.Create ;
     FButtons.Add ('&OK') ;
     FButtons.Add ('&Cancel') ;
     FMessage := TStringList.Create ;
     FMessage.Clear ;
     FCustomIcon := TPicture.Create ;
     FBackColor := clBtnFace ;
     FIcon := icNone ;
     FParams := TStringList.Create ;
     FParams.clear ;
     FDefault := -1 ;
     FCancel := -1 ;
     FWAV := wavNone ;
     FButtonsCursor := crDefault ;
     FResourceWAV := False;
     fButtonsMinWidth:= 75 ;
     fButtonsSameWidth:= True;
end ;

function TUserDlg.Show : integer ;
var
 w, MaxMessageWidth, MessageHeight, i, j, ButtonWidth,
 L, p, MaxFormWidth  : integer ;
 cmdBtn : TCorelGlyphButton ; // GB
 btnLeft : integer;
 MsgUp, Msg, Name, lower: String;
 lblMessage : TLabel ;
 ico : TImage ;
 FMessageCopy : TStringList ;
begin
     FMessageCopy := TStringList.Create ;

     { Erstellen der Form-Properties }
     frm := TForm.Create (nil) ;
     frm.Font := FFont ;
     frm.Caption := FTitle ;
     frm.Color := FBackColor ;
     frm.BorderStyle := bsDialog ;
     frm.Position := poScreenCenter ;
     frm.KeyPreview := true ;
     frm.OnShow := DialogShow ;

     { Label = Message Speicher freigeben }
     lblMessage := TLabel.Create (frm) ;
     lblMessage.Parent := frm ;
     lblMessage.Top := 8 ;
     lblMessage.Left := 8 ;
     lblMessage.caption := '' ;

     { Falls ein Icon erwnscht, dann laden }
     ico := TImage.Create (frm) ;   // wenn im if, dann gibt's einen Warnung
     if FIcon <> icNone
     then begin
              ico.Parent := frm ;

               case FIcon of
                 icWarning      : ico.Picture.Bitmap.
                                   LoadFromResourceName (HINSTANCE,'ICOWARNING') ;
                 icError        : ico.Picture.Bitmap.
                                   LoadFromResourceName (HINSTANCE,'ICOERROR') ;
                 icInformation  : ico.Picture.Bitmap.
                                   LoadFromResourceName (HINSTANCE,'ICOINFORMATION') ;
                 icConfirmation : ico.Picture.Bitmap.
                                   LoadFromResourceName (HINSTANCE,'ICOCONFIRMATION') ;
                 icCustom       : ico.Picture.Assign (FCustomIcon) ;
                 icNone         : ico.Picture.Assign (nil) ;
               end ;

               ico.Top := 10 ;
               ico.Left := 10 ;
               ico.AutoSize := true ;

               ico.Transparent := true ;
               { Message muss jetz weiter nach rechts rcken }
               lblMessage.Left := ico.Left + ico.Width + 10 ;
          end
     else begin
               ico.AutoSize := false ;
               ico.height := 1 ;
               ico.width := 1 ;
          end ;

     { Var Parameter setzen falls vorhanden }
     FMessageCopy.Assign (FMessage) ;
     for j := 0 to FMessageCopy.Count-1
     do begin
             Msg := FMessageCopy[j] ;
             MsgUp := Uppercase (Msg) ;
             for i := 0 to FParams.Count-1
             do begin
                     Name := ':' + Uppercase(FParams.Names[i]) ;
                     L := length (Name) ;
                     p := pos (Name,MsgUp) ;
                     while p <> 0
                     do begin
                             Delete (Msg,p,L) ;
                             Delete (MsgUp,p,L) ;
                             insert (FParams.Values[FParams.Names[i]],Msg,p) ;
                             insert (FParams.Values[FParams.Names[i]],MsgUp,p) ;
                             p := pos (Name,MsgUp) ;
                        end ;
                end ;
             FMessageCopy[j] := Msg ;
        end ;

     { MessageLabel.caption setzen, mit Zeilen trennen, und Ermittelung der
       lngsten Zeile }
     MaxMessageWidth := 0 ;
     for i := 0 to FMessageCopy.Count-1
     do begin
             lblMessage.caption := lblMessage.caption + FMessageCopy[i] ;
             if i <> FMessageCopy.Count-1
             then lblMessage.caption := lblMessage.caption + #13 ;
             w := frm.canvas.textwidth (FMessageCopy[i]) ;
             if w > MaxMessageWidth
             then MaxMessageWidth := w ;
        end ;

     { MessageHhe berechnen }
     MessageHeight := FMessageCopy.Count * frm.Canvas.textheight ('W') ;

     { Falls ueberhaupt was im Message ... }
     if MaxMessageWidth > 0
     then frm.width := lblMessage.Left + MaxMessageWidth + 18 ;
     MaxFormWidth := trunc(screen.Width * 0.6) ;
     if frm.Width > MaxFormWidth
     then begin
               lblMessage.AutoSize := true ;
               lblMessage.Width := lblMessage.Width - (frm.Width-MaxFormWidth) ;
               lblMessage.WordWrap := true ;
               MessageHeight := lblMessage.Height ;
               frm.Width := MaxFormWidth ;
          end ;

     { Hoehe der Form anpassen }
     if MessageHeight > 0
     then if ico.Height > MessageHeight
          then frm.Height := ico.Height + 40
          else frm.Height := MessageHeight + 40 ;


     // Leere Buttons werden gelscht
     while (FButtons[FButtons.Count-1] = '') and (FButtons.Count>0) do
           FButtons.Delete(FButtons.Count-1);

     if FButtons.Count=0 then begin // Wenn kein Button definiert, dann min. einen Button definieren
        FButtons.Add('OK');
     end;


     { Buttons freigeben und setzen und breiteste Caption ermitteln }
     // Buttons erzeugen und maximale Breite aller Buttons ermittlen
     ButtonWidth := fButtonsMinWidth ;
     for i := 0 to FButtons.Count-1 do begin
             cmdBtn := TCorelGlyphButton.Create (frm) ;
             cmdBtn.Name := 'btn'+IntToStr(i);
             cmdBtn.Cursor := FButtonsCursor ;
             cmdBtn.Parent := frm ;
             cmdBtn.Top := frm.Height ;
             cmdBtn.Height := 25 ;
             cmdBtn.Caption := FButtons[i] ;
             //cmdBtn.Flat := FFlat ;
             cmdBtn.OnClick := FormClose ;


             // Glyph feststellen, ber Caption;
             if fButtonsShowGlyph = True then begin
                lower:=DelAllOccurances(lowercase(cmdBtn.Caption),'&');
                if (Lower='ok') or (Lower='ok') then begin
                   cmdBtn.GlyphKind:=glOK
                end else if (Lower='abort') or (Lower='abbruch') then begin
                     cmdBtn.GlyphKind:=glAbort
                end else if (Lower='all') or (Lower='alles') then begin
                     cmdBtn.GlyphKind:=glAll
                end else if (Lower='cancel') or (Lower='abbrechen') then begin
                     cmdBtn.GlyphKind:=glCancel
                end else if (Lower='close') or (Lower='schlieen') then begin
                     cmdBtn.GlyphKind:=glClose
                end else if (Lower='help') or (Lower='hilfe') then begin
                     cmdBtn.GlyphKind:=glHelp
                end else if (Lower='ignore') or (Lower='ignorieren') then begin
                     cmdBtn.GlyphKind:=glIgnore
                end else if (Lower='no') or (Lower='nein') then begin
                     cmdBtn.GlyphKind:=glNo
                end else if (Lower='ok') or (Lower='ok') then begin
                     cmdBtn.GlyphKind:=glOk
                end else if (Lower='retry') or (Lower='wiederholen') then begin
                     cmdBtn.GlyphKind:=glRetry;
                end else if (Lower='yes') or (Lower='ja') then begin
                     cmdBtn.GlyphKind:=glYes
                end else cmdBtn.GlyphKind := glNone ;
             end;

             // Damit durch cmdBtn.Kind werden eventuell die beiden folgenden
             // Eigensachaften verndert, deshalb werden sie hier zurckgesetzt
             cmdBtn.Caption := FButtons[i] ;
             cmdBtn.ModalResult := mrNone;
             cmdBtn.Cancel := False;
             cmdBtn.Default := False;

             if i=fDefault then
                cmdBtn.Default:=True ;    // DefaultButton markieren;
             if i=FCancel then
                cmdBtn.Cancel:=True;      // Cancel Button


             // Breite des Buttons berechnen
             cmdBtn.Width:= frm.canvas.textwidth(FButtons[i]) + cmdBtn.Glyphwidth + 16 ;
                             {+ max(cmdBtn.Glyphwidth,16) ; //+20}

             // maximale Breite speichern
             if cmdBtn.Width > ButtonWidth then
                ButtonWidth := cmdBtn.Width ;
        end ;

     // Breite aller Buttons anpassen
     btnLeft:=8;
     for i := 0 to FButtons.Count-1 do begin
         cmdBtn:=TCorelGlyphButton(frm.FindComponent('btn'+IntToStr(i))); // Button suchen
         // Wenn alle Buttons gleiche Breite haben sollen
         cmdBtn.Left := btnLeft;
         if fButtonsSameWidth = True then begin  // Buttons alle gleich breit
             cmdBtn.Width := ButtonWidth ;
         end else begin // Buttons so breit wie der Text, aber min. ButtonsMinWidth
             cmdBtn.Width := max(fButtonsMinWidth, cmdBtn.Width);
         end;
         btnLeft:= btnLeft + cmdBtn.Width +5;  // Position fr nchsten Button
     end ;

     { Falls Gesamtbreite aller Buttons > Form.width, dann Form Breite
       neu setzen }
     if FButtons.Count > 0 then begin
        frm.height := frm.Height + 60 ;     // was soll das
        btnLeft := btnLeft + 8;             // rechts noch zustzlich 8 Pixel
        if btnLeft > frm.width then begin
           frm.width := btnLeft ;
        end else begin // Wenn Buttons kleiner als Form, dann zentrieren
            for i := 0 to FButtons.Count-1 do begin
                cmdBtn:=TCorelGlyphButton(frm.FindComponent('btn'+IntToStr(i))); // Button suchen
                cmdBtn.Left:= cmdBtn.Left + (frm.width-btnLeft) div 2; // Buttons nach rechts schieben
            end ;
        end;
     end ;

     { x zum Schliessen nur zeigen wenn Cancel gesetzt }
     if (FCancel >= 0) and (FCancel <= FButtons.count-1)
     then begin
               frm.BorderIcons := frm.BorderIcons + [biSystemMenu] ;
               BtnNo := FCancel ;
          end
     else frm.BorderIcons := frm.BorderIcons - [biSystemMenu] ;


     { Zeigen }
     frm.showmodal ;

     { Speicher frei machen }
     for i := 0 to FButtons.Count-1 do begin
         cmdBtn := TCorelGlyphButton(frm.FindComponent('btn'+IntToStr(i)));
         cmdBtn.free ;
     end;

     FMessageCopy.Free ;
     lblMessage.free ;
     ico.Free ;
     frm.free ;

     { Funktionswert uebergeben }
     Result := btnNo ;
end ;

procedure TUserDlg.DialogShow (Sender : TObject) ;
var
 cmdBtn: TCorelGlyphButton;
begin
     if (FDefault >= 0) and (FDefault <= FButtons.count-1)
     then begin
               cmdBtn:=TCorelGlyphButton(frm.FindComponent('btn'+IntToStr(FDefault)));
               cmdBtn.SetFocus ;
          end ;
     frm.Invalidate ;

     CheckAndPlayWav ;
end ;

procedure TUserDlg.CheckAndPlayWav ;
var
 snd : integer ;
 Res, ResHandle : THandle ;
begin
     if not (FWAV in [wavNone,wavFile,wavResource])  // alles ausser None und Custom
     then begin
               case FWAV of
                    wavAsterisk : snd := MB_ICONASTERISK ;
                 wavExclamation : snd := MB_ICONEXCLAMATION ;
                    wavQuestion : snd := MB_ICONQUESTION ;
                     wavDefault : snd := MB_OK ;
               end ;
               MessageBeep (Snd) ;
          end
     else if FWAV = wavFile
          then begin
                    if fileexists (FCustomWAV)
                    then sndplaysound (PChar(FCustomWAV),SND_ASYNC) ;
               end
     else if FWAV = wavResource
          then begin
                    try
                       PlaySound(PChar(FCustomWAV), hInstance,
                                 SND_RESOURCE or SND_ASYNC);
                    except
                    end ;
               end ;
end ;

procedure TUserDlg.FormClose (Sender : TObject) ;
var Button: TCorelGlyphButton;
begin
     Button:=TCorelGlyphButton(Sender);
     BtnNo := StrToInt(Copy(Button.Name,4,5));
     frm.close ;
end ;

procedure Register;
begin
     RegisterComponents('My Stuff', [TUserDlg]);
     RegisterPropertyEditor(TypeInfo(String), TUserDlg, 'About', TAboutProperty);  // About 3.1
     RegisterPropertyEditor(TypeInfo(String), TUserDlg, 'Preview', TPreviewProperty);  // Preview
end;

end.
