{Ŀ
                           SP Software Development                          
 Ĵ
                     Copyright,(C) 1998 Petrus van Breda.                   
                        All Rights Reserved Worldwide                       
 Ĵ
               This source code is the exclusive property of:               
                            SP Software Development.                        
                             P.O.Box 9254, Edleen                           
                             1625, South Africa                             
 Ĵ
         Unauthorized distribution or disclosure of this source code        
                  or modification or removal of this notice                 
                constitutes a breach of the license agreement               
 }

unit UrlLblU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ShellAPI, Menus, Clipbrd;

type
  TUrlLabel = class(TCustomLabel)
  private
    { Private declarations }
      FClick   : boolean;
      FURL        : string;
      Menu: TPopupMenu;
      MenuItem: TMenuItem;
      FUpFontColor: TColor;
      FDownFontColor: TColor;
  protected
    { Protected declarations }
      procedure   SetClick(Value: boolean);
      procedure   MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
      procedure   MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
      procedure   OpenObject(sObjectPath : PChar);
      procedure OnMenuClick(Sender: TObject);      
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    { Published declarations }
    property    Click: boolean read FClick write SetClick;
    property    GoURL: string read FURL write FURL;
    property FontDownColor: TColor read FDownFontColor write FDownFontColor default clPurple;

    property Align;
    property Alignment;
    property AutoSize default False;
    property Color;
    property Caption;
    property DragCursor;
    property DragMode;
    property Enabled;
    property Font;
    property ParentColor;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property Transparent;
    property ShowHint;
    property Visible;
    property WordWrap;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
  end;

procedure Register;

implementation

{Default URL for SSI and Hint}
const
   DEF_URL = 'mailto: sandp@netactive.co.za';
   HINT_INF = 'ACCESS TO INFORMATION';
   CAP_INF = 'Petrus van Breda';

procedure Register;
begin
  RegisterComponents('SPSoft', [TUrlLabel]);
end;
constructor TUrlLabel.Create(AOwner: TComponent);
begin
   inherited;
{Create Default Settings}
   FClick := True;
   Cursor    := crHandPoint;
   FURL      := DEF_URL;
   Hint      := HINT_INF;
   Caption   := CAP_INF;
   ShowHint  := True;
   FDownFontColor := clPurple;

   with Font do begin
      Color := clBlue;
      Style := [fsUnderline];
   end;

   Menu := TPopupMenu.Create(Self);
   MenuItem := TMenuItem.Create(Menu);
   with MenuItem do begin
      Caption := '&Copy';
      OnClick := OnMenuClick;
   end;
   Menu.Items.Add(MenuItem);
   PopupMenu := Menu;

end;

destructor TUrlLabel.Destroy;
begin
 Menu.Free;
 inherited Destroy;
end;

procedure TUrlLabel.OnMenuClick;
begin
 If Trim(FUrl) = '' then
  Clipboard.AsText := Caption
 Else
  Clipboard.AsText := FUrl;
end;

{Set the cursor to a hand when it moves over the Label}
procedure TUrlLabel.SetClick(Value: boolean);
begin
   FClick := Value;
   if Click then Cursor := crHandPoint
      else Cursor := crDefault;
end;

{When the mouse is clicked on the Lable, try to log onto URL}

Procedure TUrlLabel.OpenObject(sObjectPath : PChar);
 Begin
  ShellExecute(0,Nil,sObjectPath,Nil,Nil,SW_Normal);
 End;

procedure TUrlLabel.MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
 Var
  TempString : Array[0..79] of char;

Var
 TestFUrl : String;

begin
 {If ssDouble in Shift then}
  If Button = mbLeft then
   Begin
    FUpFontColor := Font.Color;
    Font.Color := FDownFontColor;

    If Trim(FURL) = '' then
     TestFUrl := Caption
    Else
     TestFUrl := FURL;

    If Trim(TestFURL) <> '' then
     Begin
      StrPCopy(TempString,TestFURL);
      OpenObject(TempString);
     End;
   End;
   inherited;
end;

procedure TUrlLabel.MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  If Button = mbLeft then
   Font.Color := FUpFontColor;
   inherited;
end;

end.
