unit UCStatusbarAutofeed;

{ This component catches the onHint event of TApplication and
  displays the hint in the desired statusbar panel.
  Place this component on the same form as your statusbar,
  select panel (if the statusbar hasn't the SimplePanel property
  set to true) and the hints will appear.
  Please refer to UCStatusbarAutofeed.txt for more information.
  Tested with Delphi 5 but it should also work with D3 and D4.
  Freeware by UCSoft <info@ucsoft.de>
  http://www.ucsoft.de
  }
  
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  comctrls;

type
  TUCStatusbarAutofeed = class(TComponent)
  private
    { Private-Deklarationen }
    FEnabled : boolean;
    FLocked : boolean;
    FOldOnHint : TNotifyEvent;
    FStatusBar : TStatusbar;
    FPanel : integer;
    procedure SetEnableState(NewState : boolean);
    procedure FeedStatusbar(Sender: TObject);
    procedure DisplayHint(HintStr : string);
    procedure SetStatusbar(NewStatusbar : TStatusbar);
    procedure SetStatuspanel(NewPanel : integer);
  protected
    { Protected-Deklarationen }
  public
    { Public-Deklarationen }
    procedure LockStatusBar(StatusMsg : string);
    procedure UnlockStatusBar;
    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;
  published
    { Published-Deklarationen }
    property Enabled : boolean read FEnabled write SetEnableState;
    property Statusbar : TStatusbar read FStatusbar write SetStatusbar;
    property PanelIndex : integer read FPanel write SetStatusPanel default 0;
  end;

procedure Register;

implementation

{$R *.RES}

procedure TUCStatusbarAutofeed.SetEnableState(NewState : boolean);
begin
  if NewState<>FEnabled then
  begin
    FEnabled:=NewState;
    if FEnabled and (not (csDesigning in ComponentState)) then
    begin
      FOldOnHint:=Application.OnHint;
      Application.OnHint:=FeedStatusbar;
    end
    else
    begin
      if not (csDesigning in ComponentState) then
        if Assigned(FOldOnHint) then
          Application.OnHint:=FOldOnHint;
    end;
  end;
end;

procedure TUCStatusbarAutofeed.LockStatusBar(StatusMsg : string);
begin
  if Assigned(FStatusbar) then
  begin
    FLocked:=true;
    DisplayHint(StatusMsg);
  end;
end;

procedure TUCStatusbarAutofeed.UnlockStatusBar;
begin
  if Assigned(FStatusbar) then
    FLocked:=false;
end;

procedure TUCStatusbarAutofeed.FeedStatusbar(Sender: TObject);
begin
  if not Assigned(FStatusbar) then
    Exit;
  if not FLocked then
    DisplayHint(Application.Hint);
end;

constructor TUCStatusbarAutofeed.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);
  if not (csDesigning in ComponentState) then
  begin
    FOldOnHint:=Application.OnHint;
    Application.OnHint:=FeedStatusbar;
  end;
  FEnabled:=true;
end;

destructor TUCStatusbarAutofeed.Destroy;
begin
  if not (csDesigning in ComponentState) then
    if Assigned(FOldOnHint) then
      Application.OnHint:=FOldOnHint;
  inherited Destroy;
end;

procedure TUCStatusbarAutofeed.SetStatusbar(NewStatusbar : TStatusbar);
begin
  if NewStatusbar<>FStatusbar then
  begin
    FStatusbar:=NewStatusbar;
  end;
end;

procedure TUCStatusbarAutofeed.SetStatuspanel(NewPanel : integer);
begin
  if (NewPanel<>FPanel) and (FPanel>=0) then
    FPanel:=NewPanel;
end;

procedure TUCStatusbarAutofeed.DisplayHint(HintStr : string);
begin
  if Assigned(FStatusbar) and FEnabled and (not (csDesigning in ComponentState)) then
  begin
    if FStatusbar.SimplePanel then
      FStatusbar.SimpleText:=HintStr
    else
    begin
      if FPanel<FStatusbar.Panels.Count then
        FStatusbar.Panels[FPanel].Text:=HintStr;
    end;
  end;
end;

procedure Register;
begin
  RegisterComponents('UCSoft', [TUCStatusbarAutofeed]);
end;

end.
