{***************************************************************************}
{ uEGrdCSV component                                                        }
{ for Delphi & C++Builder                                                   }
{ version 1.0   04/11/2005                                                             }
{                                                                           }
{ written by Paolo Segu'                                                    }
{ Email : paolo.segu@tiscali.it                                             }
{ Web :                                                                     }
{                                                                           }
{ The source code is given as is, WITHOUT WARRANTY OF ANY KIND.             }
{ The author is not responsible for any possible damage done due to the     }
{ use of this code.                                                         }
{ The component can be freely used in any application.                      }
{***************************************************************************}

unit uEGrdCSV;

interface

uses
  Windows, Messages, SysUtils, Classes, Grids, Dialogs;

const
  MSG_ERROROPENFILE = 'Error opening file';
  MSG_ERRORIMPORTFILE = 'Error importing file';

type
  TuEGrdCSV = class(TComponent)
  private
    myDelimiter: Char;
    myQuoteChar: Char;
    myFileName: string;

    myGrid: TStringGrid;

    myHeader: boolean;
  protected
    { Protected declarations }
  public
    constructor Create(AOwner: TComponent); override;

    function ImportCSV: boolean;
    function ExportCSV: boolean;
  published
    property Delimiter: Char read myDelimiter write myDelimiter;
    property QuoteChar: Char read myQuoteChar write myQuoteChar;
    property FileName: string read myFileName write myFileName;

    property StringGrid: TStringGrid read myGrid write myGrid;
    property Header: boolean read myHeader write myHeader;
  end;

procedure Register;

implementation
{ TuEGrdCSV }

{***************************************************************************

***************************************************************************}
constructor TuEGrdCSV.Create(AOwner: TComponent);
begin
  inherited;
  myDelimiter:= ';';
  myQuoteChar:= '"';
end;


{***************************************************************************

***************************************************************************}
function TuEGrdCSV.ImportCSV: boolean;
var
  myFile: TStringList;
  i: integer;
  r: integer;
  c: integer;
  s: string;
begin
  Result:= False;
  if not Assigned(myGrid) then
    Exit;

  myFile:= TStringList.Create;
  try
    try
      myFile.LoadFromFile(myFileName);
    except
      ShowMessage(MSG_ERROROPENFILE);
      Exit;
    end;

// column number
// if "Header" is calc on first row
// else search for the MAX
    myGrid.ColCount:= 1;
    if Header then
    begin
      s:= myFile.Strings[0];
      for i:= 0 to Length(s) do
        if s[i] = myDelimiter then
          myGrid.ColCount:= myGrid.ColCount + 1;
    end
    else
    begin
      myGrid.ColCount:= 1;
      for r:= 0 to myFile.Count - 1 do
      begin
        c:= 1;
        s:= myFile.Strings[r];
        for i:= 0 to Length(s) do
          if s[i] = myDelimiter then
            inc(c);
        if c > myGrid.ColCount then
          myGrid.ColCount:= c;
      end;
    end;


// row number
    myGrid.RowCount:= myFile.Count;
    if not myHeader then
      myGrid.RowCount:= myGrid.RowCount + 1;

// import
    try
      if myHeader then
      begin
        myGrid.FixedRows:= 1;
        c:= 0;
        end
      else
        c:= 1;

      for i:= 0 to myFile.Count - 1 do
      begin
        myGrid.Rows[i + c].Delimiter:= myDelimiter;
        myGrid.Rows[i + c].QuoteChar:= myQuoteChar;
        myGrid.Rows[i + c].DelimitedText:= myFile.Strings[i];
      end;
    except
      ShowMessage(MSG_ERRORIMPORTFILE);
      Exit;
    end;

    Result:= True;

  finally
    myFile.Free;
  end;
end;


{***************************************************************************

***************************************************************************}
function TuEGrdCSV.ExportCSV: boolean;
var
  myFile: TStringList;
  i: integer;
  c: integer;
begin
  Result:= False;
  if not Assigned(myGrid) then
    Exit;
  myFile:= TStringList.Create;
  try
    c:= 0;
    if not myHeader then
      c:= 1;

    for i:= c to myGrid.RowCount - 1 do
    begin
      myGrid.Rows[i].Delimiter:= myDelimiter;
      myGrid.Rows[i].QuoteChar:= myQuoteChar;
      myFile.Add(myGrid.Rows[i].DelimitedText);
    end;

    myFile.SaveToFile(myFileName);
    Result:= True;

  finally
    myFile.Free;
  end;
end;


{***************************************************************************

***************************************************************************}
procedure Register;
begin
  RegisterComponents('Synesis', [TuEGrdCSV]);
end;



end.

