unit TurnPie;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, DBChart, TeEngine, Series;

type
  TTurnPie = class(TCustomUpDown)
  private
    FSeries : TPieSeries;
    procedure WMHScroll(var Message: TWMHScroll); message CN_HSCROLL;
    procedure WMSize(var Message: TWMSize); message WM_SIZE;
  protected
    procedure SetPieSeries(ASeries:TPieSeries);
  public
    constructor Create(AOwner:TComponent);override;
  published
    property PieSeries : TPieSeries read FSeries write SetPieSeries;
    property AlignButton;
    property ArrowKeys;
    property Enabled;
    property Hint;
    property Increment;
    property Orientation;
    property ParentShowHint;
    property PopupMenu;
    property Position;
    property ShowHint;
    property TabOrder;
    property TabStop;
    property Visible;
    property OnChanging;
    property OnClick;
    property OnEnter;
    property OnExit;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
  end;

procedure Register;

implementation

constructor TTurnPie.Create(AOwner:TComponent);
begin
inherited Create(AOwner);
Orientation:=udHorizontal;
Width:=70;
Height:=16;
Wrap:=True;
Max:=360;
Increment:=3;
end;

procedure TTurnPie.WMHScroll(var Message: TWMHScroll);
begin
inherited;
if FSeries<> nil then
FSeries.RotationAngle := Position;
end;

procedure TTurnPie.WMSize(var Message: TWMSize);
begin
inherited;
if FSeries<>nil then
FSeries.RotationAngle := Position;
end;

procedure TTurnPie.SetPieSeries(ASeries:TPieSeries);
begin
if FSeries <> ASeries then FSeries := ASeries;
end;

procedure Register;
begin
RegisterComponents('Data Controls',[TTurnPie]);
end;

end.
