{ $Id: TranslatorEdt.pas,v 1.10 2001/12/04 13:24:03 laa Exp $ }

{
    This file is part of the TTranslator 

    TTranslator is a Delphi component for localizing String and TStrings 
    properties of components dropped on a form. You can also localize your 
    code strings with TTranslator.
    Copyright (C) 2002 Polycon Ab

    This is a licensed version of TTranslator, it may be used as described
    in the TTranslator license agreement. If you have not acquired a 
    commercial TTranslator license, your are using this product illegaly.    
}

unit TranslatorEdt;

interface
{$i common.inc}

uses
{$ifdef VER140}
  DesignIntf, DesignEditors, DesignMenus, SysUtils,
{$else}
  DsgnIntf,
{$endif VER140}
  Classes, Menus, Translator;

type
  TTranslatorLanguageProperty = class(TStringProperty)
  private
    function GetTranslator : TTranslator;
  public
    property Translator : TTranslator read GetTranslator;
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValues(Proc: TGetStrProc); override;
    function GetValue: string; override;
    procedure SetValue(const Value: string); override;
  end;

  TStringsProperty = class(TClassProperty)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
  end;

  TAboutProperty = class(TClassProperty)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
  end;

  TTranslatorEditor = class(TDefaultEditor)
  private
    procedure EditStrings(Sender : TObject);
    procedure ShowAbout(Sender : TObject);
    procedure SetLanguage(Sender : TObject);
  protected
{$ifdef VER140}
    procedure EditProperty(const Prop: IProperty; var Continue: Boolean); override;
{$else}
    procedure EditProperty(PropertyEditor: TPropertyEditor; var Continue, FreeEditor: Boolean); override;
{$endif VER140}
  public
{$ifdef D4_OR_HIGHER}
{$ifdef VER140}
    procedure PrepareItem(Index: Integer; const AItem: IMenuItem); override;
{$else}
    procedure PrepareItem(Index: Integer; const AItem: TMenuItem); override; // FIXA!!!
{$endif VER140}
{$endif D4_OR_HIGHER}
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
  end;

{$ifdef D4_OR_HIGHER}
{$ifdef VER140}
  procedure ShowTranslatorEditor(AComponent : TTranslator; ADesigner : IDesigner);
{$else}
  procedure ShowTranslatorEditor(AComponent : TTranslator; ADesigner : IFormDesigner);
{$endif VER140}
{$else}
  procedure ShowTranslatorEditor(AComponent : TTranslator; ADesigner : TFormDesigner);
{$endif D4_OR_HIGHER}
  procedure Register;

implementation

uses TranslatorEditor, AboutTranslator, Forms;

procedure ShowAboutDlg(AStrings : IEditableTranslatedStrings);
var
  Dlg : TdlgAboutTranslator;
begin
  Application.CreateForm(TdlgAboutTranslator, Dlg);
  Dlg.Show(TTranslator.TranslatorVersion);
end;

{$ifdef D4_OR_HIGHER}
{$ifdef VER140}
procedure ShowTranslatorEditor(AComponent : TTranslator; ADesigner : IDesigner);
{$else}
procedure ShowTranslatorEditor(AComponent : TTranslator; ADesigner : IFormDesigner);
{$endif VER140}
{$else}
procedure ShowTranslatorEditor(AComponent : TTranslator; ADesigner : TFormDesigner);
{$endif D4_OR_HIGHER}

  procedure UpdateLanguage(AStrings : IEditableTranslatedStrings);
  begin
    AStrings.UpdateLanguage;
  end;

  procedure UpdateUI(AStrings : IEditableTranslatedStrings);
  begin
    AStrings.UpdateUI;
  end;

var
  Editor: TdlgStringsEditor;
  FCaption : String;
begin
  UpdateLanguage(AComponent.Strings);

  Application.CreateForm(TdlgStringsEditor, Editor);
  try
    Editor.Strings := AComponent.Strings;
    FCaption := 'Editing ';
    if AComponent.Owner <> nil then
      FCaption := FCaption +AComponent.Owner.Name +'.';
    FCaption := FCaption +AComponent.Name;
    Editor.Caption := FCaption;
    Editor.ShowModal;

    if ADesigner <> nil then // Enable debugging
      ADesigner.Modified;
  finally
    Editor.Release;
    UpdateUI(AComponent.Strings);
  end;
end;

// ------------------------- TTranslatorLanguageProperty -----------------------

function TTranslatorLanguageProperty.GetTranslator: TTranslator;
begin
  Result := TTranslator(GetComponent(0));
end;

function TTranslatorLanguageProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paValueList];
end;

procedure TTranslatorLanguageProperty.GetValues(Proc: TGetStrProc);
var
  FTranslator : TTranslator;
  i : Integer;
begin
  FTranslator := Translator;
  for i := 0 to FTranslator.Strings.LanguageCount - 1 do
    Proc(FTranslator.Strings.Languages[i]);
end;

function TTranslatorLanguageProperty.GetValue: string;
begin
  Result := Translator.Language;
end;

procedure TTranslatorLanguageProperty.SetValue(const Value: string);
begin
  Translator.Language := Value;
end;

{ TStringsProperty }

procedure TStringsProperty.Edit;
var
  Strings: TTranslatedStrings;
begin
  Strings := TTranslatedStrings(GetOrdValue);
  ShowTranslatorEditor(Strings.Owner, Designer);
end;

function TStringsProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog];
end;

{ TAboutProperty }

procedure TAboutProperty.Edit;
begin
  if  (PropCount > 0) and (GetComponent(0) is TTranslator) then
    ShowAboutDlg(TTranslator(GetComponent(0)).Strings);
end;

function TAboutProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog];
end;

{ TTranslatorEditor }


{$ifdef VER140}
procedure TTranslatorEditor.EditProperty(const Prop: IProperty; var Continue: Boolean);
{$else}
procedure TTranslatorEditor.EditProperty(PropertyEditor: TPropertyEditor; var Continue, FreeEditor: Boolean);
{$endif VER140}
begin
{$ifndef VER140}
  FreeEditor := True;
{$endif VER140}
  Continue := False;

  ShowAbout(nil);
{  TTranslator(Self.Component).Strings.Edit(Designer); }
end;

function TTranslatorEditor.GetVerbCount: Integer;
begin
  Result := 3;
end;

function TTranslatorEditor.GetVerb(Index: Integer): string;
begin
  if Index = 0 then
    Result := 'Edit Strings...'
  else if Index = 1 then
    Result := 'Language'
  else if Index = 2 then
    Result := 'About Translator...'
  else Result := '';
end;

{$ifdef D4_OR_HIGHER}
// FIXA!!! -- denna hittades inte under Delphi3
{$ifdef VER140}
procedure TTranslatorEditor.PrepareItem(Index: Integer; const AItem: IMenuItem);
{$else}
procedure TTranslatorEditor.PrepareItem(Index: Integer; const AItem: TMenuItem);
{$endif VER140}
var
  i : Integer;
{$ifndef VER140}
  FMenuItem : TMenuItem;
{$endif VER140}
begin
  if Index = 1 then
  with Self.Component as TTranslator do
  begin
    for i := 0 to Strings.LanguageCount - 1 do
    begin
{$ifdef VER140}
      AItem.AddItem( Strings.Languages[i], scNone, (Strings.Languages[i] = Language), True, SetLanguage, 0, 'T' + IntToStr(i) );
{$else}
      FMenuItem := TMenuItem.Create(AItem);
      FMenuItem.Caption := Strings.Languages[i];
      FMenuItem.Tag := i;
      FMenuItem.RadioItem := True;
      FMenuItem.Checked := FMenuItem.Caption = Language;
      FMenuItem.OnClick := SetLanguage;
      AItem.Add(FMenuItem);
{$endif VER140}
    end;
  end;
end;
{$endif D4_OR_HIGHER}

procedure TTranslatorEditor.ExecuteVerb(Index: Integer);
begin
  case Index of
    0: EditStrings(nil);
    1:; // Sub Menu
    2: ShowAbout(nil);
  end;
end;

procedure TTranslatorEditor.EditStrings(Sender : TObject);
begin
  if (Component is TTranslator) then
    ShowTranslatorEditor(TTranslator(Component), Designer);
end;

procedure TTranslatorEditor.ShowAbout(Sender : TObject);
begin
  if (Component is TTranslator) then
    ShowAboutDlg(TTranslator(Component).Strings);
end;

procedure TTranslatorEditor.SetLanguage(Sender : TObject);
var
  NewIndex : integer;
begin
  with Self.Component as TTranslator do
  begin
{$ifdef VER140}
    NewIndex := StrToInt( System.Copy(TMenuItem(Sender).Name,2,Length(TMenuItem(Sender).Name)) );
{$else}
    NewIndex := TMenuItem(Sender).Tag;
{$endif VER140}
    if Language <> Strings.Languages[NewIndex] then
    begin
      Language := Strings.Languages[NewIndex];
      Designer.Modified;
    end;
  end;
end;

procedure Register;
begin
  {Property Editors}
  RegisterPropertyEditor(TypeInfo(TLanguage), TTranslator, '', TTranslatorLanguageProperty);
  RegisterPropertyEditor(TypeInfo(TTranslatedStrings), nil, '', TStringsProperty);
  RegisterPropertyEditor(TypeInfo(TAboutTranslator), nil, '', TAboutProperty);

  {Component Editors}
  RegisterComponentEditor(TTranslator, TTranslatorEditor);
end;

end.
