{ $Id: DataTypes.pas,v 1.44 2002/07/30 10:24:23 mvj Exp $}

{
    This file is part of the TTranslator 

    TTranslator is a Delphi component for localizing String and TStrings 
    properties of components dropped on a form. You can also localize your 
    code strings with TTranslator.
    Copyright (C) 2002 Polycon Ab

    This is a licensed version of TTranslator, it may be used as described
    in the TTranslator license agreement. If you have not acquired a 
    commercial TTranslator license, your are using this product illegaly.    
}

unit DataTypes;

interface
{$i common.inc}

type

  TDisplayValues = (dvKeyOnly, dvKeyAndText, dvTextOnly, dvDefault);

  TSortOrder = (soAscending, soDescending);
  TRowStatus = (rsUnchanged, rsChanged, rsDeleted, rsNew, rsUnaccepted, rsExternControlled);
  TSetAction = (saDontOverwriteKeys, saOverwriteOnKeyChange);
  TSetResult = (srOk, srInvalidValue, srKeyConflict, srKeyOverwrited, srReadOnly);
  TGetAction = (gaReference, gaCopy, gaCut, gaDelete);
  TPutAction = (paDontOverwriteKeys, paOverwriteOnKeyChange, paOverwriteOnDifferingField, paAddExcept,
                paAddReplaceNone, paAddReplaceBlank, paAddReplaceNonAggregable, paInternal);
  TPutResult = (prOk, prValuesMissing, prKeyConflict, prKeyOverwrited, prIllegalKeyValue,
                prRowsAdded, prCannotAdd);
  TDistributeAction = (daFirst, daSecond, daBoth, daNone);
  TGranularity      = (tgOne, tgThousand, tgMillion);
  TRefillType = (rtNever, rtAlways, rtDependentChange);
  TConflictAction = (caCurrent, caOverwrite, caUnion, caIntersection);

  TCompareResult = (crEqual, crSeparate, crOverlapping, crSubset, crSuperset);

const
  IllegalPutResults : set of TPutResult = [prValuesMissing, prKeyConflict, prIllegalKeyValue, prCannotAdd];
  IllegalSetResults : set of TSetResult = [srInvalidValue, srKeyConflict, srReadOnly];

  CommonCompareResults : set of TCompareResult = [crEqual, crOverlapping, crSubset, crSuperset];

  PutResultText : array[TPutResult] of String =
                ('Ok', 'Values missing', 'Key conflict', 'Key overwrited', 'Illegal key value',
                 'Rows added', 'Cannot add');
  DisplayValueText : array[TDisplayValues] of string =
                 ('KeyOnly', 'KeyAndText', 'TextOnly', 'Default');

{  GranularityTexts :  array[TGranularity] of string = ('One', 'Thousand', 'Million');
  GranularityShortTexts :  array[TGranularity] of string = ('', 'K', 'M'); }
  GranularityIdentifiers :  array[TGranularity] of string = ('ONE', 'KILO', 'MEGA');
  GranularityDivisors : array[TGranularity] of cardinal = (1,1000,1000000);

type
  TAddAction = (aaExceptOnDifferentValues, aaReplaceNone, aaReplaceBlank,
                aaReplaceNonAggregable, aaReplaceAllValues);
  TChangeType = (kcNewRow, kcKeyUpdate, kcDeletedRow, kcVisibility);

  TIntervalIndex = (iiLow, iiHigh);

  TLogType = (ltInformation, ltError, ltWarning );

  TOperationType = (otNone, otLoad, otCalcOperation, otClear, otSave, otOther);

implementation

end.


