{ $Id: DataInterfaces.pas,v 1.5 2001/08/02 15:03:29 mvj Exp $}

{
    This file is part of the TTranslator 

    TTranslator is a Delphi component for localizing String and TStrings 
    properties of components dropped on a form. You can also localize your 
    code strings with TTranslator.
    Copyright (C) 2002 Polycon Ab

    This is a licensed version of TTranslator, it may be used as described
    in the TTranslator license agreement. If you have not acquired a 
    commercial TTranslator license, your are using this product illegaly.    
}

unit DataInterfaces;

interface

uses
{$ifndef LINUX}
  Graphics;
{$else}
  QGraphics;
{$endif LINUX}

type
  TTextAlignment = (rcaLeft, rcaRight, rcaCenter);

  {/** Interface for abstracting qr details from the rest of reporting. */}
  ILabel = interface
    ['{2BFA7F44-7AFC-45A8-B636-86569D668660}']
    function GetFontSize : integer;
    function GetTextAlignment : TTextAlignment;

    procedure SetFontSize(ASize : integer);
    procedure SetBGColor(AColor : TColor);
    procedure SetFGColor(AColor : TColor);
    procedure SetFontStyles(FontStyles : TFontStyles);
    procedure Clear;
    procedure SetTextAlignment(AnAlignment : TTextAlignment);
    property FontSize : integer read GetFontSize write SetFontSize;
    property TextAlignment : TTextAlignment read GetTextAlignment write SetTextAlignment;
  end;

implementation

end.
