unit ObjTransactions;

interface
uses classes,sysutils;

type
TTransactable=class;
TTransactNotify = procedure (Obj:TTransactable) of object;

TTransactable=class(TPersistent)
  private
    fready,fcommited,frolledback,fprepared:Boolean;
    fName:String;
    fonCommit,fonRollback,fOnReady,fOnFail:TTRansactNotify;
  public
   constructor create;
   destructor destroy;override;
    procedure Begintransaction; virtual;
    procedure Commit; virtual;
    procedure RollBack; virtual;
    Procedure Execute; virtual;
    procedure prepare;virtual;
  published
    property Ready:boolean read fready write fready;
    property Committed:boolean read fcommited write fcommited;
    property RolledBack:boolean read fRolledBack write frolledBack;
    property Name:String read fName write fName;
   property OnCommit:TTransactnotify read fOnCommit write fOnCommit;
   property OnRollBack:TTransactNotify read fOnRollback write fOnRollBack;
   property OnReady:TTransactNotify read fOnReady write fOnReady;
   property OnFail:TTransactNotify read fOnFail write fOnFail ;
  end;

TComponentTransaction = class(TTransactable)
 private
    fList:TList;
    fInTransaction,fAutoRollback:Boolean;
    freadycount,fcommitedcount,frolledbackcount:integer;
 public
   constructor create;
   destructor destroy;override;
   procedure ComponentCommit (Obj:TTransactable);
   procedure ComponentReady (Obj:TTransactable);
   procedure ComponentFailure  (Obj:TTransactable);
   procedure ComponentRollBack (Obj:TTransactable);
   procedure BeginTransaction;  override;
   function  AddObject (Obj:TTransactable):integer;
   function  Objects (index:integer):TTransactable;
   function  ObjectCount:integer;
   procedure DeleteObject (index:integer);
   procedure Commit;  override;
   procedure RollBack; override;
   procedure SetActive(act:Boolean);
   procedure Execute;override; {Fires the Execution of all sub objects}
   procedure Prepare;override;
 published
   Property Active:Boolean read fInTransaction write SetActive;
   property DefaultRollBack:boolean read fautorollback write fautorollback;
 end;
{1: Add all your objects
 2: Objects should have a begintrans,execute, commit, and rollback
 }

implementation

constructor TTransactable.create;
begin
  inherited create;
  fready:=false;fcommited:=false;frolledback:=false;fprepared:=false;
end;

destructor TTransactable.destroy;
begin
 try
  {}
 finally
   inherited destroy;
 end;
end;
procedure TTransactable.prepare;
begin
{override me if your object needs some getting ready before we begintransactions}
end;

procedure TTransactable.Begintransaction;
begin
{Nothing}
  fready:=false;fcommited:=false;frolledback:=false;
end;

procedure TTransactable.Commit;
begin
if assigned(fOnCommit) then fOnCommit(self);
fcommited:=TRUE;
fready:=false;
frolledback:=false;
end;

procedure TTransactable.RollBack;
begin
if assigned(fOnRollBack) then FOnRollBack(self);
fRolledBack:=TRUE;
fready:=false;
fcommited:=false;
end;

Procedure TTransactable.Execute;
begin
if assigned(fOnReady) then FOnReady(self);
fready:=TRUE;
fcommited:=false;
frolledback:=false;
end;

constructor TComponentTransaction.create;
begin
 inherited create;
 flist:=tlist.create;
 fInTransaction:=FALSE;
 fAutoRollBack:=True;
 freadyCount:=0;
 fcommitedcount:=0;
 frolledbackcount:=0;
end;

procedure TComponentTransaction.SetActive(act:Boolean);
begin
{}
if act then
begin
 {If the want it on turn it on if not already on}
if NOT(fintransaction) then
 begin
   BeginTransaction;
 end;
end
 else
begin
 {If they want it off then look at default}
 if fintransaction then
 begin
   if fautorollback then
     RollBack
     else
     Commit;
 end;
end;

end;

destructor TComponentTransaction.destroy;
var TC:TTransactable;
begin
 try
   {if in a transaction we need to roll it back if that was selected}

   {Explicitly if inside if to avoid any optimization}
   if fInTransaction then
    begin
     if fAutoRollBack then RollBack else Commit;
    end;

   while flist.count>0 do
   begin
      TC:=TTransactable(flist[flist.count-1]);

      if assigned(TC) then TC.free;
      flist.delete(flist.count-1)
   end;
   flist.free;
 finally
   inherited destroy;
 end;
end;
procedure TComponentTransaction.ComponentCommit (Obj:TTransactable);
begin
{When a component commits
Since we are happy if this happens, we'll save this space
for some future notifcations
}
inc(fcommitedcount);
{If everyone has committed then notify our "owner" thru ascestors OnCOmmit}
if fcommitedcount=flist.count then
   begin
     inherited Commit ;
   end;
end;

procedure TComponentTransaction.ComponentReady (Obj:TTransactable);
begin
{when a compnent has executed and is ready to commit
Since we are happy that a component did its thing we are
saving this space for future notifications}
inc(freadycount);
 
end;

procedure TComponentTransaction.ComponentFailure  (Obj:TTransactable);
begin
{when an execution fails}
RollBack;
end;

procedure TComponentTransaction.ComponentRollBack (Obj:TTransactable);
begin
{when a component rolls back.. weve fired our rollback, they are telling
us YES WE DID ROLLBACK, }
inc(frolledbackcount);
if frolledbackcount+fcommitedcount=flist.count then
    inherited Rollback;
end;

procedure TComponentTransaction.BeginTransaction;
var i:integer;TC:TTransactable;
begin
{Calls Begin trans on all compnents}
for i:= 0 to flist.count-1 do
 begin
    TC:=TTransactable(flist[i]);
    TC.Begintransaction;
 end;
end;

function  TComponentTransaction.AddObject (Obj:TTransactable):integer;
begin
{}
Obj.OnCOmmit:=ComponentCommit;
Obj.OnRollBack:=ComponentRollBack;
Obj.OnReady:=ComponentReady;
Obj.OnFail:=ComponentFailure;
result:=flist.add (Obj);
end;

function  TComponentTransaction.Objects (index:integer):TTransactable;
begin
{}
result:=TTransactable(flist[index]);
end;

function  TComponentTransaction.ObjectCount:integer;
begin
{}
result:=flist.count;
end;

procedure TComponentTransaction.DeleteObject (index:integer);
begin
{}
flist.delete(index);
end;

procedure TComponentTransaction.Execute;
var i:integer;TC:TTransactable;
begin
{Calls Execute on all compnents}
try
for i:= 0 to flist.count-1 do
 begin
    TC:=TTransactable(flist[i]);
    TC.execute;
 end;
 except on E:Exception do
    RollBack;
 end;
end;

procedure TComponentTransaction.Commit;
{
 Attempt to Commit Each One... if any fail the call all the
 rollbacks in the list.
 It would also be a good idea to store the objects XML or in Toad files
 while we do this.. that way we can recover if the components have no
 other way to recover.
}
var i:integer;TC:TTransactable;
begin
{Calls Commit on all compnents}
try
for i:= 0 to flist.count-1 do
 begin
    TC:=TTransactable(flist[i]);
    TC.Commit;
 end;
  except on E:Exception do
    RollBack;
 end;
end;


procedure TComponentTransaction.RollBack;
var i:integer;TC:TTransactable;
begin
{Calls Begin trans on all compnents}
for i:= 0 to flist.count-1 do
 begin
    TC:=TTransactable(flist[i]);
    TC.Rollback;
 end;
end;

procedure TComponentTransaction.Prepare;
var i:integer;TC:TTransactable;
begin
{Calls Begin trans on all compnents}
for i:= 0 to flist.count-1 do
 begin
    TC:=TTransactable(flist[i]);
    TC.Prepare;
 end;
end;



end.
