unit ADOTransactions;

interface
uses Classes,ObjTransactions,ADODB_TLB,Sysutils;

{
In this test each transaction will have a SQL property
that will be fired upon commit using the given COnnStr,Userid, and Password
ANY Exceptions raised will be caught by during execution and rollback fired;
}
type

TADOTransaction = class(TTransactable)
 private
   fSql:String;fConnection:TConnection;fconnstr,fuser,fpass:String;
 public
   constructor create;
   destructor destroy;override;
 published
   property SQL:String read fsql write fsql;
   property ConnectionString:String read fconnstr write fconnstr;
   property UserId:String read fuser write fuser;
   property Password:String read fpass write fpass;
   procedure Prepare;override;
   procedure Commit;override;
   procedure RollBack;override;
   Procedure BeginTransaction;override;
   procedure Execute;override;
 end;

implementation

constructor  TADOTransaction.create;
begin
{}
inherited create;
fConnection:=TConnection.create(nil);
end;

destructor  TADOTransaction.destroy;
begin
{}
try
 fConnection.free;
finally
 inherited destroy;
end;
end;

procedure TADOTransaction.Prepare;
var ignore:Variant;
begin
   fconnection.open (fConnstr,fuser,fpass,ignore);
   inherited Prepare;
end;

procedure TADOTransaction.Commit;
begin
   {}
   try
   if fconnection.state=1 then
   begin
    fconnection.committrans;
    fconnection.close;
   inherited commit;
   end;             
   except On E:Exception do RollBack; end;

end;

procedure TADOTransaction.RollBack;
begin
   {}
if fconnection.state=1 then
   begin
    fconnection.Rollbacktrans;
    fconnection.close;
   end;
   inherited rollback;
end;

Procedure TADOTransaction.BeginTransaction;
begin
   {}
   fconnection.begintrans;
   inherited BeginTransaction;
end;

procedure TADOTransaction.Execute;
var ignore:Olevariant;
begin
   {}
   fconnection.execute(fsql,ignore,0);
   inherited Execute;
end;

end.
