{*****************************************************************************}
{                                                                             }
{       Maps v0.93 Generic Associative Containers for Delphi 2, 3 & 4         }
{                                                                             }
{                 Copyright (c) 1999 Robert R. Marsh, S.J.                    }
{               & the British Province of the Society of Jesus                }
{                                                                             }
{                This source code may *not* be redistributed                  }
{                ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                  }
{                                                                             }
{       If you like Maps and find yourself using it please consider           }
{       making a donation to your favorite charity. I would also be           }
{       pleased if you would acknowledge Maps in any projects that            }
{       make use of it.                                                       }
{                                                                             }
{       Maps is supplied as is. The author disclaims all warranties,          }
{       expressed or implied, including, without limitation, the              }
{       warranties of merchantability and of fitness for any purpose.         }
{       The author assumes no liability for damages, direct or                }
{       consequential, which may result from the use of QDB.                  }
{                                                                             }
{                           rrm@sprynet.com                                   }
{                     http://home.sprynet.com/~rrm                            }
{                                                                             }
{*****************************************************************************}

(*

  The Rand unit packages a simple random number generator for use with Maps.

*)

unit Rand;

interface

type
  TRandGen = class(TObject)
  private
    FSeed : Cardinal;
  public
    constructor Create(Seed : Cardinal);
    function Random(Range : Cardinal) : Cardinal;
    function Random32 : Cardinal;
    procedure Randomize;
    procedure Seed(Seed : Cardinal);
  end;

implementation

uses
  SysUtils;

{ TRandGen }

constructor TRandGen.Create(Seed : Cardinal);
begin
  inherited Create;
  if Seed = 0 then
    Seed := 1;
  FSeed := Seed;
end;

function TRandGen.Random(Range : Cardinal) : Cardinal;
begin
  Result := Random32 mod Range;
end;

function TRandGen.Random32 : Cardinal;
const
  a = 16807; // multiplier
  m = 2147483647; // 2**31 - 1
  q = Cardinal(127773); // m div a
  r = 2836; // m mod a
var
  l : Cardinal;
  h : Cardinal;
begin
  l := a * (FSeed and $FFFF);
  h := a * (FSeed shr 16);
  Inc(l, ((h and $7FFF) shl 16));
  if l > m then
  begin
    l := l and m;
    Inc(l);
  end;
  l := l + (h shr 15);
  if l > m then
  begin
    l := l and m;
    Inc(l);
  end;
  FSeed := l;
  Result := l;
end;

procedure TRandGen.Randomize;
type
  Cast = record
    x : Cardinal;
    y : Cardinal;
  end;
var
  t : Double;
begin
  t := Now;
  FSeed := Cast(t).x xor Cast(t).y;
end;

procedure TRandGen.Seed(Seed : Cardinal);
begin
  if Seed = 0 then
    Seed := 1;
  FSeed := Seed;
end;

end.

