{$INCLUDE OPTIONS.INC}

{*****************************************************************************}
{                                                                             }
{       Maps v0.93 Generic Associative Containers for Delphi 2, 3 & 4         }
{                                                                             }
{                 Copyright (c) 1999 Robert R. Marsh, S.J.                    }
{               & the British Province of the Society of Jesus                }
{                                                                             }
{                This source code may *not* be redistributed                  }
{                ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                  }
{                                                                             }
{       If you like Maps and find yourself using it please consider           }
{       making a donation to your favorite charity. I would also be           }
{       pleased if you would acknowledge Maps in any projects that            }
{       make use of it.                                                       }
{                                                                             }
{       Maps is supplied as is. The author disclaims all warranties,          }
{       expressed or implied, including, without limitation, the              }
{       warranties of merchantability and of fitness for any purpose.         }
{       The author assumes no liability for damages, direct or                }
{       consequential, which may result from the use of QDB.                  }
{                                                                             }
{                           rrm@sprynet.com                                   }
{                     http://home.sprynet.com/~rrm                            }
{                                                                             }
{*****************************************************************************}

(*

   The Hashing unit is used by Maps

*)

{$R-}{$Q-} // gotta have range & overflow checking off

unit Hashing;

interface

// Returns a 32-bit value based on Key. The idea is that
// small variations in the Key should result in unpredictable
// differences in the hash value.
// The method used here is to take the Key four bytes at a
// time and translate each byte into a random byte (by a
// simple lookup table). The 4-byte value so produced is
// xor-ed into the current value of the hash and then the
// hash bits are rotated right one bit before repeating
// the process for another 4 bytes.
// This hash seems to work better (at least on the test data
// I used) than the customary ELF Hash. It's also faster.

// "_Hash" is straight pascal code... (provided for completeness)
function _Hash(const Key; KeyLength : Integer) : Cardinal;
// ..."Hash" is a tweaked asm version. The fast version is used
// internally by ADT.
function Hash(const Key; KeyLength : Integer) : Cardinal;

implementation

// A shuffled table of bytes 0..255 -- effectively
// transforms any byte used as index into another
// random byte value.
const
  RT : array[0..255] of Byte = (
    $03, $D7, $4F, $26, $B3, $45, $B5, $73,
    $8B, $27, $C6, $A9, $35, $ED, $7D, $6E,
    $A5, $87, $7F, $1E, $D3, $20, $C9, $2E,
    $79, $CC, $7A, $C2, $43, $3B, $D4, $81,
    $77, $09, $F9, $EA, $B4, $2F, $B7, $58,
    $29, $49, $40, $61, $78, $CF, $3F, $00,
    $BC, $5B, $D5, $6C, $19, $9A, $AF, $D2,
    $32, $80, $AC, $65, $59, $E6, $8C, $08,
    $30, $A2, $4D, $0F, $92, $1D, $A6, $2D,
    $93, $BF, $7C, $91, $75, $34, $A0, $68,
    $C5, $A8, $9F, $71, $11, $88, $14, $60,
    $B1, $82, $38, $50, $41, $F5, $89, $9D,
    $CB, $F4, $BB, $D9, $5A, $5D, $A1, $0E,
    $A3, $98, $6D, $F7, $70, $90, $4B, $D6,
    $AE, $8A, $17, $B0, $9B, $8E, $2B, $24,
    $F3, $DE, $C8, $BE, $4A, $28, $5F, $0A,
    $E1, $6B, $D0, $23, $A4, $0C, $DC, $57,
    $8F, $42, $DF, $E2, $EC, $0B, $E0, $64,
    $3A, $E7, $FD, $C7, $E5, $D1, $E4, $18,
    $46, $BD, $01, $D8, $54, $B2, $84, $A7,
    $67, $3E, $55, $86, $E9, $FC, $7E, $1A,
    $39, $8D, $1B, $EE, $4C, $B8, $F1, $DD,
    $5C, $02, $AD, $37, $F0, $3D, $13, $07,
    $AB, $85, $10, $EF, $CA, $36, $96, $15,
    $1C, $53, $AA, $51, $83, $56, $5E, $EB,
    $C4, $1F, $21, $E8, $FA, $F8, $DA, $06,
    $6A, $9C, $31, $72, $99, $FB, $04, $6F,
    $E3, $B9, $16, $9E, $12, $C3, $05, $F2,
    $0D, $CE, $52, $DB, $44, $95, $47, $69,
    $4E, $2A, $CD, $48, $76, $94, $7B, $22,
    $3C, $BA, $FF, $2C, $F6, $74, $B6, $33,
    $62, $25, $C0, $63, $FE, $66, $C1, $97);

function _Hash(const Key; KeyLength : Integer) : Cardinal;
type
  TBuffer = array[0..0] of Byte;
  PBuffer = ^TBuffer;
  THashBuffer = record
    case Byte of
      1 : (h : Cardinal);
      2 : (h1 : Byte; H2 : Byte; h3 : Byte; h4 : Byte);
  end;
var
  i : Integer;
  P : PBuffer;
  h : THashBuffer;
begin
  // start with a good "random" bit pattern so that
  // even single byte hashes are well scattered over
  // a 32-bit range
  Result := Cardinal(Pointer($9E3779B9));
  P := @Key;
  Inc(P, KeyLength);
  i := -(KeyLength);
  while i < 0 do
  begin
    h.h := 0;
    h.h1 := RT[P[i]];
    Inc(i);
    if i < 0 then
    begin
      h.H2 := RT[P[i]];
      Inc(i);
      if i < 0 then
      begin
        h.h3 := RT[P[i]];
        Inc(i);
        if i < 0 then
        begin
          h.h4 := RT[P[i]];
          Inc(i);
        end;
      end;
    end;
    Result := Result xor h.h;
    // i.e. rotate the Result bit-pattern 1 bit to the right
    Result := (Result shr 1) or (Result shl 31);
  end;
end;

// asm translation and optimization of _hash

var
  RTP : Pointer = @RT;

function Hash(const Key; KeyLength : Integer) : Cardinal;
asm
        push   esi
        push   edi
        push   ecx
        mov    edi, RTP
//  Result := $9E3779B9;
        mov    ecx, $9E3779B9
//  P := @Key;
        mov    esi, eax
//  Inc(P, KeyLength);
        add    esi, edx
//  i := -(KeyLength);
        mov    eax, edx
        neg    eax
//  while i < 0 do
//  begin
        test   eax, eax
        jnl    @Exit
//    H.H :=0;
@Top:   xor    edx, edx
        mov    [esp], edx
//    H.h1:= RT[P[i]];
        xor    edx, edx
        mov    dl, [esi+eax]
        mov    dl, [edi+edx]
        mov    [esp], dl
//    inc(i);
        inc    eax
//    if i < 0 then
        test   eax, eax
        jnl    @Calc
//      H.h2:= RT[P[i]];
        xor    edx, edx
        mov    dl, [esi+eax]
        mov    dl, [edi+edx]
        mov    [esp+$01], dl
//    inc(i);
        inc    eax
//    if i < 0 then
        test   eax, eax
        jnl    @Calc
//      H.h3:= RT[P[i]];
        xor    edx, edx
        mov    dl, [esi+eax]
        mov    dl, [edi+edx]
        mov    [esp+$02], dl
//    inc(i);
        inc    eax
//    if i < 0 then
        test   eax, eax
        jnl    @Calc
//      H.h4:= RT[P[i]];
        xor    edx, edx
        mov    dl, [esi+eax]
        mov    dl, [edi+edx]
        mov    [esp+$03], dl
//    inc(i);
        inc    eax
//    Result := Result xor H.H;
@Calc:  xor    ecx, [esp]
//    Result := (Result shr 1) or (Result shl 31);
        ror    ecx, 1
//  while i < 0 do
        test   eax, eax
        jl     @Top
//end;
@Exit:  mov    eax, ecx
        pop    ecx
        pop    edi
        pop    esi
        ret
end;

end.

