unit filelock;


interface
uses classes,windows,sysutils;

type
 TLockableFile = class(tobject)
 private 
   fmutex:THandle;fname:String;
 public
  property FileName:String read fname write fname;
  function LockFile:boolean;
  procedure UnlockFile;
 end;

implementation

function TLockableFile.LockFile:boolean;{returns false if timeout}
var p:pchar;
begin
 p:=stralloc(length('FileLock_'+fname)+1);
 strpcopy(p,'FileLock_'+fname+#0);
 fmutex:=Windows.CreateMutex(nil, False,p);
 strdispose(p);
 if WaitForSingleObject(fMutex , 30000)=WAIT_TIMEOUT then
  result:=false
 else
   result:=true;
end;

procedure TLockableFile.UnlockFile;
begin
ReleaseMutex(fmutex);
CloseHandle(fMutex);
end;



end.