unit Toadindices;

interface
uses classes,sysutils,Toadbase5,Toadtransactions;

type


TToadIndex = class(TObject)
   private
      fStorage:TToadRawTable;
      fIndexed:TToadRawTable;
      fMemoryIndex:TList; {The "In Memory" index}
      findexfield,fkeyfield :string;
   public
     constructor create;
     destructor destroy;override;
     procedure Open (Table:TToadRawTable);
     procedure Close;
     procedure ReIndex (Table:TToadRawTable); {iterate thru and additems}
     procedure ClearAll; {wipe out the index,called by Reindex}
     property  IndexField:string read findexfield  write findexfield ;
     property  KeyField:string read fkeyfield  write fkeyfield ;
     procedure AddItem (Item:TToadRecord;row,col:integer);
     procedure DeleteItem (Item:TToadRecord);
     function  GetCoordinates (FieldValue:Variant):TToadCoordinate;
     function Exists (FieldValue:Variant):boolean;
     function CoordinateList (fieldValue:variant):TList;
   end;
   {FIELDS OF AN INDEX:
    ID,IndexedField1....IndexedFieldN,Row,Col,Parent,Left,Right
    so can build tree with minimal fuss.. already has structure
    in it... or I can just do simple indexing until I build the BTree
    }


       {
TToadCursor = class (Tcomponent)
  {Index consists of a selected primary key field, and
   a secondary field (may be in sorted order)
   Index is read into memory and fed into a BTree or RBtree
   or similar system. Given a filter of relationship/value,
   a resulting cursor of primary keys and indexed values is
   available... it may be scrolled through in a serial manner.
   A TToadCursor will be built up this idea.

   Someday, transactions, indices, and tables will reside/able-to
   reside in one file... but for now they are separated.
   }    {
   published
   property Relationship:TToadRelationship read frelation write SetRelation;
   property Value:Variant read fvalue write SetValue;
   property IndexField:String read fidx write fidx;
   property FileName:string read fname write fname;{Toadbase file to index}
 {  procedure Reindex;{rebuild the entire index file}
 {  procedure Loadindex (filename:String); {load an index}
 {  procedure First;
   procedure Prev;
   procedure Next;
   procedure Last;
   function  CurrentRecord:TToadRecord;{pulls record from Toadbase file}
 {  function  CurrentKey:Variant;{key from index file}
 {  function  CurrentIDX:Variant;{indexed field from index file}
 {  function  EOF:boolean;
   function  BOF:boolean;
end;

{
ok... so.. how to do a join w/out table reads?... index for the where clause
on one, then pull each indexed and match to an indexed key of another

So customers and invoices

SELECT customers.Name,invoices.amount,invoices.date from customers join invoices on invoice.custid=customers.custid where customername='Mike'

ok..
INDEX CUSTOMERS.Name (PK + 'Name')
INDEX INVOICES.custid


find CUSTOMERS.Name='Mike' get PK
find invoices.PK matched to a custid, and
pull the records by key.

Index should store

ROW,COL,PK,Indexfield
so it can turn to the Raw Table and issue a MoveTo(Row,Col) and pull
JUST THAT ONE RECORD.

Now, lets tackle an index
}

implementation
constructor TToadIndex.create;
begin
  fstorage:=TToadRawTable.create ;
end;

destructor TToadIndex.destroy;
begin
 try
   close;
 finally
   inherited destroy;
 end;
end;

procedure TToadIndex.Open (Table:TToadRawTable);
begin
  if not(assigned(fstorage)) then fstorage:=TToadRawTable.create;
  if fileexists(findexfield+'_'+table.tablename+'.idx') then
  begin
  fstorage.tablename:='IDX_'+findexfield;
  fstorage.Open(findexfield+'_'+table.tablename+'.idx');
  findexed:=table;
  end;
  {Now we need to load the table into memory}
end;

procedure TToadIndex.Close;
begin
  fstorage.close;
  fstorage.free;
end;

procedure TToadIndex.ReIndex (Table:TToadRawTable); {iterate thru and additems}
var r,c:cardinal;maxr,maxc:cardinal;kidx,iidx:integer;
begin
findexed:=Table;

fstorage:=TToadRawTable.create;
fstorage.tablename:='IDX_'+findexfield;
kidx:=table.currentrecord.Indexof(fkeyfield);
iidx:=table.currentrecord.Indexof(findexfield);
while fstorage.currentrecord.Fieldcount >0 do
  fstorage.CurrentRecord.Delete (fstorage.currentrecord.Fieldcount -1);
fstorage.CurrentRecord.add(fkeyfield,table.currentrecord.fields(kidx).vartype,table.currentrecord.fields(kidx).length);
fstorage.CurrentRecord.add(findexfield,table.currentrecord.fields(iidx).vartype,table.currentrecord.fields(iidx).length);
fstorage.CurrentRecord.add('ROW',varInteger,sizeof(integer));
fstorage.CurrentRecord.add('COL',varInteger,sizeof(integer));
if fileexists(findexfield+'_'+table.tablename+'.idx') then clearall;
fstorage.Open(findexfield+'_'+table.tablename+'.idx');
fstorage.setsize (100,100);
maxr:=Table.rows;
maxc:=Table.Cols;
for r:= 0 to maxr-1 do
  for c:= 0 to maxc-1 do
   begin
      Table.MoveTo (r,c);
      AddItem(Table.CurrentRecord,r,c);
   end;
end;

procedure TToadIndex.ClearAll; {wipe out the index,called by Reindex}
var r,c
:cardinal;maxr,maxc:cardinal;
begin
fstorage.close;
deletefile(findexfield+'*.idx');
end;

procedure TToadIndex.AddItem (Item:TToadRecord;row,col:integer);
var kidx,iidx:integer;
begin
kidx:=item.Indexof(fkeyfield);
iidx:=item.Indexof(findexfield);
fstorage.CurrentRecord.fields(0).data:=Item.fields(kidx).data;
fstorage.CurrentRecord.fields(1).data:=Item.fields(iidx).data;
fstorage.CurrentRecord.fields(2).data:= row;
fstorage.CurrentRecord.fields(3).data:= col;
fstorage.append;
end;

procedure TToadIndex.DeleteItem (Item:TToadRecord);
var kidx,iidx:integer;r,c:cardinal;key:variant;
begin
kidx:=item.Indexof(fkeyfield);
iidx:=item.Indexof(findexfield);
key:=Item.fields(kidx).data;
for r:= 0 to findexed.rows-1 do
 for c:= 0 to findexed.cols-1 do
  begin
   findexed.moveto(r,c);
   if findexed.currentrecord.fields(kidx).data=key then findexed.delete;
  end;
end;

function TToadIndex.GetCoordinates (FieldValue:Variant):TToadCoordinate;
var r,c:cardinal;found:boolean; coord:TToadCoordinate; idx:integer; v:variant;
begin
found:=false;r:=0;c:=0;
coord.Row :=-1;
coord.col:=-1;
idx:=findexed.currentrecord.indexof(findexfield)  ;
fstorage.MoveTo (0,0);
 while ((r<fstorage.rows) AND (c<fstorage.cols) AND not(found)) do
 begin
 fstorage.MoveTo (r,c);
   v:= fstorage.currentrecord.fields(idx).data;
   if v=fieldvalue then
    begin
       found:=true;
       coord.row:=fstorage.currentrecord.fields(2).data;
       coord.col:=fstorage.currentrecord.fields(3).data;
    end;
     inc(c);
     if c=fstorage.cols  then
       begin
         c:=0;
         inc(r);
       end;

 end;
result:=coord;
end;

function TToadIndex.Exists (FieldValue:Variant):boolean;
var coord:TToadcoordinate;
begin
coord:=GetCoordinates(FieldValue);
result:=false;
if ((coord.Row > -1) and (coord.col>-1)) then result:=true;
end;

function TToadIndex.CoordinateList (fieldValue:variant):TList;
var r,c:cardinal;found:boolean; cord:TToadCoordinate; coord:TToadCoordinateObject; idx:integer; v:variant;
begin
result:=tlist.create;
found:=false;r:=0;c:=0;
cord.Row := -1;
cord.col:=-1;
coord.coordinates:=cord;
idx:=findexed.currentrecord.indexof(findexfield)  ;
fstorage.MoveTo (0,0);
 while ((r<fstorage.rows) AND (c<fstorage.cols)) do
 begin
 fstorage.MoveTo (r,c);
   v:= fstorage.currentrecord.fields(idx).data;
   if v=fieldvalue then
    begin
       coord:=TToadCoordinateObject.create;
       cord.Row :=fstorage.currentrecord.fields(2).data;
       cord.col:=fstorage.currentrecord.fields(3).data;
       coord.coordinates:=cord;
       result.add(coord);
    end;
     inc(c);
     if c=fstorage.cols  then
       begin
         c:=0;
         inc(r);
       end;

 end;
 
end;


end.
