unit Toadbase5;

interface
uses classes,sysutils,mapfiles,windows,dialogs;

type
TToadfieldtype = integer; {Corresponds to VarTypes}
TToadCoordinate = record
                Row,Col:Longint;
                end;

TToadCoordinateObject = class(TObject)
   private
     fcoord:TToadCoordinate;
   public
     property Coordinates:TToadcoordinate read fcoord write fcoord;
   end;

TToadField = class(TPersistent)
           private
            fName:string;
            fVarType:integer;
            fMaxLength:integer;
            fLength:integer;
            fData:Variant;
            fkey:boolean;
            fbuffer:Pointer;
           public
            property Buffer:Pointer read fbuffer write fbuffer;
           published
            property IsKey:Boolean read fkey write fkey;

            property Name:string read fname write fname ;
            property VarType:integer read fvartype write fvartype;
            property Length:integer read flength write flength;
            property Maxlength:integer read fmaxlength write fmaxlength ;
            property Data:Variant read fdata write fdata;
           end;

TToadCompare = (tcEQ,tcNEQ,tcLT,tcGT,tcLTE,tcGTE,tcLike);

TToadLocks = (lockHeader,LockRow,LockCOl,LockRecord,LockCounter,LockRowBalance,LockrowGID);
 {Locks are made on an individual PART of the header, and not the entire
 header... so different threads can get a lock on EXACTLY what they need.}

TToadHeader = Record
	Version: array [0..3] of byte; {050}
	Table_Name:String[20];
        Rows,Cols: integer;{rows are arranged in a grid of records like PVFS}
        {GID positions are stored by row after the header, 100 rows, 100 GID's}
        RowBalance:integer;{cycles 0 to rowcount-1 to tell a client which row to do an insert on... mutexed}
	Counter : Cardinal;{Only one counter is really necessary}
	Fields: Array [0..20] of string[40];
	FieldTypes: Array [0..20] of TToadFieldType;
        FieldLength: Array [0..20] of integer;
	FKFields: Array [0..20] of string[40]; {local FK}
	FKrefsPK: Array [0..20] of string[40];{which PK field does it reference}
	PKTables: Array [0..20] of string[40]; {which table does it reference}
	PKDB: Array [0..20] of string[40]; {future - what database refs}
	PKServer: Array [0..20] of string[40]; {future - what server}
	KeyField:integer;{which field is PK?}
	RecordSize:longint; {file size is headersize+sizeof(cardinal)*rows+ rows*cols*recordsize}
	FieldCount:integer;
end;

TToadRecord = class( TObject)
            private
                   ffields:TList;
            public
                  constructor create; virtual;
                  destructor destroy;override;
                  function Add(fieldname:string;fieldtype,size:integer):integer;
                  procedure Delete(field:integer);
                  procedure Edit (field:integer;newname:String;newtype,newsize:integer);
            published
                  function Indexof (name:String):integer;
                  function Names (idx:integer):string;
                  function Fieldcount:integer;
                  function Fields(idx:integer):TToadField;
            end;

TToadRecordmap = class(TRecordmap)
  public
     procedure ReadRec(var Rec); virtual; abstract;
     procedure WriteRec(const Rec); virtual; abstract;
     property CurrentRec;
     property HeaderSize;
     property RecCount;
     property RecordSize;
  end;

TAllowNotifyEvent = procedure (sender:Tobject;Subject:TObject;row,col:cardinal;var allow:boolean) of object;

TToadRawTable = class (TObject)
{
 Table works solely on direct read/write of a record by/for position,
 User's cursor will actually interact with a Transaction Table, which will
 handle database interaction for them in an ACID fashion. This table
 provides mechanisms for navigating, reading, and writing the file, as
 well as record locking.
}
 private
        fMap:TToadRecordmap;
        fHeader:TToadHeader;
        fRecord:TToadRecord;
        fname:String;
        frows,fcols,fcurrentrec,frow,fcol:cardinal;
        finsertion:THANDLE;
        finsertionCounter:integer;
        fonbeforeDelete,fonafterDelete :TallowNotifyevent;
        fonbeforeSave,fonafterSave :TallowNotifyevent;
        fonbeforeappend,fonafterappend :TallowNotifyevent;
 protected
   procedure SetHeader(Header:TToadHeader);virtual;
   function  GetHeader:TToadHeader;virtual;
   procedure QuietMove(iRow,iCOl:cardinal);
 public
   property  Map:TToadRecordMap read fmap;
   property  Header:TToadHeader read Getheader write Setheader;
   constructor create;virtual;
   destructor destroy;override;
   procedure SetSize (iRows,iCols:cardinal);
   function  RowCount:integer;
   function  ColCount:integer;
   procedure  setRowCount(newrows:integer);
   procedure setColCount(newcols:integer);
 published
   procedure Open (filename:String);

   procedure Close;
   property Rows:integer read rowcount write setrowcount;
   property Cols:integer read colcount write setcolcount;
   property TableName:string read fname write fname;
   function  MoveTo (iRow,iCol:integer):TToadRecord;
   function  CurrentRecord:TToadRecord;
   property  Row:cardinal read frow;
   property  Col:cardinal read fcol;
   procedure Read; 
   procedure Save; {directly store modifications to the database}
   procedure Delete; {directly write 000's to the record space   }
   procedure Append; {append current record at the Rows current GID }
   property OnBeforeAppend :TAllownotifyEvent read fOnBeforeAppend  write fOnBeforeAppend;
   property OnAfterAppend  :TAllownotifyEvent read fonafterAppend  write fonafterAppend;
   property OnBeforeSave :TAllownotifyEvent read fOnBeforeSave  write fOnBeforeSave;
   property OnAfterSave  :TAllownotifyEvent read fonafterSave  write fonafterSave;
   property OnBeforeDelete :TAllownotifyEvent read fOnBeforeDelete  write fOnBeforeDelete;
   property OnAfterDelete  :TAllownotifyEvent read fonafterDelete  write fonafterDelete;
 end;

//CreateRawToadbase (Filename:String;Header:TToadHeader);

{RawFormat:

[TTOADHEADER record][GIDPositionCOunters for each Row][Data]

}

implementation
{TToad record}
{represents a record of fields... the current position in a cursor,
a record before inserted into the database, the description of
database fields, etc.}
constructor TToadRecord.create ;
begin
inherited create ;
ffields:=tlist.create;
end;

function TToadRecord.Add(fieldname:string;fieldtype,size:integer):integer;
var f:TToadfield;
begin
f:=TToadfield.create;
f.Name:=fieldname;
f.vartype:=fieldtype;
f.Length :=size;
f.buffer := stralloc(size);
result:=ffields.add (f);
end;

destructor TToadRecord.destroy ;
var f:TToadfield;
begin
try
 {clear out any fields left over.}
 while ffields.count>0 do
  begin
   f:=TToadfield(ffields[ffields.count-1]);
   f.free;
   ffields.delete(ffields.count-1);
  end;
finally
   {finalize}
   inherited destroy;
end;
end;

procedure TToadRecord.Delete(field:integer);
var f:TToadfield;
begin
  if field<ffields.count then
  if assigned(ffields[field]) then
  begin
   f:=TToadfield(ffields[field]);
   strdispose(f.buffer);
   f.free;
   end;
   ffields.delete(field); {throw the default exception if they goofed}
end;

procedure TToadRecord.Edit (field:integer;newname:String;newtype,newsize:integer);
var f:TToadfield;
begin
{This isn't to edit the field VALUE, this is to edit the field DEFINITION..
you know, design time stuff. hmm... I think I'll make it an integer, NO.. a float}
if field<ffields.count then
  if assigned(ffields[field]) then
  begin
   f:=TToadfield(ffields[field]);
   strdispose(f.buffer);
   f.Name :=newname;
   f.data := Varastype(0 ,varNull);{Null the data so we don't get wierdness}
   f.vartype:=newtype;
   f.Length :=newsize;
   f.buffer:=stralloc(newsize);
  end;
end;

function TToadRecord.Indexof (name:String):integer;
var i,idx:integer;f:TToadfield; found:boolean;
begin
i:=0;idx:=-1;found:=false;
while ((i<ffields.count ) AND not(found)) do
 begin
   f:=TToadfield(ffields[i]);
   if uppercase(f.name)=uppercase(trim(name)) then
      begin
         found:=true;
         idx:=i;
      end;
   inc(i);
 end;
 result:=idx;
end;

function TToadRecord.Names (idx:integer):string;
var f:TToadfield;
begin
f:=TToadfield(ffields[idx]);
result:=f.name;
end;

function TToadRecord.Fieldcount:integer;
begin
 result := ffields.count;
end;

function TToadRecord.Fields(idx:integer):TToadField;
begin
result:=ffields[idx];
end;

{TToadRawTable}
constructor TToadRawTable.create;
begin
 inherited create;
 fRecord:=TToadRecord.create;
 finsertioncounter:=0;
end;

destructor TToadRawTable.destroy;
begin
try

 fRecord.free;
  
finally
 inherited destroy;
end;
end;


procedure TToadRawTable.SetHeader(Header:TToadHeader);
var i,sz:integer;
begin
 fheader:=Header;
 {Create out current record format from incoming header}
 sz:=0;
 for i:= 0 to header.FieldCount-1 do
  begin
   if frecord.fieldcount<=i then begin
                           frecord.add(header.fields[i],header.fieldtypes[i],header.fieldlength[i]);
                           end;
   if  frecord.Names(i) <> header.Fields [i]  then
      frecord.Edit(i,header.fields[i],header.fieldtypes[i],header.fieldlength[i]);
   sz:= sz + header.fieldlength[i];
  end;
  fheader.RecordSize :=sz;
end;

function  TToadRawTable.GetHeader:TToadHeader;
var i,sz:integer;
begin
 result:=fheader;
 {Build outgoing header from out current record}
 fheader.FieldCount := frecord.Fieldcount ;
 sz:=0;
   for i:= 0 to frecord.Fieldcount-1 do
      begin
        sz:=sz+frecord.fields(i).Length;
        fheader.Fields[i]:= frecord.Names (i);
        fheader.FieldTypes [i]:= frecord.fields(i).vartype;
        fheader.FieldLength[i]:= frecord.fields(i).Length;
        if frecord.Fields(i).iskey then
                                       begin
                                       fheader.KeyField :=i;
                                       end;
      end;
      fheader.RecordSize :=sz;
      fheader.Rows := frows;
      fheader.cols := fcols;
  result:=fheader;
end;

procedure TToadRawTable.Open (filename:String);
var CF:File of TToadHeader;BF:File ; i,card:integer; TempHeader:TToadheader;
begin
if fileexists(filename) then
 begin
 {open that file!}
 fmap:=TToadRecordMap.Create(filename);
 fmap.HeaderSize := sizeof(fheader)+(100 * sizeof(Cardinal) );
 fmap.FileOptions := foOpenAlways;
 fmap.active:=true;
 fmap.Seek(0,0);
 fmap.Read(Tempheader,sizeof(fheader));
 Header:=Tempheader ;
 fmap.recordsize:=tempheader.RecordSize ;
 fmap.CurrentRec := 0;
 end else
   begin
     {create us a new database!}
     fmap:=TToadRecordMap.Create(filename);
     fmap.FileOptions := foCreateNew;
     TempHeader:=GetHeader;
     fmap.HeaderSize := sizeof(fheader)+(100* sizeof(Cardinal) );
     fmap.RecordSize := fheader.recordsize;
     fmap.active:=true;
     fmap.reccount:=1;

     fmap.Seek(0,0);
     {write out header}

     fmap.Write(Tempheader,sizeof(TToadheader));
     card:=-1;
     {initialize the row insertion points to 0}
     for i:= 0 to 100 -1 do
      fmap.Write(card,sizeof(Cardinal));
     {Done!}
     fmap.currentrec:=0;
   end;
end;

procedure TToadRawTable.SetSize (iRows,iCols:cardinal);
var TempHeader:TToadheader;
begin
 {}   fmap.RecCount := irows*icols;
 frows:=irows;
 fcols:=icols;
 fheader.rows:=irows;
 fheader.cols:=icols;
 Tempheader:=GetHeader;
 fmap.Seek(0,0);
 fmap.Write(Tempheader,sizeof(TToadheader));

end;

procedure TToadRawTable.Close;
begin
if assigned(fmap) then
 begin
  if fmap.active then fmap.active:=false;
 fmap.Free;
 end;

end;

function  TToadRawTable.RowCOunt:integer;
begin
result:=fheader.Rows ;
end;

function  TToadRawTable.ColCount:integer;
begin
result:=fheader.Cols ;
end;
procedure TToadRawTable.QuietMove(iRow,iCOl:cardinal);
var r,c,recpos:cardinal; i:integer;  p:Pchar; d:variant;
begin
c:=fheader.cols;
frow:=iRow;
fcol:=iCol;
recpos:=0;
recpos:= iRow * c; {row 10 col 0 is #cols * 10}
recpos := recpos + icol;
fcurrentrec:=recpos;
fmap.currentrec:= recpos ;
{ok... found our rec... ok suppose 5 X 5
row 0,col 0 = 0
row 0,col 4 = 0 * 5 + 4  = 4
row 1, col 0 = 1 * 5 + 0 = 5
row 1, col 4 = 1 * 5 + 4 = 9
row 2, col 0 = 2 * 5 + 0 = 10
row}
fmap.CurrentRec := fcurrentrec;
end;

function  TToadRawTable.MoveTo (iRow,iCol:integer):TToadrecord;
begin
QuietMove(iRow,iCol);

 self.read;
 
end;

function  TToadRawTable.CurrentRecord:TToadRecord;
begin
result:=frecord;
end;
procedure TToadRawTable.Save;
var i,j:integer;s:String;f:TToadfield;
  vSmallint : Smallint;
  vint : Integer   ;
  vSingle   :Single;
  vDouble   :Double;
  vCurrency :Currency;
  vDate     :TDateTime;
  vOleStr   :String;
  vBoolean  :boolean;
  vByte     :byte;
  vString   :String;
  p:pchar;
  mtx:pchar;fsaving:THandle;
  res:integer; EFailMutex:Exception;
  continue:boolean;
begin
 {ok... now for some fun... first we need to obtain a lock on
 an insertion point}
 continue:=true;
 if assigned(fonbeforesave) then fonbeforesave(self,currentrecord,self.Row ,self.col,continue);
 if continue then
  begin
 mtx:=stralloc(length('TDB05_SAV'+inttostr(fmap.currentRec) )+1);
 strpcopy(mtx,'TDB05_SAV'+inttostr(fmap.currentRec)+#0);
 fsaving:=Windows.CreateMutex(nil, False,mtx);
 res:=WAIT_TIMEOUT;
 while ((res=WAIT_TIMEOUT) OR (res=WAIT_FAILED)) do
   begin
    if res=WAIT_FAILED then
       begin
          EFailMutex:=Exception.Create('Low Level Errors occured creating Mutex');
          raise(EFailMutex);
       end;
    res:=WaitForSingleObject(fsaving, 50);
   end ;
   {we got the lock.. so start writing}

 for i:= 0 to frecord.Fieldcount -1 do
 begin
 {writable types:}
 f:=frecord.Fields(i);
 case f.vartype of
  varSmallint : begin
                vsmallint:=f.data;
                fmap.write(vsmallint,sizeof(smallint));
                end;
  varInteger  : begin
                vint:=f.data;
                fmap.write(vint,sizeof(integer));
                end;
  varSingle   : begin
                vsingle:=f.data;
                fmap.write(vsingle,sizeof(single));
                end;
  varDouble   : begin
                vdouble:=f.data;
                fmap.write(vdouble,sizeof(double));
                end;
  varCurrency : begin
                vcurrency:=f.data;
                fmap.write(vcurrency,sizeof(currency));
                end;
  varDate     : begin
                vdate:=f.data;
                fmap.write(vdate,sizeof(tdatetime));
                end;
  varOleStr   : begin
                volestr:=f.data;
                fmap.write(volestr,f.Length );
                  for j:= 0 to f.length-1 do
                  p[j]:=#0;
                end;
  varBoolean  : begin
                vboolean:=f.data;
                fmap.write(vboolean,sizeof(boolean));
                end;
  varByte     : begin
                vbyte:=f.data;
                fmap.write(vbyte,1);
                end;
  varString   : begin
                p:=f.buffer;
                Strpcopy(p,f.data);
                fmap.write(p[0],f.length );
                for j:= 0 to f.length-1 do
                  p[j]:=#0;
                end;
 end;
 end;
  ReleaseMutex(fSaving);
  CloseHandle(fsaving);
 end; {if continue...}
  if assigned(fonaftersave) then
     begin
     fonaftersave(self,currentrecord,self.Row ,self.col,continue);
     {raw table isn't transactional, so it doesn't care about failures
      after the fact.}
     end;
end;

procedure  TToadRawTable.setRowCount(newrows:integer);
begin
  self.SetSize(newrows,fcols);
  frows:=newrows;
end;

procedure TToadRawTable.setColCount(newcols:integer);
begin
  self.SetSize(frows,newcols);
  fcols:=newcols;
end;

procedure TToadRawTable.Read; {directly store modifications to the database}
var i,j:integer;s:String;f:TToadfield;
  vSmallint : Smallint;
  vint : Integer   ;
  vSingle   :Single;
  vDouble   :Double;
  vCurrency :Currency;
  vDate     :TDateTime;
  vOleStr   :String;
  vBoolean  :boolean;
  vByte     :byte;
  vString   :String;
  p:pchar;
begin
for i:= 0 to frecord.Fieldcount -1 do
 begin
 {writable types:}

 f:=frecord.Fields(i);
 case f.vartype of
  varSmallint : begin
                fmap.read(vsmallint,sizeof(smallint));
                f.data:=vsmallint;
                end;
  varInteger  : begin
                fmap.read(vint,sizeof(integer));  
                f.data:=vint;
                end;
  varSingle   : begin
                fmap.read(vsingle,sizeof(single));  
                f.data:= vsingle;
                end;
  varDouble   : begin
                fmap.read(vdouble,sizeof(double));
                f.data:=  vdouble;
                end;
  varCurrency : begin
                fmap.read(vcurrency,sizeof(currency));  
                f.data:=vcurrency;
                end;
  varDate     : begin
                fmap.read(vdate,sizeof(tdatetime));
                f.data:=vdate;
                end;
  varOleStr   : begin
                p:=f.buffer;
                fmap.read(p,f.length );
                vstring:=strpas(p);
                f.data:=vstring;
                for j:= 0 to f.length-1 do
                  p[j]:=#0;
                end;
  varBoolean  : begin
                fmap.read(vboolean,sizeof(boolean));     
                f.data:=vboolean;
                end;
  varByte     : begin
                fmap.read(vbyte,1);
                f.data:=vbyte;
                end;
  varString   : begin
                p:= f.buffer ;
                fmap.read(p[0],f.length );
                vstring:=strpas(p);
                f.data:=vstring;
                for j:= 0 to f.length-1 do
                  p[j]:=#0;
                end;
 end;
 end;
 fmap.CurrentRec := fcurrentrec;
end;

procedure TToadRawTable.Delete; {directly write 000's to the record space   }
var b:byte;i,max:integer;continue:boolean;
begin
continue:=true;
if assigned(fonbeforedelete) then fonbeforedelete(self,currentrecord,self.Row ,self.col,continue);
if continue then
begin
max:=fheader.RecordSize ;
b:=0;
for i:= 0 to max-1 do
 begin
   fmap.write (b,1);
 end;
{physical space is clear, now clear the in-memory record}
 for i:= 0 to frecord.fieldcount-1 do
  frecord.Fields(i).Data:=VarasType(0,VarNull);

fmap.CurrentRec := fcurrentrec;
end; {if continue}
if assigned(fonafterdelete) then fonafterdelete(self,currentrecord,self.Row ,self.col,continue);
end;

procedure TToadRawTable.Append; {append current record at the Rows current GID }
var p:pchar;f,idx,inspos,mrow,mcol:integer;continue, found:boolean; res:integer;
begin
 {ok... now for some fun... first we need to obtain a lock on
 an insertion point}
continue:=true;
if assigned(fonbeforeappend) then fonbeforeappend(self,currentrecord,self.Row ,self.col,continue);
if continue then
begin
 found:=false;
 f:=0;
while(( f<99) and not(found)) do
 begin
 p:=stralloc(length('TDB05_INS'+inttostr(f))+1);
 strpcopy(p,'TDB05_INS'+inttostr(f)+#0);
 finsertion:=Windows.CreateMutex(nil, False,p);
 res:=WaitForSingleObject(finsertion, 50);
 if ((res=WAIT_TIMEOUT) OR (res=WAIT_FAILED)) then
   begin
     {timeed out or failed}
     found:=false;
     ReleaseMutex(finsertion);
     CloseHandle(finsertion);
     strdispose(p);
     inc(f)
   end
 else
   begin
    {got it!}
     found:=true;
     idx:=(f * sizeof(cardinal))+sizeof(fheader);
     fmap.Seek(idx,0);
     fmap.read(inspos,sizeof(cardinal));
     inc(inspos);
     fmap.Seek(idx,0);
     fmap.write(inspos,sizeof(cardinal));
     {INSPOS is where we need to be!}
     QuietMove(f,inspos);
     Self.save;
     releasemutex(finsertion);
     closehandle(finsertion);
   end;
 end;
end;
  {if continue...}
if assigned(fonafterappend) then fonafterappend(self,currentrecord,self.Row ,self.col,continue);
end;

end.


{Basic Idea:

A Table consists of a table header, which describes the contents of the table,
a series of row "next insertion point" counters, and then a grid
of data.  Inserts are done by attempting to get a lock on a counter, upon failing,
going to the next and round and round again... this will tend to fill the
table from the front, but ease the waiting time for concurrent inserts.

Deletion, at this point, is by writing all 0's... there is no recovery
as of yet.. that will be a layer on top of transactions.... the way I was going to impliment before is an extra
table (or section) that lets you know what items are available to fill in.
For now I'll stick with FAST is better than SMALL or ECONOMICAL... later
I'll improve the economy of space... this is intended for web servers, not
palm pilots.

This File is the raw-write to a table... and as such should not normally be used
by an end user.. who should talk to the next file over "ToadTransactions", or
better-yet, the full blown Toad Cursor or my planned TDataset component. By then
I should have the whole mess pretty straight and working almost like
an RDBMS/ISAM-VSAM hybrid...

The idea is to use the API of IPC.. memory mapped files, Mutexes. etc. to create
a fast, lightweight , multithread capable and aware, Database without having
any extra daemons laying about.


}

