unit ToadTransactions;

interface

uses classes,sysutils,ToadBase5;
type

TToadTransactionTable = class(TToadRawTable)
 private
    fTransactions:TStringlist; {List of Id's}
    ftable:TToadRawTable;
    ftranstable:TToadRawTable;
    ftruncate:boolean;
    fname,fcurrenttrans:String;
    fdummy:TToadrecord;
    fintrans:boolean;
 protected
   procedure SetHeader(Header:TToadHeader);override;
   function  GetHeader:TToadHeader;override;
   property  Header:TToadHeader read Getheader write Setheader;
 public
   property TransTable:TToadRawTable read ftranstable;
   constructor create; override;
   destructor destroy;override;
   procedure SetSize (iRows,iCols:cardinal);
   function  RowCount:integer;
   function  ColCount:integer;
   procedure setRowCount(newrows:integer);
   procedure setColCount(newcols:integer)    ;
   procedure SetTransactionSize (iRows,iCols:cardinal);
   function  TransactionRowCount:integer;
   function  TransactionColCount:integer;
   procedure setTransactionRowCount(newrows:integer);
   procedure setTransactionColCount(newcols:integer)   ;
 published
   procedure Open (filename:String);
   procedure Close;
   property Rows:integer read rowcount write setrowcount;
   property Cols:integer read colcount write setcolcount;
   property TransactionRows:integer read Transactionrowcount write setTransactionrowcount;
   property TransactionCols:integer read Transactioncolcount write setTransactioncolcount;
   property TableName:string read fname write fname;
   function  MoveTo (iRow,iCol:integer):TToadRecord;
   function  CurrentRecord:TToadRecord;
   property CurrentTransaction:String read fcurrenttrans write fcurrenttrans;
   procedure Read; 
   procedure Save; {directly store modifications to the database}
   procedure Delete; {directly write 000's to the record space   }
   procedure Append; {append current record at the Rows current GID }
  {
    Transaction stores not only the record, but the trans id, the
    action and the order in which things occured... that way on commit, it
    can store changes to the database, or roll them back.
    }
    procedure BeginTrans (Transactionid:String);
    procedure CommitTrans (Transactionid:String);
    procedure RollBackTrans (Transactionid:String);
end;

implementation
   constructor TToadTransactionTable.create;
   begin
   ftransactions:=tstringlist.create;
   ftable:=TToadRawTable.create;
   fdummy:=TToadRecord.create;
   fintrans:=false;
   end;

   destructor TToadTransactionTable.destroy;
   begin
    try
      ftransactions.clear;
      ftransactions.Free;
      //ftable.free;
    finally
       inherited destroy;
    end;
   end;

function TToadTransactionTable.GetHeader:TToadheader;
begin
result:=ftable.header;
end;

procedure TToadTransactionTable.SetHeader (header:TToadheader);
var i:integer;
begin
  {
  OK.. open the table, read the header.. look for a transactionlog,
  if none create one, looks just like the table, but it ads the transaction
  management fields.
  }
  ftable.header:=header;
  //if assigned(ftranstable) then ftranstable.free;
  if assigned(ftranstable) then fdummy.free;
  fdummy:=TToadRecord.create;
  ftranstable:=TToadrawtable.create;
  ftranstable.tablename:=ftable.tablename+'_Trans';
  ftranstable.CurrentRecord.add('#TRANS_ID',varstring,25);
  ftranstable.CurrentRecord.add('#TRANS_ROW',varinteger,sizeof(integer));
  ftranstable.CurrentRecord.add('#TRANS_COL',varinteger,sizeof(integer));
  ftranstable.CurrentRecord.add('#TRANS_TIMESTAMP',varDate,sizeof(TDateTime));
  ftranstable.CurrentRecord.add('#TRANSACTION_ACTION',varstring,3); {INSERT,UPDATE_BEFORE,UPDATE_AFTER,DELETE INS/UPB/UPA/DEL}
  ftranstable.CurrentRecord.add('#TRANS_COMMITED',varboolean,1);
  ftranstable.CurrentRecord.add('#TRANS_ROLLEDBACK',varboolean,1);
  if fname='' then fname:='Transaction.Log' ;
  for i:=0 to ftable.currentrecord.Fieldcount-1 do
   begin
     ftranstable.currentrecord.add(ftable.currentrecord.Names(i),ftable.currentrecord.fields(i).VarType,ftable.currentrecord.fields(i).length );
     fdummy.add(ftable.currentrecord.Names(i),ftable.currentrecord.fields(i).VarType,ftable.currentrecord.fields(i).length );
   end;
  ftranstable.Open (fname);
end;

procedure TToadTransactionTable.Open (filename:String);
begin
 if not(assigned(ftable)) then ftable:=TToadrawTable.create;
 if not(assigned(ftranstable)) then ftranstable:=TToadrawTable.create;
 ftable.open(filename);
 setHeader(ftable.Header);
end;

procedure TToadTransactionTable.Close;
begin
 ftable.close;
 ftranstable.close;
 ftable.free;
 ftranstable.free;
end;

procedure TToadTransactionTable.BeginTrans (Transactionid:String);
begin
{should test for transaction existing and raise errors for
restarting a transaction, etc.}
ftransactions.add(Transactionid);
fcurrenttrans:=Transactionid;
fintrans:=True;
end;

procedure TToadTransactionTable.CommitTrans (Transactionid:String);
var r,c:cardinal;tranid,act:String; actrow,actcol:cardinal; i:integer;
    commited,failed:boolean;   Lasttrans:integer; hold, idx:Cardinal;
begin
{copy items over to the table}
 {is the last inserted point when I started...}

{it would be nice to use and index to find.. but for now, I scroll..}

{Last trans is the last trans inserted on this row..why go past it?}

for r:= 0 to ftranstable.Rowcount-1 do
 begin
 idx:=(r * sizeof(cardinal))+sizeof(ftranstable.Header );
 hold:=ftranstable.map.Position ;
 ftranstable.map.Seek(idx,0);
 ftranstable.map.read( Lasttrans ,sizeof(cardinal));
 ftranstable.map.Seek(hold,0);

 if (LastTrans>=0) then
 for c:=0 to Lasttrans do
 begin
  ftranstable.moveto(r,c);
  tranid := transtable.CurrentRecord.fields(0).data;
  act := transtable.CurrentRecord.fields(4).data;
  actrow := transtable.CurrentRecord.fields(1).data;
  actcol := transtable.CurrentRecord.fields(2).data;
  commited:=  ftranstable.CurrentRecord.fields(5).data ;
  failed:=  ftranstable.CurrentRecord.fields(6).data ;
  if ((tranid=transactionid) and (commited=false) and (failed=false)) then
   begin

    if act='INS' then
       begin
         for i:= 0 to ftable.currentrecord.fieldcount-1 do
          begin
             ftable.currentrecord.fields(i).data:=ftranstable.currentrecord.fields(i+7).data;
          end;
          ftable.append;
       end;
    if act='UPA' then
       begin
         ftable.moveto(actrow,actcol)   ;
         for i:= 0 to ftable.currentrecord.fieldcount-1 do
          begin
             ftable.currentrecord.fields(i).data:=ftranstable.currentrecord.fields(i+7).data;
          end;
          ftable.save;
       end;
    if act='DEL' then
       begin
         ftable.moveto(actrow,actcol)   ;
         ftable.delete;
       end;
       ftranstable.MoveTo(r,c);
       ftranstable.CurrentRecord.fields(5).data:=TRUE;
       ftranstable.CurrentRecord.fields(6).data:=FALSE;
       ftranstable.save;
   end;

 end;
 end;
{when done,set the current trans:=ftransactions[ftransactions.count-1]}
end;

procedure TToadTransactionTable.RollBackTrans (Transactionid:String);
{delete the items... never happened.. }
var r,c:cardinal;tranid,act:String; actrow,actcol:cardinal; i:integer;
  commited,failed:boolean;Lasttrans:integer; hold, idx:Cardinal;
begin
{copy items over to the table}
 {is the last inserted point when I started...}

{it would be nice to use and index to find.. but for now, I scroll..}

{Last trans is the last trans inserted on this row..why go past it?}

for r:= 0 to ftranstable.Rowcount-1 do
 begin
 idx:=(r * sizeof(cardinal))+sizeof(ftranstable.Header );
 hold:=ftranstable.map.Position ;
 ftranstable.map.Seek(idx,0);
 ftranstable.map.read( Lasttrans ,sizeof(cardinal));
 ftranstable.map.Seek(hold,0);

 if (LastTrans>=0) then
 for c:=0 to Lasttrans do
 begin
  ftranstable.moveto(r,c);
  tranid := transtable.CurrentRecord.fields(0).data;
    commited:=  ftranstable.CurrentRecord.fields(5).data ;
  failed:=  ftranstable.CurrentRecord.fields(6).data ;
  if ((tranid=transactionid) and (commited=false) and (failed=false)) then
   begin
      ftranstable.delete;
   end;
 end;
 end;
{when done,set the current trans:=ftransactions[ftransactions.count-1]}
end;

function  TToadTransactionTable.CurrentRecord:TToadRecord;
begin
{}
result:=ftable.CurrentRecord ;
end;
procedure TToadTransactionTable.Read;
var i:integer;
begin
 ftable.read;
 for i:= 0 to ftable.currentrecord.fieldcount-1 do
 fdummy.fields(i).data:=ftable.currentrecord.fields(i).data; {for updating, we need a "Before"}
end;

procedure TToadTransactionTable.Save;
var i:integer;
begin
{do an update}
{record BEFORE UPDATE}
ftranstable.CurrentRecord.fields(0).data:=fcurrenttrans;
ftranstable.CurrentRecord.fields(1).data:=ftable.row;{don't know where it will go yet}
ftranstable.CurrentRecord.fields(2).data:=ftable.col;{don't know where it will go yet}
ftranstable.CurrentRecord.fields(3).data:=Now();
ftranstable.CurrentRecord.fields(4).data:='UPB';
ftranstable.CurrentRecord.fields(5).data:=FALSE;
ftranstable.CurrentRecord.fields(6).data:=FALSE;
for i:= 0 to ftable.currentrecord.fieldcount-1 do
  begin
    ftranstable.CurrentRecord.fields(i+7).data:=fdummy.fields(i).data;
  end;
ftranstable.append;

{Record AFTER UPDATE}
ftranstable.CurrentRecord.fields(0).data:=fcurrenttrans;
ftranstable.CurrentRecord.fields(1).data:=ftable.row;{don't know where it will go yet}
ftranstable.CurrentRecord.fields(2).data:=ftable.col;{don't know where it will go yet}
ftranstable.CurrentRecord.fields(3).data:=Now();
ftranstable.CurrentRecord.fields(4).data:='UPA';
ftranstable.CurrentRecord.fields(5).data:=FALSE;
ftranstable.CurrentRecord.fields(6).data:=FALSE;
for i:= 0 to ftable.currentrecord.fieldcount-1 do
  begin
    ftranstable.CurrentRecord.fields(i+7).data:=ftable.currentrecord.fields(i).data;
  end;
ftranstable.append;
end;

procedure TToadTransactionTable.Delete;
var i:integer;
begin
{do an delete}
ftranstable.CurrentRecord.fields(0).data:=fcurrenttrans;
ftranstable.CurrentRecord.fields(1).data:=ftable.row;{don't know where it will go yet}
ftranstable.CurrentRecord.fields(2).data:=ftable.col;{don't know where it will go yet}
ftranstable.CurrentRecord.fields(3).data:=Now();
ftranstable.CurrentRecord.fields(4).data:='DEL';
ftranstable.CurrentRecord.fields(5).data:=FALSE;
ftranstable.CurrentRecord.fields(6).data:=FALSE;
for i:= 0 to ftable.currentrecord.fieldcount-1 do
  begin
    ftranstable.CurrentRecord.fields(i+7).data:=ftable.currentrecord.fields(i).data;
  end;
ftranstable.append;
end;

procedure TToadTransactionTable.Append;
var i:integer;
begin
{do an append}
ftranstable.CurrentRecord.fields(0).data:=fcurrenttrans;
ftranstable.CurrentRecord.fields(1).data:=ftable.row;{don't know where it will go yet}
ftranstable.CurrentRecord.fields(2).data:=ftable.col;{don't know where it will go yet}
ftranstable.CurrentRecord.fields(3).data:=Now();
ftranstable.CurrentRecord.fields(4).data:='INS';
ftranstable.CurrentRecord.fields(5).data:=FALSE;
ftranstable.CurrentRecord.fields(6).data:=FALSE;
for i:= 0 to ftable.currentrecord.fieldcount-1 do
  begin
    ftranstable.CurrentRecord.fields(i+7).data:=ftable.currentrecord.fields(i).data;
  end;
ftranstable.append;
end;
procedure TToadTransactionTable.SetTransactionSize (iRows,iCols:cardinal);
begin
  ftranstable.setsize(irows,icols);
end;
function  TToadTransactionTable.TransactionRowCount:integer;
begin
 result:=ftranstable.RowCount;
end;
function  TToadTransactionTable.TransactionColCount:integer;
begin
 result:=ftranstable.colcount;
end;
procedure TToadTransactionTable.setTransactionRowCount(newrows:integer);
begin
ftranstable.setRowcount(newrows);
end;
procedure TToadTransactionTable.setTransactionColCount(newcols:integer)   ;
begin
ftranstable.setcolcount(newcols);
end;
procedure TToadTransactionTable.SetSize (iRows,iCols:cardinal);
begin
ftable.SetSize (irows,icols);
end;

function  TToadTransactionTable.RowCount:integer;
begin
result:=ftable.rowcount;
end;

function  TToadTransactionTable.ColCount:integer;
begin
result:=ftable.colcount;
end;

procedure TToadTransactionTable.setRowCount(newrows:integer);
begin
ftable.setRowCount(newRows);
end;

procedure TToadTransactionTable.setColCount(newcols:integer);
begin
ftable.setColCOunt(newcols);

end;

function  TToadTransactionTable.MoveTo (iRow,iCol:integer):TToadRecord;
var r,c,recpos:cardinal; i:integer;  p:Pchar; d:variant;
begin
 ftable.moveto(irow,iCol);
 self.read;
 result:=ftable.currentRecord;
end;

end.
