unit ToadDeleted;
{This unit tracks insertion points of deleted records, and controls access
via a mutex.  So after a delete has taken place, then we can place the
record's row and col here for keeping until someone wants to append a record.
Instead of being placed at the end of the file, they can overwrite
a deleted space.}
interface
uses windows,classes,Toadbase5,sysutils;
type
TToadDeleted = class(TObject)
private
  fDeleted :TToadRawTable; {Name, object is a TList or TToadCoordinates}
  fDeletedMutices:TList; {List.. corresponding to each Registered Table}
  flog:String;
public
  procedure RegisterDeletedRecord (Table:String;Row,Col:cardinal;Size:longint);
  function GetSafeInsertion(Table:String): TToadCoordinate;
  property LogFile:String read flog write flog;
end;

{
Toaddelete works in a fifo sort of way. its counter field represents
the next record to be spit out of GetSafeInsertion.. after spitting, it
deletes the record and incriments the value.. when it reaches the end
of its size restriction, it will automatically start back at 0. Any
Deletions at that point that haven't been made will be unacheivable.
A log file can be made if necessary... select logtofile ('filename') and
it will append any non-deleted coordinates to the filename specified. This
would allow you to run a program that could compress or compact your database
with minimal fuss.
}

implementation
  procedure TToaddeleted.RegisterDeletedRecord (Table:String;Row,Col:cardinal;Size:longint);
  begin
  end;
  function TToaddeleted.GetSafeInsertion(Table:String): TToadCoordinate;
  begin

  end;
end.
