unit Shortcut;

interface

type
  TShortcutInfo = record
    Path: String;            // Path to shortcut source file
    WorkDir: String;         // Working dir.
    Args: String;            // Arguments
    Desc: String;            // Description - not very useful
    IconPath: String;        // File containing icon - often same as Path
    IconIndex: Integer;      // Index of icon in the icon file
    Hotkey: Word;            // Hotkey (like Alt+Shift+F) - numeric
  end;

  procedure CreateShortcut(scTitle, scFolder, Desc, SourceFile, Args: String);
  function GetShortcutInfo(Filename: String;
           var ShortcutInfo: TShortcutInfo): Boolean;

implementation

uses
  Windows, SysUtils, ShlObj, ComObj, ActiveX;


procedure CreateShellLink(sDesc, sLinkToFileName, sStartIn,
  sArguments, sIconPath, sLinkName: String; iIconIndex: Integer);
var
  sl : IShellLink;
  ppf : IPersistFile;
  wcLinkName : array[0..MAX_PATH] of WideChar;
begin
  OleCheck(CoInitialize(nil));
  OleCheck(CoCreateInstance(CLSID_ShellLink, nil,
           CLSCTX_INPROC_SERVER, IID_IShellLinkA, sl));
  OleCheck(sl.QueryInterface(IPersistFile, ppf));
  OleCheck(sl.SetPath(PChar(sLinkToFileName)));
  OleCheck(sl.SetDescription(PChar(sDesc)));
  OleCheck(sl.SetWorkingDirectory(PChar(sStartIn)));
  OleCheck(sl.SetArguments(PChar(sArguments)));
  OleCheck(sl.SetIconLocation(PChar(sIconPath), iIconIndex));

  MultiByteToWideChar(CP_ACP, 0, PChar(sLinkName), -1, wcLinkName, MAX_PATH);
  OleCheck(ppf.Save(wcLinkName, true));
  CoUninitialize;
end;


procedure CreateShortcut(scTitle, scFolder, Desc, SourceFile, Args: String);
begin
  CreateShellLink(Desc, SourceFile, ExtractFilePath(SourceFile),
                  Args, SourceFile, scFolder +'\' + scTitle + '.lnk', 0);
end;


function GetShortcutInfo(Filename: String;
         var ShortcutInfo: TShortcutInfo): Boolean;
var
  sl: IShellLink;
  ppf: IPersistFile;
  wcLinkName: array[0..MAX_PATH] of WideChar;
  sPath, sDir, sArgs, sDesc, sIcon: String;
  sHotkey: Word;
  Idx: Integer;
  wfd: TWin32FindData;
begin
  Result := True;
  FillChar(ShortcutInfo, SizeOf(ShortcutInfo), 0);
  SetLength(sDesc, MAX_PATH);
  SetLength(sPath, MAX_PATH);
  SetLength(sDir, MAX_PATH);
  SetLength(sArgs, MAX_PATH);
  SetLength(sIcon, MAX_PATH);
  OleCheck(CoInitialize(nil));

  try
    OleCheck(CoCreateInstance(CLSID_ShellLink, nil,
             CLSCTX_INPROC_SERVER, IID_IShellLinkA, sl));
    OleCheck(sl.QueryInterface(IPersistFile, ppf));
    MultiByteToWideChar(CP_ACP, 0, PChar(Filename), -1, wcLinkName, MAX_PATH);
    OleCheck(ppf.Load(wcLinkName, STGM_READ));
    OleCheck(sl.GetPath(PChar(sPath), MAX_PATH, wfd, SLR_ANY_MATCH));
    OleCheck(sl.GetDescription(PChar(sDesc), MAX_PATH));
    OleCheck(sl.GetWorkingDirectory(PChar(sDir), MAX_PATH));
    OleCheck(sl.GetArguments(PChar(sArgs), MAX_PATH));
    OleCheck(sl.GetIconLocation(PChar(sIcon), MAX_PATH, Idx));
    OleCheck(sl.GetHotkey(sHotkey));
  except
    on EOleSysError do
      Result := False;
  end;

  if StrLen(PChar(sPath)) = 0 then
    { sPath is empty if the shortcut references a virtual
      folder, like My Computer }
    Result := False
  else
  begin
    SetLength(sPath, StrLen(PChar(sPath)));
    SetLength(sDir, StrLen(PChar(sDir)));
    SetLength(sDesc, StrLen(PChar(sDesc)));
    SetLength(sArgs, StrLen(PChar(sArgs)));
    ShortcutInfo.Path := sPath;
    ShortcutInfo.WorkDir  := sDir;
    ShortcutInfo.Desc := sDesc;
    ShortcutInfo.Args := sArgs;
{    if StrLen(PChar(sIcon)) <> 0 then
      ShortcutInfo.IconPath := sIcon
    else }
      ShortcutInfo.IconPath := sPath;
    ShortcutInfo.IconIndex := Idx;
    ShortcutInfo.Hotkey := sHotkey;
  end;

  CoUninitialize;
end;

end.

