unit SdMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TMainForm = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Memo1: TMemo;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    function GetFolderPath(FolderIdx: Integer): String;
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

uses
  Shortcut, ShlObj;


procedure TMainForm.Button1Click(Sender: TObject);
var
  S: String;
begin
  S := GetFolderPath(CSIDL_DESKTOP);
  CreateShortcut('Shortcut demo', S, 'My own description', Application.ExeName, 'myargs');
  ShowMessage('You should now have a shortcut to this demo on your desktop.');
end;


procedure TMainForm.Button2Click(Sender: TObject);
var
  si: TShortcutInfo;
  S: String;
begin
  S := GetFolderPath(CSIDL_DESKTOP) + '\Shortcut demo.lnk';
  if GetShortcutInfo(S, si) then
  begin
    Memo1.Clear;
    Memo1.Lines.Add('Name: ' + S);
    Memo1.Lines.Add('Path: ' + si.Path);
    Memo1.Lines.Add('Working dir.: ' + si.WorkDir);
    Memo1.Lines.Add('Arguments: ' + si.Args);
    Memo1.Lines.Add('Description: ' + si.Desc);
    Memo1.Lines.Add('Icon path: ' + si.IconPath);
    Memo1.Lines.Add('Icon index: ' + IntToStr(si.IconIndex));
  end
  else
    ShowMessage('Couldn''t get shortcut info.');
end;


function TMainForm.GetFolderPath(FolderIdx: Integer): String;
var
  iID: PItemIDList;
  szPath: PChar;
begin
  szPath := StrAlloc(MAX_PATH);
  if (SHGetSpecialFolderLocation(Application.Handle, FolderIdx, iID) = NOERROR) then
  begin
    SHGetPathFromIDList(iID, szPath);
    Result := szPath;
  end
  else
    Result := '';
  StrDispose(szPath);
end;

end.
