unit Unit1;
{
  The code herein is released to the public domain without conditions.

  Written By:      Stuart L. Richmond
  Date:            May, 1997.
  Copyright:       (R) Copyright by Stuart L. Richmond, 1997.
                       All Rights Reserved
                   richmosl@sat.net

  Description:     Example use of ICMP unit.  Performs Ping operation
                   using forms interface.

}
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ICMP, StdCtrls, ExtCtrls, Menus;

type
  TPingForm = class(TForm)
    HostNameEdit: TEdit;
    PingButton: TButton;
    StatusMemo: TMemo;
    icmp1: Ticmp;
    RadioGroup1: TRadioGroup;
    SingleRadio: TRadioButton;
    MultipleRadio: TRadioButton;
    PingCountEdit: TEdit;
    TimeOutEdit: TEdit;
    TimeoutLabel: TLabel;
    CancelButton: TButton;
    TimeBetweenEdit: TEdit;
    PingCountLabel: TLabel;
    IntervalLabel: TLabel;
    Timer1: TTimer;
    Label1: TLabel;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    Help1: TMenuItem;
    About1: TMenuItem;
    Label2: TLabel;
    procedure PingClick(Sender: TObject);
    procedure singleClick(Sender: TObject);
    procedure MultipleClick(Sender: TObject);
    procedure CancelClick(Sender: TObject);
    procedure TimedPing(Sender: TObject);
    procedure DoPing;
    procedure PingFormCreate(Sender: TObject);
    procedure PingingMode;
    procedure UserinputMode;
    procedure ExitClick(Sender: TObject);
    procedure AboutClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  PingForm: TPingForm;
  IterationCount: Integer;

implementation

uses Unit2;

{$R *.DFM}

procedure TPingForm.DoPing;
Begin
  if (icmp1.ping = nil) then begin
    if icmp1.status = CICMP_RESOLVE_ERROR then begin
     StatusMemo.Lines.Add('Error: Unable to resolve HostName "'+
                HostNameEdit.Text+'"');
    end else if icmp1.status = CICMP_NO_RESPONSE then begin
     StatusMemo.Lines.Add(icmp1.HostName+' ('+icmp1.HostIP+') No Response');
    end else begin
     StatusMemo.Lines.Add('Unknown error from TICMP: '+inttostr(icmp1.status));
     IterationCount := 0; // Cancel any repeat Pings
    end;
  end else begin
    StatusMemo.Lines.Add(icmp1.HostName+' ('+icmp1.HostIP+') Time:'+IntToStr(icmp1.pIPEchoReply^.RTT)+
      ' ms');
  end;
end;

procedure TPingForm.PingClick(Sender: TObject);

begin
  PingingMode;
  Timer1.Enabled := False;
  icmp1.TimeOut := strtoint(TimeOutEdit.Text) * 1000;
  icmp1.HostName := HostNameEdit.Text;
  if SingleRadio.checked = True then begin
    DoPing;
    UserinputMode;
  end else begin
  // Start Timer routine
    Timer1.Interval :=  strtoint(TimeBetweenEdit.Text) * 1000;
    if Timer1.Interval < 1000 then Timer1.Interval := 1000;
    IterationCount :=  strtoint(PingCountEdit.text) - 1;
    if IterationCount>=0 then begin
      DoPing;
      Timer1.Enabled := True;
    end;
    if Timer1.Enabled = False then UserinputMode;
  end;
end;

procedure TPingForm.UserinputMode;
begin
  Timer1.Enabled := False;
  HostNameEdit.Enabled := True;
  PingButton.Enabled   := True;
  RadioGroup1.Enabled  := True;
  TimeOutEdit.Enabled  := True;
  TimeoutLabel.Enabled := True;

  SingleRadio.Enabled     := True;
  MultipleRadio.Enabled   := True;
  if SingleRadio.checked = True then begin
    PingCountEdit.Enabled   := False;
    TimeBetweenEdit.Enabled := False;
    PingCountLabel.Enabled  := False;
    IntervalLabel.Enabled   := False;
  end else begin
    PingCountEdit.Enabled   := True;
    TimeBetweenEdit.Enabled := True;
    PingCountLabel.Enabled  := True;
    IntervalLabel.Enabled   := True;
  end;

    CancelButton.Enabled    := False;
end;

procedure TPingForm.PingingMode;
begin
    HostNameEdit.Enabled := False;
    PingButton.Enabled   := False;
    RadioGroup1.Enabled  := False;
    TimeOutEdit.Enabled  := False;
    TimeoutLabel.Enabled := False;

    SingleRadio.Enabled     := False;
    MultipleRadio.Enabled   := False;
    PingCountEdit.Enabled   := False;
    TimeBetweenEdit.Enabled := False;
    PingCountLabel.Enabled  := False;
    IntervalLabel.Enabled   := False;

    CancelButton.Enabled    := True;
end;

procedure TPingForm.singleClick(Sender: TObject);
begin
  SingleRadio.Checked := True;
  MultipleRadio.Checked := False;
  PingCountEdit.Enabled := False;
  TimeBetweenEdit.Enabled := False;
  PingCountLabel.Enabled := False;
  IntervalLabel.Enabled := False;
end;

procedure TPingForm.MultipleClick(Sender: TObject);
begin
  SingleRadio.Checked := False;
  MultipleRadio.Checked := True;
  PingCountEdit.Enabled := True;
  TimeBetweenEdit.Enabled := True;
  PingCountLabel.Enabled := True;
  IntervalLabel.Enabled := True;
end;

procedure TPingForm.CancelClick(Sender: TObject);
begin
  IterationCount := 0;
  Timer1.Enabled := False;
  UserinputMode;
end;

procedure TPingForm.TimedPing(Sender: TObject);
begin
  IterationCount := IterationCount - 1;
  If IterationCount >= 0 then DoPing
  else UserinputMode;
end;

procedure TPingForm.PingFormCreate(Sender: TObject);
begin
  SingleRadio.Checked := True;
  MultipleRadio.Checked := False;
  UserinputMode;
  TimeOutEdit.Text := IntToStr(Round(Icmp1.TimeOut / Integer(1000)));
  PingCountEdit.Text := '1';
  TimeBetweenEdit.Text := '1';
  HostNameEdit.Text := 'Localhost';
  StatusMemo.enabled := False;
end;

procedure TPingForm.ExitClick(Sender: TObject);
begin
  halt;
end;

procedure TPingForm.AboutClick(Sender: TObject);
begin
  AboutForm.ShowModal;
end;

end.
