unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Db, DBTables, ThreadQuery, StdCtrls, ComCtrls, Grids, DBGrids;

type
  TForm1 = class(TForm)
    ThreadQuery1: TThreadQuery;
    Button1: TButton;
    Memo1: TMemo;
    Button3: TButton;
    Button4: TButton;
    ThreadQuery2: TThreadQuery;
    ThreadQuery3: TThreadQuery;
    Button5: TButton;
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    Button2: TButton;
    Button6: TButton;
    Label1: TLabel;
    Label2: TLabel;
    CheckBox1: TCheckBox;
    Label3: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure ThreadQuery1ThreadReady(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure ThreadQuery1ThreadMsg(Sender: TObject; aMsg: String);
    procedure Button2Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
  Button1.Enabled := false;
  Memo1.Lines.Add('Query1.ThreadOpen called');
  ThreadQuery1.ThreadOpen;
  {}
  ThreadQuery2.ThreadOpen;
  Memo1.Lines.Add('Query2.ThreadOpen called');
  ThreadQuery3.ThreadOpen;
  Memo1.Lines.Add('Query3.ThreadOpen called');
  {}
  Memo1.Lines.Add('>>Control is at the main app');
end;

procedure TForm1.ThreadQuery1ThreadReady(Sender: TObject);
begin
  Memo1.Lines.Add(TThreadQuery(Sender).Name + ' is open !');
  // now a DataSource can be connected
  if CheckBox1.Checked then
    DataSource1.DataSet := ThreadQuery1;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  ThreadQuery1.ThreadClose;
  {}
  ThreadQuery2.ThreadClose;
  ThreadQuery3.ThreadClose;
  {}
  DataSource1.DataSet := NIL;
  CheckBox1.Checked := false;
  Button1.Enabled := true;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  with ThreadQuery1 do
  begin
    Memo1.Lines.Add('Q1.DatabaseName: '+DatabaseName);
    Memo1.Lines.Add('Q1.SessionName: '+SessionName);
  end;
  with ThreadQuery2 do
  begin
    Memo1.Lines.Add('Q2.DatabaseName: '+DatabaseName);
    Memo1.Lines.Add('Q2.SessionName: '+SessionName);
  end;
  with ThreadQuery3 do
  begin
    Memo1.Lines.Add('Q3.DatabaseName: '+DatabaseName);
    Memo1.Lines.Add('Q3.SessionName: '+SessionName);
  end;
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
  Memo1.Lines.Clear;
end;

procedure TForm1.ThreadQuery1ThreadMsg(Sender: TObject; aMsg: String);
begin
//  Memo1.Lines.Add(aMsg);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  with ThreadQuery1 do
  begin
    Alias := 'IBLOCAL';
    User := 'SYSDBA';
    Password := 'masterkey';
    SQL.Clear;
    SQL.Add('select * from customer');
  end;
  with ThreadQuery2 do
  begin
    Alias := 'IBLOCAL';
    User := 'SYSDBA';
    Password := 'masterkey';
    SQL.Clear;
    SQL.Add('select * from country');
  end;
  with ThreadQuery3 do
  begin
    Alias := 'IBLOCAL';
    User := 'SYSDBA';
    Password := 'masterkey';
    SQL.Clear;
    SQL.Add('select * from job');
  end;
end;

procedure TForm1.Button6Click(Sender: TObject);
begin
  with ThreadQuery1 do
  begin
    Alias := 'DBDEMOS';
    Password := '';
    User := '';
    SQL.Clear;
    SQL.Add('select Company, Sum(ItemsTotal) - Sum(AmountPaid) as AmountDue');
    SQL.Add(' from customer, orders');
    SQL.Add(' where Customer.CustNo = Orders.CustNo');
    SQL.Add(' group by Company');
  end;
  with ThreadQuery2 do
  begin
    Alias := 'DBDEMOS';
    Password := '';
    User := '';
    SQL.Clear;
    SQL.Add('select * from customer.db');
  end;
  with ThreadQuery3 do
  begin
    Alias := 'DBDEMOS';
    Password := '';
    User := '';
    SQL.Clear;
    SQL.Add('select * from biolife.db');
  end;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
  top := 10;
  left := 10;
end;

end.

