unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls,
     Gif, GifType, ComCtrls;

type
  TForm1 = class(TForm)
    Image1: TImage;
    OpenDialog1: TOpenDialog;
    Button1: TButton;
    Label1: TLabel;
    Static1: TStaticText;
    Static2: TStaticText;
    Static3: TStaticText;
    Static4: TStaticText;
    Static5: TStaticText;
    Static6: TStaticText;
    ProgressBar1: TProgressBar;
    CheckBox1: TCheckBox;
    procedure Button1Click(Sender: TObject);
    procedure Progress(Sender: TObject; Stage: TProgressStage; PercentDone: Byte; RedrawNow: Boolean; const R: TRect; const Msg: string);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    g1:             TGif;
    b1:             TBitmap;
    LastPercent:    integer;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{ ---------------------------------------------------------------------------- }

procedure TForm1.Progress(Sender: TObject; Stage: TProgressStage; PercentDone: Byte;
    RedrawNow: Boolean; const R: TRect; const Msg: string);
begin
Label1.Caption := msg;
ProgressBar1.Position := PercentDone;
if (PercentDone <> LastPercent) then Application.ProcessMessages;
LastPercent := PercentDone;
end;

{ ---------------------------------------------------------------------------- }

procedure TForm1.Button1Click(Sender: TObject);
var
    i,n:    integer;
    s:      string;
    w,h,d:  integer;

    gc:     PGifColorTable;
    hp:     HPalette;
    rr:     TRect;
    id:     PGifImageDescriptor;
begin
Static1.Caption := '';
Static2.Caption := '';
Static3.Caption := '';
Static4.Caption := '';
Static5.Caption := '';
Static6.Caption := '';
Application.ProcessMessages;

LastPercent := -1;
if (OpenDialog1.Execute) then
    begin
    g1.FreeImage;                       // delete old image and release memory
    s := OpenDialog1.Filename;

    g1.ProgressiveDisplay := false;
    if (CheckBox1.Checked) then
        begin
        Image1.Picture := nil;
        g1.SetCanvas(Image1.Canvas, Image1.ClientRect);
        g1.ProgressiveDisplay := true;
        end;

    g1.LoadFromFile(s);

    w := g1.ImageWidth[0];
    h := g1.ImageHeight[0];
    d := g1.ImageDepth[0];
    Static1.Caption := s;
    Static2.Caption := 'size= ' + IntToStr(w) + ' x ' + IntToStr(h) + ' x ' + IntToStr(d);
    s := 'FALSE';
    if (g1.Interlaced) then s := 'TRUE';
    Static3.Caption := 'Interlaced= ' + s;
    Static4.Caption := 'LZW Size= ' + IntToStr(g1.LZWSize);

    Image1.Picture.Bitmap := g1.Bitmap[0];

    Static6.Caption := '<<< done >>>';
    end;
end;

{ ---------------------------------------------------------------------------- }

procedure TForm1.FormCreate(Sender: TObject);
begin
g1 := TGif.Create;
b1 := TBitmap.Create;
g1.OnProgress := Progress;

end;

end.
