{ This unit creates a TExtListView component at run-time so you do not have to install   }
{ the component to see it work.                                                          }

unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ExtListView, Spin, ComCtrls, CommCtrl;

type
  TForm1 = class(TForm)
    Bevel1: TBevel;
    ComboBox1: TComboBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    IconSpacingX: TSpinEdit;
    IconSpacingY: TSpinEdit;
    ScrollBox1: TScrollBox;
    GridLines: TCheckBox;
    SubItemImages: TCheckBox;
    CheckBoxes: TCheckBox;
    TrackSelect: TCheckBox;
    HeaderDragDrop: TCheckBox;
    FullRowSelect: TCheckBox;
    OneClickActivate: TCheckBox;
    TwoClickActivate: TCheckBox;
    StatusBar: TStatusBar;
    Button1: TButton;
    Label5: TLabel;
    Label6: TLabel;
    cbxNoDrag: TCheckBox;
    ExtListView: TExtListView;
    procedure FormCreate(Sender: TObject);
    procedure GridLinesClick(Sender: TObject);
    procedure SubItemImagesClick(Sender: TObject);
    procedure CheckBoxesClick(Sender: TObject);
    procedure TrackSelectClick(Sender: TObject);
    procedure HeaderDragDropClick(Sender: TObject);
    procedure FullRowSelectClick(Sender: TObject);
    procedure OneClickActivateClick(Sender: TObject);
    procedure TwoClickActivateClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure IconSpacingChange(Sender: TObject);
    procedure ExtListViewMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure Button1Click(Sender: TObject);
    procedure ExtListViewMarqueeBegin(Sender: TObject; var CanBegin: Boolean);
  private
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
var
  TmpIcon: TIcon;
begin
  ComboBox1.ItemIndex := 2;
  with ExtListView do begin
    LargeImages := TImageList.Create(Self);
    with LargeImages do begin
      Width := GetSystemMetrics(SM_CXICON);
      Height := GetSystemMetrics(SM_CYICON);
      AddIcon(Application.Icon);
      TmpIcon := TIcon.Create;
      TmpIcon.Handle := LoadIcon(0, MakeIntResource(IDI_APPLICATION));
      AddIcon(TmpIcon);
    end;

    SmallImages := TImageList.Create(Self);
    with SmallImages do begin
      Width := GetSystemMetrics(SM_CXSMICON);
      Height := GetSystemMetrics(SM_CYSMICON);
      AddIcon(Application.Icon);
      AddIcon(TmpIcon);
      TmpIcon.Free;
    end;
  end;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  ExtListView.LargeImages.Free;
  ExtListView.SmallImages.Free;
end;

procedure TForm1.GridLinesClick(Sender: TObject);
begin
  with ExtListView do
  if (Sender as TCheckBox).Checked then
    ExtendedStyles := ExtendedStyles + [lvxGridLines]
  else
    ExtendedStyles := ExtendedStyles - [lvxGridLines];
end;

procedure TForm1.SubItemImagesClick(Sender: TObject);
begin
  with ExtListView do
  if (Sender as TCheckBox).Checked then
    ExtendedStyles := ExtendedStyles + [lvxSubItemImages]
  else
    ExtendedStyles := ExtendedStyles - [lvxSubItemImages];
end;

procedure TForm1.CheckBoxesClick(Sender: TObject);
begin
  with ExtListView do
  if (Sender as TCheckBox).Checked then
    ExtendedStyles := ExtendedStyles + [lvxCheckBoxes]
  else
    ExtendedStyles := ExtendedStyles - [lvxCheckBoxes];
end;

procedure TForm1.TrackSelectClick(Sender: TObject);
begin
  with ExtListView do
  if (Sender as TCheckBox).Checked then
    ExtendedStyles := ExtendedStyles + [lvxTrackSelect]
  else
    ExtendedStyles := ExtendedStyles - [lvxTrackSelect];
end;

procedure TForm1.HeaderDragDropClick(Sender: TObject);
begin
  with ExtListView do
  if (Sender as TCheckBox).Checked then
    ExtendedStyles := ExtendedStyles + [lvxHeaderDragDrop]
  else
    ExtendedStyles := ExtendedStyles - [lvxHeaderDragDrop];
end;

procedure TForm1.FullRowSelectClick(Sender: TObject);
begin
  with ExtListView do
  if (Sender as TCheckBox).Checked then
    ExtendedStyles := ExtendedStyles + [lvxFullRowSelect]
  else
    ExtendedStyles := ExtendedStyles - [lvxFullRowSelect];
end;

procedure TForm1.OneClickActivateClick(Sender: TObject);
begin
  with ExtListView do
  if (Sender as TCheckBox).Checked then
    ExtendedStyles := ExtendedStyles + [lvxOneClickActivate]
  else
    ExtendedStyles := ExtendedStyles - [lvxOneClickActivate];
end;

procedure TForm1.TwoClickActivateClick(Sender: TObject);
begin
  with ExtListView do
  if (Sender as TCheckBox).Checked then
    ExtendedStyles := ExtendedStyles + [lvxTwoClickActivate]
  else
    ExtendedStyles := ExtendedStyles - [lvxTwoClickActivate];
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
begin
  case ComboBox1.ItemIndex of
    0: ExtListView.ViewStyle := vsIcon;
    1: ExtListView.ViewStyle := vsList;
    2: ExtListView.ViewStyle := vsReport;
    3: ExtListView.ViewStyle := vsSmallIcon;
  end;
end;

procedure TForm1.IconSpacingChange(Sender: TObject);
var
  X, Y: integer;
begin
  try
    X := IconSpacingX.Value;
    Y := IconSpacingY.Value;
    with ExtListView do begin
      SetIconSpacing(X, Y);
      if ViewStyle = vsIcon then begin
        SendMessage(Handle, WM_SETREDRAW, 0, 0);
        try
          ViewStyle := vsSmallIcon;
          ViewStyle := vsIcon;
        finally
          SendMessage(Handle, WM_SETREDRAW, 1, 0);
        end;
      end;
    end;
  except
    // conversion error, ignore it.
  end;
end;

procedure TForm1.ExtListViewMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
var
  SubItemText: string;
begin
  SubItemText := ExtListView.GetSubItemAt(X, Y);
  if SubItemText <> '' then
    SubItemText := 'SubItem = ' + SubItemText;
  StatusBar.SimpleText := SubItemText;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  Columns: array[0..2] of integer;
  Tmp: integer;
begin
  if ExtListView.GetColumnOrder(3, Columns) then begin
    Tmp := Columns[0];
    Columns[0] := Columns[2];
    Columns[2] := Tmp;
    ExtListView.SetColumnOrder(3, Columns);
  end;
end;

procedure TForm1.ExtListViewMarqueeBegin(Sender: TObject; var CanBegin: Boolean);
begin
  CanBegin := not cbxNoDrag.Checked;
end;

end.
