unit uSysMenu;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtDlgs, StdCtrls, ExtCtrls, cSysM32;

type
  TfrmSysMenuDemo = class(TForm)
    SysMenuCommand: TSysMenuCommand;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    editCaption: TEdit;
    chkAutoToggle: TCheckBox;
    chkChecked: TCheckBox;
    chkSeparator: TCheckBox;
    Label2: TLabel;
    Label3: TLabel;
    Panel1: TPanel;
    Panel2: TPanel;
    imgChecked: TImage;
    imgUnChecked: TImage;
    Button1: TButton;
    Button2: TButton;
    OpenPic: TOpenPictureDialog;
    procedure OpenPictureClick(Sender: TObject);
    procedure editCaptionChange(Sender: TObject);
    procedure chkAutoToggleClick(Sender: TObject);
    procedure chkCheckedClick(Sender: TObject);
    procedure chkSeparatorClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure SysMenuCommandClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmSysMenuDemo: TfrmSysMenuDemo;

implementation

{$R *.DFM}







procedure TfrmSysMenuDemo.OpenPictureClick(Sender: TObject);
begin
  If OpenPic.Execute then
  Case (Sender as TButton).Tag of
    1 : begin
          ImgChecked.Picture.LoadFromFile(OpenPic.Filename);
          SysMenuCommand.BitmapChecked.Assign(ImgChecked.Picture.Bitmap);
        end;
    2 : begin
          ImgUnChecked.Picture.LoadFromFile(OpenPic.Filename);
          SysMenuCommand.BitmapUnchecked.Assign(ImgChecked.Picture.Bitmap);
        end;
  end;
end;

procedure TfrmSysMenuDemo.editCaptionChange(Sender: TObject);
begin
  SysMenuCommand.Caption:=editCaption.Text;
end;

procedure TfrmSysMenuDemo.chkAutoToggleClick(Sender: TObject);
begin
  SysMenuCommand.AutoToggle:=not(SysMenuCommand.AutoToggle);
end;

procedure TfrmSysMenuDemo.chkCheckedClick(Sender: TObject);
begin
  SysMenuCommand.Checked:=not(SysMenuCommand.Checked);
end;

procedure TfrmSysMenuDemo.chkSeparatorClick(Sender: TObject);
begin
  SysMenuCommand.WantSeparator:=not(SysMenuCommand.WantSeparator);
end;

procedure TfrmSysMenuDemo.FormCreate(Sender: TObject);
begin
  ImgChecked.Picture.Bitmap.Assign(SysMenuCommand.BitmapChecked);
  ImgUnchecked.Picture.Bitmap.Assign(SysMenuCommand.BitmapUnchecked);
end;

procedure TfrmSysMenuDemo.SysMenuCommandClick(Sender: TObject);
begin
  MessageDlg('By Rafael Ribas Aguil'#13+
             ' rribas@unisys.com.br',mtInformation,[mbOk],0);
end;

end.
