{ System Makro

  This simple program makes it easy to execute all kinds of Applications by hitting
  a HotKey and type in eks "FM" and the File explore will run.
  Its faster than moving around with the mouse in all kinds of menus or folders
  for repeatedly used Applications.

  First time you run this program just type in "lnk"+[Enter] and it will create
  a shortcut on your DeskTop with the HotKeys [Ctrl]+[Alt]+[M] so next time you
  can use that keycombination for quick access.

  When it runs, it wil only show a Combobox in the midle of your screen and
  go away if you press [Esc] or you type in a Makro Alias like "FM"+[Enter]

  I have suplied a standard makros.txt so you can see the format and get some
  basic idears on how to setup a command string and parameters.

  makros.txt
  Format: "Makro Alias","Command Line","Params"

  "FM","explorer.exe","" // Starts the File explorer
  "INET","rasphone.exe","-d [Entry Name]" //Uses RAS to connect to Internet
  "HANGUP","rasphone.exe","-h [Entry Name]" //Hang up RAS
  "BDD","http://www.Delphidevelopers.com","" //Browse Delphidevelopers.com
  "BIN","http://www.Inprise.com","" //Browse Inprise.com
  "NET","CMD","/k NETSTAT -a" //Runs NetStat and keep it open (NT only)
  "NET","COMMAND","NETSTAT -a" //Runs NetStat (Win95/98 only)

  You are free to use this source and information in anyway you like, it is
  public domain.

  Tip: when working with the RAS applet, you can from RUN, type rasphone.exe /h
       and se the full list of options.

  Webmaster
  www.DelphiDevelopers.com
}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Controls, Forms, Dialogs,
  StdCtrls;

const
  CmdFileName = 'makros.txt';
  CMD_ALIAS   = 0;
  CMD_COMMAND = 1;
  CMD_PARAMS  = 2;
  CMD_SHOW    = 3;

type
  TForm1 = class(TForm)
    ComboBox1: TComboBox;
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure HandleMakro;
  end;

var
  Form1: TForm1;

implementation

uses ShellAPI, ActiveX, CommCtrl, shlobj;

{$R *.DFM}

procedure DesktopLnkCreate(LinkName,ExePath,WorkDir,Arguments:string;ShowCmd,HotKey:integer);
var
  ULinkName:wideString;
  aPidl: PItemIDList;
  desktopDir: string;
  aISL: IShellLink;
  aIPF: IPersistFile;
begin
  CoInitialize(nil); // Must initialize COM or CoCreateInstance won't work
  // Get the desktop folder location (as a PItemIDList)
  if SUCCEEDED(SHGetSpecialFolderLocation(Application.Handle, CSIDL_DESKTOPDIRECTORY, aPidl)) then
  begin
    // Get the actual path of the desktop directory from the PItemIDList
    SetLength(desktopDir, MAX_PATH); // SHGetPathFromIDList assumes MAX_PATH buffer
    SHGetPathFromIDList(aPidl, PChar(desktopDir)); // Do it
    SetLength(desktopDir, StrLen(PChar(desktopDir)));

    // Our link is on the desktop.  We need a WideString here to pass to
    // IPersistFile.Save below
    // "My Home-made Shortcut" will be the caption under the shortcut's icon
    UlinkName := desktopDir+'\'+LinkName+'.lnk';

    // Get an IShellLink interface to make the shortcut
    if SUCCEEDED(CoCreateInstance(CLSID_ShellLink, nil,
              CLSCTX_INPROC_SERVER, IID_IShellLinkA, aISL)) then
    begin
      // Now we have an IShellLink interface, so we can set it up as we like.
      // Set the path (the program to run) e.g., notepad
      aISL.SetPath(PChar(ExePath));
      // Set the working directory ("Start in"), e.g., c:\windows
      aISL.SetWorkingDirectory(PChar(WorkDir));
      // Set the command-line params, e.g. test.txt
      aISL.SetArguments(PChar(Arguments));
      // Set the show command, e.g., normal
      aISL.SetShowCmd(ShowCmd); // or SW_SHOWMINIMIZED or SHOW_MAXIMIZED
      // Set the hot-key e.g., Ctrl+Alt+A
      aISL.SetHotKey(HotKey);
      // Set the icon location e.g., the fourth icon in shell32.dll
      // Uncomment to see the effect.  Otherwise, the "normal" icon for the
      // linked program will be shown
      // aISL.SetIconLocation('shell32.dll', 3);

      // The shortcut IShellLink is now all set up.
      // We get an IPersistFile interface from it, and use it to save the link
      aIPF := (aISL as IPersistFile);
      if assigned(aIPF) then
        aIPF.Save(PWideChar(UlinkName), true);

      // Both aISL and aIPF will be released automatically when they go
      // out of scope (i.e., when this routine ends).
    end;
  end;
  CoUninitialize; // Symmetric uninitialize

end;

function Execute(const FileName,lParam:string; ShowCmd: Integer): longint;
var
  zFileName,zParam: array[0..MAX_PATH] of Char;
begin
  Result := ShellExecute(Application.MainForm.Handle, nil,
  StrPCopy(zFileName, FileName),StrPCopy(zParam, lParam), nil, ShowCmd);
  if Result <= 32 then showmessage(Syserrormessage(Result));
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  s:string;
begin
  // Read Makrofile
  s:=extractfilepath(application.exename)+CmdFileName;
  if fileexists(s) then ComboBox1.Items.LoadFromFile(s) else
    Showmessage('File Not found: '+s);
  ComboBox1.Align:=alClient;
  Form1.Height:=ComboBox1.Height;
end;

procedure TForm1.HandleMakro;
var
  i:integer;
  s: string;
  CsvFile:TStringlist;
begin
  s:=ComboBox1.Text;
  // Create Default Short Cut on DeskTop
  if uppercase(s) = 'LNK' then DesktopLnkCreate('System Makro',application.exename,'','',
    SW_SHOW,((HOTKEYF_ALT or HOTKEYF_CONTROL) shl 8) or ord('M'));
  // Match ComboBox with Makro Alias
  if (s<> '') and (ComboBox1.Items.Count >0) then begin
    CsvFile:=TStringList.Create;
    for i:=0 to ComboBox1.Items.Count-1 do begin
      CsvFile.CommaText:=ComboBox1.Items[i];
      // Test for Alias or ComboBox selection
      if (uppercase(s) = uppercase(CsvFile.strings[CMD_ALIAS]))
        or (uppercase(s) = uppercase(ComboBox1.Items.Strings[i])) then
          Execute(CsvFile.strings[CMD_COMMAND],CsvFile.strings[CMD_PARAMS], SW_NORMAL);
    end;
    CsvFile.Free;
  end;

end;

procedure TForm1.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  case Key of
    // Esc key terminates application
    27:application.Terminate;
    // Enter key runs Makro and Terminates application
    13:begin
      HandleMakro;
      application.Terminate;
    end;
  end;
end;

end.
