{

 TSysImageList v1.01
 by Kambiz R. Khojasteh

 email: khojasteh@mail.com
 web: http://www.crosswinds.net/~khojasteh/

 This component is freeware and may be used in any software
 product (free or commercial) under the condition that I'm
 given proper credit (title, name and e-mail address in the
 documentation or the About box of the product this component
 is used in).

}

{$IFDEF VER100}
  {$DEFINE SI_D3}
{$ELSE}
  {$IFDEF VER120}
    {$DEFINE SI_D4}
  {$ELSE}
    {$DEFINE SI_D5OrHigher}
  {$ENDIF}
{$ENDIF}

unit SysImg;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  {$IFDEF SI_D3} ComCtrls {$ELSE} ImgList {$ENDIF};

type

  TIconSize = (isSmallIcons, isLargeIcons);

  TSysImageList = class({$IFDEF SI_D3} TImageList {$ELSE} TCustomImageList {$ENDIF})
  private
    fIconSize: TIconSize;
    procedure SetIconSize(Value: TIconSize);
    procedure UpdateHandle;
  public
    constructor Create(AOwner: TComponent); override;
    function ImageIndexOf(const Path: String; OpenIcon: Boolean
      {$IFNDEF SI_D3} = False {$ENDIF}): Integer;
  published
    Property BkColor;
    Property BlendColor;
    property DrawingStyle default dsTransparent;
    property IconSize: TIconSize read fIconSize write SetIconSize default isSmallIcons;
    property OnChange;
  end;

procedure Register;

implementation

uses
  ShellAPI, ShlObj, ActiveX;

type
  TSpecialFolder = record
    Name: String;
    ID: Integer;
  end;

const
  IconSizeFlags: array[TIconSize] of Word =
    (SHGFI_SMALLICON, SHGFI_LARGEICON);
  OPenIconFlags: array[Boolean] of Word =
    (0, SHGFI_OPENICON);
  SpecialFolders: array[1..7] of TSpecialFolder = (
    (Name: 'Desktop';              ID: CSIDL_DESKTOP),
    (Name: 'Control Panel';        ID: CSIDL_CONTROLS),
    (Name: 'Printers';             ID: CSIDL_PRINTERS),
    (Name: 'My Documents';         ID: CSIDL_PERSONAL),
    (Name: 'Recycle Bin';          ID: CSIDL_BITBUCKET),
    (Name: 'My Computer';          ID: CSIDL_DRIVES),
    (Name: 'Network Neighborhood'; ID: CSIDL_NETWORK));

constructor TSysImageList.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  fIconSize := isSmallIcons;
  DrawingStyle := dsTransparent;
  ShareImages := True;
  UpdateHandle;
end;

procedure TSysImageList.UpdateHandle;
var
  FileInfo: TShFileInfo;
begin
  Handle := ShGetFileInfo('C:\', 0, FileInfo, SizeOf(FileInfo),
    IconSizeFlags[fIconSize] or SHGFI_SYSICONINDEX);
end;

function TSysImageList.ImageIndexOf(const Path: String; OpenIcon: Boolean): Integer;
var
  FileInfo: TShFileInfo;
  DesktopFolder: IShellFolder;
  PIDL: PItemIDList;
  Malloc: IMalloc;
  NumChars, Flags: {$IFDEF SI_D3} LongInt {$ELSE} Cardinal {$ENDIF};
  WidePath: PWideChar;
  SpecialFolderID, Index: Integer;
begin
  Result := 0;
  SpecialFolderID := -1;
  for Index := Low(SpecialFolders) to High(SpecialFolders) do
    if CompareText(Path, SpecialFolders[Index].Name) = 0 then
    begin
      SpecialFolderID := SpecialFolders[Index].ID;
      Break;
    end;
  if SpecialFolderID >= 0 then
    SHGetSpecialFolderLocation(Application.Handle, SpecialFolderID, PIDL)
  else
  begin
    Flags := 0;
    if (Pos(':', Path) = 0) then
      WidePath := StringToOleStr('*' + ExtractFileExt(Path))
    else
      WidePath := StringToOleStr(Path);
    NumChars := Length(WidePath);
    SHGetDesktopFolder(DesktopFolder);
    DesktopFolder.ParseDisplayName(0, nil, WidePath, NumChars, PIDL, Flags);
  end;
  if PIDL <> nil then
  begin
    FillChar(FileInfo, SizeOf(FileInfo), 0);
    ShGetFileInfo(PChar(PIDL), 0, FileInfo, SizeOf(FileInfo), SHGFI_PIDL or
      SHGFI_SYSICONINDEX or IconSizeFlags[fIconSize] or OpenIconFlags[OpenIcon]);
    if FileInfo.iIcon > 0 then Result := FileInfo.iIcon;
    ShGetMalloc(Malloc);
    Malloc.Free(PIDL);
  end;
end;

procedure TSysImageList.SetIconSize(Value: TIconSize);
begin
  if fIconSize <> Value then
  begin
    fIconSize := Value;
    UpdateHandle;
  end;
end;

procedure Register;
begin
  RegisterComponents('Win32', [TSysImageList]);
end;

end.
